/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.userlibs.apps.docsapp.fdocs;

import com.vladsch.flexmark.convert.html.FlexmarkHtmlParser;
import io.nosqlbench.virtdata.userlibs.apps.docsapp.fdocs.FDocCtor;
import io.nosqlbench.virtdata.userlibs.apps.docsapp.fdocs.FDocFunc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FDocFuncs
implements Iterable<FDocFunc> {
    private static final Logger logger = LogManager.getLogger(FDocFuncs.class);
    private final Map<String, FDocFunc> functionsByPackage = new HashMap<String, FDocFunc>();
    private final String functionName;

    public FDocFuncs(String functionName) {
        this.functionName = functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void addFunctionDoc(FDocFunc FDocFunc2) {
        String name = FDocFunc2.getPackageName() + "." + FDocFunc2.getClassName();
        if (this.functionsByPackage.containsKey(name)) {
            throw new RuntimeException("Name '" + name + " is already present.");
        }
        this.functionsByPackage.put(name, FDocFunc2);
    }

    @Override
    public Iterator<FDocFunc> iterator() {
        ArrayList<FDocFunc> fdocs = new ArrayList<FDocFunc>(this.functionsByPackage.values());
        Collections.sort(fdocs);
        return fdocs.iterator();
    }

    public String getCombinedClassDocs() {
        List cdocs = this.functionsByPackage.values().stream().sorted().map(f -> f.getClassJavaDoc().trim()).filter(s -> s.length() > 0).collect(Collectors.toList());
        if (cdocs.size() != 1) {
            logger.warn("There were " + cdocs.size() + " class docs found for types named " + this.getFunctionName());
        }
        return String.join((CharSequence)"\n\n", cdocs);
    }

    public String asMarkdown() {
        StringBuilder sb = new StringBuilder();
        sb.append("## ").append(this.getFunctionName()).append("\n\n");
        String classDocMarkdown = FlexmarkHtmlParser.parse((String)this.getCombinedClassDocs());
        sb.append(classDocMarkdown).append("\n");
        for (FDocFunc fdf : this.functionsByPackage.values()) {
            for (FDocCtor ctor : fdf.getCtors()) {
                sb.append(ctor.asMarkdown());
            }
        }
        return sb.toString();
    }
}

