/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.userlibs.apps.docsapp;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import io.nosqlbench.docsys.api.WebServiceObject;
import io.nosqlbench.nb.annotations.Service;
import io.nosqlbench.virtdata.api.processors.DocFuncData;
import io.nosqlbench.virtdata.core.bindings.VirtDataDocs;
import io.nosqlbench.virtdata.userlibs.apps.docsapp.DocFuncDataView;
import jakarta.inject.Singleton;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Service(value=WebServiceObject.class, selector="autodocs")
@Singleton
@Path(value="/services/virtdata/functions/")
public class AutoDocsWebService
implements WebServiceObject {
    private static final Logger logger = LogManager.getLogger(AutoDocsWebService.class);
    private final List<DocFuncData> _docs = VirtDataDocs.getAllDocs();

    @GET
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @Path(value="names")
    public List<String> getAutoDocsNames() {
        return VirtDataDocs.getAllNames();
    }

    @GET
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @Produces(value={"application/json"})
    @Path(value="details")
    public List<DocFuncDataView> getAutoDocsDetails(@QueryParam(value="function") String fname) {
        return this._docs.stream().filter(d -> {
            if (fname == null || fname.isEmpty()) {
                return true;
            }
            String fullname = d.getPackageName() + "." + d.getClassName();
            return fullname.contains(fname);
        }).map(DocFuncDataView::new).collect(Collectors.toList());
    }
}

