/*
 * Decompiled with CFR 0.152.
 */
package nstream.adapter.aggr.online;

import java.util.function.Function;
import nstream.adapter.aggr.online.AggrBuilderImpl;
import nstream.adapter.aggr.online.OnlineAggrException;
import nstream.adapter.aggr.online.StructuredAggrBuilderImpl;
import swim.structure.Value;

public abstract class OnlineAggr<M, I, O> {
    protected final Function<M, I> target;
    protected final String alias;

    protected OnlineAggr(Builder<M, I, O> builder) {
        if (builder.target() == null) {
            throw new IllegalArgumentException("Can't construct Aggr against target-lacking builder");
        }
        this.target = builder.onlyIf() == null ? builder.target() : m -> builder.onlyIf().apply(m) != false ? builder.target().apply(m) : null;
        this.alias = builder.as();
    }

    public abstract void reset();

    public abstract Value moldState();

    public abstract void castState(Value var1) throws OnlineAggrException;

    public final String alias() {
        return this.alias;
    }

    protected boolean shouldIgnoreInput(I input) {
        return input == null;
    }

    protected abstract void reduce(I var1);

    public boolean receive(M msg) throws OnlineAggrException {
        I field;
        try {
            field = this.target.apply(msg);
        }
        catch (Exception e) {
            throw new OnlineAggrException("Failed to extract field from msg", e);
        }
        if (this.shouldIgnoreInput(field)) {
            return false;
        }
        this.reduce(field);
        return true;
    }

    public abstract Value resultToValue();

    public abstract O evaluate();

    public static <M, I, O> Builder<M, I, O> builder() {
        return new AggrBuilderImpl();
    }

    public static <I, O> StructuredBuilder<I, O> structuredBuilder() {
        return new StructuredAggrBuilderImpl();
    }

    public static interface Builder<M, I, O> {
        public String as();

        public Builder<M, I, O> as(String var1);

        public Function<M, I> target();

        public Builder<M, I, O> target(Function<M, I> var1);

        public Function<M, Boolean> onlyIf();

        public Builder<M, I, O> onlyIf(Function<M, Boolean> var1);
    }

    public static interface StructuredBuilder<I, O>
    extends Builder<Value, I, O> {
        public Builder<Value, I, O> targetField(String var1, Function<Value, I> var2);
    }
}

