/*
 * Decompiled with CFR 0.152.
 */
package nstream.adapter.aggr.online;

import nstream.adapter.aggr.online.OnlineAggr;
import swim.structure.Field;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Value;

public class OnlineComputer<M> {
    protected OnlineAggr<M, ?, ?>[] aggrs;
    protected Record kpi;
    private int idx;

    public OnlineComputer(int rows) {
        this.aggrs = new OnlineAggr[rows];
        this.kpi = Record.create((int)rows);
    }

    public void addAggr(OnlineAggr<M, ?, ?> aggr) {
        if (this.idx >= this.aggrs.length) {
            throw new IllegalStateException("OnlineComputer capacity exceeded");
        }
        this.aggrs[this.idx++] = aggr;
        if (aggr.alias() == null) {
            throw new IllegalArgumentException("aggr must have a defined alias()");
        }
        this.kpi.add((Item)Slot.of((String)aggr.alias()));
    }

    public void receive(M v) {
        if (this.idx != this.aggrs.length) {
            throw new IllegalStateException("Can't receive before declaring all Aggrs");
        }
        for (int i = 0; i < this.aggrs.length; ++i) {
            OnlineAggr<M, ?, ?> aggr = this.aggrs[i];
            try {
                if (!aggr.receive(v)) continue;
                ((Field)this.kpi.getItem(i)).setValue(aggr.resultToValue());
                continue;
            }
            catch (Exception e) {
                new Exception("OnlineKpiComputer exception at index " + i, e).printStackTrace();
            }
        }
    }

    public Record moldState() {
        Record state = Record.create((int)this.aggrs.length);
        for (OnlineAggr<M, ?, ?> aggr : this.aggrs) {
            state.add((Item)aggr.moldState());
        }
        return state;
    }

    public void reset() {
        for (int i = 0; i < this.aggrs.length; ++i) {
            this.aggrs[i].reset();
            ((Field)this.kpi.getItem(i)).setValue(Value.extant());
        }
    }

    public Value evaluate() {
        return this.cloneKpi();
    }

    private Value cloneKpi() {
        Record result = Record.create((int)this.kpi.length());
        for (int i = 0; i < this.kpi.length(); ++i) {
            result.add((Item)Slot.of((Value)this.kpi.getItem(i).key(), (Value)this.kpi.getItem(i).toValue()));
        }
        return result;
    }
}

