/*
 * Decompiled with CFR 0.152.
 */
package nstream.adapter.aggr.online;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import nstream.adapter.aggr.online.OnlineAggr;
import nstream.adapter.aggr.online.OnlineComputer;

public class OnlineComputerBuilder<M> {
    private final List<OnlineAggr<M, ?, ?>> aggrs = new ArrayList(10);

    public OnlineComputerBuilder<M> withAggr(OnlineAggr<M, ?, ?> aggr) {
        this.aggrs.add(aggr);
        return this;
    }

    public <I, O> OnlineComputerBuilder<M> withAggr(String alias, Function<OnlineAggr.Builder<M, I, O>, OnlineAggr<M, I, O>> aggregationFunction, Function<M, I> inputFromEvent, Function<M, Boolean> onlyIf) {
        this.aggrs.add(aggregationFunction.apply(OnlineAggr.builder().as(alias).target(inputFromEvent).onlyIf(onlyIf)));
        return this;
    }

    public <I, O> OnlineComputerBuilder<M> withAggr(String alias, Function<OnlineAggr.Builder<M, I, O>, OnlineAggr<M, I, O>> aggregationFunction, Function<M, I> inputFromEvent) {
        return this.withAggr(alias, aggregationFunction, inputFromEvent, null);
    }

    public OnlineComputer<M> build() {
        OnlineComputer<M> computer = new OnlineComputer<M>(this.aggrs.size());
        for (OnlineAggr<M, ?, ?> aggr : this.aggrs) {
            computer.addAggr(aggr);
        }
        return computer;
    }
}

