/*
 * Decompiled with CFR 0.152.
 */
package nstream.adapter.aggr.online;

import nstream.adapter.aggr.online.Aggrs;
import nstream.adapter.aggr.online.OnlineAggr;
import nstream.adapter.aggr.online.OnlineComputer;
import swim.structure.Attr;
import swim.structure.Item;
import swim.structure.Selector;
import swim.structure.Value;

public final class OnlineComputerDsl {
    private OnlineComputerDsl() {
    }

    public static OnlineComputer<Value> interpret(Value computerDef) {
        OnlineComputer<Value> computer = new OnlineComputer<Value>(computerDef.length());
        for (Item aggrDef : computerDef) {
            computer.addAggr(OnlineComputerDsl.createAggr(aggrDef));
        }
        return computer;
    }

    public static OnlineAggr<Value, ?, ?> createAggr(Item aggrDef) {
        try {
            Attr aggrAttr = (Attr)aggrDef.head();
            String alias = aggrAttr.key().stringValue();
            String aggrFunctionName = aggrAttr.value().head().key().stringValue();
            Value inputFieldSelectorDef = aggrAttr.value().head().toValue();
            if (!inputFieldSelectorDef.isDefined()) {
                inputFieldSelectorDef = Selector.identity();
            }
            return OnlineComputerDsl.createAggr(aggrFunctionName, alias, inputFieldSelectorDef);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad summary stats computer definition: " + aggrDef, e);
        }
    }

    private static OnlineAggr<Value, Double, ?> createAggr(String aggrFunctionName, String alias, Value inputFieldSelectorDef) {
        switch (aggrFunctionName) {
            case "min": {
                return Aggrs.min(OnlineComputerDsl.createAggrBuilder(alias, inputFieldSelectorDef));
            }
            case "max": {
                return Aggrs.max(OnlineComputerDsl.createAggrBuilder(alias, inputFieldSelectorDef));
            }
            case "range": {
                return Aggrs.range(OnlineComputerDsl.createAggrBuilder(alias, inputFieldSelectorDef));
            }
            case "avg": {
                return Aggrs.avg(OnlineComputerDsl.createAggrBuilder(alias, inputFieldSelectorDef));
            }
            case "count": {
                return Aggrs.count(OnlineComputerDsl.createAggrBuilder(alias, inputFieldSelectorDef));
            }
            case "variance": {
                return Aggrs.variance(OnlineComputerDsl.createAggrBuilder(alias, inputFieldSelectorDef));
            }
            case "sampleVariance": {
                return Aggrs.sampleVariance(OnlineComputerDsl.createAggrBuilder(alias, inputFieldSelectorDef));
            }
            case "stdev": {
                return Aggrs.stdev(OnlineComputerDsl.createAggrBuilder(alias, inputFieldSelectorDef));
            }
            case "sampleStdev": {
                return Aggrs.sampleStdev(OnlineComputerDsl.createAggrBuilder(alias, inputFieldSelectorDef));
            }
        }
        throw new IllegalArgumentException("Unsupported statistics function: " + aggrFunctionName);
    }

    private static <O> OnlineAggr.Builder<Value, Double, O> createAggrBuilder(String alias, Value inputFieldSelectorDef) {
        return OnlineAggr.structuredBuilder().target(v -> inputFieldSelectorDef.evaluate((Item)v).doubleValue()).as(alias);
    }
}

