/*
 * Decompiled with CFR 0.152.
 */
package nstream.adapter.aggr.online;

import nstream.adapter.aggr.online.OnlineComputer;
import nstream.adapter.aggr.online.OnlineComputerBuilder;
import nstream.adapter.aggr.online.OnlineComputerDsl;
import nstream.adapter.common.NstreamAgent;
import swim.api.SwimLane;
import swim.api.lane.CommandLane;
import swim.api.lane.ValueLane;
import swim.structure.Value;

public class SummaryStatsPatch
extends NstreamAgent {
    private OnlineComputer<Value> computer;
    @SwimLane(value="summaryStats")
    protected ValueLane<Value> summaryStats = this.valueLane().didSet((n, o) -> this.trace("(SummaryStatsPatch) " + this.nodeUri() + ".summaryStats#didSet(): newValue=" + n + ", oldValue=" + o));
    @SwimLane(value="addEvent")
    protected CommandLane<Value> addEvent = this.commandLane().onCommand(v -> {
        this.trace("(SummaryStatsPatch) " + this.nodeUri() + ".addEvent#onCommand(): value=" + v);
        this.summaryStats.set((Object)this.computeUpdatedStats((Value)v));
    });

    protected OnlineComputer<Value> loadComputer() {
        Value onlineComputerDefinition = this.getProp("statsComputerDef");
        if (onlineComputerDefinition.isDistinct()) {
            return OnlineComputerDsl.interpret(onlineComputerDefinition);
        }
        throw new IllegalArgumentException("No 'statsComputerDef' property defined");
    }

    protected Value computeUpdatedStats(Value event) {
        this.computer.receive(event);
        return this.computer.evaluate();
    }

    public void didStart() {
        this.info("(SummaryStatsPatch) " + this.nodeUri() + ": didStart");
        this.computer = this.loadComputer();
    }

    protected OnlineComputerBuilder<Value> statsComputerBuilder() {
        return new OnlineComputerBuilder<Value>();
    }
}

