/*
 * Decompiled with CFR 0.152.
 */
package nstream.adapter.aggr.online.functions;

import nstream.adapter.aggr.online.OnlineAggrException;
import swim.structure.Item;
import swim.structure.Slot;
import swim.structure.Text;

final class AggrsUtil {
    private AggrsUtil() {
    }

    static void validateSlot(Item item, Text desiredKey) throws OnlineAggrException {
        if (!(item instanceof Slot) || !item.key().equals((Object)desiredKey)) {
            throw new OnlineAggrException("Incorrect state key: " + item.key());
        }
    }

    static void validateStateSize(int size, int expected) throws OnlineAggrException {
        if (size != expected) {
            throw new OnlineAggrException("Incorrect state size: " + size);
        }
    }

    static int extractInt(Item item, String key) throws OnlineAggrException {
        try {
            return item.toValue().intValue();
        }
        catch (UnsupportedOperationException e) {
            throw new OnlineAggrException("Non-integer " + key + ": " + item.toValue(), e);
        }
    }

    static double extractDouble(Item item, String key) throws OnlineAggrException {
        try {
            return item.toValue().doubleValue();
        }
        catch (UnsupportedOperationException e) {
            throw new OnlineAggrException("Non-double " + key + ": " + item.toValue(), e);
        }
    }

    static <N> N extractN(Item item, String key) throws OnlineAggrException {
        try {
            return (N)item.toValue().numberValue();
        }
        catch (UnsupportedOperationException e) {
            throw new OnlineAggrException("Non-numeric " + key + ": " + item.toValue(), e);
        }
    }
}

