/*
 * Decompiled with CFR 0.152.
 */
package nstream.adapter.aggr.online.functions;

import java.math.BigInteger;
import nstream.adapter.aggr.online.OnlineAggr;
import nstream.adapter.aggr.online.OnlineAggrException;
import nstream.adapter.aggr.online.functions.AggrsUtil;
import nstream.adapter.aggr.online.functions.BigIntegerAvg;
import nstream.adapter.aggr.online.functions.DoubleAvg;
import nstream.adapter.aggr.online.functions.LongAvg;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Text;
import swim.structure.Value;

public abstract class Avg<M, N extends Number>
extends OnlineAggr<M, N, N> {
    protected int count;
    protected N total;
    private static final Text COUNT = Text.from((String)"count");
    private static final Text TOTAL = Text.from((String)"total");

    protected Avg(OnlineAggr.Builder<M, N, N> builder) {
        super(builder);
    }

    @Override
    public void reset() {
        this.count = 0;
        this.total = null;
    }

    @Override
    public Value moldState() {
        return Record.create((int)2).slot((Value)COUNT, this.count).slot((Value)TOTAL, (Value)(this.count == 0 ? Value.extant() : Num.from(this.total)));
    }

    @Override
    public void castState(Value v) throws OnlineAggrException {
        AggrsUtil.validateStateSize(v.length(), 2);
        Item zero = v.getItem(0);
        Item one = v.getItem(1);
        AggrsUtil.validateSlot(zero, COUNT);
        AggrsUtil.validateSlot(one, TOTAL);
        this.count = AggrsUtil.extractInt(zero, COUNT.stringValue());
        if (this.count == 0) {
            this.reset();
            return;
        }
        this.total = (Number)AggrsUtil.extractN(one, TOTAL.stringValue());
    }

    @Override
    public Value resultToValue() {
        return this.count == 0 ? Value.extant() : Num.from((Number)((Number)this.evaluate()));
    }

    public static <M> Avg<M, Double> forDouble(OnlineAggr.Builder<M, Double, Double> builder) {
        return new DoubleAvg<M>(builder);
    }

    public static <M> Avg<M, Long> forLong(OnlineAggr.Builder<M, Long, Long> builder) {
        return new LongAvg<M>(builder);
    }

    public static <M> Avg<M, BigInteger> forBigInteger(OnlineAggr.Builder<M, BigInteger, BigInteger> builder) {
        return new BigIntegerAvg<M>(builder);
    }
}

