/*
 * Decompiled with CFR 0.152.
 */
package nstream.adapter.aggr.online.functions;

import java.math.BigInteger;
import nstream.adapter.aggr.online.OnlineAggr;
import nstream.adapter.aggr.online.OnlineAggrException;
import nstream.adapter.aggr.online.functions.AggrsUtil;
import nstream.adapter.aggr.online.functions.BigIntegerMax;
import nstream.adapter.aggr.online.functions.DoubleMax;
import nstream.adapter.aggr.online.functions.LongMax;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Text;
import swim.structure.Value;

public abstract class Max<M, N extends Number>
extends OnlineAggr<M, N, N> {
    protected N max;
    private static final Text MAX = Text.from((String)"max");

    protected Max(OnlineAggr.Builder<M, N, N> builder) {
        super(builder);
    }

    @Override
    public void reset() {
        this.max = null;
    }

    @Override
    public Value moldState() {
        return Record.create((int)1).slot((Value)MAX, (Value)(this.max == null ? Value.extant() : Num.from(this.max)));
    }

    @Override
    public void castState(Value v) throws OnlineAggrException {
        AggrsUtil.validateStateSize(v.length(), 1);
        Item zero = v.getItem(0);
        AggrsUtil.validateSlot(zero, MAX);
        if (!zero.toValue().isDistinct()) {
            this.reset();
            return;
        }
        this.max = (Number)AggrsUtil.extractN(zero, MAX.stringValue());
    }

    @Override
    public N evaluate() {
        return this.max;
    }

    @Override
    public Value resultToValue() {
        return this.max == null ? Value.extant() : Num.from(this.max);
    }

    public static <M> Max<M, Double> forDouble(OnlineAggr.Builder<M, Double, Double> builder) {
        return new DoubleMax<M>(builder);
    }

    public static <M> Max<M, Long> forLong(OnlineAggr.Builder<M, Long, Long> builder) {
        return new LongMax<M>(builder);
    }

    public static <M> Max<M, BigInteger> forBigInteger(OnlineAggr.Builder<M, BigInteger, BigInteger> builder) {
        return new BigIntegerMax<M>(builder);
    }
}

