/*
 * Decompiled with CFR 0.152.
 */
package nstream.adapter.aggr.online.functions;

import java.math.BigInteger;
import nstream.adapter.aggr.online.OnlineAggr;
import nstream.adapter.aggr.online.OnlineAggrException;
import nstream.adapter.aggr.online.functions.AggrsUtil;
import nstream.adapter.aggr.online.functions.BigIntegerMin;
import nstream.adapter.aggr.online.functions.DoubleMin;
import nstream.adapter.aggr.online.functions.LongMin;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Text;
import swim.structure.Value;

public abstract class Min<M, N extends Number>
extends OnlineAggr<M, N, N> {
    protected N min;
    private static final Text MIN = Text.from((String)"min");

    protected Min(OnlineAggr.Builder<M, N, N> builder) {
        super(builder);
    }

    @Override
    public void reset() {
        this.min = null;
    }

    @Override
    public Value moldState() {
        return Record.create((int)1).slot((Value)MIN, (Value)(this.min == null ? Value.extant() : Num.from(this.min)));
    }

    @Override
    public void castState(Value v) throws OnlineAggrException {
        AggrsUtil.validateStateSize(v.length(), 1);
        Item zero = v.getItem(0);
        AggrsUtil.validateSlot(zero, MIN);
        if (!zero.toValue().isDistinct()) {
            this.reset();
            return;
        }
        this.min = (Number)AggrsUtil.extractN(zero, MIN.stringValue());
    }

    @Override
    public N evaluate() {
        return this.min;
    }

    @Override
    public Value resultToValue() {
        return this.min == null ? Value.extant() : Num.from(this.min);
    }

    public static <M> Min<M, Double> forDouble(OnlineAggr.Builder<M, Double, Double> builder) {
        return new DoubleMin<M>(builder);
    }

    public static <M> Min<M, Long> forLong(OnlineAggr.Builder<M, Long, Long> builder) {
        return new LongMin<M>(builder);
    }

    public static <M> Min<M, BigInteger> forBigInteger(OnlineAggr.Builder<M, BigInteger, BigInteger> builder) {
        return new BigIntegerMin<M>(builder);
    }
}

