/*
 * Decompiled with CFR 0.152.
 */
package nstream.adapter.aggr.online.functions;

import java.math.BigInteger;
import nstream.adapter.aggr.online.OnlineAggr;
import nstream.adapter.aggr.online.OnlineAggrException;
import nstream.adapter.aggr.online.functions.AggrsUtil;
import nstream.adapter.aggr.online.functions.BigIntegerRange;
import nstream.adapter.aggr.online.functions.DoubleRange;
import nstream.adapter.aggr.online.functions.LongRange;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Text;
import swim.structure.Value;

public abstract class Range<M, N extends Number>
extends OnlineAggr<M, N, Value> {
    protected N min;
    protected N max;
    private static final Text MIN = Text.from((String)"min");
    private static final Text MAX = Text.from((String)"max");

    protected Range(OnlineAggr.Builder<M, N, Value> builder) {
        super(builder);
    }

    @Override
    public void reset() {
        this.min = null;
        this.max = null;
    }

    @Override
    public Value moldState() {
        return Record.create((int)2).slot((Value)MIN, (Value)(this.min == null ? Value.extant() : Num.from(this.min))).slot((Value)MAX, (Value)(this.max == null ? Value.extant() : Num.from(this.max)));
    }

    @Override
    public void castState(Value v) throws OnlineAggrException {
        AggrsUtil.validateStateSize(v.length(), 2);
        Item zero = v.getItem(0);
        AggrsUtil.validateSlot(zero, MIN);
        Item one = v.getItem(1);
        AggrsUtil.validateSlot(one, MAX);
        if (!zero.toValue().isDistinct()) {
            this.reset();
            return;
        }
        this.min = (Number)AggrsUtil.extractN(zero, MIN.stringValue());
        this.max = (Number)AggrsUtil.extractN(one, MAX.stringValue());
    }

    @Override
    public Value evaluate() {
        return this.min == null ? Value.extant() : Record.create((int)2).item((Item)Num.from(this.min)).item((Item)Num.from(this.max));
    }

    @Override
    public Value resultToValue() {
        return this.evaluate();
    }

    public static <M> Range<M, Double> forDouble(OnlineAggr.Builder<M, Double, Value> builder) {
        return new DoubleRange<M>(builder);
    }

    public static <M> Range<M, Long> forLong(OnlineAggr.Builder<M, Long, Value> builder) {
        return new LongRange<M>(builder);
    }

    public static <M> Range<M, BigInteger> forBigInteger(OnlineAggr.Builder<M, BigInteger, Value> builder) {
        return new BigIntegerRange<M>(builder);
    }
}

