/*
 * Decompiled with CFR 0.152.
 */
package nstream.adapter.aggr.online.functions;

import nstream.adapter.aggr.online.OnlineAggr;
import nstream.adapter.aggr.online.OnlineAggrException;
import nstream.adapter.aggr.online.functions.AggrsUtil;
import nstream.adapter.aggr.online.functions.SampleStdev;
import nstream.adapter.aggr.online.functions.SampleVariance;
import nstream.adapter.aggr.online.functions.Stdev;
import nstream.adapter.aggr.online.functions.Variance;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Text;
import swim.structure.Value;

public abstract class Welford<M>
extends OnlineAggr<M, Double, Double> {
    protected int count;
    protected double mean;
    protected double agg;
    private static final Text COUNT = Text.from((String)"count");
    private static final Text MEAN = Text.from((String)"mean");
    private static final Text AGG = Text.from((String)"agg");

    protected Welford(OnlineAggr.Builder<M, Double, Double> builder) {
        super(builder);
    }

    @Override
    public void reset() {
        this.count = 0;
        this.mean = 0.0;
        this.agg = 0.0;
    }

    @Override
    public Value moldState() {
        if (this.count == 0) {
            return Record.create((int)3).slot((Value)COUNT).slot((Value)MEAN).slot((Value)AGG);
        }
        return Record.create((int)3).slot((Value)COUNT, this.count).slot((Value)MEAN, this.mean).slot((Value)AGG, this.agg);
    }

    @Override
    public void castState(Value v) throws OnlineAggrException {
        AggrsUtil.validateStateSize(v.length(), 3);
        Item zero = v.getItem(0);
        AggrsUtil.validateSlot(zero, COUNT);
        Item one = v.getItem(1);
        AggrsUtil.validateSlot(one, MEAN);
        Item two = v.getItem(2);
        AggrsUtil.validateSlot(one, AGG);
        if (!zero.toValue().isDistinct() || zero.toValue().intValue(0) == 0) {
            this.reset();
            return;
        }
        this.count = AggrsUtil.extractInt(zero, COUNT.stringValue());
        this.mean = AggrsUtil.extractDouble(one, MEAN.stringValue());
        this.agg = AggrsUtil.extractDouble(two, AGG.stringValue());
    }

    @Override
    protected void reduce(Double field) {
        ++this.count;
        double delta = field - this.mean;
        this.mean += delta / (double)this.count;
        this.agg += delta * (field - this.mean);
    }

    protected abstract boolean isComputable();

    @Override
    public Value resultToValue() {
        return !this.isComputable() ? Value.extant() : Num.from((Number)((Number)this.evaluate()));
    }

    public static <M> Welford<M> forVariance(OnlineAggr.Builder<M, Double, Double> builder) {
        return new Variance<M>(builder);
    }

    public static <M> Welford<M> forSampleVariance(OnlineAggr.Builder<M, Double, Double> builder) {
        return new SampleVariance<M>(builder);
    }

    public static <M> Welford<M> forStdev(OnlineAggr.Builder<M, Double, Double> builder) {
        return new Stdev<M>(builder);
    }

    public static <M> Welford<M> forSampleStdev(OnlineAggr.Builder<M, Double, Double> builder) {
        return new SampleStdev<M>(builder);
    }
}

