/*
 * Decompiled with CFR 0.152.
 */
package nstream.adapter.csv;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import nstream.adapter.common.AdapterUtils;
import nstream.adapter.common.ingress.IngestorAgent;
import nstream.adapter.common.schedule.DeferrableException;
import nstream.adapter.csv.CsvIngressSettings;
import swim.concurrent.TimerRef;
import swim.csv.Csv;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

public abstract class CsvIngestingAgent
extends IngestorAgent<CsvIngressSettings, Value> {
    protected Record csvItems;
    protected Iterator<Item> csvItemsIterator;
    protected TimerRef pollTimer;

    public TimerRef pollTimer() {
        return this.pollTimer;
    }

    protected void fetchAndRelay() throws DeferrableException {
        int currentCount = 0;
        Record result = Record.create();
        if (!this.csvItemsIterator.hasNext()) {
            if (((CsvIngressSettings)this.ingressSettings).playback()) {
                this.initCsvIterator();
            } else if (this.pollTimer != null) {
                this.pollTimer.cancel();
                this.pollTimer = null;
            }
        }
        while (this.csvItemsIterator.hasNext() && currentCount < ((CsvIngressSettings)this.ingressSettings).messagesPerPoll()) {
            result.add(this.csvItemsIterator.next());
            ++currentCount;
        }
        this.ingest(result);
    }

    protected CsvIngressSettings parseIngressSettings(Value prop) {
        return CsvIngressSettings.ingressSettingsFromProp(prop);
    }

    protected void stageReception() {
        this.loadSettings("csvIngressConf");
        this.loadCsvData();
        if (this.csvItemsIterator != null) {
            this.pollTimer = this.scheduleAtFixedRate(this::pollTimer, ((CsvIngressSettings)this.ingressSettings).firstFetchDelayMillis(), ((CsvIngressSettings)this.ingressSettings).fetchIntervalMillis(), this::fetchAndRelay);
        }
    }

    public void didStart() {
        this.info(this.nodeUri() + ": didStart");
        this.stageReception();
    }

    private void loadCsvData() {
        byte[] csvData = this.loadResource(((CsvIngressSettings)this.ingressSettings).resource());
        if (csvData.length == 0) {
            this.error(this.nodeUri() + ": Error loading csv resource " + ((CsvIngressSettings)this.ingressSettings).resource());
        } else {
            this.csvItems = Csv.parseTable((byte[])csvData, (int)((CsvIngressSettings)this.ingressSettings).delimiter());
            this.initCsvIterator();
            this.info(this.nodeUri() + ": Finished loading CsvData");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadResource(String resource) {
        try (InputStream resourceStream = AdapterUtils.openFileAsStream((String)resource, CsvIngestingAgent.class);){
            if (resourceStream == null) return new byte[0];
            byte[] byArray = resourceStream.readAllBytes();
            return byArray;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new byte[0];
    }

    private void initCsvIterator() {
        this.csvItemsIterator = this.csvItems.iterator();
    }
}

