/*
 * Decompiled with CFR 0.152.
 */
package nstream.adapter.csv;

import nstream.adapter.common.AdapterSettings;
import swim.codec.Format;
import swim.codec.Output;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Record;
import swim.structure.Tag;
import swim.structure.Value;

@Tag(value="csvIngressSettings")
public class CsvIngressSettings
implements AdapterSettings {
    private final String resource;
    private final int delimiter;
    private final Value relaySchema;
    private final long firstFetchDelayMillis;
    private final long fetchIntervalMillis;
    private final int messagesPerPoll;
    private final boolean playback;
    @Kind
    private static Form<CsvIngressSettings> form;
    private static final long DEFAULT_FIRST_FETCH_DELAY = 2000L;
    private static final long DEFAULT_FETCH_INTERVAL = 5000L;
    private static final int DEFAULT_MESSAGES_PER_POLL = 10;
    private static final String ERROR = "Poorly defined csvIngressSettings: Requires valid resource, relaySchema";

    public CsvIngressSettings(String resource, int delimiter, Value relaySchema, long firstFetchDelayMillis, long fetchIntervalMillis, int messagesPerPoll, boolean playback) {
        this.resource = resource;
        this.delimiter = delimiter;
        this.relaySchema = relaySchema;
        this.firstFetchDelayMillis = firstFetchDelayMillis;
        this.fetchIntervalMillis = fetchIntervalMillis;
        this.messagesPerPoll = messagesPerPoll;
        this.playback = playback;
    }

    public String resource() {
        return this.resource;
    }

    public int delimiter() {
        return this.delimiter;
    }

    public Value relaySchema() {
        return this.relaySchema;
    }

    public long firstFetchDelayMillis() {
        return this.firstFetchDelayMillis;
    }

    public long fetchIntervalMillis() {
        return this.fetchIntervalMillis;
    }

    public int messagesPerPoll() {
        return this.messagesPerPoll;
    }

    public boolean playback() {
        return this.playback;
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("CsvIngressSettings").write(46).write("of").write(40).write(41).write(46).write("resource").write(40).debug((Object)this.resource).write(41).write(46).write("delimiter").write(40).debug((Object)this.delimiter).write(41).write(46).write("relaySchema").write(40).debug((Object)this.relaySchema).write(41).write(46).write("firstFetchDelayMillis").write(40).debug((Object)this.firstFetchDelayMillis).write(41).write(46).write("fetchIntervalMillis").write(40).debug((Object)this.fetchIntervalMillis).write(41).write(46).write("messagesPerPoll").write(40).debug((Object)this.messagesPerPoll).write(41).write(46).write("playback").write(40).debug((Object)this.playback).write(41);
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static Form<CsvIngressSettings> form() {
        if (form == null) {
            form = Form.forClass(CsvIngressSettings.class);
        }
        return form;
    }

    public static CsvIngressSettings ingressSettingsFromProp(Value prop) {
        String resource = prop.get("resource").stringValue("");
        Value relaySchema = prop.get("relaySchema");
        if (!resource.equals("") && relaySchema.isDistinct() && relaySchema instanceof Record) {
            int delimiter = prop.get("delimiter").intValue(44);
            long firstFetchDelayMillis = prop.get("firstFetchDelayMillis").longValue(2000L);
            long fetchIntervalMillis = prop.get("fetchIntervalMillis").longValue(5000L);
            int messagesPerPoll = prop.get("messagesPerPoll").intValue(10);
            boolean playback = prop.get("playback").booleanValue(true);
            return new CsvIngressSettings(resource, delimiter, relaySchema, firstFetchDelayMillis, fetchIntervalMillis, messagesPerPoll, playback);
        }
        throw new IllegalArgumentException(ERROR);
    }
}

