/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.sdk.accountledger.service.impl;

import io.nuls.sdk.accountledger.model.Input;
import io.nuls.sdk.accountledger.model.InputCompare;
import io.nuls.sdk.accountledger.model.MSAccount;
import io.nuls.sdk.accountledger.model.Output;
import io.nuls.sdk.accountledger.model.TransactionCreatedReturnInfo;
import io.nuls.sdk.accountledger.service.AccountLedgerService;
import io.nuls.sdk.accountledger.utils.ConvertCoinTool;
import io.nuls.sdk.accountledger.utils.LedgerUtil;
import io.nuls.sdk.core.contast.AccountErrorCode;
import io.nuls.sdk.core.contast.ErrorCode;
import io.nuls.sdk.core.contast.TransactionErrorCode;
import io.nuls.sdk.core.crypto.AESEncrypt;
import io.nuls.sdk.core.crypto.ECKey;
import io.nuls.sdk.core.crypto.Hex;
import io.nuls.sdk.core.exception.NulsException;
import io.nuls.sdk.core.model.Coin;
import io.nuls.sdk.core.model.CoinData;
import io.nuls.sdk.core.model.CoinDataResult;
import io.nuls.sdk.core.model.Na;
import io.nuls.sdk.core.model.NulsDigestData;
import io.nuls.sdk.core.model.Result;
import io.nuls.sdk.core.model.dto.BalanceInfo;
import io.nuls.sdk.core.model.transaction.Transaction;
import io.nuls.sdk.core.model.transaction.TransferTransaction;
import io.nuls.sdk.core.script.Script;
import io.nuls.sdk.core.script.ScriptBuilder;
import io.nuls.sdk.core.script.SignatureUtil;
import io.nuls.sdk.core.script.TransactionSignature;
import io.nuls.sdk.core.utils.AccountTool;
import io.nuls.sdk.core.utils.AddressTool;
import io.nuls.sdk.core.utils.Log;
import io.nuls.sdk.core.utils.NulsByteBuffer;
import io.nuls.sdk.core.utils.RestFulUtils;
import io.nuls.sdk.core.utils.StringUtils;
import io.nuls.sdk.core.utils.TimeService;
import io.nuls.sdk.core.utils.TransactionFeeCalculator;
import io.nuls.sdk.core.utils.TransactionTool;
import io.nuls.sdk.core.utils.VarInt;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.spongycastle.util.Arrays;

public class AccountLedgerServiceImpl
implements AccountLedgerService {
    private static final AccountLedgerService INSTANCE = new AccountLedgerServiceImpl();
    private RestFulUtils restFul = RestFulUtils.getInstance();

    private AccountLedgerServiceImpl() {
    }

    public static AccountLedgerService getInstance() {
        return INSTANCE;
    }

    @Override
    public Result getTxByHash(String hash) {
        if (StringUtils.isBlank((String)hash)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.PARAMETER_ERROR);
        }
        Result result = this.restFul.get("/accountledger/v1/" + hash, null);
        if (result.isFailed()) {
            return result;
        }
        Map map = (Map)result.getData();
        List inputMaps = (List)map.get("inputs");
        ArrayList<Input> inputs = new ArrayList<Input>();
        for (Map inputMap : inputMaps) {
            Input inputDto = new Input(inputMap);
            inputs.add(inputDto);
        }
        map.put("inputs", inputs);
        List outputMaps = (List)map.get("outputs");
        ArrayList<Output> outputs = new ArrayList<Output>();
        for (Map outputMap : outputMaps) {
            Output outputDto = new Output(outputMap);
            outputs.add(outputDto);
        }
        map.put("outputs", outputs);
        io.nuls.sdk.accountledger.model.Transaction transactionDto = new io.nuls.sdk.accountledger.model.Transaction(map);
        result.setData((Object)transactionDto);
        return result;
    }

    @Override
    public Result transfer(String address, String toAddress, String password, long amount, String remark) {
        if (!AddressTool.validAddress((String)address) || !AddressTool.validAddress((String)toAddress)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR);
        }
        if (StringUtils.isNotBlank((String)password) && !StringUtils.validPassword((String)password)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.PASSWORD_IS_WRONG);
        }
        if (!this.validTxRemark(remark)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.PARAMETER_ERROR);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("address", address);
        parameters.put("toAddress", toAddress);
        parameters.put("password", password);
        parameters.put("amount", amount);
        parameters.put("remark", remark);
        Result result = this.restFul.post("/accountledger/transfer", parameters);
        return result;
    }

    @Override
    public Result transfer(String address, String toAddress, long amount, String remark) {
        return this.transfer(address, toAddress, null, amount, remark);
    }

    private boolean validTxRemark(String remark) {
        if (StringUtils.isBlank((String)remark)) {
            return true;
        }
        try {
            byte[] bytes = remark.getBytes("UTF-8");
            return bytes.length <= 100;
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    @Override
    public Result getBalance(String address) {
        if (!AddressTool.validAddress((String)address)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR);
        }
        Result result = this.restFul.get("/accountledger/balance/" + address, null);
        if (result.isFailed()) {
            return result;
        }
        Map map = (Map)result.getData();
        map.put("balance", ((Map)map.get("balance")).get("value"));
        map.put("usable", ((Map)map.get("usable")).get("value"));
        map.put("locked", ((Map)map.get("locked")).get("value"));
        BalanceInfo balanceDto = new BalanceInfo(map);
        return result.setData((Object)balanceDto);
    }

    @Override
    public Result broadcastTransaction(String txHex) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("txHex", txHex);
        Result result = this.restFul.post("/accountledger/transaction/broadcast", map);
        return result;
    }

    @Override
    public Result validateTransaction(String txHex) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("txHex", txHex);
        Result result = this.restFul.post("/accountledger/transaction/valiTransaction", map);
        return result;
    }

    @Override
    public Result createTransaction(List<Input> inputs, List<Output> outputs, String remark) {
        return this.createMultipleInputAddressTransaction(inputs, 1, outputs, remark);
    }

    @Override
    public Result createTransaction(String address, String toAddress, long amount, String remark, List<Input> utxos) {
        try {
            Coin toCoin;
            if (!AddressTool.validAddress((String)address) || !AddressTool.validAddress((String)toAddress)) {
                return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR);
            }
            if (!this.validTxRemark(remark)) {
                return Result.getFailed((ErrorCode)AccountErrorCode.PARAMETER_ERROR);
            }
            byte[] remarkBytes = new byte[]{};
            try {
                remarkBytes = remark.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return Result.getFailed((ErrorCode)AccountErrorCode.PARAMETER_ERROR);
            }
            byte[] fromBytes = AddressTool.getAddress((String)address);
            byte[] toBytes = AddressTool.getAddress((String)toAddress);
            Na values = Na.valueOf((long)amount);
            TransferTransaction tx = new TransferTransaction();
            tx.setRemark(remarkBytes);
            tx.setTime(TimeService.currentTimeMillis());
            CoinData coinData = new CoinData();
            if (toBytes[2] == 3) {
                Script scriptPubkey = SignatureUtil.createOutputScript((byte[])toBytes);
                toCoin = new Coin(scriptPubkey.getProgram(), values);
            } else {
                toCoin = new Coin(toBytes, values);
            }
            coinData.getTo().add(toCoin);
            List<Coin> coinList = ConvertCoinTool.convertCoinList(utxos);
            CoinDataResult coinDataResult = TransactionTool.getCoinData((byte[])fromBytes, (Na)values, (int)(tx.size() + coinData.size()), (Na)TransactionFeeCalculator.MIN_PRECE_PRE_1024_BYTES, coinList);
            if (!coinDataResult.isEnough()) {
                return Result.getFailed((ErrorCode)TransactionErrorCode.INSUFFICIENT_BALANCE);
            }
            coinData.setFrom(coinDataResult.getCoinList());
            if (coinDataResult.getChange() != null) {
                coinData.getTo().add(coinDataResult.getChange());
            }
            tx.setCoinData(coinData);
            tx.setSize(0);
            if (tx.getSize() > 307200) {
                return Result.getFailed((ErrorCode)TransactionErrorCode.DATA_SIZE_ERROR);
            }
            TransactionCreatedReturnInfo returnInfo = LedgerUtil.makeReturnInfo((Transaction)tx);
            HashMap<String, TransactionCreatedReturnInfo> map = new HashMap<String, TransactionCreatedReturnInfo>();
            map.put("value", returnInfo);
            return Result.getSuccess().setData(map);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return Result.getFailed((String)e.getMessage());
        }
    }

    @Override
    public Result createMultipleInputAddressTransaction(List<Input> inputs, int nInputAccount, List<Output> outputs, String remark) {
        if (inputs == null || inputs.isEmpty()) {
            return Result.getFailed((String)"inputs error");
        }
        if (outputs == null || outputs.isEmpty()) {
            return Result.getFailed((String)"outputs error");
        }
        if (nInputAccount <= 0) {
            return Result.getFailed((String)"nInputAccount error");
        }
        byte[] remarkBytes = null;
        if (!StringUtils.isBlank((String)remark)) {
            try {
                remarkBytes = remark.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return Result.getFailed((String)"remark error");
            }
        }
        ArrayList<Coin> outputList = new ArrayList<Coin>();
        for (int i = 0; i < outputs.size(); ++i) {
            Output outputDto = outputs.get(i);
            Coin to = new Coin();
            try {
                if (!AddressTool.validAddress((String)outputDto.getAddress())) {
                    return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR);
                }
                byte[] owner = AddressTool.getAddress((String)outputDto.getAddress());
                if (owner[2] == 3) {
                    Script scriptPubkey = SignatureUtil.createOutputScript((byte[])to.getAddress());
                    to.setOwner(scriptPubkey.getProgram());
                } else {
                    to.setOwner(AddressTool.getAddress((String)outputDto.getAddress()));
                }
            }
            catch (Exception e) {
                return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR);
            }
            try {
                to.setNa(Na.valueOf((long)outputDto.getValue()));
            }
            catch (Exception e) {
                return Result.getFailed((ErrorCode)AccountErrorCode.DATA_PARSE_ERROR);
            }
            if (outputDto.getLockTime() < 0L) {
                return Result.getFailed((String)"lockTime error");
            }
            to.setLockTime(outputDto.getLockTime());
            outputList.add(to);
        }
        ArrayList<Coin> inputsList = new ArrayList<Coin>();
        Object address = null;
        for (int i = 0; i < inputs.size(); ++i) {
            Input inputDto = inputs.get(i);
            if (inputDto.getAddress() == null) {
                return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR);
            }
            byte[] key = Arrays.concatenate((byte[])Hex.decode((String)inputDto.getFromHash()), (byte[])new VarInt((long)inputDto.getFromIndex()).encode());
            Coin coin = new Coin();
            coin.setOwner(key);
            coin.setNa(Na.valueOf((long)inputDto.getValue()));
            coin.setLockTime(inputDto.getLockTime());
            inputsList.add(coin);
        }
        Transaction tx = TransactionTool.createTransferTx(inputsList, outputList, (byte[])remarkBytes);
        if (!TransactionTool.isFeeEnough((Transaction)tx, (int)(110 * nInputAccount), (int)1)) {
            return Result.getFailed((ErrorCode)TransactionErrorCode.FEE_NOT_RIGHT);
        }
        try {
            String txHex = Hex.encode((byte[])tx.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("value", txHex);
            return Result.getSuccess().setData(map);
        }
        catch (IOException e) {
            Log.error((Throwable)e);
            return Result.getFailed((String)e.getMessage());
        }
    }

    @Override
    public Result signTransaction(String txHex, String priKey, String address, String password) {
        if (StringUtils.isBlank((String)priKey)) {
            return Result.getFailed((String)"priKey error");
        }
        if (StringUtils.isBlank((String)txHex)) {
            return Result.getFailed((String)"txHex error");
        }
        if (!AddressTool.validAddress((String)address)) {
            return Result.getFailed((String)"address error");
        }
        if (StringUtils.isNotBlank((String)password)) {
            if (StringUtils.validPassword((String)password)) {
                byte[] privateKeyBytes = null;
                try {
                    privateKeyBytes = AESEncrypt.decrypt((byte[])Hex.decode((String)priKey), (String)password);
                }
                catch (Exception e) {
                    return Result.getFailed((ErrorCode)AccountErrorCode.PASSWORD_IS_WRONG);
                }
                priKey = Hex.encode((byte[])privateKeyBytes);
            } else {
                return Result.getFailed((ErrorCode)AccountErrorCode.PASSWORD_IS_WRONG);
            }
        }
        if (!ECKey.isValidPrivteHex((String)priKey)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.PARAMETER_ERROR, (String)"priKey error");
        }
        ECKey key = ECKey.fromPrivate((BigInteger)new BigInteger(Hex.decode((String)priKey)));
        try {
            String newAddress = AccountTool.newAddress((ECKey)key).getBase58();
            if (!newAddress.equals(address)) {
                return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR);
            }
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR);
        }
        try {
            byte[] data = Hex.decode((String)txHex);
            Transaction tx = TransactionTool.getInstance((NulsByteBuffer)new NulsByteBuffer(data));
            tx = TransactionTool.signTransaction((Transaction)tx, (ECKey)key);
            txHex = Hex.encode((byte[])tx.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("value", txHex);
            return Result.getSuccess().setData(map);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return Result.getFailed((ErrorCode)AccountErrorCode.DATA_PARSE_ERROR);
        }
    }

    @Override
    public Result signMultipleAddressTransaction(String txHex, List<String> privKeys, List<String> passwords) {
        if (StringUtils.isBlank((String)txHex)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.PARAMETER_ERROR, (String)"txHex error");
        }
        if (privKeys == null || privKeys.size() == 0) {
            return Result.getFailed((ErrorCode)AccountErrorCode.PARAMETER_ERROR, (String)"privKeys error");
        }
        if (passwords == null || passwords.size() != privKeys.size()) {
            return Result.getFailed((ErrorCode)AccountErrorCode.PARAMETER_ERROR);
        }
        ArrayList<String> signKeys = new ArrayList<String>(privKeys.size());
        for (int i = 0; i < privKeys.size(); ++i) {
            String encryptPrivKey = privKeys.get(i);
            String decryptPass = passwords.get(i);
            if (decryptPass == null || decryptPass.trim().length() == 0) {
                signKeys.add(encryptPrivKey);
                continue;
            }
            byte[] privateKeyBytes = null;
            try {
                privateKeyBytes = AESEncrypt.decrypt((byte[])Hex.decode((String)encryptPrivKey), (String)decryptPass);
            }
            catch (Exception e) {
                return Result.getFailed((ErrorCode)AccountErrorCode.DECRYPT_ACCOUNT_ERROR);
            }
            signKeys.add(Hex.encode((byte[])privateKeyBytes));
        }
        List keys = signKeys.stream().map(p -> ECKey.fromPrivate((BigInteger)new BigInteger(Hex.decode((String)p)))).collect(Collectors.toList());
        try {
            byte[] data = Hex.decode((String)txHex);
            Transaction tx = TransactionTool.getInstance((NulsByteBuffer)new NulsByteBuffer(data));
            List p2PHKSignatures = SignatureUtil.createSignaturesByEckey((Transaction)tx, keys);
            TransactionSignature transactionSignature = new TransactionSignature();
            transactionSignature.setP2PHKSignatures(p2PHKSignatures);
            tx.setTransactionSignature(transactionSignature.serialize());
            txHex = Hex.encode((byte[])tx.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("value", txHex);
            return Result.getSuccess().setData(map);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return Result.getFailed((ErrorCode)AccountErrorCode.DATA_PARSE_ERROR);
        }
    }

    @Override
    public Result createMSAccountTransferTransaction(MSAccount account, List<Input> inputs, List<Output> outputs, String remark) {
        if (account == null || account.getPubKeys() == null || account.getPubKeys().size() == 0) {
            return Result.getFailed((String)"Multiple Signature Account parameters error");
        }
        if (inputs == null || inputs.isEmpty()) {
            return Result.getFailed((String)"inputs error");
        }
        if (outputs == null || outputs.isEmpty()) {
            return Result.getFailed((String)"outputs error");
        }
        inputs.sort(InputCompare.getInstance());
        CoinData coinData = new CoinData();
        for (Input p2 : inputs) {
            byte[] fromAddr = AddressTool.getAddress((String)p2.getAddress());
            if (fromAddr[2] != 3) {
                return Result.getFailed((String)"input address is not an multiple signature address");
            }
            Script scriptPubkey = SignatureUtil.createOutputScript((byte[])fromAddr);
            Coin input = new Coin(scriptPubkey.getProgram(), Na.valueOf((long)p2.getValue()), 0L);
            coinData.getFrom().add(input);
        }
        outputs.forEach(p -> {
            byte[] receiverAddr = AddressTool.getAddress((String)p.getAddress());
            Coin output = null;
            if (receiverAddr[2] == 3) {
                Script scriptPubkey = SignatureUtil.createOutputScript((byte[])receiverAddr);
                output = new Coin(scriptPubkey.getProgram(), Na.valueOf((long)p.getValue()));
            } else {
                output = new Coin(receiverAddr, Na.valueOf((long)p.getValue()));
            }
            coinData.getTo().add(output);
        });
        TransferTransaction tx = new TransferTransaction();
        tx.setTime(TimeService.currentTimeMillis());
        tx.setCoinData(coinData);
        if (remark != null && remark.trim().length() > 0) {
            tx.setRemark(remark.trim().getBytes());
        }
        TransactionSignature signature = new TransactionSignature();
        Script redeemScript = ScriptBuilder.createNulsRedeemScript((int)account.getThreshold(), account.getPubKeys());
        signature.setScripts(Collections.singletonList(redeemScript));
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            tx.setHash(NulsDigestData.calcDigestData((byte[])tx.serializeForHash()));
            tx.setTransactionSignature(signature.serialize());
            map.put("txdata", Hex.encode((byte[])tx.serialize()));
        }
        catch (IOException e) {
            return Result.getFailed((String)"outputs error");
        }
        return Result.getSuccess().setData(map);
    }

    @Override
    public Result createChangeCoinTransaction(List<Input> inputs, String address) {
        try {
            if (inputs == null || inputs.isEmpty()) {
                return Result.getFailed((String)"inputs error");
            }
            if (StringUtils.isBlank((String)address) || !AddressTool.validAddress((String)address)) {
                return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR);
            }
            Collections.sort(inputs, InputCompare.getInstance());
            int targetSize = 0;
            int size = 0;
            ArrayList<String> transactionList = new ArrayList<String>();
            Na amount = Na.ZERO;
            boolean newTransaction = true;
            TransferTransaction tx = null;
            CoinData coinData = null;
            ArrayList<String> ownerHexList = null;
            boolean signType = true;
            for (int i = 0; i < inputs.size(); ++i) {
                Input input = inputs.get(i);
                if (input.getAddress() == null || !input.getAddress().equals(address)) {
                    return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR);
                }
                if (newTransaction) {
                    tx = new TransferTransaction();
                    tx.setTime(TimeService.currentTimeMillis());
                    size = tx.getSize() + 38;
                    coinData = new CoinData();
                    targetSize = 307200 - size - 110;
                    amount = Na.ZERO;
                    signType = true;
                    ownerHexList = new ArrayList<String>();
                    newTransaction = false;
                }
                byte[] key = Arrays.concatenate((byte[])Hex.decode((String)input.getFromHash()), (byte[])new VarInt((long)input.getFromIndex()).encode());
                Coin coin = new Coin();
                coin.setOwner(key);
                coin.setNa(Na.valueOf((long)input.getValue()));
                coin.setLockTime(input.getLockTime());
                size += coin.size();
                ownerHexList.add(Hex.encode((byte[])key));
                if (i == 127) {
                    ++size;
                }
                if (size > targetSize || i == inputs.size() - 1) {
                    if (i == inputs.size() - 1 && size <= targetSize) {
                        coinData.getFrom().add(coin);
                        tx.setCoinData(coinData);
                        amount = amount.add(coin.getNa());
                    }
                    Na fee = TransactionFeeCalculator.getFee((int)size, (Na)TransactionFeeCalculator.MIN_PRECE_PRE_1024_BYTES);
                    amount = amount.subtract(fee);
                    Coin toCoin = new Coin(AddressTool.getAddress((String)address), amount);
                    coinData.getTo().add(toCoin);
                    tx.setCoinData(coinData);
                    tx.setHash(NulsDigestData.calcDigestData((byte[])tx.serializeForHash()));
                    transactionList.add(Hex.encode((byte[])tx.serialize()));
                    if (size <= targetSize) continue;
                    --i;
                    newTransaction = true;
                    continue;
                }
                coinData.getFrom().add(coin);
                tx.setCoinData(coinData);
                amount = amount.add(coin.getNa());
            }
            HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
            map.put("value", transactionList);
            return Result.getSuccess().setData(map);
        }
        catch (IOException e) {
            Log.error((Throwable)e);
            return Result.getFailed((ErrorCode)AccountErrorCode.DATA_PARSE_ERROR);
        }
    }

    @Override
    public Result signMSTransaction(String txHex, List<String> privKeys, List<String> passwords) {
        try {
            if (StringUtils.isBlank((String)txHex)) {
                return Result.getFailed((String)"txHex can not be null!");
            }
            if (privKeys == null || privKeys.size() == 0) {
                return Result.getFailed((String)"The privKeys list can not be null!");
            }
            if (passwords == null || passwords.size() == 0) {
                return Result.getFailed((String)"The passwords list can not be null!");
            }
            if (passwords.size() != privKeys.size()) {
                return Result.getFailed((String)"privKeys length and passwords length are not equal,If there is no password in the account, please empty the string.");
            }
            HashSet<String> priKeySet = new HashSet<String>(privKeys);
            if (priKeySet.size() != privKeys.size()) {
                return Result.getFailed((String)"Private key can not be repeated!");
            }
            Transaction tx = TransactionTool.getInstance((NulsByteBuffer)new NulsByteBuffer(Hex.decode((String)txHex)));
            TransactionSignature transactionSignature = new TransactionSignature();
            transactionSignature.parse(new NulsByteBuffer(tx.getTransactionSignature()));
            if (transactionSignature == null || transactionSignature.getScripts().size() != 1) {
                return Result.getFailed((String)"Transaction data error!");
            }
            int n = SignatureUtil.getM((Script)((Script)transactionSignature.getScripts().get(0)));
            if (n != privKeys.size()) {
                return Result.getFailed((String)"The number of private keys is larger than the number of accounts that need to be signed!");
            }
            for (int i = 0; i < privKeys.size(); ++i) {
                String priKey = privKeys.get(i);
                String password = passwords.get(i);
                if (StringUtils.isBlank((String)(priKey = this.getPrikey(priKey, password)))) {
                    return Result.getFailed((ErrorCode)AccountErrorCode.PASSWORD_IS_WRONG);
                }
                if (!ECKey.isValidPrivteHex((String)priKey)) {
                    return Result.getFailed((ErrorCode)AccountErrorCode.PARAMETER_ERROR, (String)"priKey error");
                }
                ECKey key = ECKey.fromPrivate((BigInteger)new BigInteger(Hex.decode((String)priKey)));
                transactionSignature.parse(new NulsByteBuffer(tx.getTransactionSignature()));
                SignatureUtil.createMultiTransactionSignture((Transaction)tx, (TransactionSignature)transactionSignature, (ECKey)key);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("value", Hex.encode((byte[])tx.serialize()));
            return Result.getSuccess().setData(map);
        }
        catch (IOException e) {
            Log.error((Throwable)e);
            return Result.getFailed((String)"Transaction signature error!");
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return Result.getFailed((ErrorCode)AccountErrorCode.DATA_PARSE_ERROR);
        }
    }

    public String getPrikey(String prikey, String password) {
        if (StringUtils.isNotBlank((String)password)) {
            if (StringUtils.validPassword((String)password)) {
                byte[] privateKeyBytes = null;
                try {
                    privateKeyBytes = AESEncrypt.decrypt((byte[])Hex.decode((String)prikey), (String)password);
                }
                catch (Exception e) {
                    return "";
                }
                prikey = Hex.encode((byte[])privateKeyBytes);
            } else {
                return "";
            }
        }
        return prikey;
    }
}

