/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.sdk.accountledger.utils;

import io.nuls.sdk.accountledger.model.Input;
import io.nuls.sdk.accountledger.model.Output;
import io.nuls.sdk.accountledger.model.TransactionCreatedReturnInfo;
import io.nuls.sdk.accountledger.utils.ConvertCoinTool;
import io.nuls.sdk.core.crypto.Hex;
import io.nuls.sdk.core.model.CoinData;
import io.nuls.sdk.core.model.NulsDigestData;
import io.nuls.sdk.core.model.transaction.Transaction;
import io.nuls.sdk.core.utils.AssertUtil;
import io.nuls.sdk.core.utils.VarInt;
import java.io.IOException;
import java.util.Base64;
import java.util.List;

public class LedgerUtil {
    private static final int TX_HASH_LENGTH = 34;

    public static byte[] getTxHashBytes(byte[] fromBytes) {
        if (fromBytes == null || fromBytes.length < 34) {
            return null;
        }
        byte[] txBytes = new byte[34];
        System.arraycopy(fromBytes, 0, txBytes, 0, 34);
        return txBytes;
    }

    public static String getTxHash(byte[] fromBytes) {
        byte[] txBytes = LedgerUtil.getTxHashBytes(fromBytes);
        if (txBytes != null) {
            return Hex.encode((byte[])txBytes);
        }
        return null;
    }

    public static byte[] getIndexBytes(byte[] fromBytes) {
        if (fromBytes == null || fromBytes.length < 34) {
            return null;
        }
        int length = fromBytes.length - 34;
        byte[] indexBytes = new byte[length];
        System.arraycopy(fromBytes, 34, indexBytes, 0, length);
        return indexBytes;
    }

    public static Integer getIndex(byte[] fromBytes) {
        byte[] indexBytes = LedgerUtil.getIndexBytes(fromBytes);
        if (indexBytes != null) {
            VarInt varInt = new VarInt(indexBytes, 0);
            return Math.toIntExact(varInt.value);
        }
        return null;
    }

    public static String asString(byte[] bytes) {
        AssertUtil.canNotEmpty((Object)bytes);
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] asBytes(String string) {
        AssertUtil.canNotEmpty((Object)string);
        return Base64.getDecoder().decode(string);
    }

    public static TransactionCreatedReturnInfo makeReturnInfo(Transaction tx) throws IOException {
        String hash = NulsDigestData.calcDigestData((byte[])tx.serializeForHash()).getDigestHex();
        String txHex = Hex.encode((byte[])tx.serialize());
        CoinData coinData = tx.getCoinData();
        List<Input> inputs = ConvertCoinTool.convertInputList(coinData.getFrom());
        List<Output> outputs = ConvertCoinTool.convertOutputList(coinData.getTo(), hash);
        TransactionCreatedReturnInfo returnInfo = new TransactionCreatedReturnInfo(hash, txHex, inputs, outputs);
        return returnInfo;
    }
}

