/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.sdk.accountledger.utils;

import io.nuls.sdk.accountledger.model.Input;
import io.nuls.sdk.accountledger.model.Output;
import io.nuls.sdk.accountledger.utils.LedgerUtil;
import io.nuls.sdk.core.crypto.Hex;
import io.nuls.sdk.core.model.Coin;
import io.nuls.sdk.core.model.Na;
import io.nuls.sdk.core.utils.AddressTool;
import io.nuls.sdk.core.utils.ArraysTool;
import io.nuls.sdk.core.utils.VarInt;
import java.util.ArrayList;
import java.util.List;

public class ConvertCoinTool {
    public static List<Coin> convertCoinList(List<Input> utxos) {
        if (utxos == null || utxos.size() == 0) {
            return null;
        }
        ArrayList<Coin> coinList = new ArrayList<Coin>(utxos.size());
        for (Input utxo : utxos) {
            coinList.add(ConvertCoinTool.convertCoin(utxo));
        }
        return coinList;
    }

    public static Coin convertCoin(Input utxo) {
        Coin coin = new Coin();
        byte[] txHashBytes = Hex.decode((String)utxo.getFromHash());
        coin.setOwner(ArraysTool.concatenate((byte[][])new byte[][]{txHashBytes, new VarInt((long)utxo.getFromIndex()).encode()}));
        coin.setLockTime(utxo.getLockTime());
        coin.setNa(Na.valueOf((long)utxo.getValue()));
        coin.setTempOwner(AddressTool.getAddress((String)utxo.getAddress()));
        return coin;
    }

    public static List<Input> convertInputList(List<Coin> froms) {
        if (froms == null || froms.size() == 0) {
            return null;
        }
        ArrayList<Input> inputs = new ArrayList<Input>(froms.size());
        for (Coin coin : froms) {
            inputs.add(ConvertCoinTool.convertInput(coin));
        }
        return inputs;
    }

    public static Input convertInput(Coin coin) {
        Input input = new Input();
        input.setAddress(AddressTool.getStringAddressByBytes((byte[])coin.getTempOwner()));
        input.setLockTime(coin.getLockTime());
        input.setValue(coin.getNa().getValue());
        input.setFromHash(LedgerUtil.getTxHash(coin.getOwner()));
        input.setFromIndex(LedgerUtil.getIndex(coin.getOwner()));
        return input;
    }

    public static List<Output> convertOutputList(List<Coin> tos, String txHash) {
        if (tos == null || tos.size() == 0) {
            return null;
        }
        int size = tos.size();
        ArrayList<Output> outputs = new ArrayList<Output>(size);
        for (int i = 0; i < size; ++i) {
            outputs.add(ConvertCoinTool.convertOutput(tos.get(i), txHash, i));
        }
        return outputs;
    }

    public static Output convertOutput(Coin coin, String txHash, Integer index) {
        Output output = new Output();
        output.setAddress(AddressTool.getStringAddressByBytes((byte[])coin.getAddress()));
        output.setLockTime(coin.getLockTime());
        output.setValue(coin.getNa().getValue());
        output.setTxHash(txHash);
        output.setIndex(index);
        return output;
    }
}

