/*
 * Decompiled with CFR 0.152.
 */
package io.numerator.datasource.testdata;

import io.numerator.entities.FeatureFlagVariationValue;
import io.numerator.entities.FlagValueType;
import io.numerator.entities.VariationValue;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0005J\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\nJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0001R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/numerator/datasource/testdata/PollingTestDataSource;", "", "()V", "flags", "", "", "Lio/numerator/entities/FeatureFlagVariationValue;", "flagVariation", "key", "getFeatureFlagsMap", "", "getFlags", "", "updateFlagVariation", "", "newValue", "sdk-android"})
public final class PollingTestDataSource {
    @NotNull
    private Map<String, FeatureFlagVariationValue> flags = new LinkedHashMap();

    @Nullable
    public final FeatureFlagVariationValue flagVariation(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.flags.get(key);
    }

    @NotNull
    public final List<FeatureFlagVariationValue> getFlags() {
        return CollectionsKt.toList((Iterable)this.flags.values());
    }

    @NotNull
    public final Map<String, FeatureFlagVariationValue> getFeatureFlagsMap() {
        return this.flags;
    }

    public final void updateFlagVariation(@NotNull String key, @NotNull Object newValue) {
        FeatureFlagVariationValue featureFlagVariationValue;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        Object object = newValue;
        if (object instanceof Boolean) {
            featureFlagVariationValue = new FeatureFlagVariationValue(key, new VariationValue((Boolean)newValue, null, null, null, 14, null), FlagValueType.BOOLEAN);
        } else if (object instanceof String) {
            featureFlagVariationValue = new FeatureFlagVariationValue(key, new VariationValue(null, (String)newValue, null, null, 13, null), FlagValueType.STRING);
        } else if (object instanceof Double) {
            featureFlagVariationValue = new FeatureFlagVariationValue(key, new VariationValue(null, null, null, (Double)newValue, 7, null), FlagValueType.DOUBLE);
        } else if (object instanceof Long) {
            featureFlagVariationValue = new FeatureFlagVariationValue(key, new VariationValue(null, null, (Long)newValue, null, 11, null), FlagValueType.LONG);
        } else {
            throw new IllegalArgumentException("Unsupported new value type");
        }
        FeatureFlagVariationValue variationValue = featureFlagVariationValue;
        this.flags.put(key, variationValue);
    }
}

