/*
 * Decompiled with CFR 0.152.
 */
package io.numerator.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.numerator.common.exception.NumeratorException;
import io.numerator.entities.FeatureFlagCollection;
import io.numerator.repository.CacheDirectoryProvider;
import io.numerator.repository.CacheFlagProvider;
import io.numerator.services.ConfigureObjectMapperKt;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/numerator/repository/DefaultCacheFlagProvider;", "Lio/numerator/repository/CacheFlagProvider;", "Lio/numerator/entities/FeatureFlagCollection;", "cacheDirectoryProvider", "Lio/numerator/repository/CacheDirectoryProvider;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lio/numerator/repository/CacheDirectoryProvider;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "cache", "Ljava/lang/ref/SoftReference;", "clear", "", "read", "write", "collection", "sdk-android"})
@SourceDebugExtension(value={"SMAP\nDefaultCacheFlagProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultCacheFlagProvider.kt\nio/numerator/repository/DefaultCacheFlagProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class DefaultCacheFlagProvider
implements CacheFlagProvider<FeatureFlagCollection> {
    @NotNull
    private final CacheDirectoryProvider cacheDirectoryProvider;
    @NotNull
    private final ObjectMapper objectMapper;
    @Nullable
    private SoftReference<FeatureFlagCollection> cache;

    public DefaultCacheFlagProvider(@NotNull CacheDirectoryProvider cacheDirectoryProvider, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)cacheDirectoryProvider, (String)"cacheDirectoryProvider");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.cacheDirectoryProvider = cacheDirectoryProvider;
        this.objectMapper = objectMapper;
    }

    public /* synthetic */ DefaultCacheFlagProvider(CacheDirectoryProvider cacheDirectoryProvider, ObjectMapper objectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            cacheDirectoryProvider = new CacheDirectoryProvider();
        }
        if ((n & 2) != 0) {
            objectMapper = ConfigureObjectMapperKt.configureObjectMapper();
        }
        this(cacheDirectoryProvider, objectMapper);
    }

    @Override
    @NotNull
    public synchronized FeatureFlagCollection read() {
        SoftReference<FeatureFlagCollection> softReference = this.cache;
        if (softReference != null && (softReference = softReference.get()) != null) {
            SoftReference<FeatureFlagCollection> it = softReference;
            boolean bl = false;
            return it;
        }
        Object object = new String[]{"polling_featureFlags.json"};
        Path path = Paths.get(this.cacheDirectoryProvider.getCacheDirectory().toString(), object);
        try {
            byte[] byArray = Files.readAllBytes(path);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            byte[] it = byArray;
            String json = new String(it, Charsets.UTF_8);
            FeatureFlagCollection data = (FeatureFlagCollection)this.objectMapper.readValue(json, FeatureFlagCollection.class);
            this.cache = new SoftReference<FeatureFlagCollection>(data);
            object = data;
            Intrinsics.checkNotNull((Object)object);
        }
        catch (IOException e) {
            object = new FeatureFlagCollection(CollectionsKt.emptyList());
        }
        return object;
    }

    @Override
    public synchronized void write(@NotNull FeatureFlagCollection collection) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        String[] stringArray = new String[]{"polling_featureFlags.json"};
        Path path = Paths.get(this.cacheDirectoryProvider.getCacheDirectory().toString(), stringArray);
        OpenOption[] json = this.objectMapper.writeValueAsString((Object)collection);
        this.cache = new SoftReference<FeatureFlagCollection>(collection);
        try {
            Intrinsics.checkNotNull((Object)json);
            OpenOption[] openOptionArray = json;
            byte[] byArray = openOptionArray.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
            Files.write(path, byArray, openOptionArray);
        }
        catch (IOException e) {
            throw new NumeratorException("Error writing to cache file " + e.getMessage(), null, 2, null);
        }
    }

    @Override
    public synchronized void clear() {
        this.cache = null;
        String[] stringArray = new String[]{"polling_featureFlags.json"};
        Path path = Paths.get(this.cacheDirectoryProvider.getCacheDirectory().toString(), stringArray);
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            throw new NumeratorException("Error deleting cache file " + e.getMessage(), null, 2, null);
        }
    }

    public DefaultCacheFlagProvider() {
        this(null, null, 3, null);
    }
}

