/*
 * Decompiled with CFR 0.152.
 */
package io.numerator.services.adapter;

import io.numerator.common.exception.HttpInfoTracing;
import io.numerator.common.exception.NumeratorApiException;
import io.numerator.common.exception.NumeratorUnauthorizedException;
import io.numerator.common.exception.UnexpectedApiException;
import io.numerator.entities.NumeratorAPIError;
import io.numerator.entities.ServerErrorData;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.HttpException;
import retrofit2.Response;
import retrofit2.Retrofit;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0007\u001a\u00020\bH\u0096\u0001J\b\u0010\t\u001a\u00020\u0000H\u0016J\u0016\u0010\n\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J-\u0010\r\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00020\u0002 \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00020\u0002\u0018\u00010\u000e0\u000eH\u0096\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u0096\u0001J\t\u0010\u0012\u001a\u00020\u0011H\u0096\u0001J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J1\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a\"\n\b\u0000\u0010\u001b\u0018\u0001*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\bJ\u0011\u0010\u001f\u001a\n \u000f*\u0004\u0018\u00010\u00170\u0017H\u0096\u0001J\u0011\u0010 \u001a\n \u000f*\u0004\u0018\u00010!0!H\u0096\u0001J\"\u0010\"\u001a\u0002H\u001b\"\u0006\b\u0000\u0010\u001b\u0018\u0001*\u00020\u00042\u0006\u0010#\u001a\u00020$H\u0086\b\u00a2\u0006\u0002\u0010%J$\u0010&\u001a\u0004\u0018\u0001H\u001b\"\u0006\b\u0000\u0010\u001b\u0018\u0001*\u00020\u00042\u0006\u0010#\u001a\u00020$H\u0086\b\u00a2\u0006\u0002\u0010%R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/numerator/services/adapter/AppErrorsCallDelegateHandling;", "Lretrofit2/Call;", "", "retrofit", "Lretrofit2/Retrofit;", "delegate", "(Lretrofit2/Retrofit;Lretrofit2/Call;)V", "cancel", "", "clone", "enqueue", "callback", "Lretrofit2/Callback;", "execute", "Lretrofit2/Response;", "kotlin.jvm.PlatformType", "isCanceled", "", "isExecuted", "mapToDomainException", "", "remoteException", "requestInformation", "Lokhttp3/Request;", "parserServerException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "T", "Lio/numerator/entities/ServerErrorData;", "httpException", "Lretrofit2/HttpException;", "request", "timeout", "Lokio/Timeout;", "parseError", "errorBody", "Lokhttp3/ResponseBody;", "(Lretrofit2/Retrofit;Lokhttp3/ResponseBody;)Ljava/lang/Object;", "parseErrorSafety", "sdk-android"})
@SourceDebugExtension(value={"SMAP\nAppErrorsCallDelegateHandling.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppErrorsCallDelegateHandling.kt\nio/numerator/services/adapter/AppErrorsCallDelegateHandling\n*L\n1#1,132:1\n100#1,19:133\n117#1,2:152\n*S KotlinDebug\n*F\n+ 1 AppErrorsCallDelegateHandling.kt\nio/numerator/services/adapter/AppErrorsCallDelegateHandling\n*L\n54#1:133,19\n107#1:152,2\n*E\n"})
public final class AppErrorsCallDelegateHandling
implements Call<Object> {
    @NotNull
    private final Retrofit retrofit;
    @NotNull
    private final Call<Object> delegate;

    public AppErrorsCallDelegateHandling(@NotNull Retrofit retrofit, @NotNull Call<Object> delegate) {
        Intrinsics.checkNotNullParameter((Object)retrofit, (String)"retrofit");
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        this.retrofit = retrofit;
        this.delegate = delegate;
    }

    public void cancel() {
        this.delegate.cancel();
    }

    public Response<Object> execute() {
        return this.delegate.execute();
    }

    public boolean isCanceled() {
        return this.delegate.isCanceled();
    }

    public boolean isExecuted() {
        return this.delegate.isExecuted();
    }

    public Request request() {
        return this.delegate.request();
    }

    public Timeout timeout() {
        return this.delegate.timeout();
    }

    @NotNull
    public AppErrorsCallDelegateHandling clone() {
        Call call = this.delegate.clone();
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"clone(...)");
        return new AppErrorsCallDelegateHandling(this.retrofit, (Call<Object>)call);
    }

    public void enqueue(@NotNull Callback<Object> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.delegate.enqueue((Callback)new Callback<Object>(callback, this){
            final /* synthetic */ Callback<Object> $callback;
            final /* synthetic */ AppErrorsCallDelegateHandling this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
            }

            public void onResponse(@NotNull Call<Object> call, @NotNull Response<Object> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (response.isSuccessful()) {
                    this.$callback.onResponse(call, response);
                } else if (response.code() == 304) {
                    this.$callback.onResponse(call, response);
                } else {
                    Throwable throwable = (Throwable)new HttpException(response);
                    Request request = call.request();
                    Intrinsics.checkNotNullExpressionValue((Object)request, (String)"request(...)");
                    this.$callback.onFailure(call, AppErrorsCallDelegateHandling.access$mapToDomainException(this.this$0, throwable, request));
                }
            }

            public void onFailure(@NotNull Call<Object> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$callback.onFailure(call, t);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final Throwable mapToDomainException(Throwable remoteException, Request requestInformation) {
        Throwable throwable;
        Exception exception;
        ResponseBody errorBody1$iv;
        void httpException$iv;
        if (!(remoteException instanceof HttpException)) {
            return remoteException;
        }
        AppErrorsCallDelegateHandling appErrorsCallDelegateHandling = this;
        HttpException httpException = (HttpException)remoteException;
        Retrofit retrofit = this.retrofit;
        boolean $i$f$parserServerException = false;
        HttpInfoTracing httpInfoTracing$iv = new HttpInfoTracing(requestInformation.url().toString(), requestInformation.method());
        Response response = httpException$iv.response();
        ResponseBody responseBody = errorBody1$iv = response != null ? response.errorBody() : null;
        if (responseBody == null) {
            exception = new UnexpectedApiException((Throwable)httpException$iv, httpInfoTracing$iv);
        } else {
            Exception exception2;
            ResponseBody errorBody$iv = responseBody;
            try {
                void retrofit$iv;
                void this_$iv;
                void var11_10 = this_$iv;
                void $this$parseError$iv$iv = retrofit$iv;
                boolean $i$f$parseError = false;
                Converter converter$iv$iv = $this$parseError$iv$iv.responseBodyConverter((Type)((Object)NumeratorAPIError.class), new Annotation[0]);
                Object object = converter$iv$iv.convert((Object)errorBody$iv);
                Intrinsics.checkNotNull((Object)object);
                ServerErrorData response$iv = (ServerErrorData)object;
                exception2 = new NumeratorApiException(response$iv, httpInfoTracing$iv);
            }
            catch (Throwable ex$iv) {
                exception2 = new UnexpectedApiException(ex$iv, httpInfoTracing$iv);
            }
            exception = exception2;
        }
        Exception apiException = exception;
        HttpInfoTracing httpInfoTracing = new HttpInfoTracing(requestInformation.url().toString(), requestInformation.method());
        switch (((HttpException)remoteException).code()) {
            case 400: {
                throwable = new NumeratorApiException(new NumeratorAPIError("Unexpected error occurred while trying to fetch JSON. It is most likely due to a local network issue. Please make sure your request is valid and try again.", 400, null, null), httpInfoTracing);
                break;
            }
            case 404: {
                throwable = new NumeratorApiException(new NumeratorAPIError("The requested resource was not found. Please make sure your request is valid and try again.", 404, null, null), httpInfoTracing);
                break;
            }
            case 401: {
                throwable = new NumeratorUnauthorizedException("Your SDK Key seems to be wrong. You can find the valid SDK Key at https://web-dashboard.numerator.io/api-key");
                break;
            }
            default: {
                throwable = apiException;
            }
        }
        return throwable;
    }

    public final /* synthetic */ <T extends ServerErrorData> Exception parserServerException(HttpException httpException, Retrofit retrofit, Request requestInformation) {
        Exception exception;
        ResponseBody errorBody1;
        Intrinsics.checkNotNullParameter((Object)httpException, (String)"httpException");
        Intrinsics.checkNotNullParameter((Object)retrofit, (String)"retrofit");
        Intrinsics.checkNotNullParameter((Object)requestInformation, (String)"requestInformation");
        boolean $i$f$parserServerException = false;
        HttpInfoTracing httpInfoTracing = new HttpInfoTracing(requestInformation.url().toString(), requestInformation.method());
        Response response = httpException.response();
        ResponseBody responseBody = errorBody1 = response != null ? response.errorBody() : null;
        if (responseBody == null) {
            return new UnexpectedApiException((Throwable)httpException, httpInfoTracing);
        }
        ResponseBody errorBody = responseBody;
        try {
            AppErrorsCallDelegateHandling appErrorsCallDelegateHandling = this;
            Retrofit $this$parseError$iv = retrofit;
            boolean $i$f$parseError = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            Converter converter$iv = $this$parseError$iv.responseBodyConverter((Type)((Object)Object.class), new Annotation[0]);
            Object object = converter$iv.convert((Object)errorBody);
            Intrinsics.checkNotNull((Object)object);
            ServerErrorData response2 = (ServerErrorData)object;
            exception = new NumeratorApiException(response2, httpInfoTracing);
        }
        catch (Throwable ex) {
            exception = new UnexpectedApiException(ex, httpInfoTracing);
        }
        return exception;
    }

    public final /* synthetic */ <T> T parseError(Retrofit $this$parseError, ResponseBody errorBody) throws Exception {
        Intrinsics.checkNotNullParameter((Object)$this$parseError, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)errorBody, (String)"errorBody");
        boolean $i$f$parseError = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Converter converter = $this$parseError.responseBodyConverter((Type)((Object)Object.class), new Annotation[0]);
        Object object = converter.convert((Object)errorBody);
        Intrinsics.checkNotNull((Object)object);
        return (T)object;
    }

    public final /* synthetic */ <T> T parseErrorSafety(Retrofit $this$parseErrorSafety, ResponseBody errorBody) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$parseErrorSafety, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)errorBody, (String)"errorBody");
        boolean $i$f$parseErrorSafety = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Converter converter = $this$parseErrorSafety.responseBodyConverter((Type)((Object)Object.class), new Annotation[0]);
        try {
            object = converter.convert((Object)errorBody);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            object = null;
        }
        return (T)object;
    }

    public static final /* synthetic */ Throwable access$mapToDomainException(AppErrorsCallDelegateHandling $this, Throwable remoteException, Request requestInformation) {
        return $this.mapToDomainException(remoteException, requestInformation);
    }
}

