/*
 * Decompiled with CFR 0.152.
 */
package io.numerator.services.interceptor;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lio/numerator/services/interceptor/LoggingInterceptor;", "Lokhttp3/Interceptor;", "()V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "sdk-android"})
public final class LoggingInterceptor
implements Interceptor {
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        System.out.println((Object)"--------------------START REQUEST--------------------");
        System.out.println((Object)("URL: " + request.url()));
        System.out.println((Object)("Method: " + request.method()));
        System.out.println((Object)("Headers: " + request.headers()));
        RequestBody requestBody = request.body();
        if (requestBody != null) {
            RequestBody body = requestBody;
            boolean bl = false;
            Buffer buffer = new Buffer();
            body.writeTo((BufferedSink)buffer);
            System.out.println((Object)("Body: " + buffer.readUtf8()));
        }
        System.out.println((Object)"--------------------END REQUEST--------------------");
        long startTime = System.nanoTime();
        Response response = chain.proceed(request);
        long endTime = System.nanoTime();
        System.out.println((Object)"--------------------START RESPONSE--------------------");
        System.out.println((Object)("URL: " + response.request().url()));
        System.out.println((Object)("Code: " + response.code()));
        System.out.println((Object)("Duration: " + (double)(endTime - startTime) / 1000000.0 + " ms"));
        ResponseBody responseBody = response.body();
        if (responseBody != null) {
            ResponseBody body = responseBody;
            boolean bl = false;
            String bodyString = body.string();
            System.out.println((Object)("Body: " + bodyString));
            return response.newBuilder().body(ResponseBody.Companion.create(body.contentType(), bodyString)).build();
        }
        System.out.println((Object)"--------------------END RESPONSE--------------------");
        return response;
    }
}

