/*
 * Decompiled with CFR 0.152.
 */
package io.numerator.services.response;

import io.numerator.entities.NumeratorAPIError;
import io.numerator.services.NumeratorServiceInitializer;
import io.numerator.services.response.Status;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u0014*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0014B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0006\u0010\u0013\u001a\u00020\u0011R\u0015\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lio/numerator/services/response/ApiResponse;", "T", "", "status", "Lio/numerator/services/response/Status;", "data", "error", "Lio/numerator/entities/NumeratorAPIError;", "(Lio/numerator/services/response/Status;Ljava/lang/Object;Lio/numerator/entities/NumeratorAPIError;)V", "getData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getError", "()Lio/numerator/entities/NumeratorAPIError;", "getStatus", "()Lio/numerator/services/response/Status;", "isFailed", "", "isFetched", "isNotModified", "Companion", "sdk-android"})
public final class ApiResponse<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Status status;
    @Nullable
    private final T data;
    @Nullable
    private final NumeratorAPIError error;

    public ApiResponse(@NotNull Status status, @Nullable T data, @Nullable NumeratorAPIError error) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        this.status = status;
        this.data = data;
        this.error = error;
    }

    public /* synthetic */ ApiResponse(Status status, Object object, NumeratorAPIError numeratorAPIError, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            numeratorAPIError = null;
        }
        this(status, object, numeratorAPIError);
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    @Nullable
    public final T getData() {
        return this.data;
    }

    @Nullable
    public final NumeratorAPIError getError() {
        return this.error;
    }

    public final boolean isFetched() {
        return this.status == Status.FETCHED;
    }

    public final boolean isNotModified() {
        return this.status == Status.NOTMODIFIED;
    }

    public final boolean isFailed() {
        return this.status == Status.FAILED;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0004\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\n0\tH\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000b"}, d2={"Lio/numerator/services/response/ApiResponse$Companion;", "", "()V", "apiResponseOf", "Lio/numerator/services/response/ApiResponse;", "T", "successCodeRange", "Lkotlin/ranges/IntRange;", "f", "Lkotlin/Function0;", "Lretrofit2/Response;", "sdk-android"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> ApiResponse<T> apiResponseOf(@NotNull IntRange successCodeRange, @NotNull Function0<Response<T>> f) {
            ApiResponse apiResponse;
            Intrinsics.checkNotNullParameter((Object)successCodeRange, (String)"successCodeRange");
            Intrinsics.checkNotNullParameter(f, (String)"f");
            boolean $i$f$apiResponseOf = false;
            try {
                ApiResponse apiResponse2;
                Response response = (Response)f.invoke();
                int n = successCodeRange.getFirst();
                int n2 = successCodeRange.getLast();
                int n3 = response.code();
                boolean bl = n <= n3 ? n3 <= n2 : false;
                if (bl) {
                    Object object = response.body();
                    if (object == null) {
                        object = Unit.INSTANCE;
                    }
                    apiResponse2 = new ApiResponse(Status.FETCHED, object, null, 4, null);
                } else if (response.code() == 304) {
                    apiResponse2 = new ApiResponse(Status.NOTMODIFIED, null, null, 6, null);
                } else {
                    Object object = response.errorBody();
                    if (object == null || (object = object.string()) == null) {
                        String string = response.toString();
                        object = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    }
                    apiResponse2 = new ApiResponse(Status.FAILED, null, new NumeratorAPIError((String)object, null, null, null, 14, null), 2, null);
                }
                apiResponse = apiResponse2;
            }
            catch (Exception ex) {
                apiResponse = new ApiResponse(Status.FAILED, null, new NumeratorAPIError(ex.getMessage(), null, null, null, 14, null), 2, null);
            }
            return apiResponse;
        }

        public static /* synthetic */ ApiResponse apiResponseOf$default(Companion $this, IntRange successCodeRange, Function0 f, int n, Object apiResponse) {
            if ((n & 1) != 0) {
                successCodeRange = NumeratorServiceInitializer.INSTANCE.getSuccessCodeRange();
            }
            Intrinsics.checkNotNullParameter((Object)successCodeRange, (String)"successCodeRange");
            Intrinsics.checkNotNullParameter((Object)f, (String)"f");
            boolean $i$f$apiResponseOf = false;
            try {
                ApiResponse apiResponse2;
                Response response = (Response)f.invoke();
                int n2 = successCodeRange.getFirst();
                int n3 = successCodeRange.getLast();
                int n4 = response.code();
                boolean bl = n2 <= n4 ? n4 <= n3 : false;
                if (bl) {
                    Object object = response.body();
                    if (object == null) {
                        object = Unit.INSTANCE;
                    }
                    apiResponse2 = new ApiResponse(Status.FETCHED, object, null, 4, null);
                } else if (response.code() == 304) {
                    apiResponse2 = new ApiResponse(Status.NOTMODIFIED, null, null, 6, null);
                } else {
                    Object object = response.errorBody();
                    if (object == null || (object = object.string()) == null) {
                        String string = response.toString();
                        object = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    }
                    apiResponse2 = new ApiResponse(Status.FAILED, null, new NumeratorAPIError((String)object, null, null, null, 14, null), 2, null);
                }
                apiResponse = apiResponse2;
            }
            catch (Exception ex) {
                apiResponse = new ApiResponse(Status.FAILED, null, new NumeratorAPIError(ex.getMessage(), null, null, null, 14, null), 2, null);
            }
            return apiResponse;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

