/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.gradle.transform;

import io.objectbox.gradle.transform.ObjectBoxJavaTransform;
import io.objectbox.logging.Logging;
import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lio/objectbox/gradle/transform/ObjectBoxTestClassesTransformTask;", "Lorg/gradle/api/DefaultTask;", "()V", "compiledClasses", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getCompiledClasses", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "debug", "Lorg/gradle/api/provider/Property;", "", "getDebug", "()Lorg/gradle/api/provider/Property;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "transformClasses", "", "ConfigAction", "objectbox-gradle-plugin"})
public abstract class ObjectBoxTestClassesTransformTask
extends DefaultTask {
    @Input
    @NotNull
    public abstract Property<Boolean> getDebug();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getCompiledClasses();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @TaskAction
    public final void transformClasses() {
        File outputDir;
        File file = outputDir = (File)this.getOutputDir().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputDir");
        FilesKt.deleteRecursively((File)file);
        outputDir.mkdirs();
        Set set = this.getCompiledClasses().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"compiledClasses.files");
        List compiledClassesFiles = CollectionsKt.reversed((Iterable)CollectionsKt.toList((Iterable)set));
        Iterable $this$forEach$iv = compiledClassesFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            File file2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it");
            if (!file2.isFile() || !Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"jar")) continue;
            Logging.logWarning((String)("Detected JAR file in transform classpath (" + it + "), local unit tests might not work, please report this to us."));
        }
        Object object = this.getDebug().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"debug.get()");
        new ObjectBoxJavaTransform((Boolean)object).transform(compiledClassesFiles, outputDir, false);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/objectbox/gradle/transform/ObjectBoxTestClassesTransformTask$ConfigAction;", "Lorg/gradle/api/Action;", "Lio/objectbox/gradle/transform/ObjectBoxTestClassesTransformTask;", "debug", "", "outputDir", "Ljava/io/File;", "inputClasspath", "Lorg/gradle/api/file/FileCollection;", "(ZLjava/io/File;Lorg/gradle/api/file/FileCollection;)V", "execute", "", "transformTask", "objectbox-gradle-plugin"})
    public static final class ConfigAction
    implements Action<ObjectBoxTestClassesTransformTask> {
        private final boolean debug;
        private final File outputDir;
        private final FileCollection inputClasspath;

        public void execute(@NotNull ObjectBoxTestClassesTransformTask transformTask) {
            Intrinsics.checkNotNullParameter((Object)((Object)transformTask), (String)"transformTask");
            transformTask.setGroup("objectbox");
            transformTask.setDescription("Transforms Java bytecode for local unit tests.");
            transformTask.getDebug().set((Object)this.debug);
            transformTask.getOutputDir().set(this.outputDir);
            transformTask.getCompiledClasses().from(new Object[]{this.inputClasspath});
        }

        public ConfigAction(boolean debug, @NotNull File outputDir, @NotNull FileCollection inputClasspath2) {
            Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
            Intrinsics.checkNotNullParameter((Object)inputClasspath2, (String)"inputClasspath");
            this.debug = debug;
            this.outputDir = outputDir;
            this.inputClasspath = inputClasspath2;
        }
    }
}

