/*
 * Copyright 2020 ObjectBox Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// automatically generated by the FlatBuffers compiler, do not modify

package io.objectbox.model;

import java.nio.*;
import java.lang.*;
import java.util.*;
import com.google.flatbuffers.*;

/**
 * Options to open a store with. Set only the values you want; defaults are used otherwise.
 * Reminder: enable "force defaults" in the FlatBuffers builder, e.g. to pass in booleans with value "false".
 * NOTE: some setting are for "advanced" purposes that you can typically ignore for regular usage.
 *       When using advanced setting, you should know exactly what you are doing.
 */
@SuppressWarnings("unused")
public final class FlatStoreOptions extends Table {
  public static void ValidateVersion() { Constants.FLATBUFFERS_1_12_0(); }
  public static FlatStoreOptions getRootAsFlatStoreOptions(ByteBuffer _bb) { return getRootAsFlatStoreOptions(_bb, new FlatStoreOptions()); }
  public static FlatStoreOptions getRootAsFlatStoreOptions(ByteBuffer _bb, FlatStoreOptions obj) { _bb.order(ByteOrder.LITTLE_ENDIAN); return (obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb)); }
  public void __init(int _i, ByteBuffer _bb) { __reset(_i, _bb); }
  public FlatStoreOptions __assign(int _i, ByteBuffer _bb) { __init(_i, _bb); return this; }

  /**
   * Location of the database on disk; this will be a directory containing files.
   */
  public String directoryPath() { int o = __offset(4); return o != 0 ? __string(o + bb_pos) : null; }
  public ByteBuffer directoryPathAsByteBuffer() { return __vector_as_bytebuffer(4, 1); }
  public ByteBuffer directoryPathInByteBuffer(ByteBuffer _bb) { return __vector_in_bytebuffer(_bb, 4, 1); }
  /**
   * Provide a data model, e.g. to initialize or update the schema.
   */
  public int modelBytes(int j) { int o = __offset(6); return o != 0 ? bb.get(__vector(o) + j * 1) & 0xFF : 0; }
  public int modelBytesLength() { int o = __offset(6); return o != 0 ? __vector_len(o) : 0; }
  public ByteVector modelBytesVector() { return modelBytesVector(new ByteVector()); }
  public ByteVector modelBytesVector(ByteVector obj) { int o = __offset(6); return o != 0 ? obj.__assign(__vector(o), bb) : null; }
  public ByteBuffer modelBytesAsByteBuffer() { return __vector_as_bytebuffer(6, 1); }
  public ByteBuffer modelBytesInByteBuffer(ByteBuffer _bb) { return __vector_in_bytebuffer(_bb, 6, 1); }
  /**
   * This maximum size setting is meant to prevent your database from growing to unexpected sizes,
   * e.g. caused by programming error.
   * If your app runs into errors like "db full", you may consider to raise the limit.
   */
  public long maxDbSizeInKByte() { int o = __offset(8); return o != 0 ? bb.getLong(o + bb_pos) : 0L; }
  /**
   * File permissions given in Unix style octal bit flags (e.g. 0644). Ignored on Windows.
   * Note: directories become searchable if the "read" or "write" permission is set (e.g. 0640 becomes 0750).
   */
  public long fileMode() { int o = __offset(10); return o != 0 ? (long)bb.getInt(o + bb_pos) & 0xFFFFFFFFL : 0L; }
  /**
   * The maximum number of readers.
   * "Readers" are an finite resource for which we need to define a maximum number upfront.
   * The default value is enough for most apps and usually you can ignore it completely.
   * However, if you get the OBX_ERROR_MAX_READERS_EXCEEDED error, you should verify your
   * threading. For each thread, ObjectBox uses multiple readers. Their number (per thread) depends
   * on number of types, relations, and usage patterns. Thus, if you are working with many threads
   * (e.g. in a server-like scenario), it can make sense to increase the maximum number of readers.
   * Note: The internal default is currently around 120.
   *       So when hitting this limit, try values around 200-500.
   */
  public long maxReaders() { int o = __offset(12); return o != 0 ? (long)bb.getInt(o + bb_pos) & 0xFFFFFFFFL : 0L; }
  /**
   * When a database is opened, ObjectBox can perform additional consistency checks on its database structure.
   * Reliable file systems already guarantee consistency, so this is primarily meant to deal with unreliable
   * OSes, file systems, or hardware.
   * Note: ObjectBox builds upon ACID storage, which already has strong consistency mechanisms in place.
   */
  public int validateOnOpen() { int o = __offset(14); return o != 0 ? bb.getShort(o + bb_pos) & 0xFFFF : 0; }
  /**
   * To fine-tune database validation, you can specify a limit on how much data is looked at.
   * This is measured in "pages" with a page typically holding 4K.
   * Usually a low number (e.g. 1-20) is sufficient and does not impact startup performance significantly.
   * This is only to be used with ValidateOnOpenMode "Regular" and "WithLeaves".
   */
  public long validateOnOpenPageLimit() { int o = __offset(16); return o != 0 ? bb.getLong(o + bb_pos) : 0L; }
  /**
   * Don't touch unless you know exactly what you are doing:
   * Advanced setting typically meant for language bindings (not end users). See PutPaddingMode description.
   */
  public int putPaddingMode() { int o = __offset(18); return o != 0 ? bb.getShort(o + bb_pos) & 0xFFFF : 0; }
  /**
   * Advanced setting meant only for special scenarios: opens the database in a limited, schema-less mode.
   * If you don't know what this means exactly: ignore this flag.
   */
  public boolean skipReadSchema() { int o = __offset(20); return o != 0 ? 0!=bb.get(o + bb_pos) : false; }
  /**
   * Advanced setting recommended to be used together with read-only mode to ensure no data is lost.
   * Ignores the latest data snapshot (committed transaction state) and uses the previous snapshot instead.
   * When used with care (e.g. backup the DB files first), this option may also recover data removed by the latest
   * transaction.
   */
  public boolean usePreviousCommit() { int o = __offset(22); return o != 0 ? 0!=bb.get(o + bb_pos) : false; }
  /**
   * NOT IMPLEMENTED YET. Placeholder for a future version only.
   * If consistency checks fail during opening the DB (see also the pagesToValidateOnOpen setting), ObjectBox
   * automatically switches to the previous commit (see also usePreviousCommit). This way, this constitutes
   * an auto-recover mode from severe failures. HOWEVER, keep in mind that any consistency failure
   * is an indication that something is very wrong with OS/hardware and thus you should also check
   * openedWithPreviousCommit(), e.g. to alert your users.
   */
  public boolean usePreviousCommitOnValidationFailure() { int o = __offset(24); return o != 0 ? 0!=bb.get(o + bb_pos) : false; }
  /**
   * Open store in read-only mode: no schema update, no write transactions.
   */
  public boolean readOnly() { int o = __offset(26); return o != 0 ? 0!=bb.get(o + bb_pos) : false; }
  /**
   * For debugging purposes you may want enable specific logging.
   */
  public long debugFlags() { int o = __offset(28); return o != 0 ? (long)bb.getInt(o + bb_pos) & 0xFFFFFFFFL : 0L; }

  public static int createFlatStoreOptions(FlatBufferBuilder builder,
      int directoryPathOffset,
      int modelBytesOffset,
      long maxDbSizeInKByte,
      long fileMode,
      long maxReaders,
      int validateOnOpen,
      long validateOnOpenPageLimit,
      int putPaddingMode,
      boolean skipReadSchema,
      boolean usePreviousCommit,
      boolean usePreviousCommitOnValidationFailure,
      boolean readOnly,
      long debugFlags) {
    builder.startTable(13);
    FlatStoreOptions.addValidateOnOpenPageLimit(builder, validateOnOpenPageLimit);
    FlatStoreOptions.addMaxDbSizeInKByte(builder, maxDbSizeInKByte);
    FlatStoreOptions.addDebugFlags(builder, debugFlags);
    FlatStoreOptions.addMaxReaders(builder, maxReaders);
    FlatStoreOptions.addFileMode(builder, fileMode);
    FlatStoreOptions.addModelBytes(builder, modelBytesOffset);
    FlatStoreOptions.addDirectoryPath(builder, directoryPathOffset);
    FlatStoreOptions.addPutPaddingMode(builder, putPaddingMode);
    FlatStoreOptions.addValidateOnOpen(builder, validateOnOpen);
    FlatStoreOptions.addReadOnly(builder, readOnly);
    FlatStoreOptions.addUsePreviousCommitOnValidationFailure(builder, usePreviousCommitOnValidationFailure);
    FlatStoreOptions.addUsePreviousCommit(builder, usePreviousCommit);
    FlatStoreOptions.addSkipReadSchema(builder, skipReadSchema);
    return FlatStoreOptions.endFlatStoreOptions(builder);
  }

  public static void startFlatStoreOptions(FlatBufferBuilder builder) { builder.startTable(13); }
  public static void addDirectoryPath(FlatBufferBuilder builder, int directoryPathOffset) { builder.addOffset(0, directoryPathOffset, 0); }
  public static void addModelBytes(FlatBufferBuilder builder, int modelBytesOffset) { builder.addOffset(1, modelBytesOffset, 0); }
  public static int createModelBytesVector(FlatBufferBuilder builder, byte[] data) { return builder.createByteVector(data); }
  public static int createModelBytesVector(FlatBufferBuilder builder, ByteBuffer data) { return builder.createByteVector(data); }
  public static void startModelBytesVector(FlatBufferBuilder builder, int numElems) { builder.startVector(1, numElems, 1); }
  public static void addMaxDbSizeInKByte(FlatBufferBuilder builder, long maxDbSizeInKByte) { builder.addLong(2, maxDbSizeInKByte, 0L); }
  public static void addFileMode(FlatBufferBuilder builder, long fileMode) { builder.addInt(3, (int)fileMode, (int)0L); }
  public static void addMaxReaders(FlatBufferBuilder builder, long maxReaders) { builder.addInt(4, (int)maxReaders, (int)0L); }
  public static void addValidateOnOpen(FlatBufferBuilder builder, int validateOnOpen) { builder.addShort(5, (short)validateOnOpen, (short)0); }
  public static void addValidateOnOpenPageLimit(FlatBufferBuilder builder, long validateOnOpenPageLimit) { builder.addLong(6, validateOnOpenPageLimit, 0L); }
  public static void addPutPaddingMode(FlatBufferBuilder builder, int putPaddingMode) { builder.addShort(7, (short)putPaddingMode, (short)0); }
  public static void addSkipReadSchema(FlatBufferBuilder builder, boolean skipReadSchema) { builder.addBoolean(8, skipReadSchema, false); }
  public static void addUsePreviousCommit(FlatBufferBuilder builder, boolean usePreviousCommit) { builder.addBoolean(9, usePreviousCommit, false); }
  public static void addUsePreviousCommitOnValidationFailure(FlatBufferBuilder builder, boolean usePreviousCommitOnValidationFailure) { builder.addBoolean(10, usePreviousCommitOnValidationFailure, false); }
  public static void addReadOnly(FlatBufferBuilder builder, boolean readOnly) { builder.addBoolean(11, readOnly, false); }
  public static void addDebugFlags(FlatBufferBuilder builder, long debugFlags) { builder.addInt(12, (int)debugFlags, (int)0L); }
  public static int endFlatStoreOptions(FlatBufferBuilder builder) {
    int o = builder.endTable();
    return o;
  }
  public static void finishFlatStoreOptionsBuffer(FlatBufferBuilder builder, int offset) { builder.finish(offset); }
  public static void finishSizePrefixedFlatStoreOptionsBuffer(FlatBufferBuilder builder, int offset) { builder.finishSizePrefixed(offset); }

  public static final class Vector extends BaseVector {
    public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) { __reset(_vector, _element_size, _bb); return this; }

    public FlatStoreOptions get(int j) { return get(new FlatStoreOptions(), j); }
    public FlatStoreOptions get(FlatStoreOptions obj, int j) {  return obj.__assign(__indirect(__element(j), bb), bb); }
  }
}

