/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.reactive;

import io.objectbox.annotation.apihint.Internal;
import io.objectbox.reactive.DataObserver;
import io.objectbox.reactive.DataSubscription;
import io.objectbox.reactive.DelegatingObserver;
import java.lang.ref.WeakReference;

@Internal
public class WeakDataObserver<T>
implements DataObserver<T>,
DelegatingObserver {
    private final WeakReference<DataObserver<T>> weakDelegate;
    private DataSubscription subscription;

    WeakDataObserver(DataObserver<T> delegate) {
        this.weakDelegate = new WeakReference<DataObserver<DataObserver<T>>>(delegate);
    }

    @Override
    public void onData(T data) {
        DataObserver delegate = (DataObserver)this.weakDelegate.get();
        if (delegate != null) {
            delegate.onData(data);
        } else {
            this.subscription.cancel();
        }
    }

    @Override
    public DataObserver<T> getObserverDelegate() {
        return (DataObserver)this.weakDelegate.get();
    }

    public boolean equals(Object other) {
        if (other instanceof WeakDataObserver) {
            DataObserver delegate = (DataObserver)this.weakDelegate.get();
            if (delegate != null && delegate == ((WeakDataObserver)other).weakDelegate.get()) {
                return true;
            }
            return super.equals(other);
        }
        return false;
    }

    public int hashCode() {
        DataObserver delegate = (DataObserver)this.weakDelegate.get();
        if (delegate != null) {
            return delegate.hashCode();
        }
        return super.hashCode();
    }

    public void setSubscription(DataSubscription subscription) {
        this.subscription = subscription;
    }
}

