/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.relation;

import io.objectbox.Box;
import io.objectbox.BoxStore;
import io.objectbox.Cursor;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.exception.DbDetachedException;
import io.objectbox.internal.ReflectionCache;
import io.objectbox.relation.RelationInfo;
import java.io.Serializable;
import java.lang.reflect.Field;
import javax.annotation.Nullable;

public class ToOne<TARGET>
implements Serializable {
    private static final long serialVersionUID = 5092547044335989281L;
    private final Object entity;
    private final RelationInfo<Object, TARGET> relationInfo;
    private final boolean virtualProperty;
    private transient BoxStore boxStore;
    private transient Box<Object> entityBox;
    private volatile transient Box<TARGET> targetBox;
    private transient Field targetIdField;
    private TARGET target;
    private long targetId;
    private volatile long resolvedTargetId;
    private boolean checkIdOfTargetForPut;
    private boolean debugRelations;

    public ToOne(Object sourceEntity, RelationInfo<?, TARGET> relationInfo) {
        if (sourceEntity == null) {
            throw new IllegalArgumentException("No source entity given (null)");
        }
        if (relationInfo == null) {
            throw new IllegalArgumentException("No relation info given (null)");
        }
        this.entity = sourceEntity;
        this.relationInfo = relationInfo;
        this.virtualProperty = relationInfo.targetIdProperty.isVirtual;
    }

    public TARGET getTarget() {
        return this.getTarget(this.getTargetId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public TARGET getTarget(long targetId) {
        ToOne toOne = this;
        synchronized (toOne) {
            if (this.resolvedTargetId == targetId) {
                return this.target;
            }
        }
        this.ensureBoxes(null);
        TARGET targetNew = this.targetBox.get(targetId);
        this.setResolvedTarget(targetNew, targetId);
        return targetNew;
    }

    private void ensureBoxes(@Nullable TARGET target) {
        if (this.targetBox == null) {
            Field boxStoreField = ReflectionCache.getInstance().getField(this.entity.getClass(), "__boxStore");
            try {
                this.boxStore = (BoxStore)boxStoreField.get(this.entity);
                if (this.boxStore == null) {
                    if (target != null) {
                        boxStoreField = ReflectionCache.getInstance().getField(target.getClass(), "__boxStore");
                        this.boxStore = (BoxStore)boxStoreField.get(target);
                    }
                    if (this.boxStore == null) {
                        throw new DbDetachedException("Cannot resolve relation for detached entities, call box.attach(entity) beforehand.");
                    }
                }
                this.debugRelations = this.boxStore.isDebugRelations();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            this.entityBox = this.boxStore.boxFor(this.relationInfo.sourceInfo.getEntityClass());
            this.targetBox = this.boxStore.boxFor(this.relationInfo.targetInfo.getEntityClass());
        }
    }

    public TARGET getCachedTarget() {
        return this.target;
    }

    public boolean isResolved() {
        return this.resolvedTargetId == this.getTargetId();
    }

    public boolean isResolvedAndNotNull() {
        return this.resolvedTargetId != 0L && this.resolvedTargetId == this.getTargetId();
    }

    public boolean isNull() {
        return this.getTargetId() == 0L && this.target == null;
    }

    public void setTargetId(long targetId) {
        if (this.virtualProperty) {
            this.targetId = targetId;
        } else {
            try {
                this.getTargetIdField().set(this.entity, targetId);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could not update to-one ID in entity", e);
            }
        }
        if (targetId != 0L) {
            this.checkIdOfTargetForPut = false;
        }
    }

    void setAndUpdateTargetId(long targetId) {
        this.setTargetId(targetId);
        this.ensureBoxes(null);
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setTarget(@Nullable TARGET target) {
        if (target != null) {
            long targetId = this.relationInfo.targetInfo.getIdGetter().getId(target);
            this.checkIdOfTargetForPut = targetId == 0L;
            this.setTargetId(targetId);
            this.setResolvedTarget(target, targetId);
        } else {
            this.setTargetId(0L);
            this.clearResolved();
        }
    }

    public void setAndPutTarget(@Nullable TARGET target) {
        this.ensureBoxes(target);
        if (target != null) {
            long targetId = this.targetBox.getId(target);
            if (targetId == 0L) {
                this.setAndPutTargetAlways(target);
            } else {
                this.setTargetId(targetId);
                this.setResolvedTarget(target, targetId);
                this.entityBox.put(this.entity);
            }
        } else {
            this.setTargetId(0L);
            this.clearResolved();
            this.entityBox.put(this.entity);
        }
    }

    public void setAndPutTargetAlways(@Nullable TARGET target) {
        this.ensureBoxes(target);
        if (target != null) {
            this.boxStore.runInTx(() -> {
                long targetKey = this.targetBox.put(target);
                this.setResolvedTarget(target, targetKey);
                this.entityBox.put(this.entity);
            });
        } else {
            this.setTargetId(0L);
            this.clearResolved();
            this.entityBox.put(this.entity);
        }
    }

    private synchronized void setResolvedTarget(@Nullable TARGET target, long targetId) {
        if (this.debugRelations) {
            System.out.println("Setting resolved ToOne target to " + (target == null ? "null" : "non-null") + " for ID " + targetId);
        }
        this.resolvedTargetId = targetId;
        this.target = target;
    }

    private synchronized void clearResolved() {
        this.resolvedTargetId = 0L;
        this.target = null;
    }

    public long getTargetId() {
        if (this.virtualProperty) {
            return this.targetId;
        }
        Field keyField = this.getTargetIdField();
        try {
            Long key = (Long)keyField.get(this.entity);
            return key != null ? key : 0L;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not access field " + keyField);
        }
    }

    private Field getTargetIdField() {
        if (this.targetIdField == null) {
            this.targetIdField = ReflectionCache.getInstance().getField(this.entity.getClass(), this.relationInfo.targetIdProperty.name);
        }
        return this.targetIdField;
    }

    @Internal
    public boolean internalRequiresPutTarget() {
        return this.checkIdOfTargetForPut && this.target != null && this.getTargetId() == 0L;
    }

    @Internal
    public void internalPutTarget(Cursor<TARGET> targetCursor) {
        this.checkIdOfTargetForPut = false;
        long id = targetCursor.put(this.target);
        this.setTargetId(id);
        this.setResolvedTarget(this.target, id);
    }

    Object getEntity() {
        return this.entity;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ToOne)) {
            return false;
        }
        ToOne other = (ToOne)obj;
        return this.relationInfo == other.relationInfo && this.getTargetId() == other.getTargetId();
    }

    public int hashCode() {
        long targetId = this.getTargetId();
        return (int)(targetId ^ targetId >>> 32);
    }
}

