/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.tree;

import io.objectbox.BoxStore;
import io.objectbox.InternalAccess;
import io.objectbox.Transaction;
import io.objectbox.annotation.apihint.Experimental;
import io.objectbox.tree.Branch;
import io.objectbox.tree.Leaf;
import io.objectbox.tree.LeafNode;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

@Experimental
public class Tree {
    private long handle;
    private final BoxStore store;

    public Tree(BoxStore store, String uid) {
        this.store = store;
        if (store == null) {
            throw new IllegalArgumentException("store must not be null");
        }
        if (uid == null || uid.length() == 0) {
            throw new IllegalArgumentException("uid must be 0 or not empty");
        }
        this.handle = Tree.nativeCreateWithUid(store.getNativeStore(), uid);
    }

    public Tree(BoxStore store, long rootId) {
        this.store = store;
        if (store == null) {
            throw new IllegalArgumentException("store must not be null");
        }
        this.handle = Tree.nativeCreate(store.getNativeStore(), rootId);
    }

    long getHandle() {
        return this.handle;
    }

    public BoxStore getStore() {
        return this.store;
    }

    public Branch root() {
        long dataBranchId = this.nativeGetRootId(this.handle);
        return new Branch(this, dataBranchId);
    }

    public void close() {
        long handle = this.handle;
        Tree.nativeDelete(handle);
        this.handle = 0L;
    }

    public void runInTx(Runnable runnable) {
        this.store.runInTx(this.createTxRunnable(runnable));
    }

    public void runInReadTx(Runnable runnable) {
        this.store.runInReadTx(this.createTxRunnable(runnable));
    }

    public <T> T callInTx(Callable<T> callable) throws Exception {
        return this.store.callInTx(this.createTxCallable(callable));
    }

    public <T> T callInTxNoThrow(Callable<T> callable) {
        try {
            return this.store.callInTx(this.createTxCallable(callable));
        }
        catch (Exception e) {
            throw new RuntimeException("Callable threw exception", e);
        }
    }

    public <T> T callInReadTx(Callable<T> callable) {
        return this.store.callInReadTx(this.createTxCallable(callable));
    }

    private Runnable createTxRunnable(Runnable runnable) {
        return () -> {
            Transaction tx = InternalAccess.getActiveTx(this.store);
            boolean topLevel = this.nativeSetTransaction(this.handle, InternalAccess.getHandle(tx));
            try {
                runnable.run();
            }
            finally {
                if (topLevel) {
                    this.nativeClearTransaction(this.handle);
                }
            }
        };
    }

    private <T> Callable<T> createTxCallable(Callable<T> callable) {
        return () -> {
            Transaction tx = InternalAccess.getActiveTx(this.store);
            boolean topLevel = this.nativeSetTransaction(this.handle, InternalAccess.getHandle(tx));
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                if (topLevel) {
                    this.nativeClearTransaction(this.handle);
                }
            }
        };
    }

    @Nullable
    public Leaf getLeaf(long id) {
        LeafNode leafNode = this.nativeGetLeafById(this.handle, id);
        if (leafNode == null) {
            return null;
        }
        return new Leaf(leafNode);
    }

    @Nullable
    public String getString(long id) {
        Leaf leaf = this.getLeaf(id);
        return leaf != null ? leaf.asString() : null;
    }

    @Nullable
    public Long getInteger(long id) {
        Leaf leaf = this.getLeaf(id);
        return leaf != null ? leaf.asInt() : null;
    }

    @Nullable
    public Double getDouble(long id) {
        Leaf leaf = this.getLeaf(id);
        return leaf != null ? leaf.asDouble() : null;
    }

    long putMetaBranch(long id, long parentBranchId, String name) {
        return this.nativePutMetaBranch(this.handle, id, parentBranchId, name, null);
    }

    long putMetaBranch(long id, long parentBranchId, String name, @Nullable String uid) {
        return this.nativePutMetaBranch(this.handle, id, parentBranchId, name, uid);
    }

    long[] putMetaBranches(String[] path) {
        return this.nativePutMetaBranches(this.handle, 0L, path);
    }

    long[] putMetaBranches(long parentBranchId, String[] path) {
        return this.nativePutMetaBranches(this.handle, parentBranchId, path);
    }

    long putMetaLeaf(long id, long parentBranchId, String name, short valueType) {
        return this.nativePutMetaLeaf(this.handle, id, parentBranchId, name, valueType, false, null);
    }

    long putMetaLeaf(long id, long parentBranchId, String name, short valueType, boolean isUnsigned) {
        return this.nativePutMetaLeaf(this.handle, id, parentBranchId, name, valueType, isUnsigned, null);
    }

    long putMetaLeaf(long id, long parentBranchId, String name, short valueType, boolean isUnsigned, @Nullable String description) {
        return this.nativePutMetaLeaf(this.handle, id, parentBranchId, name, valueType, isUnsigned, description);
    }

    long putBranch(long id, long parentBranchId, long metaId, @Nullable String uid) {
        return this.nativePutBranch(this.handle, id, parentBranchId, metaId, uid);
    }

    long putBranch(long parentBranchId, long metaId, @Nullable String uid) {
        return this.nativePutBranch(this.handle, 0L, parentBranchId, metaId, uid);
    }

    long putBranch(long parentBranchId, long metaId) {
        return this.nativePutBranch(this.handle, 0L, parentBranchId, metaId, null);
    }

    long putValue(long id, long parentBranchId, long metaId, long value) {
        return this.nativePutValueInteger(this.handle, id, parentBranchId, metaId, value);
    }

    long putValue(long parentBranchId, long metaId, long value) {
        return this.nativePutValueInteger(this.handle, 0L, parentBranchId, metaId, value);
    }

    long putValue(long parentBranchId, long metaId, double value) {
        return this.nativePutValueFP(this.handle, 0L, parentBranchId, metaId, value);
    }

    long putValue(long id, long parentBranchId, long metaId, double value) {
        return this.nativePutValueFP(this.handle, id, parentBranchId, metaId, value);
    }

    long putValue(long id, long parentBranchId, long metaId, String value) {
        return this.nativePutValueString(this.handle, id, parentBranchId, metaId, value);
    }

    long putValue(long parentBranchId, long metaId, String value) {
        return this.nativePutValueString(this.handle, 0L, parentBranchId, metaId, value);
    }

    public long put(Leaf leaf) {
        long id = leaf.getId();
        long parentId = leaf.getParentBranchId();
        long metaId = leaf.getMetaId();
        switch (leaf.getValueType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this.nativePutValueInteger(this.handle, id, parentId, metaId, leaf.getInt());
            }
            case 7: 
            case 8: {
                return this.nativePutValueFP(this.handle, id, parentId, metaId, leaf.getDouble());
            }
            case 9: 
            case 23: {
                return this.nativePutValueString(this.handle, id, parentId, metaId, leaf.getString());
            }
        }
        throw new UnsupportedOperationException("Unsupported value type: " + leaf.getValueType());
    }

    static native long nativeCreate(long var0, long var2);

    static native long nativeCreateWithUid(long var0, String var2);

    static native void nativeDelete(long var0);

    native boolean nativeSetTransaction(long var1, long var3);

    native void nativeClearTransaction(long var1);

    native long nativeGetRootId(long var1);

    native LeafNode nativeGetLeafById(long var1, long var3);

    native long nativePutMetaBranch(long var1, long var3, long var5, String var7, @Nullable String var8);

    native long[] nativePutMetaBranches(long var1, long var3, String[] var5);

    native long nativePutMetaLeaf(long var1, long var3, long var5, String var7, short var8, boolean var9, @Nullable String var10);

    native long nativePutBranch(long var1, long var3, long var5, long var7, @Nullable String var9);

    native long nativePutValueInteger(long var1, long var3, long var5, long var7, long var9);

    native long nativePutValueFP(long var1, long var3, long var5, long var7, double var9);

    native long nativePutValueString(long var1, long var3, long var5, long var7, @Nullable String var9);
}

