/*
 * Copyright 2024 ObjectBox Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// automatically generated by the FlatBuffers compiler, do not modify

package io.objectbox.sync;

/**
 * Flags to adjust sync behavior like additional logging.
 */
@SuppressWarnings("unused")
public final class SyncFlags {
  private SyncFlags() { }
  /**
   * Enable (rather extensive) logging on how IDs are mapped (local <-> global)
   */
  public static final int DebugLogIdMapping = 1;
  /**
   * If the client gets in a state that does not allow any further synchronization, this flag instructs Sync to
   * keep local data nevertheless. While this preserves data, you need to resolve the situation manually.
   * For example, you could backup the data and start with a fresh database.
   * Note that the default behavior (this flag is not set) is to wipe existing data from all sync-enabled types and
   * sync from scratch from the server.
   * Client-only: setting this flag for Sync server has no effect.
   */
  public static final int ClientKeepDataOnSyncError = 2;
}

