/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync;

import io.objectbox.BoxStore;
import io.objectbox.BoxStoreBuilder;
import io.objectbox.sync.SyncBuilder;
import io.objectbox.sync.SyncCredentials;
import io.objectbox.sync.SyncHybridBuilder;
import io.objectbox.sync.server.SyncServerBuilder;

public final class Sync {
    public static boolean isAvailable() {
        return BoxStore.isSyncAvailable();
    }

    public static boolean isServerAvailable() {
        return BoxStore.isSyncServerAvailable();
    }

    public static boolean isHybridAvailable() {
        return Sync.isAvailable() && Sync.isServerAvailable();
    }

    public static SyncBuilder client(BoxStore boxStore, String url, SyncCredentials credentials) {
        return new SyncBuilder(boxStore, url, credentials);
    }

    public static SyncServerBuilder server(BoxStore boxStore, String url, SyncCredentials authenticatorCredentials) {
        return new SyncServerBuilder(boxStore, url, authenticatorCredentials);
    }

    public static SyncHybridBuilder hybrid(BoxStoreBuilder storeBuilder, String url, SyncCredentials authenticatorCredentials) {
        return new SyncHybridBuilder(storeBuilder, url, authenticatorCredentials);
    }

    private Sync() {
    }
}

