/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync;

import io.objectbox.BoxStore;
import io.objectbox.BoxStoreBuilder;
import io.objectbox.InternalAccess;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.sync.SyncBuilder;
import io.objectbox.sync.SyncClient;
import io.objectbox.sync.SyncCredentials;
import io.objectbox.sync.SyncHybrid;
import io.objectbox.sync.server.SyncServer;
import io.objectbox.sync.server.SyncServerBuilder;

public final class SyncHybridBuilder {
    private final BoxStore boxStore;
    private final BoxStore boxStoreServer;
    private final SyncBuilder clientBuilder;
    private final SyncServerBuilder serverBuilder;

    @Internal
    SyncHybridBuilder(BoxStoreBuilder storeBuilder, String url, SyncCredentials authenticatorCredentials) {
        BoxStoreBuilder storeBuilderServer = InternalAccess.clone(storeBuilder, "-server");
        this.boxStore = storeBuilder.build();
        this.boxStoreServer = storeBuilderServer.build();
        SyncCredentials clientCredentials = authenticatorCredentials.createClone();
        this.clientBuilder = new SyncBuilder(this.boxStore, clientCredentials);
        this.serverBuilder = new SyncServerBuilder(this.boxStoreServer, url, authenticatorCredentials);
    }

    public SyncBuilder clientBuilder() {
        return this.clientBuilder;
    }

    public SyncServerBuilder serverBuilder() {
        return this.serverBuilder;
    }

    public SyncHybrid buildAndStart() {
        SyncServer server = this.serverBuilder.buildAndStart();
        SyncClient client = this.clientBuilder.serverUrl(server.getUrl()).buildAndStart();
        return new SyncHybrid(this.boxStore, client, this.boxStoreServer, server);
    }
}

