/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.spring.processor;

import io.openapiprocessor.core.framework.FrameworkAnnotations;
import io.openapiprocessor.core.model.Annotation;
import io.openapiprocessor.core.model.RequestBody;
import io.openapiprocessor.core.model.parameters.CookieParameter;
import io.openapiprocessor.core.model.parameters.HeaderParameter;
import io.openapiprocessor.core.model.parameters.Parameter;
import io.openapiprocessor.core.model.parameters.PathParameter;
import io.openapiprocessor.core.parser.HttpMethod;
import io.openapiprocessor.spring.model.parameters.MultipartParameter;
import io.openapiprocessor.spring.model.parameters.QueryParameter;
import io.openapiprocessor.spring.processor.SpringFrameworkAnnotationsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/openapiprocessor/spring/processor/SpringFrameworkAnnotations;", "Lio/openapiprocessor/core/framework/FrameworkAnnotations;", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "getAnnotation", "Lio/openapiprocessor/core/model/Annotation;", "httpMethod", "Lio/openapiprocessor/core/parser/HttpMethod;", "parameter", "Lio/openapiprocessor/core/model/parameters/Parameter;", "key", "", "getMultipartAnnotation", "contentType", "openapi-processor-spring"})
public final class SpringFrameworkAnnotations
implements FrameworkAnnotations {
    @NotNull
    private final Logger log;

    public SpringFrameworkAnnotations() {
        Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.log = logger;
    }

    @NotNull
    public Annotation getAnnotation(@NotNull HttpMethod httpMethod) {
        Intrinsics.checkNotNullParameter((Object)httpMethod, (String)"httpMethod");
        return (Annotation)MapsKt.getValue((Map)SpringFrameworkAnnotationsKt.access$getMAPPING_ANNOTATIONS$p(), (Object)httpMethod);
    }

    @NotNull
    public Annotation getAnnotation(@NotNull Parameter parameter) {
        Annotation annotation;
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Parameter parameter2 = parameter;
        if (parameter2 instanceof RequestBody) {
            annotation = this.getAnnotation("body");
        } else if (parameter2 instanceof PathParameter) {
            annotation = this.getAnnotation("path");
        } else if (parameter2 instanceof QueryParameter) {
            annotation = this.getAnnotation("query");
        } else if (parameter2 instanceof HeaderParameter) {
            annotation = this.getAnnotation("header");
        } else if (parameter2 instanceof CookieParameter) {
            annotation = this.getAnnotation("cookie");
        } else if (parameter2 instanceof MultipartParameter) {
            annotation = this.getMultipartAnnotation(((MultipartParameter)parameter).getContentType());
        } else {
            this.log.error("unknown parameter type: " + parameter.getClass().getName());
            annotation = SpringFrameworkAnnotationsKt.access$getUNKNOWN_ANNOTATION$p();
        }
        return annotation;
    }

    private final Annotation getAnnotation(String key) {
        return (Annotation)MapsKt.getValue((Map)SpringFrameworkAnnotationsKt.access$getPARAMETER_ANNOTATIONS$p(), (Object)key);
    }

    private final Annotation getMultipartAnnotation(String contentType) {
        return contentType != null ? (Annotation)MapsKt.getValue((Map)SpringFrameworkAnnotationsKt.access$getPARAMETER_ANNOTATIONS$p(), (Object)"multipart-part") : (Annotation)MapsKt.getValue((Map)SpringFrameworkAnnotationsKt.access$getPARAMETER_ANNOTATIONS$p(), (Object)"multipart-param");
    }
}

