/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.spring.writer.java;

import io.openapiprocessor.core.converter.ApiOptions;
import java.io.Writer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lio/openapiprocessor/spring/writer/java/EnumConverterFactoryWriter;", "", "options", "Lio/openapiprocessor/core/converter/ApiOptions;", "<init>", "(Lio/openapiprocessor/core/converter/ApiOptions;)V", "getOptions", "()Lio/openapiprocessor/core/converter/ApiOptions;", "writeConverterFactory", "", "target", "Ljava/io/Writer;", "openapi-processor-spring"})
public final class EnumConverterFactoryWriter {
    @NotNull
    private final ApiOptions options;

    public EnumConverterFactoryWriter(@NotNull ApiOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
    }

    @NotNull
    public final ApiOptions getOptions() {
        return this.options;
    }

    public final void writeConverterFactory(@NotNull Writer target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        target.write(StringsKt.trimIndent((String)("\n            package " + this.options.getPackageName() + ".spring;\n            \n            import org.springframework.core.convert.converter.Converter;\n            import org.springframework.core.convert.converter.ConverterFactory;\n\n            import java.util.EnumSet;\n            import java.util.function.Supplier;\n\n            public class StringToEnumConverterFactory<T extends Enum<T> & Supplier<String>>\n                implements ConverterFactory<String, T> {\n\n                @Override\n                @SuppressWarnings({\"unchecked\", \"rawtypes\"})\n                public <E extends T> Converter<String, E> getConverter(Class<E> targetType) {\n                    return new StringToEnumConverter(targetType);\n                }\n\n                static class StringToEnumConverter<T extends Enum<T> & Supplier<String>> implements Converter<String, T> {\n\n                    private final Class<T> enumType;\n\n                    public StringToEnumConverter(Class<T> enumType) {\n                        this.enumType = enumType;\n                    }\n\n                    public T convert(String source) {\n                        String sourceValue = source.trim();\n\n                        for (T e : EnumSet.allOf(enumType)) {\n                            if (e.get().equals(sourceValue)) {\n                                return e;\n                            }\n                        }\n\n                        throw new IllegalArgumentException(String.format(\"No enum constant of %s has the value %s\",\n                            enumType.getCanonicalName(),\n                            sourceValue));\n                    }\n                }\n            }\n        ")));
    }
}

