/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.dsl.conversion;

import com.google.common.base.Preconditions;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;

public class OmlQualifiedNameConverter
implements IQualifiedNameConverter {
    public String toString(QualifiedName qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Qualified name cannot be null");
        }
        return qualifiedName.toString("");
    }

    public QualifiedName toQualifiedName(String qualifiedNameAsString) {
        Preconditions.checkArgument((qualifiedNameAsString != null ? 1 : 0) != 0, (Object)"Qualified name cannot be null");
        boolean _isEmpty = qualifiedNameAsString.isEmpty();
        boolean _not = !_isEmpty;
        Preconditions.checkArgument((boolean)_not, (Object)"Qualified name cannot be empty");
        int index = qualifiedNameAsString.lastIndexOf("#");
        if (index == -1) {
            index = qualifiedNameAsString.lastIndexOf("/");
        }
        if (index == -1 || index == qualifiedNameAsString.length() - 1) {
            return QualifiedName.create((String)qualifiedNameAsString);
        }
        String parentName = qualifiedNameAsString.substring(0, index + 1);
        String elementName = qualifiedNameAsString.substring(index + 1);
        return QualifiedName.create((String[])new String[]{parentName, elementName});
    }
}

