/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.dsl.settings;

import com.google.common.base.Objects;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;

@Log
public class JsonFileBasedPreferenceValues
extends MapBasedPreferenceValues {
    private final Path path;
    private FileTime lastModification = null;
    private static final Logger LOG = Logger.getLogger(JsonFileBasedPreferenceValues.class);

    public JsonFileBasedPreferenceValues(Path path, IPreferenceValues delegate) {
        super(delegate, (Map)CollectionLiterals.newHashMap());
        this.path = path;
    }

    public boolean checkIsUpToDate() {
        boolean result = true;
        IPreferenceValues d = this.getDelegate();
        if (d instanceof JsonFileBasedPreferenceValues) {
            result = result && ((JsonFileBasedPreferenceValues)d).checkIsUpToDate();
        }
        try {
            boolean _notEquals;
            FileTime localLastMod = Files.getLastModifiedTime(this.path, new LinkOption[0]);
            boolean bl = _notEquals = !Objects.equal((Object)localLastMod, (Object)this.lastModification);
            if (_notEquals) {
                this.lastModification = localLastMod;
                this.read();
                return false;
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                boolean _not;
                Exception e = (Exception)_t;
                if (!(e instanceof NoSuchFileException)) {
                    String _message = e.getMessage();
                    String _plus = "Error reading settings '" + this.path + "' : " + _message;
                    LOG.error((Object)_plus);
                } else {
                    this.lastModification = null;
                }
                boolean _isEmpty = this.getValues().isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    this.clear();
                    return false;
                }
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return result;
    }

    public void read() {
        try {
            this.clear();
            byte[] bytes = Files.readAllBytes(this.path);
            ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(bytes);
            InputStreamReader _inputStreamReader = new InputStreamReader(_byteArrayInputStream);
            BufferedReader _bufferedReader = new BufferedReader(_inputStreamReader);
            JsonReader reader = new JsonReader((Reader)_bufferedReader);
            reader.setLenient(true);
            JsonElement object = Streams.parse((JsonReader)reader);
            if (object instanceof JsonObject) {
                this.internalFillMap(null, (JsonObject)object);
            } else {
                LOG.error((Object)"The oml.settings file, did not contain a top level object.");
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void internalFillMap(String prefix, JsonObject object) {
        Set _entrySet = object.entrySet();
        for (Map.Entry entry : _entrySet) {
            JsonElement _value;
            JsonElement v = _value = (JsonElement)entry.getValue();
            boolean _matched = false;
            if (v instanceof JsonObject) {
                _matched = true;
                JsonElement _value_1 = (JsonElement)entry.getValue();
                this.internalFillMap((String)entry.getKey(), (JsonObject)_value_1);
            }
            if (_matched || !(v instanceof JsonPrimitive)) continue;
            _matched = true;
            Object _xifexpression = null;
            if (prefix != null) {
                String _key = (String)entry.getKey();
                _xifexpression = prefix + "." + _key;
            } else {
                _xifexpression = (String)entry.getKey();
            }
            String key = _xifexpression;
            this.put(key, ((JsonPrimitive)v).getAsString().toString());
        }
    }
}

