/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.dsl.settings;

import com.google.common.base.StandardSystemProperty;
import com.google.inject.Inject;
import io.opencaesar.oml.dsl.settings.JsonFileBasedPreferenceValues;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.IPreferenceValuesProvider;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.preferences.PreferenceValuesByLanguage;
import org.eclipse.xtext.util.IDisposable;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfigProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
@Log
public class PreferenceValuesProvider
implements IPreferenceValuesProvider {
    @Inject(optional=true)
    private IProjectConfigProvider configProvider;
    @Inject
    private LanguageInfo language;
    private List<Procedures.Procedure2<? super IPreferenceValues, ? super Resource>> onChangeListeners = CollectionLiterals.newArrayList();
    public static final Map<String, String> constantSettings = CollectionLiterals.newHashMap();
    private static final Logger LOG = Logger.getLogger(PreferenceValuesProvider.class);

    public IPreferenceValues getPreferenceValues(Resource context) {
        if (context == null) {
            Map _emptyMap = CollectionLiterals.emptyMap();
            return new MapBasedPreferenceValues(_emptyMap);
        }
        PreferenceValuesByLanguage _elvis = null;
        PreferenceValuesByLanguage _findInEmfObject = PreferenceValuesByLanguage.findInEmfObject((Notifier)context.getResourceSet());
        if (_findInEmfObject != null) {
            _elvis = _findInEmfObject;
        } else {
            PreferenceValuesByLanguage _doubleArrow;
            PreferenceValuesByLanguage _preferenceValuesByLanguage = new PreferenceValuesByLanguage();
            Procedures.Procedure1 _function = it -> it.attachToEmfObject((Notifier)context.getResourceSet());
            _elvis = _doubleArrow = (PreferenceValuesByLanguage)ObjectExtensions.operator_doubleArrow((Object)_preferenceValuesByLanguage, (Procedures.Procedure1)_function);
        }
        PreferenceValuesByLanguage valuesByLanguage = _elvis;
        IPreferenceValues _elvis_1 = null;
        IPreferenceValues _get = valuesByLanguage.get(this.language.getLanguageName());
        if (_get != null) {
            _elvis_1 = _get;
        } else {
            IPreferenceValues _createPreferenceValues;
            IProjectConfig _projectConfig = null;
            if (this.configProvider != null) {
                _projectConfig = this.configProvider.getProjectConfig(context.getResourceSet());
            }
            URI _path = null;
            if (_projectConfig != null) {
                _path = _projectConfig.getPath();
            }
            _elvis_1 = _createPreferenceValues = PreferenceValuesProvider.createPreferenceValues(_path);
        }
        IPreferenceValues values = _elvis_1;
        valuesByLanguage.put(this.language.getLanguageName(), values);
        if (values instanceof JsonFileBasedPreferenceValues) {
            boolean _not;
            boolean _checkIsUpToDate = ((JsonFileBasedPreferenceValues)values).checkIsUpToDate();
            boolean bl = _not = !_checkIsUpToDate;
            if (_not) {
                for (Procedures.Procedure2<? super IPreferenceValues, ? super Resource> listener : this.onChangeListeners) {
                    listener.apply((Object)values, (Object)context);
                }
            }
        }
        return values;
    }

    public static IPreferenceValues createPreferenceValues(URI projectURI) {
        try {
            MapBasedPreferenceValues result = new MapBasedPreferenceValues(constantSettings);
            Path userHome = Paths.get(StandardSystemProperty.USER_HOME.value(), new String[0]);
            Path userSettings = userHome.resolve(".oml").resolve("oml.settings");
            JsonFileBasedPreferenceValues _jsonFileBasedPreferenceValues = new JsonFileBasedPreferenceValues(userSettings, (IPreferenceValues)result);
            result = _jsonFileBasedPreferenceValues;
            if (projectURI == null) {
                return result;
            }
            int _xifexpression = 0;
            boolean _isEmpty = projectURI.lastSegment().isEmpty();
            _xifexpression = _isEmpty ? 1 : 0;
            int segmentsToRemove = _xifexpression;
            String _string = projectURI.trimSegments(segmentsToRemove + 1).toString();
            java.net.URI workspaceDirectory = new java.net.URI(_string);
            Path workspaceSettings = Paths.get(workspaceDirectory).resolve("oml.settings");
            JsonFileBasedPreferenceValues _jsonFileBasedPreferenceValues_1 = new JsonFileBasedPreferenceValues(workspaceSettings, (IPreferenceValues)result);
            result = _jsonFileBasedPreferenceValues_1;
            String _string_1 = projectURI.trimSegments(segmentsToRemove).toString();
            java.net.URI projectDirectory = new java.net.URI(_string_1);
            Path projectSettings = Paths.get(projectDirectory).resolve("oml.settings");
            JsonFileBasedPreferenceValues _jsonFileBasedPreferenceValues_2 = new JsonFileBasedPreferenceValues(projectSettings, (IPreferenceValues)result);
            result = _jsonFileBasedPreferenceValues_2;
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IDisposable registerChangeListener(Procedures.Procedure2<? super IPreferenceValues, ? super Resource> callback) {
        this.onChangeListeners.add(callback);
        IDisposable _function = () -> this.onChangeListeners.remove(callback);
        return _function;
    }
}

