/*
 * Copyright 2019 California Institute of Technology (\"Caltech\").
 * U.S. Government sponsorship acknowledged.
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
grammar InternalOml;

options {
	superClass=AbstractInternalAntlrParser;
}

@lexer::header {
package io.opencaesar.oml.dsl.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

@parser::header {
package io.opencaesar.oml.dsl.parser.antlr.internal;

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import io.opencaesar.oml.dsl.services.OmlGrammarAccess;

}

@parser::members {

 	private OmlGrammarAccess grammarAccess;

    public InternalOmlParser(TokenStream input, OmlGrammarAccess grammarAccess) {
        this(input);
        this.grammarAccess = grammarAccess;
        registerRules(grammarAccess.getGrammar());
    }

    @Override
    protected String getFirstRuleName() {
    	return "Ontology";
   	}

   	@Override
   	protected OmlGrammarAccess getGrammarAccess() {
   		return grammarAccess;
   	}

}

@rulecatch {
    catch (RecognitionException re) {
        recover(input,re);
        appendSkippedTokens();
    }
}

// Entry rule entryRuleOntology
entryRuleOntology returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getOntologyRule()); }
	iv_ruleOntology=ruleOntology
	{ $current=$iv_ruleOntology.current; }
	EOF;

// Rule Ontology
ruleOntology returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getOntologyAccess().getVocabularyBoxParserRuleCall_0());
		}
		this_VocabularyBox_0=ruleVocabularyBox
		{
			$current = $this_VocabularyBox_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getOntologyAccess().getDescriptionBoxParserRuleCall_1());
		}
		this_DescriptionBox_1=ruleDescriptionBox
		{
			$current = $this_DescriptionBox_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleAnnotation
entryRuleAnnotation returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAnnotationRule()); }
	iv_ruleAnnotation=ruleAnnotation
	{ $current=$iv_ruleAnnotation.current; }
	EOF;

// Rule Annotation
ruleAnnotation returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='@'
		{
			newLeafNode(otherlv_0, grammarAccess.getAnnotationAccess().getCommercialAtKeyword_0());
		}
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getAnnotationAccess().getAnnotationAction_1(),
					$current);
			}
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getAnnotationRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getAnnotationAccess().getPropertyAnnotationPropertyCrossReference_2_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getAnnotationAccess().getValueLiteralParserRuleCall_3_0_0());
					}
					lv_value_3_0=ruleLiteral
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getAnnotationRule());
						}
						set(
							$current,
							"value",
							lv_value_3_0,
							"io.opencaesar.oml.dsl.Oml.Literal");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getAnnotationRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getAnnotationAccess().getReferenceValueMemberCrossReference_3_1_0());
					}
					ruleRef
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
	)
;

// Entry rule entryRuleVocabularyBox
entryRuleVocabularyBox returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getVocabularyBoxRule()); }
	iv_ruleVocabularyBox=ruleVocabularyBox
	{ $current=$iv_ruleVocabularyBox.current; }
	EOF;

// Rule VocabularyBox
ruleVocabularyBox returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getVocabularyBoxAccess().getVocabularyParserRuleCall_0());
		}
		this_Vocabulary_0=ruleVocabulary
		{
			$current = $this_Vocabulary_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getVocabularyBoxAccess().getVocabularyBundleParserRuleCall_1());
		}
		this_VocabularyBundle_1=ruleVocabularyBundle
		{
			$current = $this_VocabularyBundle_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleVocabulary
entryRuleVocabulary returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getVocabularyRule()); }
	iv_ruleVocabulary=ruleVocabulary
	{ $current=$iv_ruleVocabulary.current; }
	EOF;

// Rule Vocabulary
ruleVocabulary returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getVocabularyAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getVocabularyRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='vocabulary'
		{
			newLeafNode(otherlv_1, grammarAccess.getVocabularyAccess().getVocabularyKeyword_1());
		}
		(
			(
				lv_namespace_2_0=RULE_NAMESPACE
				{
					newLeafNode(lv_namespace_2_0, grammarAccess.getVocabularyAccess().getNamespaceNAMESPACETerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getVocabularyRule());
					}
					setWithLastConsumed(
						$current,
						"namespace",
						lv_namespace_2_0,
						"io.opencaesar.oml.dsl.Oml.NAMESPACE");
				}
			)
		)
		otherlv_3='as'
		{
			newLeafNode(otherlv_3, grammarAccess.getVocabularyAccess().getAsKeyword_3());
		}
		(
			(
				lv_prefix_4_0=RULE_ID
				{
					newLeafNode(lv_prefix_4_0, grammarAccess.getVocabularyAccess().getPrefixIDTerminalRuleCall_4_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getVocabularyRule());
					}
					setWithLastConsumed(
						$current,
						"prefix",
						lv_prefix_4_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		otherlv_5='{'
		{
			newLeafNode(otherlv_5, grammarAccess.getVocabularyAccess().getLeftCurlyBracketKeyword_5());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getVocabularyAccess().getOwnedImportsVocabularyImportParserRuleCall_6_0());
				}
				lv_ownedImports_6_0=ruleVocabularyImport
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getVocabularyRule());
					}
					add(
						$current,
						"ownedImports",
						lv_ownedImports_6_0,
						"io.opencaesar.oml.dsl.Oml.VocabularyImport");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			(
				{
					newCompositeNode(grammarAccess.getVocabularyAccess().getOwnedStatementsVocabularyStatementParserRuleCall_7_0());
				}
				lv_ownedStatements_7_0=ruleVocabularyStatement
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getVocabularyRule());
					}
					add(
						$current,
						"ownedStatements",
						lv_ownedStatements_7_0,
						"io.opencaesar.oml.dsl.Oml.VocabularyStatement");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_8='}'
		{
			newLeafNode(otherlv_8, grammarAccess.getVocabularyAccess().getRightCurlyBracketKeyword_8());
		}
	)
;

// Entry rule entryRuleVocabularyBundle
entryRuleVocabularyBundle returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getVocabularyBundleRule()); }
	iv_ruleVocabularyBundle=ruleVocabularyBundle
	{ $current=$iv_ruleVocabularyBundle.current; }
	EOF;

// Rule VocabularyBundle
ruleVocabularyBundle returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getVocabularyBundleAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getVocabularyBundleRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='vocabulary'
		{
			newLeafNode(otherlv_1, grammarAccess.getVocabularyBundleAccess().getVocabularyKeyword_1());
		}
		otherlv_2='bundle'
		{
			newLeafNode(otherlv_2, grammarAccess.getVocabularyBundleAccess().getBundleKeyword_2());
		}
		(
			(
				lv_namespace_3_0=RULE_NAMESPACE
				{
					newLeafNode(lv_namespace_3_0, grammarAccess.getVocabularyBundleAccess().getNamespaceNAMESPACETerminalRuleCall_3_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getVocabularyBundleRule());
					}
					setWithLastConsumed(
						$current,
						"namespace",
						lv_namespace_3_0,
						"io.opencaesar.oml.dsl.Oml.NAMESPACE");
				}
			)
		)
		otherlv_4='as'
		{
			newLeafNode(otherlv_4, grammarAccess.getVocabularyBundleAccess().getAsKeyword_4());
		}
		(
			(
				lv_prefix_5_0=RULE_ID
				{
					newLeafNode(lv_prefix_5_0, grammarAccess.getVocabularyBundleAccess().getPrefixIDTerminalRuleCall_5_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getVocabularyBundleRule());
					}
					setWithLastConsumed(
						$current,
						"prefix",
						lv_prefix_5_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		otherlv_6='{'
		{
			newLeafNode(otherlv_6, grammarAccess.getVocabularyBundleAccess().getLeftCurlyBracketKeyword_6());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getVocabularyBundleAccess().getOwnedImportsVocabularyBundleImportParserRuleCall_7_0());
				}
				lv_ownedImports_7_0=ruleVocabularyBundleImport
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getVocabularyBundleRule());
					}
					add(
						$current,
						"ownedImports",
						lv_ownedImports_7_0,
						"io.opencaesar.oml.dsl.Oml.VocabularyBundleImport");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_8='}'
		{
			newLeafNode(otherlv_8, grammarAccess.getVocabularyBundleAccess().getRightCurlyBracketKeyword_8());
		}
	)
;

// Entry rule entryRuleDescriptionBox
entryRuleDescriptionBox returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDescriptionBoxRule()); }
	iv_ruleDescriptionBox=ruleDescriptionBox
	{ $current=$iv_ruleDescriptionBox.current; }
	EOF;

// Rule DescriptionBox
ruleDescriptionBox returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getDescriptionBoxAccess().getDescriptionParserRuleCall_0());
		}
		this_Description_0=ruleDescription
		{
			$current = $this_Description_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getDescriptionBoxAccess().getDescriptionBundleParserRuleCall_1());
		}
		this_DescriptionBundle_1=ruleDescriptionBundle
		{
			$current = $this_DescriptionBundle_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleDescription
entryRuleDescription returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDescriptionRule()); }
	iv_ruleDescription=ruleDescription
	{ $current=$iv_ruleDescription.current; }
	EOF;

// Rule Description
ruleDescription returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getDescriptionAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDescriptionRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='description'
		{
			newLeafNode(otherlv_1, grammarAccess.getDescriptionAccess().getDescriptionKeyword_1());
		}
		(
			(
				lv_namespace_2_0=RULE_NAMESPACE
				{
					newLeafNode(lv_namespace_2_0, grammarAccess.getDescriptionAccess().getNamespaceNAMESPACETerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDescriptionRule());
					}
					setWithLastConsumed(
						$current,
						"namespace",
						lv_namespace_2_0,
						"io.opencaesar.oml.dsl.Oml.NAMESPACE");
				}
			)
		)
		otherlv_3='as'
		{
			newLeafNode(otherlv_3, grammarAccess.getDescriptionAccess().getAsKeyword_3());
		}
		(
			(
				lv_prefix_4_0=RULE_ID
				{
					newLeafNode(lv_prefix_4_0, grammarAccess.getDescriptionAccess().getPrefixIDTerminalRuleCall_4_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDescriptionRule());
					}
					setWithLastConsumed(
						$current,
						"prefix",
						lv_prefix_4_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		otherlv_5='{'
		{
			newLeafNode(otherlv_5, grammarAccess.getDescriptionAccess().getLeftCurlyBracketKeyword_5());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getDescriptionAccess().getOwnedImportsDescriptionImportParserRuleCall_6_0());
				}
				lv_ownedImports_6_0=ruleDescriptionImport
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDescriptionRule());
					}
					add(
						$current,
						"ownedImports",
						lv_ownedImports_6_0,
						"io.opencaesar.oml.dsl.Oml.DescriptionImport");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			(
				{
					newCompositeNode(grammarAccess.getDescriptionAccess().getOwnedStatementsDescriptionStatementParserRuleCall_7_0());
				}
				lv_ownedStatements_7_0=ruleDescriptionStatement
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDescriptionRule());
					}
					add(
						$current,
						"ownedStatements",
						lv_ownedStatements_7_0,
						"io.opencaesar.oml.dsl.Oml.DescriptionStatement");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_8='}'
		{
			newLeafNode(otherlv_8, grammarAccess.getDescriptionAccess().getRightCurlyBracketKeyword_8());
		}
	)
;

// Entry rule entryRuleDescriptionBundle
entryRuleDescriptionBundle returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDescriptionBundleRule()); }
	iv_ruleDescriptionBundle=ruleDescriptionBundle
	{ $current=$iv_ruleDescriptionBundle.current; }
	EOF;

// Rule DescriptionBundle
ruleDescriptionBundle returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getDescriptionBundleAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDescriptionBundleRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='description'
		{
			newLeafNode(otherlv_1, grammarAccess.getDescriptionBundleAccess().getDescriptionKeyword_1());
		}
		otherlv_2='bundle'
		{
			newLeafNode(otherlv_2, grammarAccess.getDescriptionBundleAccess().getBundleKeyword_2());
		}
		(
			(
				lv_namespace_3_0=RULE_NAMESPACE
				{
					newLeafNode(lv_namespace_3_0, grammarAccess.getDescriptionBundleAccess().getNamespaceNAMESPACETerminalRuleCall_3_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDescriptionBundleRule());
					}
					setWithLastConsumed(
						$current,
						"namespace",
						lv_namespace_3_0,
						"io.opencaesar.oml.dsl.Oml.NAMESPACE");
				}
			)
		)
		otherlv_4='as'
		{
			newLeafNode(otherlv_4, grammarAccess.getDescriptionBundleAccess().getAsKeyword_4());
		}
		(
			(
				lv_prefix_5_0=RULE_ID
				{
					newLeafNode(lv_prefix_5_0, grammarAccess.getDescriptionBundleAccess().getPrefixIDTerminalRuleCall_5_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDescriptionBundleRule());
					}
					setWithLastConsumed(
						$current,
						"prefix",
						lv_prefix_5_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		otherlv_6='{'
		{
			newLeafNode(otherlv_6, grammarAccess.getDescriptionBundleAccess().getLeftCurlyBracketKeyword_6());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getDescriptionBundleAccess().getOwnedImportsDescriptionBundleImportParserRuleCall_7_0());
				}
				lv_ownedImports_7_0=ruleDescriptionBundleImport
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDescriptionBundleRule());
					}
					add(
						$current,
						"ownedImports",
						lv_ownedImports_7_0,
						"io.opencaesar.oml.dsl.Oml.DescriptionBundleImport");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_8='}'
		{
			newLeafNode(otherlv_8, grammarAccess.getDescriptionBundleAccess().getRightCurlyBracketKeyword_8());
		}
	)
;

// Entry rule entryRuleSpecializableTerm
entryRuleSpecializableTerm returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSpecializableTermRule()); }
	iv_ruleSpecializableTerm=ruleSpecializableTerm
	{ $current=$iv_ruleSpecializableTerm.current; }
	EOF;

// Rule SpecializableTerm
ruleSpecializableTerm returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getSpecializableTermAccess().getTypeParserRuleCall_0());
		}
		this_Type_0=ruleType
		{
			$current = $this_Type_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getSpecializableTermAccess().getAnnotationPropertyParserRuleCall_1());
		}
		this_AnnotationProperty_1=ruleAnnotationProperty
		{
			$current = $this_AnnotationProperty_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getSpecializableTermAccess().getScalarPropertyParserRuleCall_2());
		}
		this_ScalarProperty_2=ruleScalarProperty
		{
			$current = $this_ScalarProperty_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getSpecializableTermAccess().getStructuredPropertyParserRuleCall_3());
		}
		this_StructuredProperty_3=ruleStructuredProperty
		{
			$current = $this_StructuredProperty_3.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleType
entryRuleType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTypeRule()); }
	iv_ruleType=ruleType
	{ $current=$iv_ruleType.current; }
	EOF;

// Rule Type
ruleType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getTypeAccess().getClassifierParserRuleCall_0());
		}
		this_Classifier_0=ruleClassifier
		{
			$current = $this_Classifier_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTypeAccess().getScalarParserRuleCall_1());
		}
		this_Scalar_1=ruleScalar
		{
			$current = $this_Scalar_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleClassifier
entryRuleClassifier returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getClassifierRule()); }
	iv_ruleClassifier=ruleClassifier
	{ $current=$iv_ruleClassifier.current; }
	EOF;

// Rule Classifier
ruleClassifier returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getClassifierAccess().getEntityParserRuleCall_0());
		}
		this_Entity_0=ruleEntity
		{
			$current = $this_Entity_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getClassifierAccess().getStructureParserRuleCall_1());
		}
		this_Structure_1=ruleStructure
		{
			$current = $this_Structure_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleEntity
entryRuleEntity returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEntityRule()); }
	iv_ruleEntity=ruleEntity
	{ $current=$iv_ruleEntity.current; }
	EOF;

// Rule Entity
ruleEntity returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getEntityAccess().getAspectParserRuleCall_0());
		}
		this_Aspect_0=ruleAspect
		{
			$current = $this_Aspect_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getEntityAccess().getConceptParserRuleCall_1());
		}
		this_Concept_1=ruleConcept
		{
			$current = $this_Concept_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getEntityAccess().getRelationEntityParserRuleCall_2());
		}
		this_RelationEntity_2=ruleRelationEntity
		{
			$current = $this_RelationEntity_2.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleAspect
entryRuleAspect returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAspectRule()); }
	iv_ruleAspect=ruleAspect
	{ $current=$iv_ruleAspect.current; }
	EOF;

// Rule Aspect
ruleAspect returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getAspectAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getAspectRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='aspect'
		{
			newLeafNode(otherlv_1, grammarAccess.getAspectAccess().getAspectKeyword_1());
		}
		(
			(
				lv_name_2_0=RULE_ID
				{
					newLeafNode(lv_name_2_0, grammarAccess.getAspectAccess().getNameIDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getAspectRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_2_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		(
			otherlv_3=':>'
			{
				newLeafNode(otherlv_3, grammarAccess.getAspectAccess().getColonGreaterThanSignKeyword_3_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getAspectAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_3_1_0());
					}
					lv_ownedSpecializations_4_0=ruleSpecializationAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getAspectRule());
						}
						add(
							$current,
							"ownedSpecializations",
							lv_ownedSpecializations_4_0,
							"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_5=','
				{
					newLeafNode(otherlv_5, grammarAccess.getAspectAccess().getCommaKeyword_3_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getAspectAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_3_2_1_0());
						}
						lv_ownedSpecializations_6_0=ruleSpecializationAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAspectRule());
							}
							add(
								$current,
								"ownedSpecializations",
								lv_ownedSpecializations_6_0,
								"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		(
			otherlv_7='['
			{
				newLeafNode(otherlv_7, grammarAccess.getAspectAccess().getLeftSquareBracketKeyword_4_0());
			}
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getAspectAccess().getOwnedKeysKeyAxiomParserRuleCall_4_1_0_0());
						}
						lv_ownedKeys_8_0=ruleKeyAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAspectRule());
							}
							add(
								$current,
								"ownedKeys",
								lv_ownedKeys_8_0,
								"io.opencaesar.oml.dsl.Oml.KeyAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
				    |
				(
					(
						{
							newCompositeNode(grammarAccess.getAspectAccess().getOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_4_1_1_0());
						}
						lv_ownedPropertyRestrictions_9_0=rulePropertyRestrictionAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAspectRule());
							}
							add(
								$current,
								"ownedPropertyRestrictions",
								lv_ownedPropertyRestrictions_9_0,
								"io.opencaesar.oml.dsl.Oml.PropertyRestrictionAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
				    |
				(
					(
						{
							newCompositeNode(grammarAccess.getAspectAccess().getOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_4_1_2_0());
						}
						lv_ownedRelationRestrictions_10_0=ruleRelationRestrictionAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAspectRule());
							}
							add(
								$current,
								"ownedRelationRestrictions",
								lv_ownedRelationRestrictions_10_0,
								"io.opencaesar.oml.dsl.Oml.RelationRestrictionAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
			otherlv_11=']'
			{
				newLeafNode(otherlv_11, grammarAccess.getAspectAccess().getRightSquareBracketKeyword_4_2());
			}
		)?
	)
;

// Entry rule entryRuleConcept
entryRuleConcept returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getConceptRule()); }
	iv_ruleConcept=ruleConcept
	{ $current=$iv_ruleConcept.current; }
	EOF;

// Rule Concept
ruleConcept returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getConceptAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getConceptRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='concept'
		{
			newLeafNode(otherlv_1, grammarAccess.getConceptAccess().getConceptKeyword_1());
		}
		(
			(
				lv_name_2_0=RULE_ID
				{
					newLeafNode(lv_name_2_0, grammarAccess.getConceptAccess().getNameIDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getConceptRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_2_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		(
			otherlv_3=':>'
			{
				newLeafNode(otherlv_3, grammarAccess.getConceptAccess().getColonGreaterThanSignKeyword_3_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getConceptAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_3_1_0());
					}
					lv_ownedSpecializations_4_0=ruleSpecializationAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getConceptRule());
						}
						add(
							$current,
							"ownedSpecializations",
							lv_ownedSpecializations_4_0,
							"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_5=','
				{
					newLeafNode(otherlv_5, grammarAccess.getConceptAccess().getCommaKeyword_3_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getConceptAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_3_2_1_0());
						}
						lv_ownedSpecializations_6_0=ruleSpecializationAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConceptRule());
							}
							add(
								$current,
								"ownedSpecializations",
								lv_ownedSpecializations_6_0,
								"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		(
			otherlv_7='['
			{
				newLeafNode(otherlv_7, grammarAccess.getConceptAccess().getLeftSquareBracketKeyword_4_0());
			}
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getConceptAccess().getOwnedKeysKeyAxiomParserRuleCall_4_1_0_0());
						}
						lv_ownedKeys_8_0=ruleKeyAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConceptRule());
							}
							add(
								$current,
								"ownedKeys",
								lv_ownedKeys_8_0,
								"io.opencaesar.oml.dsl.Oml.KeyAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
				    |
				(
					(
						{
							newCompositeNode(grammarAccess.getConceptAccess().getOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_4_1_1_0());
						}
						lv_ownedPropertyRestrictions_9_0=rulePropertyRestrictionAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConceptRule());
							}
							add(
								$current,
								"ownedPropertyRestrictions",
								lv_ownedPropertyRestrictions_9_0,
								"io.opencaesar.oml.dsl.Oml.PropertyRestrictionAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
				    |
				(
					(
						{
							newCompositeNode(grammarAccess.getConceptAccess().getOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_4_1_2_0());
						}
						lv_ownedRelationRestrictions_10_0=ruleRelationRestrictionAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConceptRule());
							}
							add(
								$current,
								"ownedRelationRestrictions",
								lv_ownedRelationRestrictions_10_0,
								"io.opencaesar.oml.dsl.Oml.RelationRestrictionAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
			(
				otherlv_11='enumerates'
				{
					newLeafNode(otherlv_11, grammarAccess.getConceptAccess().getEnumeratesKeyword_4_2_0());
				}
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getConceptRule());
							}
						}
						{
							newCompositeNode(grammarAccess.getConceptAccess().getEnumeratedInstancesConceptInstanceCrossReference_4_2_1_0());
						}
						ruleRef
						{
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					otherlv_13=','
					{
						newLeafNode(otherlv_13, grammarAccess.getConceptAccess().getCommaKeyword_4_2_2_0());
					}
					(
						(
							{
								if ($current==null) {
									$current = createModelElement(grammarAccess.getConceptRule());
								}
							}
							{
								newCompositeNode(grammarAccess.getConceptAccess().getEnumeratedInstancesConceptInstanceCrossReference_4_2_2_1_0());
							}
							ruleRef
							{
								afterParserOrEnumRuleCall();
							}
						)
					)
				)*
			)?
			otherlv_15=']'
			{
				newLeafNode(otherlv_15, grammarAccess.getConceptAccess().getRightSquareBracketKeyword_4_3());
			}
		)?
	)
;

// Entry rule entryRuleRelationEntity
entryRuleRelationEntity returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRelationEntityRule()); }
	iv_ruleRelationEntity=ruleRelationEntity
	{ $current=$iv_ruleRelationEntity.current; }
	EOF;

// Rule RelationEntity
ruleRelationEntity returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getRelationEntityAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRelationEntityRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='relation'
		{
			newLeafNode(otherlv_1, grammarAccess.getRelationEntityAccess().getRelationKeyword_1());
		}
		otherlv_2='entity'
		{
			newLeafNode(otherlv_2, grammarAccess.getRelationEntityAccess().getEntityKeyword_2());
		}
		(
			(
				lv_name_3_0=RULE_ID
				{
					newLeafNode(lv_name_3_0, grammarAccess.getRelationEntityAccess().getNameIDTerminalRuleCall_3_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRelationEntityRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_3_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		(
			otherlv_4=':>'
			{
				newLeafNode(otherlv_4, grammarAccess.getRelationEntityAccess().getColonGreaterThanSignKeyword_4_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getRelationEntityAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0());
					}
					lv_ownedSpecializations_5_0=ruleSpecializationAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getRelationEntityRule());
						}
						add(
							$current,
							"ownedSpecializations",
							lv_ownedSpecializations_5_0,
							"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_6=','
				{
					newLeafNode(otherlv_6, grammarAccess.getRelationEntityAccess().getCommaKeyword_4_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getRelationEntityAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0());
						}
						lv_ownedSpecializations_7_0=ruleSpecializationAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getRelationEntityRule());
							}
							add(
								$current,
								"ownedSpecializations",
								lv_ownedSpecializations_7_0,
								"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		otherlv_8='['
		{
			newLeafNode(otherlv_8, grammarAccess.getRelationEntityAccess().getLeftSquareBracketKeyword_5());
		}
		otherlv_9='from'
		{
			newLeafNode(otherlv_9, grammarAccess.getRelationEntityAccess().getFromKeyword_6());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRelationEntityRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getRelationEntityAccess().getSourceEntityCrossReference_7_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_11='to'
		{
			newLeafNode(otherlv_11, grammarAccess.getRelationEntityAccess().getToKeyword_8());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRelationEntityRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getRelationEntityAccess().getTargetEntityCrossReference_9_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{ 
				  getUnorderedGroupHelper().enter(grammarAccess.getRelationEntityAccess().getUnorderedGroup_10());
				}
				(
					(
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getRelationEntityAccess().getUnorderedGroup_10(), 0)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getRelationEntityAccess().getUnorderedGroup_10(), 0);
					}
								({true}?=>((
									{
										newCompositeNode(grammarAccess.getRelationEntityAccess().getForwardRelationForwardRelationParserRuleCall_10_0_0());
									}
									lv_forwardRelation_14_0=ruleForwardRelation
									{
										if ($current==null) {
											$current = createModelElementForParent(grammarAccess.getRelationEntityRule());
										}
										set(
											$current,
											"forwardRelation",
											lv_forwardRelation_14_0,
											"io.opencaesar.oml.dsl.Oml.ForwardRelation");
										afterParserOrEnumRuleCall();
									}
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getRelationEntityAccess().getUnorderedGroup_10());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getRelationEntityAccess().getUnorderedGroup_10(), 1)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getRelationEntityAccess().getUnorderedGroup_10(), 1);
					}
								({true}?=>((
									{
										newCompositeNode(grammarAccess.getRelationEntityAccess().getReverseRelationReverseRelationParserRuleCall_10_1_0());
									}
									lv_reverseRelation_15_0=ruleReverseRelation
									{
										if ($current==null) {
											$current = createModelElementForParent(grammarAccess.getRelationEntityRule());
										}
										set(
											$current,
											"reverseRelation",
											lv_reverseRelation_15_0,
											"io.opencaesar.oml.dsl.Oml.ReverseRelation");
										afterParserOrEnumRuleCall();
									}
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getRelationEntityAccess().getUnorderedGroup_10());
					}
				)
			)
					)*
				)
			)
				{ 
				  getUnorderedGroupHelper().leave(grammarAccess.getRelationEntityAccess().getUnorderedGroup_10());
				}
		)
		(
			(
				{ 
				  getUnorderedGroupHelper().enter(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11());
				}
				(
					(
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11(), 0)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11(), 0);
					}
								({true}?=>((
									lv_functional_17_0='functional'
									{
										newLeafNode(lv_functional_17_0, grammarAccess.getRelationEntityAccess().getFunctionalFunctionalKeyword_11_0_0());
									}
									{
										if ($current==null) {
											$current = createModelElement(grammarAccess.getRelationEntityRule());
										}
										setWithLastConsumed($current, "functional", lv_functional_17_0 != null, "functional");
									}
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11(), 1)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11(), 1);
					}
								({true}?=>((
									(
										lv_inverseFunctional_18_0='inverse'
										{
											newLeafNode(lv_inverseFunctional_18_0, grammarAccess.getRelationEntityAccess().getInverseFunctionalInverseKeyword_11_1_0_0());
										}
										{
											if ($current==null) {
												$current = createModelElement(grammarAccess.getRelationEntityRule());
											}
											setWithLastConsumed($current, "inverseFunctional", lv_inverseFunctional_18_0 != null, "inverse");
										}
									)
								)
								otherlv_19='functional'
								{
									newLeafNode(otherlv_19, grammarAccess.getRelationEntityAccess().getFunctionalKeyword_11_1_1());
								}
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11(), 2)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11(), 2);
					}
								({true}?=>((
									lv_symmetric_20_0='symmetric'
									{
										newLeafNode(lv_symmetric_20_0, grammarAccess.getRelationEntityAccess().getSymmetricSymmetricKeyword_11_2_0());
									}
									{
										if ($current==null) {
											$current = createModelElement(grammarAccess.getRelationEntityRule());
										}
										setWithLastConsumed($current, "symmetric", lv_symmetric_20_0 != null, "symmetric");
									}
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11(), 3)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11(), 3);
					}
								({true}?=>((
									lv_asymmetric_21_0='asymmetric'
									{
										newLeafNode(lv_asymmetric_21_0, grammarAccess.getRelationEntityAccess().getAsymmetricAsymmetricKeyword_11_3_0());
									}
									{
										if ($current==null) {
											$current = createModelElement(grammarAccess.getRelationEntityRule());
										}
										setWithLastConsumed($current, "asymmetric", lv_asymmetric_21_0 != null, "asymmetric");
									}
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11(), 4)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11(), 4);
					}
								({true}?=>((
									lv_reflexive_22_0='reflexive'
									{
										newLeafNode(lv_reflexive_22_0, grammarAccess.getRelationEntityAccess().getReflexiveReflexiveKeyword_11_4_0());
									}
									{
										if ($current==null) {
											$current = createModelElement(grammarAccess.getRelationEntityRule());
										}
										setWithLastConsumed($current, "reflexive", lv_reflexive_22_0 != null, "reflexive");
									}
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11(), 5)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11(), 5);
					}
								({true}?=>((
									lv_irreflexive_23_0='irreflexive'
									{
										newLeafNode(lv_irreflexive_23_0, grammarAccess.getRelationEntityAccess().getIrreflexiveIrreflexiveKeyword_11_5_0());
									}
									{
										if ($current==null) {
											$current = createModelElement(grammarAccess.getRelationEntityRule());
										}
										setWithLastConsumed($current, "irreflexive", lv_irreflexive_23_0 != null, "irreflexive");
									}
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11(), 6)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11(), 6);
					}
								({true}?=>((
									lv_transitive_24_0='transitive'
									{
										newLeafNode(lv_transitive_24_0, grammarAccess.getRelationEntityAccess().getTransitiveTransitiveKeyword_11_6_0());
									}
									{
										if ($current==null) {
											$current = createModelElement(grammarAccess.getRelationEntityRule());
										}
										setWithLastConsumed($current, "transitive", lv_transitive_24_0 != null, "transitive");
									}
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11());
					}
				)
			)
					)*
				)
			)
				{ 
				  getUnorderedGroupHelper().leave(grammarAccess.getRelationEntityAccess().getUnorderedGroup_11());
				}
		)
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getRelationEntityAccess().getOwnedKeysKeyAxiomParserRuleCall_12_0_0());
					}
					lv_ownedKeys_25_0=ruleKeyAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getRelationEntityRule());
						}
						add(
							$current,
							"ownedKeys",
							lv_ownedKeys_25_0,
							"io.opencaesar.oml.dsl.Oml.KeyAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					{
						newCompositeNode(grammarAccess.getRelationEntityAccess().getOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_12_1_0());
					}
					lv_ownedPropertyRestrictions_26_0=rulePropertyRestrictionAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getRelationEntityRule());
						}
						add(
							$current,
							"ownedPropertyRestrictions",
							lv_ownedPropertyRestrictions_26_0,
							"io.opencaesar.oml.dsl.Oml.PropertyRestrictionAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					{
						newCompositeNode(grammarAccess.getRelationEntityAccess().getOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_12_2_0());
					}
					lv_ownedRelationRestrictions_27_0=ruleRelationRestrictionAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getRelationEntityRule());
						}
						add(
							$current,
							"ownedRelationRestrictions",
							lv_ownedRelationRestrictions_27_0,
							"io.opencaesar.oml.dsl.Oml.RelationRestrictionAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		otherlv_28=']'
		{
			newLeafNode(otherlv_28, grammarAccess.getRelationEntityAccess().getRightSquareBracketKeyword_13());
		}
	)
;

// Entry rule entryRuleStructure
entryRuleStructure returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStructureRule()); }
	iv_ruleStructure=ruleStructure
	{ $current=$iv_ruleStructure.current; }
	EOF;

// Rule Structure
ruleStructure returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getStructureAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStructureRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='structure'
		{
			newLeafNode(otherlv_1, grammarAccess.getStructureAccess().getStructureKeyword_1());
		}
		(
			(
				lv_name_2_0=RULE_ID
				{
					newLeafNode(lv_name_2_0, grammarAccess.getStructureAccess().getNameIDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getStructureRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_2_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		(
			otherlv_3=':>'
			{
				newLeafNode(otherlv_3, grammarAccess.getStructureAccess().getColonGreaterThanSignKeyword_3_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getStructureAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_3_1_0());
					}
					lv_ownedSpecializations_4_0=ruleSpecializationAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getStructureRule());
						}
						add(
							$current,
							"ownedSpecializations",
							lv_ownedSpecializations_4_0,
							"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_5=','
				{
					newLeafNode(otherlv_5, grammarAccess.getStructureAccess().getCommaKeyword_3_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getStructureAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_3_2_1_0());
						}
						lv_ownedSpecializations_6_0=ruleSpecializationAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getStructureRule());
							}
							add(
								$current,
								"ownedSpecializations",
								lv_ownedSpecializations_6_0,
								"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		(
			otherlv_7='['
			{
				newLeafNode(otherlv_7, grammarAccess.getStructureAccess().getLeftSquareBracketKeyword_4_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getStructureAccess().getOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_4_1_0());
					}
					lv_ownedPropertyRestrictions_8_0=rulePropertyRestrictionAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getStructureRule());
						}
						add(
							$current,
							"ownedPropertyRestrictions",
							lv_ownedPropertyRestrictions_8_0,
							"io.opencaesar.oml.dsl.Oml.PropertyRestrictionAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_9=']'
			{
				newLeafNode(otherlv_9, grammarAccess.getStructureAccess().getRightSquareBracketKeyword_4_2());
			}
		)?
	)
;

// Entry rule entryRuleProperty
entryRuleProperty returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPropertyRule()); }
	iv_ruleProperty=ruleProperty
	{ $current=$iv_ruleProperty.current; }
	EOF;

// Rule Property
ruleProperty returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getPropertyAccess().getAnnotationPropertyParserRuleCall_0());
		}
		this_AnnotationProperty_0=ruleAnnotationProperty
		{
			$current = $this_AnnotationProperty_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPropertyAccess().getSemanticPropertyParserRuleCall_1());
		}
		this_SemanticProperty_1=ruleSemanticProperty
		{
			$current = $this_SemanticProperty_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleAnnotationProperty
entryRuleAnnotationProperty returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAnnotationPropertyRule()); }
	iv_ruleAnnotationProperty=ruleAnnotationProperty
	{ $current=$iv_ruleAnnotationProperty.current; }
	EOF;

// Rule AnnotationProperty
ruleAnnotationProperty returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getAnnotationPropertyAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getAnnotationPropertyRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='annotation'
		{
			newLeafNode(otherlv_1, grammarAccess.getAnnotationPropertyAccess().getAnnotationKeyword_1());
		}
		otherlv_2='property'
		{
			newLeafNode(otherlv_2, grammarAccess.getAnnotationPropertyAccess().getPropertyKeyword_2());
		}
		(
			(
				lv_name_3_0=RULE_ID
				{
					newLeafNode(lv_name_3_0, grammarAccess.getAnnotationPropertyAccess().getNameIDTerminalRuleCall_3_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getAnnotationPropertyRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_3_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		(
			otherlv_4=':>'
			{
				newLeafNode(otherlv_4, grammarAccess.getAnnotationPropertyAccess().getColonGreaterThanSignKeyword_4_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getAnnotationPropertyAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0());
					}
					lv_ownedSpecializations_5_0=ruleSpecializationAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getAnnotationPropertyRule());
						}
						add(
							$current,
							"ownedSpecializations",
							lv_ownedSpecializations_5_0,
							"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_6=','
				{
					newLeafNode(otherlv_6, grammarAccess.getAnnotationPropertyAccess().getCommaKeyword_4_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getAnnotationPropertyAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0());
						}
						lv_ownedSpecializations_7_0=ruleSpecializationAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAnnotationPropertyRule());
							}
							add(
								$current,
								"ownedSpecializations",
								lv_ownedSpecializations_7_0,
								"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
	)
;

// Entry rule entryRuleSemanticProperty
entryRuleSemanticProperty returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSemanticPropertyRule()); }
	iv_ruleSemanticProperty=ruleSemanticProperty
	{ $current=$iv_ruleSemanticProperty.current; }
	EOF;

// Rule SemanticProperty
ruleSemanticProperty returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getSemanticPropertyAccess().getScalarPropertyParserRuleCall_0());
		}
		this_ScalarProperty_0=ruleScalarProperty
		{
			$current = $this_ScalarProperty_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getSemanticPropertyAccess().getStructuredPropertyParserRuleCall_1());
		}
		this_StructuredProperty_1=ruleStructuredProperty
		{
			$current = $this_StructuredProperty_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleScalarProperty
entryRuleScalarProperty returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getScalarPropertyRule()); }
	iv_ruleScalarProperty=ruleScalarProperty
	{ $current=$iv_ruleScalarProperty.current; }
	EOF;

// Rule ScalarProperty
ruleScalarProperty returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getScalarPropertyAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getScalarPropertyRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='scalar'
		{
			newLeafNode(otherlv_1, grammarAccess.getScalarPropertyAccess().getScalarKeyword_1());
		}
		otherlv_2='property'
		{
			newLeafNode(otherlv_2, grammarAccess.getScalarPropertyAccess().getPropertyKeyword_2());
		}
		(
			(
				lv_name_3_0=RULE_ID
				{
					newLeafNode(lv_name_3_0, grammarAccess.getScalarPropertyAccess().getNameIDTerminalRuleCall_3_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getScalarPropertyRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_3_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		(
			otherlv_4=':>'
			{
				newLeafNode(otherlv_4, grammarAccess.getScalarPropertyAccess().getColonGreaterThanSignKeyword_4_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getScalarPropertyAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0());
					}
					lv_ownedSpecializations_5_0=ruleSpecializationAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getScalarPropertyRule());
						}
						add(
							$current,
							"ownedSpecializations",
							lv_ownedSpecializations_5_0,
							"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_6=','
				{
					newLeafNode(otherlv_6, grammarAccess.getScalarPropertyAccess().getCommaKeyword_4_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getScalarPropertyAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0());
						}
						lv_ownedSpecializations_7_0=ruleSpecializationAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getScalarPropertyRule());
							}
							add(
								$current,
								"ownedSpecializations",
								lv_ownedSpecializations_7_0,
								"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		(
			otherlv_8='['
			{
				newLeafNode(otherlv_8, grammarAccess.getScalarPropertyAccess().getLeftSquareBracketKeyword_5_0());
			}
			otherlv_9='domain'
			{
				newLeafNode(otherlv_9, grammarAccess.getScalarPropertyAccess().getDomainKeyword_5_1());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getScalarPropertyRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getScalarPropertyAccess().getDomainClassifierCrossReference_5_2_0());
					}
					ruleRef
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_11='range'
			{
				newLeafNode(otherlv_11, grammarAccess.getScalarPropertyAccess().getRangeKeyword_5_3());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getScalarPropertyRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getScalarPropertyAccess().getRangeScalarCrossReference_5_4_0());
					}
					ruleRef
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				(
					lv_functional_13_0='functional'
					{
						newLeafNode(lv_functional_13_0, grammarAccess.getScalarPropertyAccess().getFunctionalFunctionalKeyword_5_5_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getScalarPropertyRule());
						}
						setWithLastConsumed($current, "functional", lv_functional_13_0 != null, "functional");
					}
				)
			)?
			otherlv_14=']'
			{
				newLeafNode(otherlv_14, grammarAccess.getScalarPropertyAccess().getRightSquareBracketKeyword_5_6());
			}
		)?
	)
;

// Entry rule entryRuleStructuredProperty
entryRuleStructuredProperty returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStructuredPropertyRule()); }
	iv_ruleStructuredProperty=ruleStructuredProperty
	{ $current=$iv_ruleStructuredProperty.current; }
	EOF;

// Rule StructuredProperty
ruleStructuredProperty returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getStructuredPropertyAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStructuredPropertyRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='structured'
		{
			newLeafNode(otherlv_1, grammarAccess.getStructuredPropertyAccess().getStructuredKeyword_1());
		}
		otherlv_2='property'
		{
			newLeafNode(otherlv_2, grammarAccess.getStructuredPropertyAccess().getPropertyKeyword_2());
		}
		(
			(
				lv_name_3_0=RULE_ID
				{
					newLeafNode(lv_name_3_0, grammarAccess.getStructuredPropertyAccess().getNameIDTerminalRuleCall_3_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getStructuredPropertyRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_3_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		(
			otherlv_4=':>'
			{
				newLeafNode(otherlv_4, grammarAccess.getStructuredPropertyAccess().getColonGreaterThanSignKeyword_4_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getStructuredPropertyAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0());
					}
					lv_ownedSpecializations_5_0=ruleSpecializationAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getStructuredPropertyRule());
						}
						add(
							$current,
							"ownedSpecializations",
							lv_ownedSpecializations_5_0,
							"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_6=','
				{
					newLeafNode(otherlv_6, grammarAccess.getStructuredPropertyAccess().getCommaKeyword_4_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getStructuredPropertyAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0());
						}
						lv_ownedSpecializations_7_0=ruleSpecializationAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getStructuredPropertyRule());
							}
							add(
								$current,
								"ownedSpecializations",
								lv_ownedSpecializations_7_0,
								"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		(
			otherlv_8='['
			{
				newLeafNode(otherlv_8, grammarAccess.getStructuredPropertyAccess().getLeftSquareBracketKeyword_5_0());
			}
			otherlv_9='domain'
			{
				newLeafNode(otherlv_9, grammarAccess.getStructuredPropertyAccess().getDomainKeyword_5_1());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getStructuredPropertyRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getStructuredPropertyAccess().getDomainClassifierCrossReference_5_2_0());
					}
					ruleRef
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_11='range'
			{
				newLeafNode(otherlv_11, grammarAccess.getStructuredPropertyAccess().getRangeKeyword_5_3());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getStructuredPropertyRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getStructuredPropertyAccess().getRangeStructureCrossReference_5_4_0());
					}
					ruleRef
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				(
					lv_functional_13_0='functional'
					{
						newLeafNode(lv_functional_13_0, grammarAccess.getStructuredPropertyAccess().getFunctionalFunctionalKeyword_5_5_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getStructuredPropertyRule());
						}
						setWithLastConsumed($current, "functional", lv_functional_13_0 != null, "functional");
					}
				)
			)?
			otherlv_14=']'
			{
				newLeafNode(otherlv_14, grammarAccess.getStructuredPropertyAccess().getRightSquareBracketKeyword_5_6());
			}
		)?
	)
;

// Entry rule entryRuleScalar
entryRuleScalar returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getScalarRule()); }
	iv_ruleScalar=ruleScalar
	{ $current=$iv_ruleScalar.current; }
	EOF;

// Rule Scalar
ruleScalar returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getScalarAccess().getFacetedScalarParserRuleCall_0());
		}
		this_FacetedScalar_0=ruleFacetedScalar
		{
			$current = $this_FacetedScalar_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getScalarAccess().getEnumeratedScalarParserRuleCall_1());
		}
		this_EnumeratedScalar_1=ruleEnumeratedScalar
		{
			$current = $this_EnumeratedScalar_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleFacetedScalar
entryRuleFacetedScalar returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getFacetedScalarRule()); }
	iv_ruleFacetedScalar=ruleFacetedScalar
	{ $current=$iv_ruleFacetedScalar.current; }
	EOF;

// Rule FacetedScalar
ruleFacetedScalar returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getFacetedScalarAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getFacetedScalarRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='scalar'
		{
			newLeafNode(otherlv_1, grammarAccess.getFacetedScalarAccess().getScalarKeyword_1());
		}
		(
			(
				lv_name_2_0=RULE_ID
				{
					newLeafNode(lv_name_2_0, grammarAccess.getFacetedScalarAccess().getNameIDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getFacetedScalarRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_2_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		(
			otherlv_3=':>'
			{
				newLeafNode(otherlv_3, grammarAccess.getFacetedScalarAccess().getColonGreaterThanSignKeyword_3_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getFacetedScalarAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_3_1_0());
					}
					lv_ownedSpecializations_4_0=ruleSpecializationAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFacetedScalarRule());
						}
						add(
							$current,
							"ownedSpecializations",
							lv_ownedSpecializations_4_0,
							"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_5=','
				{
					newLeafNode(otherlv_5, grammarAccess.getFacetedScalarAccess().getCommaKeyword_3_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getFacetedScalarAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_3_2_1_0());
						}
						lv_ownedSpecializations_6_0=ruleSpecializationAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getFacetedScalarRule());
							}
							add(
								$current,
								"ownedSpecializations",
								lv_ownedSpecializations_6_0,
								"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		(
			otherlv_7='['
			{
				newLeafNode(otherlv_7, grammarAccess.getFacetedScalarAccess().getLeftSquareBracketKeyword_4_0());
			}
			(
				(
					{ 
					  getUnorderedGroupHelper().enter(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1());
					}
					(
						(
				(
					{getUnorderedGroupHelper().canSelect(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1(), 0)}?=>(
						{
							getUnorderedGroupHelper().select(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1(), 0);
						}
									({true}?=>(otherlv_9='length'
									{
										newLeafNode(otherlv_9, grammarAccess.getFacetedScalarAccess().getLengthKeyword_4_1_0_0());
									}
									(
										(
											{
												newCompositeNode(grammarAccess.getFacetedScalarAccess().getLengthUnsignedIntegerParserRuleCall_4_1_0_1_0());
											}
											lv_length_10_0=ruleUnsignedInteger
											{
												if ($current==null) {
													$current = createModelElementForParent(grammarAccess.getFacetedScalarRule());
												}
												set(
													$current,
													"length",
													lv_length_10_0,
													"io.opencaesar.oml.dsl.Oml.UnsignedInteger");
												afterParserOrEnumRuleCall();
											}
										)
									)
									))
						{ 
							getUnorderedGroupHelper().returnFromSelection(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1());
						}
					)
				)|
				(
					{getUnorderedGroupHelper().canSelect(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1(), 1)}?=>(
						{
							getUnorderedGroupHelper().select(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1(), 1);
						}
									({true}?=>(otherlv_11='minLength'
									{
										newLeafNode(otherlv_11, grammarAccess.getFacetedScalarAccess().getMinLengthKeyword_4_1_1_0());
									}
									(
										(
											{
												newCompositeNode(grammarAccess.getFacetedScalarAccess().getMinLengthUnsignedIntegerParserRuleCall_4_1_1_1_0());
											}
											lv_minLength_12_0=ruleUnsignedInteger
											{
												if ($current==null) {
													$current = createModelElementForParent(grammarAccess.getFacetedScalarRule());
												}
												set(
													$current,
													"minLength",
													lv_minLength_12_0,
													"io.opencaesar.oml.dsl.Oml.UnsignedInteger");
												afterParserOrEnumRuleCall();
											}
										)
									)
									))
						{ 
							getUnorderedGroupHelper().returnFromSelection(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1());
						}
					)
				)|
				(
					{getUnorderedGroupHelper().canSelect(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1(), 2)}?=>(
						{
							getUnorderedGroupHelper().select(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1(), 2);
						}
									({true}?=>(otherlv_13='maxLength'
									{
										newLeafNode(otherlv_13, grammarAccess.getFacetedScalarAccess().getMaxLengthKeyword_4_1_2_0());
									}
									(
										(
											{
												newCompositeNode(grammarAccess.getFacetedScalarAccess().getMaxLengthUnsignedIntegerParserRuleCall_4_1_2_1_0());
											}
											lv_maxLength_14_0=ruleUnsignedInteger
											{
												if ($current==null) {
													$current = createModelElementForParent(grammarAccess.getFacetedScalarRule());
												}
												set(
													$current,
													"maxLength",
													lv_maxLength_14_0,
													"io.opencaesar.oml.dsl.Oml.UnsignedInteger");
												afterParserOrEnumRuleCall();
											}
										)
									)
									))
						{ 
							getUnorderedGroupHelper().returnFromSelection(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1());
						}
					)
				)|
				(
					{getUnorderedGroupHelper().canSelect(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1(), 3)}?=>(
						{
							getUnorderedGroupHelper().select(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1(), 3);
						}
									({true}?=>(otherlv_15='pattern'
									{
										newLeafNode(otherlv_15, grammarAccess.getFacetedScalarAccess().getPatternKeyword_4_1_3_0());
									}
									(
										(
											lv_pattern_16_0=RULE_STRING
											{
												newLeafNode(lv_pattern_16_0, grammarAccess.getFacetedScalarAccess().getPatternSTRINGTerminalRuleCall_4_1_3_1_0());
											}
											{
												if ($current==null) {
													$current = createModelElement(grammarAccess.getFacetedScalarRule());
												}
												setWithLastConsumed(
													$current,
													"pattern",
													lv_pattern_16_0,
													"io.opencaesar.oml.dsl.Oml.STRING");
											}
										)
									)
									))
						{ 
							getUnorderedGroupHelper().returnFromSelection(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1());
						}
					)
				)|
				(
					{getUnorderedGroupHelper().canSelect(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1(), 4)}?=>(
						{
							getUnorderedGroupHelper().select(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1(), 4);
						}
									({true}?=>(otherlv_17='language'
									{
										newLeafNode(otherlv_17, grammarAccess.getFacetedScalarAccess().getLanguageKeyword_4_1_4_0());
									}
									(
										(
											lv_language_18_0=RULE_ID
											{
												newLeafNode(lv_language_18_0, grammarAccess.getFacetedScalarAccess().getLanguageIDTerminalRuleCall_4_1_4_1_0());
											}
											{
												if ($current==null) {
													$current = createModelElement(grammarAccess.getFacetedScalarRule());
												}
												setWithLastConsumed(
													$current,
													"language",
													lv_language_18_0,
													"io.opencaesar.oml.dsl.Oml.ID");
											}
										)
									)
									))
						{ 
							getUnorderedGroupHelper().returnFromSelection(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1());
						}
					)
				)|
				(
					{getUnorderedGroupHelper().canSelect(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1(), 5)}?=>(
						{
							getUnorderedGroupHelper().select(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1(), 5);
						}
									({true}?=>(otherlv_19='minInclusive'
									{
										newLeafNode(otherlv_19, grammarAccess.getFacetedScalarAccess().getMinInclusiveKeyword_4_1_5_0());
									}
									(
										(
											{
												newCompositeNode(grammarAccess.getFacetedScalarAccess().getMinInclusiveLiteralParserRuleCall_4_1_5_1_0());
											}
											lv_minInclusive_20_0=ruleLiteral
											{
												if ($current==null) {
													$current = createModelElementForParent(grammarAccess.getFacetedScalarRule());
												}
												set(
													$current,
													"minInclusive",
													lv_minInclusive_20_0,
													"io.opencaesar.oml.dsl.Oml.Literal");
												afterParserOrEnumRuleCall();
											}
										)
									)
									))
						{ 
							getUnorderedGroupHelper().returnFromSelection(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1());
						}
					)
				)|
				(
					{getUnorderedGroupHelper().canSelect(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1(), 6)}?=>(
						{
							getUnorderedGroupHelper().select(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1(), 6);
						}
									({true}?=>(otherlv_21='minExclusive'
									{
										newLeafNode(otherlv_21, grammarAccess.getFacetedScalarAccess().getMinExclusiveKeyword_4_1_6_0());
									}
									(
										(
											{
												newCompositeNode(grammarAccess.getFacetedScalarAccess().getMinExclusiveLiteralParserRuleCall_4_1_6_1_0());
											}
											lv_minExclusive_22_0=ruleLiteral
											{
												if ($current==null) {
													$current = createModelElementForParent(grammarAccess.getFacetedScalarRule());
												}
												set(
													$current,
													"minExclusive",
													lv_minExclusive_22_0,
													"io.opencaesar.oml.dsl.Oml.Literal");
												afterParserOrEnumRuleCall();
											}
										)
									)
									))
						{ 
							getUnorderedGroupHelper().returnFromSelection(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1());
						}
					)
				)|
				(
					{getUnorderedGroupHelper().canSelect(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1(), 7)}?=>(
						{
							getUnorderedGroupHelper().select(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1(), 7);
						}
									({true}?=>(otherlv_23='maxInclusive'
									{
										newLeafNode(otherlv_23, grammarAccess.getFacetedScalarAccess().getMaxInclusiveKeyword_4_1_7_0());
									}
									(
										(
											{
												newCompositeNode(grammarAccess.getFacetedScalarAccess().getMaxInclusiveLiteralParserRuleCall_4_1_7_1_0());
											}
											lv_maxInclusive_24_0=ruleLiteral
											{
												if ($current==null) {
													$current = createModelElementForParent(grammarAccess.getFacetedScalarRule());
												}
												set(
													$current,
													"maxInclusive",
													lv_maxInclusive_24_0,
													"io.opencaesar.oml.dsl.Oml.Literal");
												afterParserOrEnumRuleCall();
											}
										)
									)
									))
						{ 
							getUnorderedGroupHelper().returnFromSelection(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1());
						}
					)
				)|
				(
					{getUnorderedGroupHelper().canSelect(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1(), 8)}?=>(
						{
							getUnorderedGroupHelper().select(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1(), 8);
						}
									({true}?=>(otherlv_25='maxExclusive'
									{
										newLeafNode(otherlv_25, grammarAccess.getFacetedScalarAccess().getMaxExclusiveKeyword_4_1_8_0());
									}
									(
										(
											{
												newCompositeNode(grammarAccess.getFacetedScalarAccess().getMaxExclusiveLiteralParserRuleCall_4_1_8_1_0());
											}
											lv_maxExclusive_26_0=ruleLiteral
											{
												if ($current==null) {
													$current = createModelElementForParent(grammarAccess.getFacetedScalarRule());
												}
												set(
													$current,
													"maxExclusive",
													lv_maxExclusive_26_0,
													"io.opencaesar.oml.dsl.Oml.Literal");
												afterParserOrEnumRuleCall();
											}
										)
									)
									))
						{ 
							getUnorderedGroupHelper().returnFromSelection(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1());
						}
					)
				)
						)*
					)
				)
					{ 
					  getUnorderedGroupHelper().leave(grammarAccess.getFacetedScalarAccess().getUnorderedGroup_4_1());
					}
			)
			otherlv_27=']'
			{
				newLeafNode(otherlv_27, grammarAccess.getFacetedScalarAccess().getRightSquareBracketKeyword_4_2());
			}
		)?
	)
;

// Entry rule entryRuleEnumeratedScalar
entryRuleEnumeratedScalar returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEnumeratedScalarRule()); }
	iv_ruleEnumeratedScalar=ruleEnumeratedScalar
	{ $current=$iv_ruleEnumeratedScalar.current; }
	EOF;

// Rule EnumeratedScalar
ruleEnumeratedScalar returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getEnumeratedScalarAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEnumeratedScalarRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='enumerated'
		{
			newLeafNode(otherlv_1, grammarAccess.getEnumeratedScalarAccess().getEnumeratedKeyword_1());
		}
		otherlv_2='scalar'
		{
			newLeafNode(otherlv_2, grammarAccess.getEnumeratedScalarAccess().getScalarKeyword_2());
		}
		(
			(
				lv_name_3_0=RULE_ID
				{
					newLeafNode(lv_name_3_0, grammarAccess.getEnumeratedScalarAccess().getNameIDTerminalRuleCall_3_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEnumeratedScalarRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_3_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		(
			otherlv_4=':>'
			{
				newLeafNode(otherlv_4, grammarAccess.getEnumeratedScalarAccess().getColonGreaterThanSignKeyword_4_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getEnumeratedScalarAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0());
					}
					lv_ownedSpecializations_5_0=ruleSpecializationAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getEnumeratedScalarRule());
						}
						add(
							$current,
							"ownedSpecializations",
							lv_ownedSpecializations_5_0,
							"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_6=','
				{
					newLeafNode(otherlv_6, grammarAccess.getEnumeratedScalarAccess().getCommaKeyword_4_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getEnumeratedScalarAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0());
						}
						lv_ownedSpecializations_7_0=ruleSpecializationAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getEnumeratedScalarRule());
							}
							add(
								$current,
								"ownedSpecializations",
								lv_ownedSpecializations_7_0,
								"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		(
			otherlv_8='['
			{
				newLeafNode(otherlv_8, grammarAccess.getEnumeratedScalarAccess().getLeftSquareBracketKeyword_5_0());
			}
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getEnumeratedScalarAccess().getLiteralsLiteralParserRuleCall_5_1_0_0());
						}
						lv_literals_9_0=ruleLiteral
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getEnumeratedScalarRule());
							}
							add(
								$current,
								"literals",
								lv_literals_9_0,
								"io.opencaesar.oml.dsl.Oml.Literal");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					otherlv_10=','
					{
						newLeafNode(otherlv_10, grammarAccess.getEnumeratedScalarAccess().getCommaKeyword_5_1_1_0());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getEnumeratedScalarAccess().getLiteralsLiteralParserRuleCall_5_1_1_1_0());
							}
							lv_literals_11_0=ruleLiteral
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getEnumeratedScalarRule());
								}
								add(
									$current,
									"literals",
									lv_literals_11_0,
									"io.opencaesar.oml.dsl.Oml.Literal");
								afterParserOrEnumRuleCall();
							}
						)
					)
				)*
			)?
			otherlv_12=']'
			{
				newLeafNode(otherlv_12, grammarAccess.getEnumeratedScalarAccess().getRightSquareBracketKeyword_5_2());
			}
		)?
	)
;

// Entry rule entryRuleForwardRelation
entryRuleForwardRelation returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getForwardRelationRule()); }
	iv_ruleForwardRelation=ruleForwardRelation
	{ $current=$iv_ruleForwardRelation.current; }
	EOF;

// Rule ForwardRelation
ruleForwardRelation returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getForwardRelationAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getForwardRelationRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='forward'
		{
			newLeafNode(otherlv_1, grammarAccess.getForwardRelationAccess().getForwardKeyword_1());
		}
		(
			(
				lv_name_2_0=RULE_ID
				{
					newLeafNode(lv_name_2_0, grammarAccess.getForwardRelationAccess().getNameIDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getForwardRelationRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_2_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
	)
;

// Entry rule entryRuleReverseRelation
entryRuleReverseRelation returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getReverseRelationRule()); }
	iv_ruleReverseRelation=ruleReverseRelation
	{ $current=$iv_ruleReverseRelation.current; }
	EOF;

// Rule ReverseRelation
ruleReverseRelation returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getReverseRelationAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getReverseRelationRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='reverse'
		{
			newLeafNode(otherlv_1, grammarAccess.getReverseRelationAccess().getReverseKeyword_1());
		}
		(
			(
				lv_name_2_0=RULE_ID
				{
					newLeafNode(lv_name_2_0, grammarAccess.getReverseRelationAccess().getNameIDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getReverseRelationRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_2_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
	)
;

// Entry rule entryRuleRule
entryRuleRule returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRuleRule()); }
	iv_ruleRule=ruleRule
	{ $current=$iv_ruleRule.current; }
	EOF;

// Rule Rule
ruleRule returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getRuleAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRuleRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='rule'
		{
			newLeafNode(otherlv_1, grammarAccess.getRuleAccess().getRuleKeyword_1());
		}
		(
			(
				lv_name_2_0=RULE_ID
				{
					newLeafNode(lv_name_2_0, grammarAccess.getRuleAccess().getNameIDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRuleRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_2_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		otherlv_3='['
		{
			newLeafNode(otherlv_3, grammarAccess.getRuleAccess().getLeftSquareBracketKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRuleAccess().getAntecedentPredicateParserRuleCall_4_0());
				}
				lv_antecedent_4_0=rulePredicate
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRuleRule());
					}
					add(
						$current,
						"antecedent",
						lv_antecedent_4_0,
						"io.opencaesar.oml.dsl.Oml.Predicate");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_5='^'
			{
				newLeafNode(otherlv_5, grammarAccess.getRuleAccess().getCircumflexAccentKeyword_5_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getRuleAccess().getAntecedentPredicateParserRuleCall_5_1_0());
					}
					lv_antecedent_6_0=rulePredicate
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getRuleRule());
						}
						add(
							$current,
							"antecedent",
							lv_antecedent_6_0,
							"io.opencaesar.oml.dsl.Oml.Predicate");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		otherlv_7='->'
		{
			newLeafNode(otherlv_7, grammarAccess.getRuleAccess().getHyphenMinusGreaterThanSignKeyword_6());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRuleAccess().getConsequentPredicateParserRuleCall_7_0());
				}
				lv_consequent_8_0=rulePredicate
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRuleRule());
					}
					add(
						$current,
						"consequent",
						lv_consequent_8_0,
						"io.opencaesar.oml.dsl.Oml.Predicate");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_9='^'
			{
				newLeafNode(otherlv_9, grammarAccess.getRuleAccess().getCircumflexAccentKeyword_8_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getRuleAccess().getConsequentPredicateParserRuleCall_8_1_0());
					}
					lv_consequent_10_0=rulePredicate
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getRuleRule());
						}
						add(
							$current,
							"consequent",
							lv_consequent_10_0,
							"io.opencaesar.oml.dsl.Oml.Predicate");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		otherlv_11=']'
		{
			newLeafNode(otherlv_11, grammarAccess.getRuleAccess().getRightSquareBracketKeyword_9());
		}
	)
;

// Entry rule entryRuleStructureInstance
entryRuleStructureInstance returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStructureInstanceRule()); }
	iv_ruleStructureInstance=ruleStructureInstance
	{ $current=$iv_ruleStructureInstance.current; }
	EOF;

// Rule StructureInstance
ruleStructureInstance returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getStructureInstanceRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getStructureInstanceAccess().getTypeStructureCrossReference_0_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_1='['
		{
			newLeafNode(otherlv_1, grammarAccess.getStructureInstanceAccess().getLeftSquareBracketKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getStructureInstanceAccess().getOwnedPropertyValuesPropertyValueAssertionParserRuleCall_2_0());
				}
				lv_ownedPropertyValues_2_0=rulePropertyValueAssertion
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStructureInstanceRule());
					}
					add(
						$current,
						"ownedPropertyValues",
						lv_ownedPropertyValues_2_0,
						"io.opencaesar.oml.dsl.Oml.PropertyValueAssertion");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_3=']'
		{
			newLeafNode(otherlv_3, grammarAccess.getStructureInstanceAccess().getRightSquareBracketKeyword_3());
		}
	)
;

// Entry rule entryRuleNamedInstance
entryRuleNamedInstance returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNamedInstanceRule()); }
	iv_ruleNamedInstance=ruleNamedInstance
	{ $current=$iv_ruleNamedInstance.current; }
	EOF;

// Rule NamedInstance
ruleNamedInstance returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getNamedInstanceAccess().getConceptInstanceParserRuleCall_0());
		}
		this_ConceptInstance_0=ruleConceptInstance
		{
			$current = $this_ConceptInstance_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getNamedInstanceAccess().getRelationInstanceParserRuleCall_1());
		}
		this_RelationInstance_1=ruleRelationInstance
		{
			$current = $this_RelationInstance_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleConceptInstance
entryRuleConceptInstance returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getConceptInstanceRule()); }
	iv_ruleConceptInstance=ruleConceptInstance
	{ $current=$iv_ruleConceptInstance.current; }
	EOF;

// Rule ConceptInstance
ruleConceptInstance returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getConceptInstanceAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getConceptInstanceRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='ci'
		{
			newLeafNode(otherlv_1, grammarAccess.getConceptInstanceAccess().getCiKeyword_1());
		}
		(
			(
				lv_name_2_0=RULE_ID
				{
					newLeafNode(lv_name_2_0, grammarAccess.getConceptInstanceAccess().getNameIDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getConceptInstanceRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_2_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		(
			otherlv_3=':'
			{
				newLeafNode(otherlv_3, grammarAccess.getConceptInstanceAccess().getColonKeyword_3_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getConceptInstanceAccess().getOwnedTypesConceptTypeAssertionParserRuleCall_3_1_0());
					}
					lv_ownedTypes_4_0=ruleConceptTypeAssertion
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getConceptInstanceRule());
						}
						add(
							$current,
							"ownedTypes",
							lv_ownedTypes_4_0,
							"io.opencaesar.oml.dsl.Oml.ConceptTypeAssertion");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_5=','
				{
					newLeafNode(otherlv_5, grammarAccess.getConceptInstanceAccess().getCommaKeyword_3_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getConceptInstanceAccess().getOwnedTypesConceptTypeAssertionParserRuleCall_3_2_1_0());
						}
						lv_ownedTypes_6_0=ruleConceptTypeAssertion
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConceptInstanceRule());
							}
							add(
								$current,
								"ownedTypes",
								lv_ownedTypes_6_0,
								"io.opencaesar.oml.dsl.Oml.ConceptTypeAssertion");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		(
			otherlv_7='['
			{
				newLeafNode(otherlv_7, grammarAccess.getConceptInstanceAccess().getLeftSquareBracketKeyword_4_0());
			}
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getConceptInstanceAccess().getOwnedPropertyValuesPropertyValueAssertionParserRuleCall_4_1_0_0());
						}
						lv_ownedPropertyValues_8_0=rulePropertyValueAssertion
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConceptInstanceRule());
							}
							add(
								$current,
								"ownedPropertyValues",
								lv_ownedPropertyValues_8_0,
								"io.opencaesar.oml.dsl.Oml.PropertyValueAssertion");
							afterParserOrEnumRuleCall();
						}
					)
				)
				    |
				(
					(
						{
							newCompositeNode(grammarAccess.getConceptInstanceAccess().getOwnedLinksLinkAssertionParserRuleCall_4_1_1_0());
						}
						lv_ownedLinks_9_0=ruleLinkAssertion
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConceptInstanceRule());
							}
							add(
								$current,
								"ownedLinks",
								lv_ownedLinks_9_0,
								"io.opencaesar.oml.dsl.Oml.LinkAssertion");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
			otherlv_10=']'
			{
				newLeafNode(otherlv_10, grammarAccess.getConceptInstanceAccess().getRightSquareBracketKeyword_4_2());
			}
		)?
	)
;

// Entry rule entryRuleRelationInstance
entryRuleRelationInstance returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRelationInstanceRule()); }
	iv_ruleRelationInstance=ruleRelationInstance
	{ $current=$iv_ruleRelationInstance.current; }
	EOF;

// Rule RelationInstance
ruleRelationInstance returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getRelationInstanceAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRelationInstanceRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='ri'
		{
			newLeafNode(otherlv_1, grammarAccess.getRelationInstanceAccess().getRiKeyword_1());
		}
		(
			(
				lv_name_2_0=RULE_ID
				{
					newLeafNode(lv_name_2_0, grammarAccess.getRelationInstanceAccess().getNameIDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRelationInstanceRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_2_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		(
			otherlv_3=':'
			{
				newLeafNode(otherlv_3, grammarAccess.getRelationInstanceAccess().getColonKeyword_3_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getRelationInstanceAccess().getOwnedTypesRelationTypeAssertionParserRuleCall_3_1_0());
					}
					lv_ownedTypes_4_0=ruleRelationTypeAssertion
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getRelationInstanceRule());
						}
						add(
							$current,
							"ownedTypes",
							lv_ownedTypes_4_0,
							"io.opencaesar.oml.dsl.Oml.RelationTypeAssertion");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_5=','
				{
					newLeafNode(otherlv_5, grammarAccess.getRelationInstanceAccess().getCommaKeyword_3_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getRelationInstanceAccess().getOwnedTypesRelationTypeAssertionParserRuleCall_3_2_1_0());
						}
						lv_ownedTypes_6_0=ruleRelationTypeAssertion
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getRelationInstanceRule());
							}
							add(
								$current,
								"ownedTypes",
								lv_ownedTypes_6_0,
								"io.opencaesar.oml.dsl.Oml.RelationTypeAssertion");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		otherlv_7='['
		{
			newLeafNode(otherlv_7, grammarAccess.getRelationInstanceAccess().getLeftSquareBracketKeyword_4());
		}
		otherlv_8='from'
		{
			newLeafNode(otherlv_8, grammarAccess.getRelationInstanceAccess().getFromKeyword_5());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRelationInstanceRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getRelationInstanceAccess().getSourcesNamedInstanceCrossReference_6_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_10=','
			{
				newLeafNode(otherlv_10, grammarAccess.getRelationInstanceAccess().getCommaKeyword_7_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getRelationInstanceRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getRelationInstanceAccess().getSourcesNamedInstanceCrossReference_7_1_0());
					}
					ruleRef
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		otherlv_12='to'
		{
			newLeafNode(otherlv_12, grammarAccess.getRelationInstanceAccess().getToKeyword_8());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRelationInstanceRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getRelationInstanceAccess().getTargetsNamedInstanceCrossReference_9_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_14=','
			{
				newLeafNode(otherlv_14, grammarAccess.getRelationInstanceAccess().getCommaKeyword_10_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getRelationInstanceRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getRelationInstanceAccess().getTargetsNamedInstanceCrossReference_10_1_0());
					}
					ruleRef
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getRelationInstanceAccess().getOwnedPropertyValuesPropertyValueAssertionParserRuleCall_11_0_0());
					}
					lv_ownedPropertyValues_16_0=rulePropertyValueAssertion
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getRelationInstanceRule());
						}
						add(
							$current,
							"ownedPropertyValues",
							lv_ownedPropertyValues_16_0,
							"io.opencaesar.oml.dsl.Oml.PropertyValueAssertion");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					{
						newCompositeNode(grammarAccess.getRelationInstanceAccess().getOwnedLinksLinkAssertionParserRuleCall_11_1_0());
					}
					lv_ownedLinks_17_0=ruleLinkAssertion
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getRelationInstanceRule());
						}
						add(
							$current,
							"ownedLinks",
							lv_ownedLinks_17_0,
							"io.opencaesar.oml.dsl.Oml.LinkAssertion");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		otherlv_18=']'
		{
			newLeafNode(otherlv_18, grammarAccess.getRelationInstanceAccess().getRightSquareBracketKeyword_12());
		}
	)
;

// Entry rule entryRuleSpecializableTermReference
entryRuleSpecializableTermReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSpecializableTermReferenceRule()); }
	iv_ruleSpecializableTermReference=ruleSpecializableTermReference
	{ $current=$iv_ruleSpecializableTermReference.current; }
	EOF;

// Rule SpecializableTermReference
ruleSpecializableTermReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getSpecializableTermReferenceAccess().getClassifierReferenceParserRuleCall_0());
		}
		this_ClassifierReference_0=ruleClassifierReference
		{
			$current = $this_ClassifierReference_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getSpecializableTermReferenceAccess().getFacetedScalarReferenceParserRuleCall_1());
		}
		this_FacetedScalarReference_1=ruleFacetedScalarReference
		{
			$current = $this_FacetedScalarReference_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getSpecializableTermReferenceAccess().getEnumeratedScalarReferenceParserRuleCall_2());
		}
		this_EnumeratedScalarReference_2=ruleEnumeratedScalarReference
		{
			$current = $this_EnumeratedScalarReference_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getSpecializableTermReferenceAccess().getAnnotationPropertyReferenceParserRuleCall_3());
		}
		this_AnnotationPropertyReference_3=ruleAnnotationPropertyReference
		{
			$current = $this_AnnotationPropertyReference_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getSpecializableTermReferenceAccess().getScalarPropertyReferenceParserRuleCall_4());
		}
		this_ScalarPropertyReference_4=ruleScalarPropertyReference
		{
			$current = $this_ScalarPropertyReference_4.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getSpecializableTermReferenceAccess().getStructuredPropertyReferenceParserRuleCall_5());
		}
		this_StructuredPropertyReference_5=ruleStructuredPropertyReference
		{
			$current = $this_StructuredPropertyReference_5.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleClassifierReference
entryRuleClassifierReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getClassifierReferenceRule()); }
	iv_ruleClassifierReference=ruleClassifierReference
	{ $current=$iv_ruleClassifierReference.current; }
	EOF;

// Rule ClassifierReference
ruleClassifierReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getClassifierReferenceAccess().getEntityReferenceParserRuleCall_0());
		}
		this_EntityReference_0=ruleEntityReference
		{
			$current = $this_EntityReference_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getClassifierReferenceAccess().getStructureReferenceParserRuleCall_1());
		}
		this_StructureReference_1=ruleStructureReference
		{
			$current = $this_StructureReference_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleEntityReference
entryRuleEntityReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEntityReferenceRule()); }
	iv_ruleEntityReference=ruleEntityReference
	{ $current=$iv_ruleEntityReference.current; }
	EOF;

// Rule EntityReference
ruleEntityReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getEntityReferenceAccess().getAspectReferenceParserRuleCall_0());
		}
		this_AspectReference_0=ruleAspectReference
		{
			$current = $this_AspectReference_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getEntityReferenceAccess().getConceptReferenceParserRuleCall_1());
		}
		this_ConceptReference_1=ruleConceptReference
		{
			$current = $this_ConceptReference_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getEntityReferenceAccess().getRelationEntityReferenceParserRuleCall_2());
		}
		this_RelationEntityReference_2=ruleRelationEntityReference
		{
			$current = $this_RelationEntityReference_2.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleAspectReference
entryRuleAspectReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAspectReferenceRule()); }
	iv_ruleAspectReference=ruleAspectReference
	{ $current=$iv_ruleAspectReference.current; }
	EOF;

// Rule AspectReference
ruleAspectReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getAspectReferenceAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getAspectReferenceRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='ref'
		{
			newLeafNode(otherlv_1, grammarAccess.getAspectReferenceAccess().getRefKeyword_1());
		}
		otherlv_2='aspect'
		{
			newLeafNode(otherlv_2, grammarAccess.getAspectReferenceAccess().getAspectKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getAspectReferenceRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getAspectReferenceAccess().getAspectAspectCrossReference_3_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_4=':>'
			{
				newLeafNode(otherlv_4, grammarAccess.getAspectReferenceAccess().getColonGreaterThanSignKeyword_4_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getAspectReferenceAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0());
					}
					lv_ownedSpecializations_5_0=ruleSpecializationAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getAspectReferenceRule());
						}
						add(
							$current,
							"ownedSpecializations",
							lv_ownedSpecializations_5_0,
							"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_6=','
				{
					newLeafNode(otherlv_6, grammarAccess.getAspectReferenceAccess().getCommaKeyword_4_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getAspectReferenceAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0());
						}
						lv_ownedSpecializations_7_0=ruleSpecializationAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAspectReferenceRule());
							}
							add(
								$current,
								"ownedSpecializations",
								lv_ownedSpecializations_7_0,
								"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		(
			otherlv_8='['
			{
				newLeafNode(otherlv_8, grammarAccess.getAspectReferenceAccess().getLeftSquareBracketKeyword_5_0());
			}
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getAspectReferenceAccess().getOwnedKeysKeyAxiomParserRuleCall_5_1_0_0());
						}
						lv_ownedKeys_9_0=ruleKeyAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAspectReferenceRule());
							}
							add(
								$current,
								"ownedKeys",
								lv_ownedKeys_9_0,
								"io.opencaesar.oml.dsl.Oml.KeyAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
				    |
				(
					(
						{
							newCompositeNode(grammarAccess.getAspectReferenceAccess().getOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_5_1_1_0());
						}
						lv_ownedPropertyRestrictions_10_0=rulePropertyRestrictionAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAspectReferenceRule());
							}
							add(
								$current,
								"ownedPropertyRestrictions",
								lv_ownedPropertyRestrictions_10_0,
								"io.opencaesar.oml.dsl.Oml.PropertyRestrictionAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
				    |
				(
					(
						{
							newCompositeNode(grammarAccess.getAspectReferenceAccess().getOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_5_1_2_0());
						}
						lv_ownedRelationRestrictions_11_0=ruleRelationRestrictionAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAspectReferenceRule());
							}
							add(
								$current,
								"ownedRelationRestrictions",
								lv_ownedRelationRestrictions_11_0,
								"io.opencaesar.oml.dsl.Oml.RelationRestrictionAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
			otherlv_12=']'
			{
				newLeafNode(otherlv_12, grammarAccess.getAspectReferenceAccess().getRightSquareBracketKeyword_5_2());
			}
		)?
	)
;

// Entry rule entryRuleConceptReference
entryRuleConceptReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getConceptReferenceRule()); }
	iv_ruleConceptReference=ruleConceptReference
	{ $current=$iv_ruleConceptReference.current; }
	EOF;

// Rule ConceptReference
ruleConceptReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getConceptReferenceAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getConceptReferenceRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='ref'
		{
			newLeafNode(otherlv_1, grammarAccess.getConceptReferenceAccess().getRefKeyword_1());
		}
		otherlv_2='concept'
		{
			newLeafNode(otherlv_2, grammarAccess.getConceptReferenceAccess().getConceptKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getConceptReferenceRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getConceptReferenceAccess().getConceptConceptCrossReference_3_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_4=':>'
			{
				newLeafNode(otherlv_4, grammarAccess.getConceptReferenceAccess().getColonGreaterThanSignKeyword_4_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getConceptReferenceAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0());
					}
					lv_ownedSpecializations_5_0=ruleSpecializationAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getConceptReferenceRule());
						}
						add(
							$current,
							"ownedSpecializations",
							lv_ownedSpecializations_5_0,
							"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_6=','
				{
					newLeafNode(otherlv_6, grammarAccess.getConceptReferenceAccess().getCommaKeyword_4_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getConceptReferenceAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0());
						}
						lv_ownedSpecializations_7_0=ruleSpecializationAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConceptReferenceRule());
							}
							add(
								$current,
								"ownedSpecializations",
								lv_ownedSpecializations_7_0,
								"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		(
			otherlv_8='['
			{
				newLeafNode(otherlv_8, grammarAccess.getConceptReferenceAccess().getLeftSquareBracketKeyword_5_0());
			}
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getConceptReferenceAccess().getOwnedKeysKeyAxiomParserRuleCall_5_1_0_0());
						}
						lv_ownedKeys_9_0=ruleKeyAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConceptReferenceRule());
							}
							add(
								$current,
								"ownedKeys",
								lv_ownedKeys_9_0,
								"io.opencaesar.oml.dsl.Oml.KeyAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
				    |
				(
					(
						{
							newCompositeNode(grammarAccess.getConceptReferenceAccess().getOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_5_1_1_0());
						}
						lv_ownedPropertyRestrictions_10_0=rulePropertyRestrictionAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConceptReferenceRule());
							}
							add(
								$current,
								"ownedPropertyRestrictions",
								lv_ownedPropertyRestrictions_10_0,
								"io.opencaesar.oml.dsl.Oml.PropertyRestrictionAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
				    |
				(
					(
						{
							newCompositeNode(grammarAccess.getConceptReferenceAccess().getOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_5_1_2_0());
						}
						lv_ownedRelationRestrictions_11_0=ruleRelationRestrictionAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConceptReferenceRule());
							}
							add(
								$current,
								"ownedRelationRestrictions",
								lv_ownedRelationRestrictions_11_0,
								"io.opencaesar.oml.dsl.Oml.RelationRestrictionAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
			otherlv_12=']'
			{
				newLeafNode(otherlv_12, grammarAccess.getConceptReferenceAccess().getRightSquareBracketKeyword_5_2());
			}
		)?
	)
;

// Entry rule entryRuleRelationEntityReference
entryRuleRelationEntityReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRelationEntityReferenceRule()); }
	iv_ruleRelationEntityReference=ruleRelationEntityReference
	{ $current=$iv_ruleRelationEntityReference.current; }
	EOF;

// Rule RelationEntityReference
ruleRelationEntityReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getRelationEntityReferenceAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRelationEntityReferenceRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='ref'
		{
			newLeafNode(otherlv_1, grammarAccess.getRelationEntityReferenceAccess().getRefKeyword_1());
		}
		otherlv_2='relation'
		{
			newLeafNode(otherlv_2, grammarAccess.getRelationEntityReferenceAccess().getRelationKeyword_2());
		}
		otherlv_3='entity'
		{
			newLeafNode(otherlv_3, grammarAccess.getRelationEntityReferenceAccess().getEntityKeyword_3());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRelationEntityReferenceRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getRelationEntityReferenceAccess().getEntityRelationEntityCrossReference_4_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_5=':>'
			{
				newLeafNode(otherlv_5, grammarAccess.getRelationEntityReferenceAccess().getColonGreaterThanSignKeyword_5_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getRelationEntityReferenceAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0());
					}
					lv_ownedSpecializations_6_0=ruleSpecializationAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getRelationEntityReferenceRule());
						}
						add(
							$current,
							"ownedSpecializations",
							lv_ownedSpecializations_6_0,
							"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_7=','
				{
					newLeafNode(otherlv_7, grammarAccess.getRelationEntityReferenceAccess().getCommaKeyword_5_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getRelationEntityReferenceAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0());
						}
						lv_ownedSpecializations_8_0=ruleSpecializationAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getRelationEntityReferenceRule());
							}
							add(
								$current,
								"ownedSpecializations",
								lv_ownedSpecializations_8_0,
								"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		(
			otherlv_9='['
			{
				newLeafNode(otherlv_9, grammarAccess.getRelationEntityReferenceAccess().getLeftSquareBracketKeyword_6_0());
			}
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getRelationEntityReferenceAccess().getOwnedKeysKeyAxiomParserRuleCall_6_1_0_0());
						}
						lv_ownedKeys_10_0=ruleKeyAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getRelationEntityReferenceRule());
							}
							add(
								$current,
								"ownedKeys",
								lv_ownedKeys_10_0,
								"io.opencaesar.oml.dsl.Oml.KeyAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
				    |
				(
					(
						{
							newCompositeNode(grammarAccess.getRelationEntityReferenceAccess().getOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_6_1_1_0());
						}
						lv_ownedPropertyRestrictions_11_0=rulePropertyRestrictionAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getRelationEntityReferenceRule());
							}
							add(
								$current,
								"ownedPropertyRestrictions",
								lv_ownedPropertyRestrictions_11_0,
								"io.opencaesar.oml.dsl.Oml.PropertyRestrictionAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
				    |
				(
					(
						{
							newCompositeNode(grammarAccess.getRelationEntityReferenceAccess().getOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_6_1_2_0());
						}
						lv_ownedRelationRestrictions_12_0=ruleRelationRestrictionAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getRelationEntityReferenceRule());
							}
							add(
								$current,
								"ownedRelationRestrictions",
								lv_ownedRelationRestrictions_12_0,
								"io.opencaesar.oml.dsl.Oml.RelationRestrictionAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
			otherlv_13=']'
			{
				newLeafNode(otherlv_13, grammarAccess.getRelationEntityReferenceAccess().getRightSquareBracketKeyword_6_2());
			}
		)?
	)
;

// Entry rule entryRuleStructureReference
entryRuleStructureReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStructureReferenceRule()); }
	iv_ruleStructureReference=ruleStructureReference
	{ $current=$iv_ruleStructureReference.current; }
	EOF;

// Rule StructureReference
ruleStructureReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getStructureReferenceAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStructureReferenceRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='ref'
		{
			newLeafNode(otherlv_1, grammarAccess.getStructureReferenceAccess().getRefKeyword_1());
		}
		otherlv_2='structure'
		{
			newLeafNode(otherlv_2, grammarAccess.getStructureReferenceAccess().getStructureKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getStructureReferenceRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getStructureReferenceAccess().getStructureStructureCrossReference_3_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_4=':>'
			{
				newLeafNode(otherlv_4, grammarAccess.getStructureReferenceAccess().getColonGreaterThanSignKeyword_4_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getStructureReferenceAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0());
					}
					lv_ownedSpecializations_5_0=ruleSpecializationAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getStructureReferenceRule());
						}
						add(
							$current,
							"ownedSpecializations",
							lv_ownedSpecializations_5_0,
							"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_6=','
				{
					newLeafNode(otherlv_6, grammarAccess.getStructureReferenceAccess().getCommaKeyword_4_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getStructureReferenceAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0());
						}
						lv_ownedSpecializations_7_0=ruleSpecializationAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getStructureReferenceRule());
							}
							add(
								$current,
								"ownedSpecializations",
								lv_ownedSpecializations_7_0,
								"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		(
			otherlv_8='['
			{
				newLeafNode(otherlv_8, grammarAccess.getStructureReferenceAccess().getLeftSquareBracketKeyword_5_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getStructureReferenceAccess().getOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_5_1_0());
					}
					lv_ownedPropertyRestrictions_9_0=rulePropertyRestrictionAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getStructureReferenceRule());
						}
						add(
							$current,
							"ownedPropertyRestrictions",
							lv_ownedPropertyRestrictions_9_0,
							"io.opencaesar.oml.dsl.Oml.PropertyRestrictionAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_10=']'
			{
				newLeafNode(otherlv_10, grammarAccess.getStructureReferenceAccess().getRightSquareBracketKeyword_5_2());
			}
		)?
	)
;

// Entry rule entryRuleAnnotationPropertyReference
entryRuleAnnotationPropertyReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAnnotationPropertyReferenceRule()); }
	iv_ruleAnnotationPropertyReference=ruleAnnotationPropertyReference
	{ $current=$iv_ruleAnnotationPropertyReference.current; }
	EOF;

// Rule AnnotationPropertyReference
ruleAnnotationPropertyReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getAnnotationPropertyReferenceAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getAnnotationPropertyReferenceRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='ref'
		{
			newLeafNode(otherlv_1, grammarAccess.getAnnotationPropertyReferenceAccess().getRefKeyword_1());
		}
		otherlv_2='annotation'
		{
			newLeafNode(otherlv_2, grammarAccess.getAnnotationPropertyReferenceAccess().getAnnotationKeyword_2());
		}
		otherlv_3='property'
		{
			newLeafNode(otherlv_3, grammarAccess.getAnnotationPropertyReferenceAccess().getPropertyKeyword_3());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getAnnotationPropertyReferenceRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getAnnotationPropertyReferenceAccess().getPropertyAnnotationPropertyCrossReference_4_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_5=':>'
			{
				newLeafNode(otherlv_5, grammarAccess.getAnnotationPropertyReferenceAccess().getColonGreaterThanSignKeyword_5_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getAnnotationPropertyReferenceAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0());
					}
					lv_ownedSpecializations_6_0=ruleSpecializationAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getAnnotationPropertyReferenceRule());
						}
						add(
							$current,
							"ownedSpecializations",
							lv_ownedSpecializations_6_0,
							"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_7=','
				{
					newLeafNode(otherlv_7, grammarAccess.getAnnotationPropertyReferenceAccess().getCommaKeyword_5_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getAnnotationPropertyReferenceAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0());
						}
						lv_ownedSpecializations_8_0=ruleSpecializationAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAnnotationPropertyReferenceRule());
							}
							add(
								$current,
								"ownedSpecializations",
								lv_ownedSpecializations_8_0,
								"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
	)
;

// Entry rule entryRuleScalarPropertyReference
entryRuleScalarPropertyReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getScalarPropertyReferenceRule()); }
	iv_ruleScalarPropertyReference=ruleScalarPropertyReference
	{ $current=$iv_ruleScalarPropertyReference.current; }
	EOF;

// Rule ScalarPropertyReference
ruleScalarPropertyReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getScalarPropertyReferenceAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getScalarPropertyReferenceRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='ref'
		{
			newLeafNode(otherlv_1, grammarAccess.getScalarPropertyReferenceAccess().getRefKeyword_1());
		}
		otherlv_2='scalar'
		{
			newLeafNode(otherlv_2, grammarAccess.getScalarPropertyReferenceAccess().getScalarKeyword_2());
		}
		otherlv_3='property'
		{
			newLeafNode(otherlv_3, grammarAccess.getScalarPropertyReferenceAccess().getPropertyKeyword_3());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getScalarPropertyReferenceRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getScalarPropertyReferenceAccess().getPropertyScalarPropertyCrossReference_4_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_5=':>'
			{
				newLeafNode(otherlv_5, grammarAccess.getScalarPropertyReferenceAccess().getColonGreaterThanSignKeyword_5_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getScalarPropertyReferenceAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0());
					}
					lv_ownedSpecializations_6_0=ruleSpecializationAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getScalarPropertyReferenceRule());
						}
						add(
							$current,
							"ownedSpecializations",
							lv_ownedSpecializations_6_0,
							"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_7=','
				{
					newLeafNode(otherlv_7, grammarAccess.getScalarPropertyReferenceAccess().getCommaKeyword_5_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getScalarPropertyReferenceAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0());
						}
						lv_ownedSpecializations_8_0=ruleSpecializationAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getScalarPropertyReferenceRule());
							}
							add(
								$current,
								"ownedSpecializations",
								lv_ownedSpecializations_8_0,
								"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
	)
;

// Entry rule entryRuleStructuredPropertyReference
entryRuleStructuredPropertyReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStructuredPropertyReferenceRule()); }
	iv_ruleStructuredPropertyReference=ruleStructuredPropertyReference
	{ $current=$iv_ruleStructuredPropertyReference.current; }
	EOF;

// Rule StructuredPropertyReference
ruleStructuredPropertyReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getStructuredPropertyReferenceAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStructuredPropertyReferenceRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='ref'
		{
			newLeafNode(otherlv_1, grammarAccess.getStructuredPropertyReferenceAccess().getRefKeyword_1());
		}
		otherlv_2='structured'
		{
			newLeafNode(otherlv_2, grammarAccess.getStructuredPropertyReferenceAccess().getStructuredKeyword_2());
		}
		otherlv_3='property'
		{
			newLeafNode(otherlv_3, grammarAccess.getStructuredPropertyReferenceAccess().getPropertyKeyword_3());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getStructuredPropertyReferenceRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getStructuredPropertyReferenceAccess().getPropertyStructuredPropertyCrossReference_4_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_5=':>'
			{
				newLeafNode(otherlv_5, grammarAccess.getStructuredPropertyReferenceAccess().getColonGreaterThanSignKeyword_5_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getStructuredPropertyReferenceAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0());
					}
					lv_ownedSpecializations_6_0=ruleSpecializationAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getStructuredPropertyReferenceRule());
						}
						add(
							$current,
							"ownedSpecializations",
							lv_ownedSpecializations_6_0,
							"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_7=','
				{
					newLeafNode(otherlv_7, grammarAccess.getStructuredPropertyReferenceAccess().getCommaKeyword_5_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getStructuredPropertyReferenceAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0());
						}
						lv_ownedSpecializations_8_0=ruleSpecializationAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getStructuredPropertyReferenceRule());
							}
							add(
								$current,
								"ownedSpecializations",
								lv_ownedSpecializations_8_0,
								"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
	)
;

// Entry rule entryRuleFacetedScalarReference
entryRuleFacetedScalarReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getFacetedScalarReferenceRule()); }
	iv_ruleFacetedScalarReference=ruleFacetedScalarReference
	{ $current=$iv_ruleFacetedScalarReference.current; }
	EOF;

// Rule FacetedScalarReference
ruleFacetedScalarReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getFacetedScalarReferenceAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getFacetedScalarReferenceRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='ref'
		{
			newLeafNode(otherlv_1, grammarAccess.getFacetedScalarReferenceAccess().getRefKeyword_1());
		}
		otherlv_2='scalar'
		{
			newLeafNode(otherlv_2, grammarAccess.getFacetedScalarReferenceAccess().getScalarKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getFacetedScalarReferenceRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getFacetedScalarReferenceAccess().getScalarFacetedScalarCrossReference_3_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_4=':>'
			{
				newLeafNode(otherlv_4, grammarAccess.getFacetedScalarReferenceAccess().getColonGreaterThanSignKeyword_4_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getFacetedScalarReferenceAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0());
					}
					lv_ownedSpecializations_5_0=ruleSpecializationAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFacetedScalarReferenceRule());
						}
						add(
							$current,
							"ownedSpecializations",
							lv_ownedSpecializations_5_0,
							"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_6=','
				{
					newLeafNode(otherlv_6, grammarAccess.getFacetedScalarReferenceAccess().getCommaKeyword_4_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getFacetedScalarReferenceAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0());
						}
						lv_ownedSpecializations_7_0=ruleSpecializationAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getFacetedScalarReferenceRule());
							}
							add(
								$current,
								"ownedSpecializations",
								lv_ownedSpecializations_7_0,
								"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
	)
;

// Entry rule entryRuleEnumeratedScalarReference
entryRuleEnumeratedScalarReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEnumeratedScalarReferenceRule()); }
	iv_ruleEnumeratedScalarReference=ruleEnumeratedScalarReference
	{ $current=$iv_ruleEnumeratedScalarReference.current; }
	EOF;

// Rule EnumeratedScalarReference
ruleEnumeratedScalarReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getEnumeratedScalarReferenceAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEnumeratedScalarReferenceRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='ref'
		{
			newLeafNode(otherlv_1, grammarAccess.getEnumeratedScalarReferenceAccess().getRefKeyword_1());
		}
		otherlv_2='enumerated'
		{
			newLeafNode(otherlv_2, grammarAccess.getEnumeratedScalarReferenceAccess().getEnumeratedKeyword_2());
		}
		otherlv_3='scalar'
		{
			newLeafNode(otherlv_3, grammarAccess.getEnumeratedScalarReferenceAccess().getScalarKeyword_3());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEnumeratedScalarReferenceRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getEnumeratedScalarReferenceAccess().getScalarEnumeratedScalarCrossReference_4_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_5=':>'
			{
				newLeafNode(otherlv_5, grammarAccess.getEnumeratedScalarReferenceAccess().getColonGreaterThanSignKeyword_5_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getEnumeratedScalarReferenceAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0());
					}
					lv_ownedSpecializations_6_0=ruleSpecializationAxiom
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getEnumeratedScalarReferenceRule());
						}
						add(
							$current,
							"ownedSpecializations",
							lv_ownedSpecializations_6_0,
							"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_7=','
				{
					newLeafNode(otherlv_7, grammarAccess.getEnumeratedScalarReferenceAccess().getCommaKeyword_5_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getEnumeratedScalarReferenceAccess().getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0());
						}
						lv_ownedSpecializations_8_0=ruleSpecializationAxiom
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getEnumeratedScalarReferenceRule());
							}
							add(
								$current,
								"ownedSpecializations",
								lv_ownedSpecializations_8_0,
								"io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
	)
;

// Entry rule entryRuleRelationReference
entryRuleRelationReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRelationReferenceRule()); }
	iv_ruleRelationReference=ruleRelationReference
	{ $current=$iv_ruleRelationReference.current; }
	EOF;

// Rule RelationReference
ruleRelationReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getRelationReferenceAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRelationReferenceRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='ref'
		{
			newLeafNode(otherlv_1, grammarAccess.getRelationReferenceAccess().getRefKeyword_1());
		}
		otherlv_2='relation'
		{
			newLeafNode(otherlv_2, grammarAccess.getRelationReferenceAccess().getRelationKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRelationReferenceRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getRelationReferenceAccess().getRelationRelationCrossReference_3_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleRuleReference
entryRuleRuleReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRuleReferenceRule()); }
	iv_ruleRuleReference=ruleRuleReference
	{ $current=$iv_ruleRuleReference.current; }
	EOF;

// Rule RuleReference
ruleRuleReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getRuleReferenceAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRuleReferenceRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='ref'
		{
			newLeafNode(otherlv_1, grammarAccess.getRuleReferenceAccess().getRefKeyword_1());
		}
		otherlv_2='rule'
		{
			newLeafNode(otherlv_2, grammarAccess.getRuleReferenceAccess().getRuleKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRuleReferenceRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getRuleReferenceAccess().getRuleRuleCrossReference_3_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleNamedInstanceReference
entryRuleNamedInstanceReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNamedInstanceReferenceRule()); }
	iv_ruleNamedInstanceReference=ruleNamedInstanceReference
	{ $current=$iv_ruleNamedInstanceReference.current; }
	EOF;

// Rule NamedInstanceReference
ruleNamedInstanceReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getNamedInstanceReferenceAccess().getConceptInstanceReferenceParserRuleCall_0());
		}
		this_ConceptInstanceReference_0=ruleConceptInstanceReference
		{
			$current = $this_ConceptInstanceReference_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getNamedInstanceReferenceAccess().getRelationInstanceReferenceParserRuleCall_1());
		}
		this_RelationInstanceReference_1=ruleRelationInstanceReference
		{
			$current = $this_RelationInstanceReference_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleConceptInstanceReference
entryRuleConceptInstanceReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getConceptInstanceReferenceRule()); }
	iv_ruleConceptInstanceReference=ruleConceptInstanceReference
	{ $current=$iv_ruleConceptInstanceReference.current; }
	EOF;

// Rule ConceptInstanceReference
ruleConceptInstanceReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getConceptInstanceReferenceAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getConceptInstanceReferenceRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='ref'
		{
			newLeafNode(otherlv_1, grammarAccess.getConceptInstanceReferenceAccess().getRefKeyword_1());
		}
		otherlv_2='ci'
		{
			newLeafNode(otherlv_2, grammarAccess.getConceptInstanceReferenceAccess().getCiKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getConceptInstanceReferenceRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getConceptInstanceReferenceAccess().getInstanceConceptInstanceCrossReference_3_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_4=':'
			{
				newLeafNode(otherlv_4, grammarAccess.getConceptInstanceReferenceAccess().getColonKeyword_4_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getConceptInstanceReferenceAccess().getOwnedTypesConceptTypeAssertionParserRuleCall_4_1_0());
					}
					lv_ownedTypes_5_0=ruleConceptTypeAssertion
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getConceptInstanceReferenceRule());
						}
						add(
							$current,
							"ownedTypes",
							lv_ownedTypes_5_0,
							"io.opencaesar.oml.dsl.Oml.ConceptTypeAssertion");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_6=','
				{
					newLeafNode(otherlv_6, grammarAccess.getConceptInstanceReferenceAccess().getCommaKeyword_4_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getConceptInstanceReferenceAccess().getOwnedTypesConceptTypeAssertionParserRuleCall_4_2_1_0());
						}
						lv_ownedTypes_7_0=ruleConceptTypeAssertion
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConceptInstanceReferenceRule());
							}
							add(
								$current,
								"ownedTypes",
								lv_ownedTypes_7_0,
								"io.opencaesar.oml.dsl.Oml.ConceptTypeAssertion");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		(
			otherlv_8='['
			{
				newLeafNode(otherlv_8, grammarAccess.getConceptInstanceReferenceAccess().getLeftSquareBracketKeyword_5_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getConceptInstanceReferenceAccess().getOwnedPropertyValuesPropertyValueAssertionParserRuleCall_5_1_0());
					}
					lv_ownedPropertyValues_9_0=rulePropertyValueAssertion
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getConceptInstanceReferenceRule());
						}
						add(
							$current,
							"ownedPropertyValues",
							lv_ownedPropertyValues_9_0,
							"io.opencaesar.oml.dsl.Oml.PropertyValueAssertion");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			(
				(
					{
						newCompositeNode(grammarAccess.getConceptInstanceReferenceAccess().getOwnedLinksLinkAssertionParserRuleCall_5_2_0());
					}
					lv_ownedLinks_10_0=ruleLinkAssertion
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getConceptInstanceReferenceRule());
						}
						add(
							$current,
							"ownedLinks",
							lv_ownedLinks_10_0,
							"io.opencaesar.oml.dsl.Oml.LinkAssertion");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_11=']'
			{
				newLeafNode(otherlv_11, grammarAccess.getConceptInstanceReferenceAccess().getRightSquareBracketKeyword_5_3());
			}
		)?
	)
;

// Entry rule entryRuleRelationInstanceReference
entryRuleRelationInstanceReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRelationInstanceReferenceRule()); }
	iv_ruleRelationInstanceReference=ruleRelationInstanceReference
	{ $current=$iv_ruleRelationInstanceReference.current; }
	EOF;

// Rule RelationInstanceReference
ruleRelationInstanceReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getRelationInstanceReferenceAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRelationInstanceReferenceRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='ref'
		{
			newLeafNode(otherlv_1, grammarAccess.getRelationInstanceReferenceAccess().getRefKeyword_1());
		}
		otherlv_2='ri'
		{
			newLeafNode(otherlv_2, grammarAccess.getRelationInstanceReferenceAccess().getRiKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRelationInstanceReferenceRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getRelationInstanceReferenceAccess().getInstanceRelationInstanceCrossReference_3_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_4=':'
			{
				newLeafNode(otherlv_4, grammarAccess.getRelationInstanceReferenceAccess().getColonKeyword_4_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getRelationInstanceReferenceAccess().getOwnedTypesRelationTypeAssertionParserRuleCall_4_1_0());
					}
					lv_ownedTypes_5_0=ruleRelationTypeAssertion
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getRelationInstanceReferenceRule());
						}
						add(
							$current,
							"ownedTypes",
							lv_ownedTypes_5_0,
							"io.opencaesar.oml.dsl.Oml.RelationTypeAssertion");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_6=','
				{
					newLeafNode(otherlv_6, grammarAccess.getRelationInstanceReferenceAccess().getCommaKeyword_4_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getRelationInstanceReferenceAccess().getOwnedTypesRelationTypeAssertionParserRuleCall_4_2_1_0());
						}
						lv_ownedTypes_7_0=ruleRelationTypeAssertion
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getRelationInstanceReferenceRule());
							}
							add(
								$current,
								"ownedTypes",
								lv_ownedTypes_7_0,
								"io.opencaesar.oml.dsl.Oml.RelationTypeAssertion");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		(
			otherlv_8='['
			{
				newLeafNode(otherlv_8, grammarAccess.getRelationInstanceReferenceAccess().getLeftSquareBracketKeyword_5_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getRelationInstanceReferenceAccess().getOwnedPropertyValuesPropertyValueAssertionParserRuleCall_5_1_0());
					}
					lv_ownedPropertyValues_9_0=rulePropertyValueAssertion
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getRelationInstanceReferenceRule());
						}
						add(
							$current,
							"ownedPropertyValues",
							lv_ownedPropertyValues_9_0,
							"io.opencaesar.oml.dsl.Oml.PropertyValueAssertion");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			(
				(
					{
						newCompositeNode(grammarAccess.getRelationInstanceReferenceAccess().getOwnedLinksLinkAssertionParserRuleCall_5_2_0());
					}
					lv_ownedLinks_10_0=ruleLinkAssertion
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getRelationInstanceReferenceRule());
						}
						add(
							$current,
							"ownedLinks",
							lv_ownedLinks_10_0,
							"io.opencaesar.oml.dsl.Oml.LinkAssertion");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_11=']'
			{
				newLeafNode(otherlv_11, grammarAccess.getRelationInstanceReferenceAccess().getRightSquareBracketKeyword_5_3());
			}
		)?
	)
;

// Entry rule entryRuleVocabularyStatement
entryRuleVocabularyStatement returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getVocabularyStatementRule()); }
	iv_ruleVocabularyStatement=ruleVocabularyStatement
	{ $current=$iv_ruleVocabularyStatement.current; }
	EOF;

// Rule VocabularyStatement
ruleVocabularyStatement returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getVocabularyStatementAccess().getRuleParserRuleCall_0());
		}
		this_Rule_0=ruleRule
		{
			$current = $this_Rule_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getVocabularyStatementAccess().getRuleReferenceParserRuleCall_1());
		}
		this_RuleReference_1=ruleRuleReference
		{
			$current = $this_RuleReference_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getVocabularyStatementAccess().getSpecializableTermParserRuleCall_2());
		}
		this_SpecializableTerm_2=ruleSpecializableTerm
		{
			$current = $this_SpecializableTerm_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getVocabularyStatementAccess().getSpecializableTermReferenceParserRuleCall_3());
		}
		this_SpecializableTermReference_3=ruleSpecializableTermReference
		{
			$current = $this_SpecializableTermReference_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getVocabularyStatementAccess().getRelationReferenceParserRuleCall_4());
		}
		this_RelationReference_4=ruleRelationReference
		{
			$current = $this_RelationReference_4.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleDescriptionStatement
entryRuleDescriptionStatement returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDescriptionStatementRule()); }
	iv_ruleDescriptionStatement=ruleDescriptionStatement
	{ $current=$iv_ruleDescriptionStatement.current; }
	EOF;

// Rule DescriptionStatement
ruleDescriptionStatement returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getDescriptionStatementAccess().getNamedInstanceParserRuleCall_0());
		}
		this_NamedInstance_0=ruleNamedInstance
		{
			$current = $this_NamedInstance_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getDescriptionStatementAccess().getNamedInstanceReferenceParserRuleCall_1());
		}
		this_NamedInstanceReference_1=ruleNamedInstanceReference
		{
			$current = $this_NamedInstanceReference_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleVocabularyImport
entryRuleVocabularyImport returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getVocabularyImportRule()); }
	iv_ruleVocabularyImport=ruleVocabularyImport
	{ $current=$iv_ruleVocabularyImport.current; }
	EOF;

// Rule VocabularyImport
ruleVocabularyImport returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getVocabularyImportAccess().getVocabularyExtensionParserRuleCall_0());
		}
		this_VocabularyExtension_0=ruleVocabularyExtension
		{
			$current = $this_VocabularyExtension_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getVocabularyImportAccess().getVocabularyUsageParserRuleCall_1());
		}
		this_VocabularyUsage_1=ruleVocabularyUsage
		{
			$current = $this_VocabularyUsage_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleVocabularyExtension
entryRuleVocabularyExtension returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getVocabularyExtensionRule()); }
	iv_ruleVocabularyExtension=ruleVocabularyExtension
	{ $current=$iv_ruleVocabularyExtension.current; }
	EOF;

// Rule VocabularyExtension
ruleVocabularyExtension returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getVocabularyExtensionAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getVocabularyExtensionRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='extends'
		{
			newLeafNode(otherlv_1, grammarAccess.getVocabularyExtensionAccess().getExtendsKeyword_1());
		}
		(
			(
				lv_namespace_2_0=RULE_NAMESPACE
				{
					newLeafNode(lv_namespace_2_0, grammarAccess.getVocabularyExtensionAccess().getNamespaceNAMESPACETerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getVocabularyExtensionRule());
					}
					setWithLastConsumed(
						$current,
						"namespace",
						lv_namespace_2_0,
						"io.opencaesar.oml.dsl.Oml.NAMESPACE");
				}
			)
		)
		(
			otherlv_3='as'
			{
				newLeafNode(otherlv_3, grammarAccess.getVocabularyExtensionAccess().getAsKeyword_3_0());
			}
			(
				(
					lv_prefix_4_0=RULE_ID
					{
						newLeafNode(lv_prefix_4_0, grammarAccess.getVocabularyExtensionAccess().getPrefixIDTerminalRuleCall_3_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getVocabularyExtensionRule());
						}
						setWithLastConsumed(
							$current,
							"prefix",
							lv_prefix_4_0,
							"io.opencaesar.oml.dsl.Oml.ID");
					}
				)
			)
		)?
	)
;

// Entry rule entryRuleVocabularyUsage
entryRuleVocabularyUsage returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getVocabularyUsageRule()); }
	iv_ruleVocabularyUsage=ruleVocabularyUsage
	{ $current=$iv_ruleVocabularyUsage.current; }
	EOF;

// Rule VocabularyUsage
ruleVocabularyUsage returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getVocabularyUsageAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getVocabularyUsageRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='uses'
		{
			newLeafNode(otherlv_1, grammarAccess.getVocabularyUsageAccess().getUsesKeyword_1());
		}
		(
			(
				lv_namespace_2_0=RULE_NAMESPACE
				{
					newLeafNode(lv_namespace_2_0, grammarAccess.getVocabularyUsageAccess().getNamespaceNAMESPACETerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getVocabularyUsageRule());
					}
					setWithLastConsumed(
						$current,
						"namespace",
						lv_namespace_2_0,
						"io.opencaesar.oml.dsl.Oml.NAMESPACE");
				}
			)
		)
		(
			otherlv_3='as'
			{
				newLeafNode(otherlv_3, grammarAccess.getVocabularyUsageAccess().getAsKeyword_3_0());
			}
			(
				(
					lv_prefix_4_0=RULE_ID
					{
						newLeafNode(lv_prefix_4_0, grammarAccess.getVocabularyUsageAccess().getPrefixIDTerminalRuleCall_3_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getVocabularyUsageRule());
						}
						setWithLastConsumed(
							$current,
							"prefix",
							lv_prefix_4_0,
							"io.opencaesar.oml.dsl.Oml.ID");
					}
				)
			)
		)?
	)
;

// Entry rule entryRuleVocabularyBundleImport
entryRuleVocabularyBundleImport returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getVocabularyBundleImportRule()); }
	iv_ruleVocabularyBundleImport=ruleVocabularyBundleImport
	{ $current=$iv_ruleVocabularyBundleImport.current; }
	EOF;

// Rule VocabularyBundleImport
ruleVocabularyBundleImport returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getVocabularyBundleImportAccess().getVocabularyBundleExtensionParserRuleCall_0());
		}
		this_VocabularyBundleExtension_0=ruleVocabularyBundleExtension
		{
			$current = $this_VocabularyBundleExtension_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getVocabularyBundleImportAccess().getVocabularyBundleInclusionParserRuleCall_1());
		}
		this_VocabularyBundleInclusion_1=ruleVocabularyBundleInclusion
		{
			$current = $this_VocabularyBundleInclusion_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleVocabularyBundleInclusion
entryRuleVocabularyBundleInclusion returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getVocabularyBundleInclusionRule()); }
	iv_ruleVocabularyBundleInclusion=ruleVocabularyBundleInclusion
	{ $current=$iv_ruleVocabularyBundleInclusion.current; }
	EOF;

// Rule VocabularyBundleInclusion
ruleVocabularyBundleInclusion returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getVocabularyBundleInclusionAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getVocabularyBundleInclusionRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='includes'
		{
			newLeafNode(otherlv_1, grammarAccess.getVocabularyBundleInclusionAccess().getIncludesKeyword_1());
		}
		(
			(
				lv_namespace_2_0=RULE_NAMESPACE
				{
					newLeafNode(lv_namespace_2_0, grammarAccess.getVocabularyBundleInclusionAccess().getNamespaceNAMESPACETerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getVocabularyBundleInclusionRule());
					}
					setWithLastConsumed(
						$current,
						"namespace",
						lv_namespace_2_0,
						"io.opencaesar.oml.dsl.Oml.NAMESPACE");
				}
			)
		)
		(
			otherlv_3='as'
			{
				newLeafNode(otherlv_3, grammarAccess.getVocabularyBundleInclusionAccess().getAsKeyword_3_0());
			}
			(
				(
					lv_prefix_4_0=RULE_ID
					{
						newLeafNode(lv_prefix_4_0, grammarAccess.getVocabularyBundleInclusionAccess().getPrefixIDTerminalRuleCall_3_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getVocabularyBundleInclusionRule());
						}
						setWithLastConsumed(
							$current,
							"prefix",
							lv_prefix_4_0,
							"io.opencaesar.oml.dsl.Oml.ID");
					}
				)
			)
		)?
	)
;

// Entry rule entryRuleVocabularyBundleExtension
entryRuleVocabularyBundleExtension returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getVocabularyBundleExtensionRule()); }
	iv_ruleVocabularyBundleExtension=ruleVocabularyBundleExtension
	{ $current=$iv_ruleVocabularyBundleExtension.current; }
	EOF;

// Rule VocabularyBundleExtension
ruleVocabularyBundleExtension returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getVocabularyBundleExtensionAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getVocabularyBundleExtensionRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='extends'
		{
			newLeafNode(otherlv_1, grammarAccess.getVocabularyBundleExtensionAccess().getExtendsKeyword_1());
		}
		(
			(
				lv_namespace_2_0=RULE_NAMESPACE
				{
					newLeafNode(lv_namespace_2_0, grammarAccess.getVocabularyBundleExtensionAccess().getNamespaceNAMESPACETerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getVocabularyBundleExtensionRule());
					}
					setWithLastConsumed(
						$current,
						"namespace",
						lv_namespace_2_0,
						"io.opencaesar.oml.dsl.Oml.NAMESPACE");
				}
			)
		)
		(
			otherlv_3='as'
			{
				newLeafNode(otherlv_3, grammarAccess.getVocabularyBundleExtensionAccess().getAsKeyword_3_0());
			}
			(
				(
					lv_prefix_4_0=RULE_ID
					{
						newLeafNode(lv_prefix_4_0, grammarAccess.getVocabularyBundleExtensionAccess().getPrefixIDTerminalRuleCall_3_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getVocabularyBundleExtensionRule());
						}
						setWithLastConsumed(
							$current,
							"prefix",
							lv_prefix_4_0,
							"io.opencaesar.oml.dsl.Oml.ID");
					}
				)
			)
		)?
	)
;

// Entry rule entryRuleDescriptionImport
entryRuleDescriptionImport returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDescriptionImportRule()); }
	iv_ruleDescriptionImport=ruleDescriptionImport
	{ $current=$iv_ruleDescriptionImport.current; }
	EOF;

// Rule DescriptionImport
ruleDescriptionImport returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getDescriptionImportAccess().getDescriptionExtensionParserRuleCall_0());
		}
		this_DescriptionExtension_0=ruleDescriptionExtension
		{
			$current = $this_DescriptionExtension_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getDescriptionImportAccess().getDescriptionUsageParserRuleCall_1());
		}
		this_DescriptionUsage_1=ruleDescriptionUsage
		{
			$current = $this_DescriptionUsage_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleDescriptionUsage
entryRuleDescriptionUsage returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDescriptionUsageRule()); }
	iv_ruleDescriptionUsage=ruleDescriptionUsage
	{ $current=$iv_ruleDescriptionUsage.current; }
	EOF;

// Rule DescriptionUsage
ruleDescriptionUsage returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getDescriptionUsageAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDescriptionUsageRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='uses'
		{
			newLeafNode(otherlv_1, grammarAccess.getDescriptionUsageAccess().getUsesKeyword_1());
		}
		(
			(
				lv_namespace_2_0=RULE_NAMESPACE
				{
					newLeafNode(lv_namespace_2_0, grammarAccess.getDescriptionUsageAccess().getNamespaceNAMESPACETerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDescriptionUsageRule());
					}
					setWithLastConsumed(
						$current,
						"namespace",
						lv_namespace_2_0,
						"io.opencaesar.oml.dsl.Oml.NAMESPACE");
				}
			)
		)
		(
			otherlv_3='as'
			{
				newLeafNode(otherlv_3, grammarAccess.getDescriptionUsageAccess().getAsKeyword_3_0());
			}
			(
				(
					lv_prefix_4_0=RULE_ID
					{
						newLeafNode(lv_prefix_4_0, grammarAccess.getDescriptionUsageAccess().getPrefixIDTerminalRuleCall_3_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getDescriptionUsageRule());
						}
						setWithLastConsumed(
							$current,
							"prefix",
							lv_prefix_4_0,
							"io.opencaesar.oml.dsl.Oml.ID");
					}
				)
			)
		)?
	)
;

// Entry rule entryRuleDescriptionExtension
entryRuleDescriptionExtension returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDescriptionExtensionRule()); }
	iv_ruleDescriptionExtension=ruleDescriptionExtension
	{ $current=$iv_ruleDescriptionExtension.current; }
	EOF;

// Rule DescriptionExtension
ruleDescriptionExtension returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getDescriptionExtensionAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDescriptionExtensionRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='extends'
		{
			newLeafNode(otherlv_1, grammarAccess.getDescriptionExtensionAccess().getExtendsKeyword_1());
		}
		(
			(
				lv_namespace_2_0=RULE_NAMESPACE
				{
					newLeafNode(lv_namespace_2_0, grammarAccess.getDescriptionExtensionAccess().getNamespaceNAMESPACETerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDescriptionExtensionRule());
					}
					setWithLastConsumed(
						$current,
						"namespace",
						lv_namespace_2_0,
						"io.opencaesar.oml.dsl.Oml.NAMESPACE");
				}
			)
		)
		(
			otherlv_3='as'
			{
				newLeafNode(otherlv_3, grammarAccess.getDescriptionExtensionAccess().getAsKeyword_3_0());
			}
			(
				(
					lv_prefix_4_0=RULE_ID
					{
						newLeafNode(lv_prefix_4_0, grammarAccess.getDescriptionExtensionAccess().getPrefixIDTerminalRuleCall_3_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getDescriptionExtensionRule());
						}
						setWithLastConsumed(
							$current,
							"prefix",
							lv_prefix_4_0,
							"io.opencaesar.oml.dsl.Oml.ID");
					}
				)
			)
		)?
	)
;

// Entry rule entryRuleDescriptionBundleImport
entryRuleDescriptionBundleImport returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDescriptionBundleImportRule()); }
	iv_ruleDescriptionBundleImport=ruleDescriptionBundleImport
	{ $current=$iv_ruleDescriptionBundleImport.current; }
	EOF;

// Rule DescriptionBundleImport
ruleDescriptionBundleImport returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getDescriptionBundleImportAccess().getDescriptionBundleExtensionParserRuleCall_0());
		}
		this_DescriptionBundleExtension_0=ruleDescriptionBundleExtension
		{
			$current = $this_DescriptionBundleExtension_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getDescriptionBundleImportAccess().getDescriptionBundleInclusionParserRuleCall_1());
		}
		this_DescriptionBundleInclusion_1=ruleDescriptionBundleInclusion
		{
			$current = $this_DescriptionBundleInclusion_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getDescriptionBundleImportAccess().getDescriptionBundleUsageParserRuleCall_2());
		}
		this_DescriptionBundleUsage_2=ruleDescriptionBundleUsage
		{
			$current = $this_DescriptionBundleUsage_2.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleDescriptionBundleInclusion
entryRuleDescriptionBundleInclusion returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDescriptionBundleInclusionRule()); }
	iv_ruleDescriptionBundleInclusion=ruleDescriptionBundleInclusion
	{ $current=$iv_ruleDescriptionBundleInclusion.current; }
	EOF;

// Rule DescriptionBundleInclusion
ruleDescriptionBundleInclusion returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getDescriptionBundleInclusionAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDescriptionBundleInclusionRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='includes'
		{
			newLeafNode(otherlv_1, grammarAccess.getDescriptionBundleInclusionAccess().getIncludesKeyword_1());
		}
		(
			(
				lv_namespace_2_0=RULE_NAMESPACE
				{
					newLeafNode(lv_namespace_2_0, grammarAccess.getDescriptionBundleInclusionAccess().getNamespaceNAMESPACETerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDescriptionBundleInclusionRule());
					}
					setWithLastConsumed(
						$current,
						"namespace",
						lv_namespace_2_0,
						"io.opencaesar.oml.dsl.Oml.NAMESPACE");
				}
			)
		)
		(
			otherlv_3='as'
			{
				newLeafNode(otherlv_3, grammarAccess.getDescriptionBundleInclusionAccess().getAsKeyword_3_0());
			}
			(
				(
					lv_prefix_4_0=RULE_ID
					{
						newLeafNode(lv_prefix_4_0, grammarAccess.getDescriptionBundleInclusionAccess().getPrefixIDTerminalRuleCall_3_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getDescriptionBundleInclusionRule());
						}
						setWithLastConsumed(
							$current,
							"prefix",
							lv_prefix_4_0,
							"io.opencaesar.oml.dsl.Oml.ID");
					}
				)
			)
		)?
	)
;

// Entry rule entryRuleDescriptionBundleExtension
entryRuleDescriptionBundleExtension returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDescriptionBundleExtensionRule()); }
	iv_ruleDescriptionBundleExtension=ruleDescriptionBundleExtension
	{ $current=$iv_ruleDescriptionBundleExtension.current; }
	EOF;

// Rule DescriptionBundleExtension
ruleDescriptionBundleExtension returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getDescriptionBundleExtensionAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDescriptionBundleExtensionRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='extends'
		{
			newLeafNode(otherlv_1, grammarAccess.getDescriptionBundleExtensionAccess().getExtendsKeyword_1());
		}
		(
			(
				lv_namespace_2_0=RULE_NAMESPACE
				{
					newLeafNode(lv_namespace_2_0, grammarAccess.getDescriptionBundleExtensionAccess().getNamespaceNAMESPACETerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDescriptionBundleExtensionRule());
					}
					setWithLastConsumed(
						$current,
						"namespace",
						lv_namespace_2_0,
						"io.opencaesar.oml.dsl.Oml.NAMESPACE");
				}
			)
		)
		(
			otherlv_3='as'
			{
				newLeafNode(otherlv_3, grammarAccess.getDescriptionBundleExtensionAccess().getAsKeyword_3_0());
			}
			(
				(
					lv_prefix_4_0=RULE_ID
					{
						newLeafNode(lv_prefix_4_0, grammarAccess.getDescriptionBundleExtensionAccess().getPrefixIDTerminalRuleCall_3_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getDescriptionBundleExtensionRule());
						}
						setWithLastConsumed(
							$current,
							"prefix",
							lv_prefix_4_0,
							"io.opencaesar.oml.dsl.Oml.ID");
					}
				)
			)
		)?
	)
;

// Entry rule entryRuleDescriptionBundleUsage
entryRuleDescriptionBundleUsage returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDescriptionBundleUsageRule()); }
	iv_ruleDescriptionBundleUsage=ruleDescriptionBundleUsage
	{ $current=$iv_ruleDescriptionBundleUsage.current; }
	EOF;

// Rule DescriptionBundleUsage
ruleDescriptionBundleUsage returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getDescriptionBundleUsageAccess().getOwnedAnnotationsAnnotationParserRuleCall_0_0());
				}
				lv_ownedAnnotations_0_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDescriptionBundleUsageRule());
					}
					add(
						$current,
						"ownedAnnotations",
						lv_ownedAnnotations_0_0,
						"io.opencaesar.oml.dsl.Oml.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_1='uses'
		{
			newLeafNode(otherlv_1, grammarAccess.getDescriptionBundleUsageAccess().getUsesKeyword_1());
		}
		(
			(
				lv_namespace_2_0=RULE_NAMESPACE
				{
					newLeafNode(lv_namespace_2_0, grammarAccess.getDescriptionBundleUsageAccess().getNamespaceNAMESPACETerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDescriptionBundleUsageRule());
					}
					setWithLastConsumed(
						$current,
						"namespace",
						lv_namespace_2_0,
						"io.opencaesar.oml.dsl.Oml.NAMESPACE");
				}
			)
		)
		(
			otherlv_3='as'
			{
				newLeafNode(otherlv_3, grammarAccess.getDescriptionBundleUsageAccess().getAsKeyword_3_0());
			}
			(
				(
					lv_prefix_4_0=RULE_ID
					{
						newLeafNode(lv_prefix_4_0, grammarAccess.getDescriptionBundleUsageAccess().getPrefixIDTerminalRuleCall_3_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getDescriptionBundleUsageRule());
						}
						setWithLastConsumed(
							$current,
							"prefix",
							lv_prefix_4_0,
							"io.opencaesar.oml.dsl.Oml.ID");
					}
				)
			)
		)?
	)
;

// Entry rule entryRuleSpecializationAxiom
entryRuleSpecializationAxiom returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSpecializationAxiomRule()); }
	iv_ruleSpecializationAxiom=ruleSpecializationAxiom
	{ $current=$iv_ruleSpecializationAxiom.current; }
	EOF;

// Rule SpecializationAxiom
ruleSpecializationAxiom returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				if ($current==null) {
					$current = createModelElement(grammarAccess.getSpecializationAxiomRule());
				}
			}
			{
				newCompositeNode(grammarAccess.getSpecializationAxiomAccess().getSpecializedTermSpecializableTermCrossReference_0());
			}
			ruleRef
			{
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRulePropertyRestrictionAxiom
entryRulePropertyRestrictionAxiom returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPropertyRestrictionAxiomRule()); }
	iv_rulePropertyRestrictionAxiom=rulePropertyRestrictionAxiom
	{ $current=$iv_rulePropertyRestrictionAxiom.current; }
	EOF;

// Rule PropertyRestrictionAxiom
rulePropertyRestrictionAxiom returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getPropertyRestrictionAxiomAccess().getScalarPropertyRestrictionAxiomParserRuleCall_0());
		}
		this_ScalarPropertyRestrictionAxiom_0=ruleScalarPropertyRestrictionAxiom
		{
			$current = $this_ScalarPropertyRestrictionAxiom_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPropertyRestrictionAxiomAccess().getStructuredPropertyRestrictionAxiomParserRuleCall_1());
		}
		this_StructuredPropertyRestrictionAxiom_1=ruleStructuredPropertyRestrictionAxiom
		{
			$current = $this_StructuredPropertyRestrictionAxiom_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleScalarPropertyRestrictionAxiom
entryRuleScalarPropertyRestrictionAxiom returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getScalarPropertyRestrictionAxiomRule()); }
	iv_ruleScalarPropertyRestrictionAxiom=ruleScalarPropertyRestrictionAxiom
	{ $current=$iv_ruleScalarPropertyRestrictionAxiom.current; }
	EOF;

// Rule ScalarPropertyRestrictionAxiom
ruleScalarPropertyRestrictionAxiom returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getScalarPropertyRestrictionAxiomAccess().getScalarPropertyRangeRestrictionAxiomParserRuleCall_0());
		}
		this_ScalarPropertyRangeRestrictionAxiom_0=ruleScalarPropertyRangeRestrictionAxiom
		{
			$current = $this_ScalarPropertyRangeRestrictionAxiom_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getScalarPropertyRestrictionAxiomAccess().getScalarPropertyCardinalityRestrictionAxiomParserRuleCall_1());
		}
		this_ScalarPropertyCardinalityRestrictionAxiom_1=ruleScalarPropertyCardinalityRestrictionAxiom
		{
			$current = $this_ScalarPropertyCardinalityRestrictionAxiom_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getScalarPropertyRestrictionAxiomAccess().getScalarPropertyValueRestrictionAxiomParserRuleCall_2());
		}
		this_ScalarPropertyValueRestrictionAxiom_2=ruleScalarPropertyValueRestrictionAxiom
		{
			$current = $this_ScalarPropertyValueRestrictionAxiom_2.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleScalarPropertyRangeRestrictionAxiom
entryRuleScalarPropertyRangeRestrictionAxiom returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getScalarPropertyRangeRestrictionAxiomRule()); }
	iv_ruleScalarPropertyRangeRestrictionAxiom=ruleScalarPropertyRangeRestrictionAxiom
	{ $current=$iv_ruleScalarPropertyRangeRestrictionAxiom.current; }
	EOF;

// Rule ScalarPropertyRangeRestrictionAxiom
ruleScalarPropertyRangeRestrictionAxiom returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='restricts'
		{
			newLeafNode(otherlv_0, grammarAccess.getScalarPropertyRangeRestrictionAxiomAccess().getRestrictsKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getScalarPropertyRangeRestrictionAxiomAccess().getKindRangeRestrictionKindEnumRuleCall_1_0());
				}
				lv_kind_1_0=ruleRangeRestrictionKind
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getScalarPropertyRangeRestrictionAxiomRule());
					}
					set(
						$current,
						"kind",
						lv_kind_1_0,
						"io.opencaesar.oml.dsl.Oml.RangeRestrictionKind");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='scalar'
		{
			newLeafNode(otherlv_2, grammarAccess.getScalarPropertyRangeRestrictionAxiomAccess().getScalarKeyword_2());
		}
		otherlv_3='property'
		{
			newLeafNode(otherlv_3, grammarAccess.getScalarPropertyRangeRestrictionAxiomAccess().getPropertyKeyword_3());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getScalarPropertyRangeRestrictionAxiomRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getScalarPropertyRangeRestrictionAxiomAccess().getPropertyScalarPropertyCrossReference_4_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_5='to'
		{
			newLeafNode(otherlv_5, grammarAccess.getScalarPropertyRangeRestrictionAxiomAccess().getToKeyword_5());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getScalarPropertyRangeRestrictionAxiomRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getScalarPropertyRangeRestrictionAxiomAccess().getRangeScalarCrossReference_6_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleScalarPropertyCardinalityRestrictionAxiom
entryRuleScalarPropertyCardinalityRestrictionAxiom returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getScalarPropertyCardinalityRestrictionAxiomRule()); }
	iv_ruleScalarPropertyCardinalityRestrictionAxiom=ruleScalarPropertyCardinalityRestrictionAxiom
	{ $current=$iv_ruleScalarPropertyCardinalityRestrictionAxiom.current; }
	EOF;

// Rule ScalarPropertyCardinalityRestrictionAxiom
ruleScalarPropertyCardinalityRestrictionAxiom returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='restricts'
		{
			newLeafNode(otherlv_0, grammarAccess.getScalarPropertyCardinalityRestrictionAxiomAccess().getRestrictsKeyword_0());
		}
		otherlv_1='scalar'
		{
			newLeafNode(otherlv_1, grammarAccess.getScalarPropertyCardinalityRestrictionAxiomAccess().getScalarKeyword_1());
		}
		otherlv_2='property'
		{
			newLeafNode(otherlv_2, grammarAccess.getScalarPropertyCardinalityRestrictionAxiomAccess().getPropertyKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getScalarPropertyCardinalityRestrictionAxiomRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getScalarPropertyCardinalityRestrictionAxiomAccess().getPropertyScalarPropertyCrossReference_3_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4='to'
		{
			newLeafNode(otherlv_4, grammarAccess.getScalarPropertyCardinalityRestrictionAxiomAccess().getToKeyword_4());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getScalarPropertyCardinalityRestrictionAxiomAccess().getKindCardinalityRestrictionKindEnumRuleCall_5_0());
				}
				lv_kind_5_0=ruleCardinalityRestrictionKind
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getScalarPropertyCardinalityRestrictionAxiomRule());
					}
					set(
						$current,
						"kind",
						lv_kind_5_0,
						"io.opencaesar.oml.dsl.Oml.CardinalityRestrictionKind");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getScalarPropertyCardinalityRestrictionAxiomAccess().getCardinalityUnsignedIntegerParserRuleCall_6_0());
				}
				lv_cardinality_6_0=ruleUnsignedInteger
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getScalarPropertyCardinalityRestrictionAxiomRule());
					}
					set(
						$current,
						"cardinality",
						lv_cardinality_6_0,
						"io.opencaesar.oml.dsl.Oml.UnsignedInteger");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getScalarPropertyCardinalityRestrictionAxiomRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getScalarPropertyCardinalityRestrictionAxiomAccess().getRangeScalarCrossReference_7_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)?
	)
;

// Entry rule entryRuleScalarPropertyValueRestrictionAxiom
entryRuleScalarPropertyValueRestrictionAxiom returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getScalarPropertyValueRestrictionAxiomRule()); }
	iv_ruleScalarPropertyValueRestrictionAxiom=ruleScalarPropertyValueRestrictionAxiom
	{ $current=$iv_ruleScalarPropertyValueRestrictionAxiom.current; }
	EOF;

// Rule ScalarPropertyValueRestrictionAxiom
ruleScalarPropertyValueRestrictionAxiom returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='restricts'
		{
			newLeafNode(otherlv_0, grammarAccess.getScalarPropertyValueRestrictionAxiomAccess().getRestrictsKeyword_0());
		}
		otherlv_1='scalar'
		{
			newLeafNode(otherlv_1, grammarAccess.getScalarPropertyValueRestrictionAxiomAccess().getScalarKeyword_1());
		}
		otherlv_2='property'
		{
			newLeafNode(otherlv_2, grammarAccess.getScalarPropertyValueRestrictionAxiomAccess().getPropertyKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getScalarPropertyValueRestrictionAxiomRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getScalarPropertyValueRestrictionAxiomAccess().getPropertyScalarPropertyCrossReference_3_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4='to'
		{
			newLeafNode(otherlv_4, grammarAccess.getScalarPropertyValueRestrictionAxiomAccess().getToKeyword_4());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getScalarPropertyValueRestrictionAxiomAccess().getValueLiteralParserRuleCall_5_0());
				}
				lv_value_5_0=ruleLiteral
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getScalarPropertyValueRestrictionAxiomRule());
					}
					set(
						$current,
						"value",
						lv_value_5_0,
						"io.opencaesar.oml.dsl.Oml.Literal");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleStructuredPropertyRestrictionAxiom
entryRuleStructuredPropertyRestrictionAxiom returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStructuredPropertyRestrictionAxiomRule()); }
	iv_ruleStructuredPropertyRestrictionAxiom=ruleStructuredPropertyRestrictionAxiom
	{ $current=$iv_ruleStructuredPropertyRestrictionAxiom.current; }
	EOF;

// Rule StructuredPropertyRestrictionAxiom
ruleStructuredPropertyRestrictionAxiom returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getStructuredPropertyRestrictionAxiomAccess().getStructuredPropertyRangeRestrictionAxiomParserRuleCall_0());
		}
		this_StructuredPropertyRangeRestrictionAxiom_0=ruleStructuredPropertyRangeRestrictionAxiom
		{
			$current = $this_StructuredPropertyRangeRestrictionAxiom_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getStructuredPropertyRestrictionAxiomAccess().getStructuredPropertyCardinalityRestrictionAxiomParserRuleCall_1());
		}
		this_StructuredPropertyCardinalityRestrictionAxiom_1=ruleStructuredPropertyCardinalityRestrictionAxiom
		{
			$current = $this_StructuredPropertyCardinalityRestrictionAxiom_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getStructuredPropertyRestrictionAxiomAccess().getStructuredPropertyValueRestrictionAxiomParserRuleCall_2());
		}
		this_StructuredPropertyValueRestrictionAxiom_2=ruleStructuredPropertyValueRestrictionAxiom
		{
			$current = $this_StructuredPropertyValueRestrictionAxiom_2.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleStructuredPropertyRangeRestrictionAxiom
entryRuleStructuredPropertyRangeRestrictionAxiom returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStructuredPropertyRangeRestrictionAxiomRule()); }
	iv_ruleStructuredPropertyRangeRestrictionAxiom=ruleStructuredPropertyRangeRestrictionAxiom
	{ $current=$iv_ruleStructuredPropertyRangeRestrictionAxiom.current; }
	EOF;

// Rule StructuredPropertyRangeRestrictionAxiom
ruleStructuredPropertyRangeRestrictionAxiom returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='restricts'
		{
			newLeafNode(otherlv_0, grammarAccess.getStructuredPropertyRangeRestrictionAxiomAccess().getRestrictsKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getStructuredPropertyRangeRestrictionAxiomAccess().getKindRangeRestrictionKindEnumRuleCall_1_0());
				}
				lv_kind_1_0=ruleRangeRestrictionKind
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStructuredPropertyRangeRestrictionAxiomRule());
					}
					set(
						$current,
						"kind",
						lv_kind_1_0,
						"io.opencaesar.oml.dsl.Oml.RangeRestrictionKind");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='structured'
		{
			newLeafNode(otherlv_2, grammarAccess.getStructuredPropertyRangeRestrictionAxiomAccess().getStructuredKeyword_2());
		}
		otherlv_3='property'
		{
			newLeafNode(otherlv_3, grammarAccess.getStructuredPropertyRangeRestrictionAxiomAccess().getPropertyKeyword_3());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getStructuredPropertyRangeRestrictionAxiomRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getStructuredPropertyRangeRestrictionAxiomAccess().getPropertyStructuredPropertyCrossReference_4_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_5='to'
		{
			newLeafNode(otherlv_5, grammarAccess.getStructuredPropertyRangeRestrictionAxiomAccess().getToKeyword_5());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getStructuredPropertyRangeRestrictionAxiomRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getStructuredPropertyRangeRestrictionAxiomAccess().getRangeStructureCrossReference_6_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleStructuredPropertyCardinalityRestrictionAxiom
entryRuleStructuredPropertyCardinalityRestrictionAxiom returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStructuredPropertyCardinalityRestrictionAxiomRule()); }
	iv_ruleStructuredPropertyCardinalityRestrictionAxiom=ruleStructuredPropertyCardinalityRestrictionAxiom
	{ $current=$iv_ruleStructuredPropertyCardinalityRestrictionAxiom.current; }
	EOF;

// Rule StructuredPropertyCardinalityRestrictionAxiom
ruleStructuredPropertyCardinalityRestrictionAxiom returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='restricts'
		{
			newLeafNode(otherlv_0, grammarAccess.getStructuredPropertyCardinalityRestrictionAxiomAccess().getRestrictsKeyword_0());
		}
		otherlv_1='structured'
		{
			newLeafNode(otherlv_1, grammarAccess.getStructuredPropertyCardinalityRestrictionAxiomAccess().getStructuredKeyword_1());
		}
		otherlv_2='property'
		{
			newLeafNode(otherlv_2, grammarAccess.getStructuredPropertyCardinalityRestrictionAxiomAccess().getPropertyKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getStructuredPropertyCardinalityRestrictionAxiomRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getStructuredPropertyCardinalityRestrictionAxiomAccess().getPropertyStructuredPropertyCrossReference_3_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4='to'
		{
			newLeafNode(otherlv_4, grammarAccess.getStructuredPropertyCardinalityRestrictionAxiomAccess().getToKeyword_4());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getStructuredPropertyCardinalityRestrictionAxiomAccess().getKindCardinalityRestrictionKindEnumRuleCall_5_0());
				}
				lv_kind_5_0=ruleCardinalityRestrictionKind
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStructuredPropertyCardinalityRestrictionAxiomRule());
					}
					set(
						$current,
						"kind",
						lv_kind_5_0,
						"io.opencaesar.oml.dsl.Oml.CardinalityRestrictionKind");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getStructuredPropertyCardinalityRestrictionAxiomAccess().getCardinalityUnsignedIntegerParserRuleCall_6_0());
				}
				lv_cardinality_6_0=ruleUnsignedInteger
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStructuredPropertyCardinalityRestrictionAxiomRule());
					}
					set(
						$current,
						"cardinality",
						lv_cardinality_6_0,
						"io.opencaesar.oml.dsl.Oml.UnsignedInteger");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getStructuredPropertyCardinalityRestrictionAxiomRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getStructuredPropertyCardinalityRestrictionAxiomAccess().getRangeStructureCrossReference_7_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)?
	)
;

// Entry rule entryRuleStructuredPropertyValueRestrictionAxiom
entryRuleStructuredPropertyValueRestrictionAxiom returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStructuredPropertyValueRestrictionAxiomRule()); }
	iv_ruleStructuredPropertyValueRestrictionAxiom=ruleStructuredPropertyValueRestrictionAxiom
	{ $current=$iv_ruleStructuredPropertyValueRestrictionAxiom.current; }
	EOF;

// Rule StructuredPropertyValueRestrictionAxiom
ruleStructuredPropertyValueRestrictionAxiom returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='restricts'
		{
			newLeafNode(otherlv_0, grammarAccess.getStructuredPropertyValueRestrictionAxiomAccess().getRestrictsKeyword_0());
		}
		otherlv_1='structured'
		{
			newLeafNode(otherlv_1, grammarAccess.getStructuredPropertyValueRestrictionAxiomAccess().getStructuredKeyword_1());
		}
		otherlv_2='property'
		{
			newLeafNode(otherlv_2, grammarAccess.getStructuredPropertyValueRestrictionAxiomAccess().getPropertyKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getStructuredPropertyValueRestrictionAxiomRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getStructuredPropertyValueRestrictionAxiomAccess().getPropertyStructuredPropertyCrossReference_3_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4='to'
		{
			newLeafNode(otherlv_4, grammarAccess.getStructuredPropertyValueRestrictionAxiomAccess().getToKeyword_4());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getStructuredPropertyValueRestrictionAxiomAccess().getValueStructureInstanceParserRuleCall_5_0());
				}
				lv_value_5_0=ruleStructureInstance
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStructuredPropertyValueRestrictionAxiomRule());
					}
					set(
						$current,
						"value",
						lv_value_5_0,
						"io.opencaesar.oml.dsl.Oml.StructureInstance");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleRelationRestrictionAxiom
entryRuleRelationRestrictionAxiom returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRelationRestrictionAxiomRule()); }
	iv_ruleRelationRestrictionAxiom=ruleRelationRestrictionAxiom
	{ $current=$iv_ruleRelationRestrictionAxiom.current; }
	EOF;

// Rule RelationRestrictionAxiom
ruleRelationRestrictionAxiom returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getRelationRestrictionAxiomAccess().getRelationRangeRestrictionAxiomParserRuleCall_0());
		}
		this_RelationRangeRestrictionAxiom_0=ruleRelationRangeRestrictionAxiom
		{
			$current = $this_RelationRangeRestrictionAxiom_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getRelationRestrictionAxiomAccess().getRelationCardinalityRestrictionAxiomParserRuleCall_1());
		}
		this_RelationCardinalityRestrictionAxiom_1=ruleRelationCardinalityRestrictionAxiom
		{
			$current = $this_RelationCardinalityRestrictionAxiom_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getRelationRestrictionAxiomAccess().getRelationTargetRestrictionAxiomParserRuleCall_2());
		}
		this_RelationTargetRestrictionAxiom_2=ruleRelationTargetRestrictionAxiom
		{
			$current = $this_RelationTargetRestrictionAxiom_2.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleRelationRangeRestrictionAxiom
entryRuleRelationRangeRestrictionAxiom returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRelationRangeRestrictionAxiomRule()); }
	iv_ruleRelationRangeRestrictionAxiom=ruleRelationRangeRestrictionAxiom
	{ $current=$iv_ruleRelationRangeRestrictionAxiom.current; }
	EOF;

// Rule RelationRangeRestrictionAxiom
ruleRelationRangeRestrictionAxiom returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='restricts'
		{
			newLeafNode(otherlv_0, grammarAccess.getRelationRangeRestrictionAxiomAccess().getRestrictsKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRelationRangeRestrictionAxiomAccess().getKindRangeRestrictionKindEnumRuleCall_1_0());
				}
				lv_kind_1_0=ruleRangeRestrictionKind
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRelationRangeRestrictionAxiomRule());
					}
					set(
						$current,
						"kind",
						lv_kind_1_0,
						"io.opencaesar.oml.dsl.Oml.RangeRestrictionKind");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='relation'
		{
			newLeafNode(otherlv_2, grammarAccess.getRelationRangeRestrictionAxiomAccess().getRelationKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRelationRangeRestrictionAxiomRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getRelationRangeRestrictionAxiomAccess().getRelationRelationCrossReference_3_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4='to'
		{
			newLeafNode(otherlv_4, grammarAccess.getRelationRangeRestrictionAxiomAccess().getToKeyword_4());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRelationRangeRestrictionAxiomRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getRelationRangeRestrictionAxiomAccess().getRangeEntityCrossReference_5_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleRelationCardinalityRestrictionAxiom
entryRuleRelationCardinalityRestrictionAxiom returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRelationCardinalityRestrictionAxiomRule()); }
	iv_ruleRelationCardinalityRestrictionAxiom=ruleRelationCardinalityRestrictionAxiom
	{ $current=$iv_ruleRelationCardinalityRestrictionAxiom.current; }
	EOF;

// Rule RelationCardinalityRestrictionAxiom
ruleRelationCardinalityRestrictionAxiom returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='restricts'
		{
			newLeafNode(otherlv_0, grammarAccess.getRelationCardinalityRestrictionAxiomAccess().getRestrictsKeyword_0());
		}
		otherlv_1='relation'
		{
			newLeafNode(otherlv_1, grammarAccess.getRelationCardinalityRestrictionAxiomAccess().getRelationKeyword_1());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRelationCardinalityRestrictionAxiomRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getRelationCardinalityRestrictionAxiomAccess().getRelationRelationCrossReference_2_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_3='to'
		{
			newLeafNode(otherlv_3, grammarAccess.getRelationCardinalityRestrictionAxiomAccess().getToKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRelationCardinalityRestrictionAxiomAccess().getKindCardinalityRestrictionKindEnumRuleCall_4_0());
				}
				lv_kind_4_0=ruleCardinalityRestrictionKind
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRelationCardinalityRestrictionAxiomRule());
					}
					set(
						$current,
						"kind",
						lv_kind_4_0,
						"io.opencaesar.oml.dsl.Oml.CardinalityRestrictionKind");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getRelationCardinalityRestrictionAxiomAccess().getCardinalityUnsignedIntegerParserRuleCall_5_0());
				}
				lv_cardinality_5_0=ruleUnsignedInteger
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRelationCardinalityRestrictionAxiomRule());
					}
					set(
						$current,
						"cardinality",
						lv_cardinality_5_0,
						"io.opencaesar.oml.dsl.Oml.UnsignedInteger");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRelationCardinalityRestrictionAxiomRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getRelationCardinalityRestrictionAxiomAccess().getRangeEntityCrossReference_6_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)?
	)
;

// Entry rule entryRuleRelationTargetRestrictionAxiom
entryRuleRelationTargetRestrictionAxiom returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRelationTargetRestrictionAxiomRule()); }
	iv_ruleRelationTargetRestrictionAxiom=ruleRelationTargetRestrictionAxiom
	{ $current=$iv_ruleRelationTargetRestrictionAxiom.current; }
	EOF;

// Rule RelationTargetRestrictionAxiom
ruleRelationTargetRestrictionAxiom returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='restricts'
		{
			newLeafNode(otherlv_0, grammarAccess.getRelationTargetRestrictionAxiomAccess().getRestrictsKeyword_0());
		}
		otherlv_1='relation'
		{
			newLeafNode(otherlv_1, grammarAccess.getRelationTargetRestrictionAxiomAccess().getRelationKeyword_1());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRelationTargetRestrictionAxiomRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getRelationTargetRestrictionAxiomAccess().getRelationRelationCrossReference_2_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_3='to'
		{
			newLeafNode(otherlv_3, grammarAccess.getRelationTargetRestrictionAxiomAccess().getToKeyword_3());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRelationTargetRestrictionAxiomRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getRelationTargetRestrictionAxiomAccess().getTargetNamedInstanceCrossReference_4_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleKeyAxiom
entryRuleKeyAxiom returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getKeyAxiomRule()); }
	iv_ruleKeyAxiom=ruleKeyAxiom
	{ $current=$iv_ruleKeyAxiom.current; }
	EOF;

// Rule KeyAxiom
ruleKeyAxiom returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='key'
		{
			newLeafNode(otherlv_0, grammarAccess.getKeyAxiomAccess().getKeyKeyword_0());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getKeyAxiomRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getKeyAxiomAccess().getPropertiesFeatureCrossReference_1_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_2=','
			{
				newLeafNode(otherlv_2, grammarAccess.getKeyAxiomAccess().getCommaKeyword_2_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getKeyAxiomRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getKeyAxiomAccess().getPropertiesFeatureCrossReference_2_1_0());
					}
					ruleRef
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
	)
;

// Entry rule entryRuleConceptTypeAssertion
entryRuleConceptTypeAssertion returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getConceptTypeAssertionRule()); }
	iv_ruleConceptTypeAssertion=ruleConceptTypeAssertion
	{ $current=$iv_ruleConceptTypeAssertion.current; }
	EOF;

// Rule ConceptTypeAssertion
ruleConceptTypeAssertion returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				if ($current==null) {
					$current = createModelElement(grammarAccess.getConceptTypeAssertionRule());
				}
			}
			{
				newCompositeNode(grammarAccess.getConceptTypeAssertionAccess().getTypeConceptCrossReference_0());
			}
			ruleRef
			{
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRuleRelationTypeAssertion
entryRuleRelationTypeAssertion returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRelationTypeAssertionRule()); }
	iv_ruleRelationTypeAssertion=ruleRelationTypeAssertion
	{ $current=$iv_ruleRelationTypeAssertion.current; }
	EOF;

// Rule RelationTypeAssertion
ruleRelationTypeAssertion returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				if ($current==null) {
					$current = createModelElement(grammarAccess.getRelationTypeAssertionRule());
				}
			}
			{
				newCompositeNode(grammarAccess.getRelationTypeAssertionAccess().getTypeRelationEntityCrossReference_0());
			}
			ruleRef
			{
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRulePropertyValueAssertion
entryRulePropertyValueAssertion returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPropertyValueAssertionRule()); }
	iv_rulePropertyValueAssertion=rulePropertyValueAssertion
	{ $current=$iv_rulePropertyValueAssertion.current; }
	EOF;

// Rule PropertyValueAssertion
rulePropertyValueAssertion returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getPropertyValueAssertionAccess().getScalarPropertyValueAssertionParserRuleCall_0());
		}
		this_ScalarPropertyValueAssertion_0=ruleScalarPropertyValueAssertion
		{
			$current = $this_ScalarPropertyValueAssertion_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPropertyValueAssertionAccess().getStructuredPropertyValueAssertionParserRuleCall_1());
		}
		this_StructuredPropertyValueAssertion_1=ruleStructuredPropertyValueAssertion
		{
			$current = $this_StructuredPropertyValueAssertion_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleScalarPropertyValueAssertion
entryRuleScalarPropertyValueAssertion returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getScalarPropertyValueAssertionRule()); }
	iv_ruleScalarPropertyValueAssertion=ruleScalarPropertyValueAssertion
	{ $current=$iv_ruleScalarPropertyValueAssertion.current; }
	EOF;

// Rule ScalarPropertyValueAssertion
ruleScalarPropertyValueAssertion returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getScalarPropertyValueAssertionRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getScalarPropertyValueAssertionAccess().getPropertyScalarPropertyCrossReference_0_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getScalarPropertyValueAssertionAccess().getValueLiteralParserRuleCall_1_0());
				}
				lv_value_1_0=ruleLiteral
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getScalarPropertyValueAssertionRule());
					}
					set(
						$current,
						"value",
						lv_value_1_0,
						"io.opencaesar.oml.dsl.Oml.Literal");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleStructuredPropertyValueAssertion
entryRuleStructuredPropertyValueAssertion returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStructuredPropertyValueAssertionRule()); }
	iv_ruleStructuredPropertyValueAssertion=ruleStructuredPropertyValueAssertion
	{ $current=$iv_ruleStructuredPropertyValueAssertion.current; }
	EOF;

// Rule StructuredPropertyValueAssertion
ruleStructuredPropertyValueAssertion returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getStructuredPropertyValueAssertionRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getStructuredPropertyValueAssertionAccess().getPropertyStructuredPropertyCrossReference_0_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getStructuredPropertyValueAssertionAccess().getValueStructureInstanceParserRuleCall_1_0());
				}
				lv_value_1_0=ruleStructureInstance
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStructuredPropertyValueAssertionRule());
					}
					set(
						$current,
						"value",
						lv_value_1_0,
						"io.opencaesar.oml.dsl.Oml.StructureInstance");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleLinkAssertion
entryRuleLinkAssertion returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLinkAssertionRule()); }
	iv_ruleLinkAssertion=ruleLinkAssertion
	{ $current=$iv_ruleLinkAssertion.current; }
	EOF;

// Rule LinkAssertion
ruleLinkAssertion returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getLinkAssertionRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getLinkAssertionAccess().getRelationRelationCrossReference_0_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getLinkAssertionRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getLinkAssertionAccess().getTargetNamedInstanceCrossReference_1_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRulePredicate
entryRulePredicate returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPredicateRule()); }
	iv_rulePredicate=rulePredicate
	{ $current=$iv_rulePredicate.current; }
	EOF;

// Rule Predicate
rulePredicate returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getPredicateAccess().getUnaryPredicateParserRuleCall_0());
		}
		this_UnaryPredicate_0=ruleUnaryPredicate
		{
			$current = $this_UnaryPredicate_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPredicateAccess().getBinaryPredicateParserRuleCall_1());
		}
		this_BinaryPredicate_1=ruleBinaryPredicate
		{
			$current = $this_BinaryPredicate_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleUnaryPredicate
entryRuleUnaryPredicate returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getUnaryPredicateRule()); }
	iv_ruleUnaryPredicate=ruleUnaryPredicate
	{ $current=$iv_ruleUnaryPredicate.current; }
	EOF;

// Rule UnaryPredicate
ruleUnaryPredicate returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	{
		newCompositeNode(grammarAccess.getUnaryPredicateAccess().getTypePredicateParserRuleCall());
	}
	this_TypePredicate_0=ruleTypePredicate
	{
		$current = $this_TypePredicate_0.current;
		afterParserOrEnumRuleCall();
	}
;

// Entry rule entryRuleTypePredicate
entryRuleTypePredicate returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTypePredicateRule()); }
	iv_ruleTypePredicate=ruleTypePredicate
	{ $current=$iv_ruleTypePredicate.current; }
	EOF;

// Rule TypePredicate
ruleTypePredicate returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getTypePredicateRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getTypePredicateAccess().getTypeTypeCrossReference_0_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			('(')=>
			otherlv_1='('
			{
				newLeafNode(otherlv_1, grammarAccess.getTypePredicateAccess().getLeftParenthesisKeyword_1());
			}
		)
		(
			(
				lv_variable_2_0=RULE_ID
				{
					newLeafNode(lv_variable_2_0, grammarAccess.getTypePredicateAccess().getVariableIDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getTypePredicateRule());
					}
					setWithLastConsumed(
						$current,
						"variable",
						lv_variable_2_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		otherlv_3=')'
		{
			newLeafNode(otherlv_3, grammarAccess.getTypePredicateAccess().getRightParenthesisKeyword_3());
		}
	)
;

// Entry rule entryRuleBinaryPredicate
entryRuleBinaryPredicate returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBinaryPredicateRule()); }
	iv_ruleBinaryPredicate=ruleBinaryPredicate
	{ $current=$iv_ruleBinaryPredicate.current; }
	EOF;

// Rule BinaryPredicate
ruleBinaryPredicate returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getBinaryPredicateAccess().getRelationEntityPredicateParserRuleCall_0());
		}
		this_RelationEntityPredicate_0=ruleRelationEntityPredicate
		{
			$current = $this_RelationEntityPredicate_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getBinaryPredicateAccess().getFeaturePredicateParserRuleCall_1());
		}
		this_FeaturePredicate_1=ruleFeaturePredicate
		{
			$current = $this_FeaturePredicate_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getBinaryPredicateAccess().getSameAsPredicateParserRuleCall_2());
		}
		this_SameAsPredicate_2=ruleSameAsPredicate
		{
			$current = $this_SameAsPredicate_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getBinaryPredicateAccess().getDifferentFromPredicateParserRuleCall_3());
		}
		this_DifferentFromPredicate_3=ruleDifferentFromPredicate
		{
			$current = $this_DifferentFromPredicate_3.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleRelationEntityPredicate
entryRuleRelationEntityPredicate returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRelationEntityPredicateRule()); }
	iv_ruleRelationEntityPredicate=ruleRelationEntityPredicate
	{ $current=$iv_ruleRelationEntityPredicate.current; }
	EOF;

// Rule RelationEntityPredicate
ruleRelationEntityPredicate returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRelationEntityPredicateRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getRelationEntityPredicateAccess().getEntityRelationEntityCrossReference_0_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getRelationEntityPredicateAccess().getLeftParenthesisKeyword_1());
		}
		(
			(
				lv_variable1_2_0=RULE_ID
				{
					newLeafNode(lv_variable1_2_0, grammarAccess.getRelationEntityPredicateAccess().getVariable1IDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRelationEntityPredicateRule());
					}
					setWithLastConsumed(
						$current,
						"variable1",
						lv_variable1_2_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		otherlv_3=','
		{
			newLeafNode(otherlv_3, grammarAccess.getRelationEntityPredicateAccess().getCommaKeyword_3());
		}
		(
			(
				lv_entityVariable_4_0=RULE_ID
				{
					newLeafNode(lv_entityVariable_4_0, grammarAccess.getRelationEntityPredicateAccess().getEntityVariableIDTerminalRuleCall_4_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRelationEntityPredicateRule());
					}
					setWithLastConsumed(
						$current,
						"entityVariable",
						lv_entityVariable_4_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		otherlv_5=','
		{
			newLeafNode(otherlv_5, grammarAccess.getRelationEntityPredicateAccess().getCommaKeyword_5());
		}
		(
			(
				(
					lv_variable2_6_0=RULE_ID
					{
						newLeafNode(lv_variable2_6_0, grammarAccess.getRelationEntityPredicateAccess().getVariable2IDTerminalRuleCall_6_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getRelationEntityPredicateRule());
						}
						setWithLastConsumed(
							$current,
							"variable2",
							lv_variable2_6_0,
							"io.opencaesar.oml.dsl.Oml.ID");
					}
				)
			)
			    |
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getRelationEntityPredicateRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getRelationEntityPredicateAccess().getInstance2NamedInstanceCrossReference_6_1_0());
					}
					ruleCrossRef
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		otherlv_8=')'
		{
			newLeafNode(otherlv_8, grammarAccess.getRelationEntityPredicateAccess().getRightParenthesisKeyword_7());
		}
	)
;

// Entry rule entryRuleFeaturePredicate
entryRuleFeaturePredicate returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getFeaturePredicateRule()); }
	iv_ruleFeaturePredicate=ruleFeaturePredicate
	{ $current=$iv_ruleFeaturePredicate.current; }
	EOF;

// Rule FeaturePredicate
ruleFeaturePredicate returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getFeaturePredicateRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getFeaturePredicateAccess().getFeatureFeatureCrossReference_0_0());
				}
				ruleRef
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getFeaturePredicateAccess().getLeftParenthesisKeyword_1());
		}
		(
			(
				lv_variable1_2_0=RULE_ID
				{
					newLeafNode(lv_variable1_2_0, grammarAccess.getFeaturePredicateAccess().getVariable1IDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getFeaturePredicateRule());
					}
					setWithLastConsumed(
						$current,
						"variable1",
						lv_variable1_2_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		otherlv_3=','
		{
			newLeafNode(otherlv_3, grammarAccess.getFeaturePredicateAccess().getCommaKeyword_3());
		}
		(
			(
				(
					lv_variable2_4_0=RULE_ID
					{
						newLeafNode(lv_variable2_4_0, grammarAccess.getFeaturePredicateAccess().getVariable2IDTerminalRuleCall_4_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getFeaturePredicateRule());
						}
						setWithLastConsumed(
							$current,
							"variable2",
							lv_variable2_4_0,
							"io.opencaesar.oml.dsl.Oml.ID");
					}
				)
			)
			    |
			(
				(
					{
						newCompositeNode(grammarAccess.getFeaturePredicateAccess().getLiteral2LiteralParserRuleCall_4_1_0());
					}
					lv_literal2_5_0=ruleLiteral
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFeaturePredicateRule());
						}
						set(
							$current,
							"literal2",
							lv_literal2_5_0,
							"io.opencaesar.oml.dsl.Oml.Literal");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getFeaturePredicateRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getFeaturePredicateAccess().getInstance2NamedInstanceCrossReference_4_2_0());
					}
					ruleCrossRef
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		otherlv_7=')'
		{
			newLeafNode(otherlv_7, grammarAccess.getFeaturePredicateAccess().getRightParenthesisKeyword_5());
		}
	)
;

// Entry rule entryRuleSameAsPredicate
entryRuleSameAsPredicate returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSameAsPredicateRule()); }
	iv_ruleSameAsPredicate=ruleSameAsPredicate
	{ $current=$iv_ruleSameAsPredicate.current; }
	EOF;

// Rule SameAsPredicate
ruleSameAsPredicate returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='sameAs'
		{
			newLeafNode(otherlv_0, grammarAccess.getSameAsPredicateAccess().getSameAsKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getSameAsPredicateAccess().getLeftParenthesisKeyword_1());
		}
		(
			(
				lv_variable1_2_0=RULE_ID
				{
					newLeafNode(lv_variable1_2_0, grammarAccess.getSameAsPredicateAccess().getVariable1IDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getSameAsPredicateRule());
					}
					setWithLastConsumed(
						$current,
						"variable1",
						lv_variable1_2_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		otherlv_3=','
		{
			newLeafNode(otherlv_3, grammarAccess.getSameAsPredicateAccess().getCommaKeyword_3());
		}
		(
			(
				(
					lv_variable2_4_0=RULE_ID
					{
						newLeafNode(lv_variable2_4_0, grammarAccess.getSameAsPredicateAccess().getVariable2IDTerminalRuleCall_4_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getSameAsPredicateRule());
						}
						setWithLastConsumed(
							$current,
							"variable2",
							lv_variable2_4_0,
							"io.opencaesar.oml.dsl.Oml.ID");
					}
				)
			)
			    |
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getSameAsPredicateRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getSameAsPredicateAccess().getInstance2NamedInstanceCrossReference_4_1_0());
					}
					ruleCrossRef
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		otherlv_6=')'
		{
			newLeafNode(otherlv_6, grammarAccess.getSameAsPredicateAccess().getRightParenthesisKeyword_5());
		}
	)
;

// Entry rule entryRuleDifferentFromPredicate
entryRuleDifferentFromPredicate returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDifferentFromPredicateRule()); }
	iv_ruleDifferentFromPredicate=ruleDifferentFromPredicate
	{ $current=$iv_ruleDifferentFromPredicate.current; }
	EOF;

// Rule DifferentFromPredicate
ruleDifferentFromPredicate returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='differentFrom'
		{
			newLeafNode(otherlv_0, grammarAccess.getDifferentFromPredicateAccess().getDifferentFromKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getDifferentFromPredicateAccess().getLeftParenthesisKeyword_1());
		}
		(
			(
				lv_variable1_2_0=RULE_ID
				{
					newLeafNode(lv_variable1_2_0, grammarAccess.getDifferentFromPredicateAccess().getVariable1IDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDifferentFromPredicateRule());
					}
					setWithLastConsumed(
						$current,
						"variable1",
						lv_variable1_2_0,
						"io.opencaesar.oml.dsl.Oml.ID");
				}
			)
		)
		otherlv_3=','
		{
			newLeafNode(otherlv_3, grammarAccess.getDifferentFromPredicateAccess().getCommaKeyword_3());
		}
		(
			(
				(
					lv_variable2_4_0=RULE_ID
					{
						newLeafNode(lv_variable2_4_0, grammarAccess.getDifferentFromPredicateAccess().getVariable2IDTerminalRuleCall_4_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getDifferentFromPredicateRule());
						}
						setWithLastConsumed(
							$current,
							"variable2",
							lv_variable2_4_0,
							"io.opencaesar.oml.dsl.Oml.ID");
					}
				)
			)
			    |
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getDifferentFromPredicateRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getDifferentFromPredicateAccess().getInstance2NamedInstanceCrossReference_4_1_0());
					}
					ruleCrossRef
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		otherlv_6=')'
		{
			newLeafNode(otherlv_6, grammarAccess.getDifferentFromPredicateAccess().getRightParenthesisKeyword_5());
		}
	)
;

// Entry rule entryRuleLiteral
entryRuleLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLiteralRule()); }
	iv_ruleLiteral=ruleLiteral
	{ $current=$iv_ruleLiteral.current; }
	EOF;

// Rule Literal
ruleLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getIntegerLiteralParserRuleCall_0());
		}
		this_IntegerLiteral_0=ruleIntegerLiteral
		{
			$current = $this_IntegerLiteral_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getDecimalLiteralParserRuleCall_1());
		}
		this_DecimalLiteral_1=ruleDecimalLiteral
		{
			$current = $this_DecimalLiteral_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getDoubleLiteralParserRuleCall_2());
		}
		this_DoubleLiteral_2=ruleDoubleLiteral
		{
			$current = $this_DoubleLiteral_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getBooleanLiteralParserRuleCall_3());
		}
		this_BooleanLiteral_3=ruleBooleanLiteral
		{
			$current = $this_BooleanLiteral_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getQuotedLiteralParserRuleCall_4());
		}
		this_QuotedLiteral_4=ruleQuotedLiteral
		{
			$current = $this_QuotedLiteral_4.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleIntegerLiteral
entryRuleIntegerLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getIntegerLiteralRule()); }
	iv_ruleIntegerLiteral=ruleIntegerLiteral
	{ $current=$iv_ruleIntegerLiteral.current; }
	EOF;

// Rule IntegerLiteral
ruleIntegerLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				newCompositeNode(grammarAccess.getIntegerLiteralAccess().getValueIntegerParserRuleCall_0());
			}
			lv_value_0_0=ruleInteger
			{
				if ($current==null) {
					$current = createModelElementForParent(grammarAccess.getIntegerLiteralRule());
				}
				set(
					$current,
					"value",
					lv_value_0_0,
					"io.opencaesar.oml.dsl.Oml.Integer");
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRuleDecimalLiteral
entryRuleDecimalLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDecimalLiteralRule()); }
	iv_ruleDecimalLiteral=ruleDecimalLiteral
	{ $current=$iv_ruleDecimalLiteral.current; }
	EOF;

// Rule DecimalLiteral
ruleDecimalLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				newCompositeNode(grammarAccess.getDecimalLiteralAccess().getValueDecimalParserRuleCall_0());
			}
			lv_value_0_0=ruleDecimal
			{
				if ($current==null) {
					$current = createModelElementForParent(grammarAccess.getDecimalLiteralRule());
				}
				set(
					$current,
					"value",
					lv_value_0_0,
					"io.opencaesar.oml.dsl.Oml.Decimal");
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRuleDoubleLiteral
entryRuleDoubleLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDoubleLiteralRule()); }
	iv_ruleDoubleLiteral=ruleDoubleLiteral
	{ $current=$iv_ruleDoubleLiteral.current; }
	EOF;

// Rule DoubleLiteral
ruleDoubleLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				newCompositeNode(grammarAccess.getDoubleLiteralAccess().getValueDoubleParserRuleCall_0());
			}
			lv_value_0_0=ruleDouble
			{
				if ($current==null) {
					$current = createModelElementForParent(grammarAccess.getDoubleLiteralRule());
				}
				set(
					$current,
					"value",
					lv_value_0_0,
					"io.opencaesar.oml.dsl.Oml.Double");
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRuleBooleanLiteral
entryRuleBooleanLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBooleanLiteralRule()); }
	iv_ruleBooleanLiteral=ruleBooleanLiteral
	{ $current=$iv_ruleBooleanLiteral.current; }
	EOF;

// Rule BooleanLiteral
ruleBooleanLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				newCompositeNode(grammarAccess.getBooleanLiteralAccess().getValueBooleanParserRuleCall_0());
			}
			lv_value_0_0=ruleBoolean
			{
				if ($current==null) {
					$current = createModelElementForParent(grammarAccess.getBooleanLiteralRule());
				}
				set(
					$current,
					"value",
					lv_value_0_0,
					"io.opencaesar.oml.dsl.Oml.Boolean");
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRuleQuotedLiteral
entryRuleQuotedLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getQuotedLiteralRule()); }
	iv_ruleQuotedLiteral=ruleQuotedLiteral
	{ $current=$iv_ruleQuotedLiteral.current; }
	EOF;

// Rule QuotedLiteral
ruleQuotedLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_value_0_0=RULE_STRING
				{
					newLeafNode(lv_value_0_0, grammarAccess.getQuotedLiteralAccess().getValueSTRINGTerminalRuleCall_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getQuotedLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_0_0,
						"io.opencaesar.oml.dsl.Oml.STRING");
				}
			)
		)
		(
			(
				otherlv_1='^^'
				{
					newLeafNode(otherlv_1, grammarAccess.getQuotedLiteralAccess().getCircumflexAccentCircumflexAccentKeyword_1_0_0());
				}
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getQuotedLiteralRule());
							}
						}
						{
							newCompositeNode(grammarAccess.getQuotedLiteralAccess().getTypeScalarCrossReference_1_0_1_0());
						}
						ruleRef
						{
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
			    |
			(
				otherlv_3='$'
				{
					newLeafNode(otherlv_3, grammarAccess.getQuotedLiteralAccess().getDollarSignKeyword_1_1_0());
				}
				(
					(
						lv_langTag_4_0=RULE_ID
						{
							newLeafNode(lv_langTag_4_0, grammarAccess.getQuotedLiteralAccess().getLangTagIDTerminalRuleCall_1_1_1_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getQuotedLiteralRule());
							}
							setWithLastConsumed(
								$current,
								"langTag",
								lv_langTag_4_0,
								"io.opencaesar.oml.dsl.Oml.ID");
						}
					)
				)
			)
		)?
	)
;

// Entry rule entryRuleRef
entryRuleRef returns [String current=null]:
	{ newCompositeNode(grammarAccess.getRefRule()); }
	iv_ruleRef=ruleRef
	{ $current=$iv_ruleRef.current.getText(); }
	EOF;

// Rule Ref
ruleRef returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_ID_0=RULE_ID
		{
			$current.merge(this_ID_0);
		}
		{
			newLeafNode(this_ID_0, grammarAccess.getRefAccess().getIDTerminalRuleCall_0());
		}
		    |
		this_QNAME_1=RULE_QNAME
		{
			$current.merge(this_QNAME_1);
		}
		{
			newLeafNode(this_QNAME_1, grammarAccess.getRefAccess().getQNAMETerminalRuleCall_1());
		}
		    |
		this_IRI_2=RULE_IRI
		{
			$current.merge(this_IRI_2);
		}
		{
			newLeafNode(this_IRI_2, grammarAccess.getRefAccess().getIRITerminalRuleCall_2());
		}
	)
;

// Entry rule entryRuleCrossRef
entryRuleCrossRef returns [String current=null]:
	{ newCompositeNode(grammarAccess.getCrossRefRule()); }
	iv_ruleCrossRef=ruleCrossRef
	{ $current=$iv_ruleCrossRef.current.getText(); }
	EOF;

// Rule CrossRef
ruleCrossRef returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_QNAME_0=RULE_QNAME
		{
			$current.merge(this_QNAME_0);
		}
		{
			newLeafNode(this_QNAME_0, grammarAccess.getCrossRefAccess().getQNAMETerminalRuleCall_0());
		}
		    |
		this_IRI_1=RULE_IRI
		{
			$current.merge(this_IRI_1);
		}
		{
			newLeafNode(this_IRI_1, grammarAccess.getCrossRefAccess().getIRITerminalRuleCall_1());
		}
	)
;

// Entry rule entryRuleBoolean
entryRuleBoolean returns [String current=null]:
	{ newCompositeNode(grammarAccess.getBooleanRule()); }
	iv_ruleBoolean=ruleBoolean
	{ $current=$iv_ruleBoolean.current.getText(); }
	EOF;

// Rule Boolean
ruleBoolean returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	this_BOOLEAN_STR_0=RULE_BOOLEAN_STR
	{
		$current.merge(this_BOOLEAN_STR_0);
	}
	{
		newLeafNode(this_BOOLEAN_STR_0, grammarAccess.getBooleanAccess().getBOOLEAN_STRTerminalRuleCall());
	}
;

// Entry rule entryRuleUnsignedInteger
entryRuleUnsignedInteger returns [String current=null]:
	{ newCompositeNode(grammarAccess.getUnsignedIntegerRule()); }
	iv_ruleUnsignedInteger=ruleUnsignedInteger
	{ $current=$iv_ruleUnsignedInteger.current.getText(); }
	EOF;

// Rule UnsignedInteger
ruleUnsignedInteger returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	this_UNSIGNED_INTEGER_STR_0=RULE_UNSIGNED_INTEGER_STR
	{
		$current.merge(this_UNSIGNED_INTEGER_STR_0);
	}
	{
		newLeafNode(this_UNSIGNED_INTEGER_STR_0, grammarAccess.getUnsignedIntegerAccess().getUNSIGNED_INTEGER_STRTerminalRuleCall());
	}
;

// Entry rule entryRuleInteger
entryRuleInteger returns [String current=null]:
	{ newCompositeNode(grammarAccess.getIntegerRule()); }
	iv_ruleInteger=ruleInteger
	{ $current=$iv_ruleInteger.current.getText(); }
	EOF;

// Rule Integer
ruleInteger returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_UNSIGNED_INTEGER_STR_0=RULE_UNSIGNED_INTEGER_STR
		{
			$current.merge(this_UNSIGNED_INTEGER_STR_0);
		}
		{
			newLeafNode(this_UNSIGNED_INTEGER_STR_0, grammarAccess.getIntegerAccess().getUNSIGNED_INTEGER_STRTerminalRuleCall_0());
		}
		    |
		this_INTEGER_STR_1=RULE_INTEGER_STR
		{
			$current.merge(this_INTEGER_STR_1);
		}
		{
			newLeafNode(this_INTEGER_STR_1, grammarAccess.getIntegerAccess().getINTEGER_STRTerminalRuleCall_1());
		}
	)
;

// Entry rule entryRuleDecimal
entryRuleDecimal returns [String current=null]:
	{ newCompositeNode(grammarAccess.getDecimalRule()); }
	iv_ruleDecimal=ruleDecimal
	{ $current=$iv_ruleDecimal.current.getText(); }
	EOF;

// Rule Decimal
ruleDecimal returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	this_DECIMAL_STR_0=RULE_DECIMAL_STR
	{
		$current.merge(this_DECIMAL_STR_0);
	}
	{
		newLeafNode(this_DECIMAL_STR_0, grammarAccess.getDecimalAccess().getDECIMAL_STRTerminalRuleCall());
	}
;

// Entry rule entryRuleDouble
entryRuleDouble returns [String current=null]:
	{ newCompositeNode(grammarAccess.getDoubleRule()); }
	iv_ruleDouble=ruleDouble
	{ $current=$iv_ruleDouble.current.getText(); }
	EOF;

// Rule Double
ruleDouble returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	this_DOUBLE_STR_0=RULE_DOUBLE_STR
	{
		$current.merge(this_DOUBLE_STR_0);
	}
	{
		newLeafNode(this_DOUBLE_STR_0, grammarAccess.getDoubleAccess().getDOUBLE_STRTerminalRuleCall());
	}
;

// Rule RangeRestrictionKind
ruleRangeRestrictionKind returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='all'
			{
				$current = grammarAccess.getRangeRestrictionKindAccess().getAllEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getRangeRestrictionKindAccess().getAllEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='some'
			{
				$current = grammarAccess.getRangeRestrictionKindAccess().getSomeEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getRangeRestrictionKindAccess().getSomeEnumLiteralDeclaration_1());
			}
		)
	)
;

// Rule CardinalityRestrictionKind
ruleCardinalityRestrictionKind returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='exactly'
			{
				$current = grammarAccess.getCardinalityRestrictionKindAccess().getExactlyEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getCardinalityRestrictionKindAccess().getExactlyEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='min'
			{
				$current = grammarAccess.getCardinalityRestrictionKindAccess().getMinEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getCardinalityRestrictionKindAccess().getMinEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='max'
			{
				$current = grammarAccess.getCardinalityRestrictionKindAccess().getMaxEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getCardinalityRestrictionKindAccess().getMaxEnumLiteralDeclaration_2());
			}
		)
	)
;

RULE_BOOLEAN_STR : ('false'|'true');

RULE_UNSIGNED_INTEGER_STR : RULE_DIGIT+;

RULE_INTEGER_STR : ('+'|'-')? RULE_DIGIT+;

RULE_DECIMAL_STR : ('+'|'-')? (RULE_DIGIT+ ('.' RULE_DIGIT*)?|'.' RULE_DIGIT+);

RULE_DOUBLE_STR : ('+'|'-')? (RULE_DIGIT+ ('.' RULE_DIGIT*)?|'.' RULE_DIGIT+) (('e'|'E') ('+'|'-')? RULE_DIGIT+)?;

RULE_STRING : ('"' (~(('"'|'\\'))|'\\' .)* '"'|'\'' (~(('\''|'\\'))|'\\' .)* '\''|'\'\'\'' ( options {greedy=false;} : . )*'\'\'\''|'"""' ( options {greedy=false;} : . )*'"""');

RULE_NAMESPACE : '<' ~(('>'|' '|'#'))* ('#'|'/') '>';

RULE_IRI : '<' ~(('>'|' '))* '>';

RULE_ID : RULE_IDFRAG;

RULE_QNAME : RULE_IDFRAG ':' RULE_IDFRAG;

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

fragment RULE_IDFRAG : '^'? (RULE_ALPHA|RULE_DIGIT|'_') (RULE_ALPHA|RULE_DIGIT|'_'|'-'|'.'|'$')*;

fragment RULE_ALPHA : ('a'..'z'|'A'..'Z');

fragment RULE_DIGIT : '0'..'9';
