/*
 * Copyright 2019 California Institute of Technology (\"Caltech\").
 * U.S. Government sponsorship acknowledged.
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.opencaesar.oml.dsl.serializer;

import com.google.inject.Inject;
import io.opencaesar.oml.dsl.services.OmlGrammarAccess;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.serializer.analysis.GrammarAlias.AbstractElementAlias;
import org.eclipse.xtext.serializer.analysis.GrammarAlias.GroupAlias;
import org.eclipse.xtext.serializer.analysis.GrammarAlias.TokenAlias;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider.ISynNavigable;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider.ISynTransition;
import org.eclipse.xtext.serializer.sequencer.AbstractSyntacticSequencer;

@SuppressWarnings("all")
public class OmlSyntacticSequencer extends AbstractSyntacticSequencer {

	protected OmlGrammarAccess grammarAccess;
	protected AbstractElementAlias match_AspectReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q;
	protected AbstractElementAlias match_Aspect___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q;
	protected AbstractElementAlias match_ConceptInstanceReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_3__q;
	protected AbstractElementAlias match_ConceptInstance___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q;
	protected AbstractElementAlias match_ConceptReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q;
	protected AbstractElementAlias match_Concept___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_3__q;
	protected AbstractElementAlias match_EnumeratedScalar___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q;
	protected AbstractElementAlias match_FacetedScalar___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q;
	protected AbstractElementAlias match_RelationEntityReference___LeftSquareBracketKeyword_6_0_RightSquareBracketKeyword_6_2__q;
	protected AbstractElementAlias match_RelationInstanceReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_3__q;
	protected AbstractElementAlias match_StructureReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q;
	protected AbstractElementAlias match_Structure___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q;
	
	@Inject
	protected void init(IGrammarAccess access) {
		grammarAccess = (OmlGrammarAccess) access;
		match_AspectReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getAspectReferenceAccess().getLeftSquareBracketKeyword_5_0()), new TokenAlias(false, false, grammarAccess.getAspectReferenceAccess().getRightSquareBracketKeyword_5_2()));
		match_Aspect___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getAspectAccess().getLeftSquareBracketKeyword_4_0()), new TokenAlias(false, false, grammarAccess.getAspectAccess().getRightSquareBracketKeyword_4_2()));
		match_ConceptInstanceReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_3__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getConceptInstanceReferenceAccess().getLeftSquareBracketKeyword_5_0()), new TokenAlias(false, false, grammarAccess.getConceptInstanceReferenceAccess().getRightSquareBracketKeyword_5_3()));
		match_ConceptInstance___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getConceptInstanceAccess().getLeftSquareBracketKeyword_4_0()), new TokenAlias(false, false, grammarAccess.getConceptInstanceAccess().getRightSquareBracketKeyword_4_2()));
		match_ConceptReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getConceptReferenceAccess().getLeftSquareBracketKeyword_5_0()), new TokenAlias(false, false, grammarAccess.getConceptReferenceAccess().getRightSquareBracketKeyword_5_2()));
		match_Concept___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_3__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getConceptAccess().getLeftSquareBracketKeyword_4_0()), new TokenAlias(false, false, grammarAccess.getConceptAccess().getRightSquareBracketKeyword_4_3()));
		match_EnumeratedScalar___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getEnumeratedScalarAccess().getLeftSquareBracketKeyword_5_0()), new TokenAlias(false, false, grammarAccess.getEnumeratedScalarAccess().getRightSquareBracketKeyword_5_2()));
		match_FacetedScalar___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getFacetedScalarAccess().getLeftSquareBracketKeyword_4_0()), new TokenAlias(false, false, grammarAccess.getFacetedScalarAccess().getRightSquareBracketKeyword_4_2()));
		match_RelationEntityReference___LeftSquareBracketKeyword_6_0_RightSquareBracketKeyword_6_2__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getRelationEntityReferenceAccess().getLeftSquareBracketKeyword_6_0()), new TokenAlias(false, false, grammarAccess.getRelationEntityReferenceAccess().getRightSquareBracketKeyword_6_2()));
		match_RelationInstanceReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_3__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getRelationInstanceReferenceAccess().getLeftSquareBracketKeyword_5_0()), new TokenAlias(false, false, grammarAccess.getRelationInstanceReferenceAccess().getRightSquareBracketKeyword_5_3()));
		match_StructureReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getStructureReferenceAccess().getLeftSquareBracketKeyword_5_0()), new TokenAlias(false, false, grammarAccess.getStructureReferenceAccess().getRightSquareBracketKeyword_5_2()));
		match_Structure___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getStructureAccess().getLeftSquareBracketKeyword_4_0()), new TokenAlias(false, false, grammarAccess.getStructureAccess().getRightSquareBracketKeyword_4_2()));
	}
	
	@Override
	protected String getUnassignedRuleCallToken(EObject semanticObject, RuleCall ruleCall, INode node) {
		return "";
	}
	
	
	@Override
	protected void emitUnassignedTokens(EObject semanticObject, ISynTransition transition, INode fromNode, INode toNode) {
		if (transition.getAmbiguousSyntaxes().isEmpty()) return;
		List<INode> transitionNodes = collectNodes(fromNode, toNode);
		for (AbstractElementAlias syntax : transition.getAmbiguousSyntaxes()) {
			List<INode> syntaxNodes = getNodesFor(transitionNodes, syntax);
			if (match_AspectReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q.equals(syntax))
				emit_AspectReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_Aspect___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q.equals(syntax))
				emit_Aspect___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ConceptInstanceReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_3__q.equals(syntax))
				emit_ConceptInstanceReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_3__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ConceptInstance___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q.equals(syntax))
				emit_ConceptInstance___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ConceptReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q.equals(syntax))
				emit_ConceptReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_Concept___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_3__q.equals(syntax))
				emit_Concept___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_3__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_EnumeratedScalar___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q.equals(syntax))
				emit_EnumeratedScalar___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_FacetedScalar___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q.equals(syntax))
				emit_FacetedScalar___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_RelationEntityReference___LeftSquareBracketKeyword_6_0_RightSquareBracketKeyword_6_2__q.equals(syntax))
				emit_RelationEntityReference___LeftSquareBracketKeyword_6_0_RightSquareBracketKeyword_6_2__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_RelationInstanceReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_3__q.equals(syntax))
				emit_RelationInstanceReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_3__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_StructureReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q.equals(syntax))
				emit_StructureReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_Structure___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q.equals(syntax))
				emit_Structure___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else acceptNodes(getLastNavigableState(), syntaxNodes);
		}
	}

	/**
	 * <pre>
	 * Ambiguous syntax:
	 *     ('[' ']')?
	 *
	 * This ambiguous syntax occurs at:
	 *     aspect=[Aspect|Ref] (ambiguity) (rule end)
	 *     ownedSpecializations+=SpecializationAxiom (ambiguity) (rule end)
	 
	 * </pre>
	 */
	protected void emit_AspectReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
	/**
	 * <pre>
	 * Ambiguous syntax:
	 *     ('[' ']')?
	 *
	 * This ambiguous syntax occurs at:
	 *     name=ID (ambiguity) (rule end)
	 *     ownedSpecializations+=SpecializationAxiom (ambiguity) (rule end)
	 
	 * </pre>
	 */
	protected void emit_Aspect___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
	/**
	 * <pre>
	 * Ambiguous syntax:
	 *     ('[' ']')?
	 *
	 * This ambiguous syntax occurs at:
	 *     instance=[ConceptInstance|Ref] (ambiguity) (rule end)
	 *     ownedTypes+=ConceptTypeAssertion (ambiguity) (rule end)
	 
	 * </pre>
	 */
	protected void emit_ConceptInstanceReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_3__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
	/**
	 * <pre>
	 * Ambiguous syntax:
	 *     ('[' ']')?
	 *
	 * This ambiguous syntax occurs at:
	 *     name=ID (ambiguity) (rule end)
	 *     ownedTypes+=ConceptTypeAssertion (ambiguity) (rule end)
	 
	 * </pre>
	 */
	protected void emit_ConceptInstance___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
	/**
	 * <pre>
	 * Ambiguous syntax:
	 *     ('[' ']')?
	 *
	 * This ambiguous syntax occurs at:
	 *     concept=[Concept|Ref] (ambiguity) (rule end)
	 *     ownedSpecializations+=SpecializationAxiom (ambiguity) (rule end)
	 
	 * </pre>
	 */
	protected void emit_ConceptReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
	/**
	 * <pre>
	 * Ambiguous syntax:
	 *     ('[' ']')?
	 *
	 * This ambiguous syntax occurs at:
	 *     name=ID (ambiguity) (rule end)
	 *     ownedSpecializations+=SpecializationAxiom (ambiguity) (rule end)
	 
	 * </pre>
	 */
	protected void emit_Concept___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_3__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
	/**
	 * <pre>
	 * Ambiguous syntax:
	 *     ('[' ']')?
	 *
	 * This ambiguous syntax occurs at:
	 *     name=ID (ambiguity) (rule end)
	 *     ownedSpecializations+=SpecializationAxiom (ambiguity) (rule end)
	 
	 * </pre>
	 */
	protected void emit_EnumeratedScalar___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
	/**
	 * <pre>
	 * Ambiguous syntax:
	 *     ('[' ']')?
	 *
	 * This ambiguous syntax occurs at:
	 *     name=ID (ambiguity) (rule end)
	 *     ownedSpecializations+=SpecializationAxiom (ambiguity) (rule end)
	 
	 * </pre>
	 */
	protected void emit_FacetedScalar___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
	/**
	 * <pre>
	 * Ambiguous syntax:
	 *     ('[' ']')?
	 *
	 * This ambiguous syntax occurs at:
	 *     entity=[RelationEntity|Ref] (ambiguity) (rule end)
	 *     ownedSpecializations+=SpecializationAxiom (ambiguity) (rule end)
	 
	 * </pre>
	 */
	protected void emit_RelationEntityReference___LeftSquareBracketKeyword_6_0_RightSquareBracketKeyword_6_2__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
	/**
	 * <pre>
	 * Ambiguous syntax:
	 *     ('[' ']')?
	 *
	 * This ambiguous syntax occurs at:
	 *     instance=[RelationInstance|Ref] (ambiguity) (rule end)
	 *     ownedTypes+=RelationTypeAssertion (ambiguity) (rule end)
	 
	 * </pre>
	 */
	protected void emit_RelationInstanceReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_3__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
	/**
	 * <pre>
	 * Ambiguous syntax:
	 *     ('[' ']')?
	 *
	 * This ambiguous syntax occurs at:
	 *     ownedSpecializations+=SpecializationAxiom (ambiguity) (rule end)
	 *     structure=[Structure|Ref] (ambiguity) (rule end)
	 
	 * </pre>
	 */
	protected void emit_StructureReference___LeftSquareBracketKeyword_5_0_RightSquareBracketKeyword_5_2__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
	/**
	 * <pre>
	 * Ambiguous syntax:
	 *     ('[' ']')?
	 *
	 * This ambiguous syntax occurs at:
	 *     name=ID (ambiguity) (rule end)
	 *     ownedSpecializations+=SpecializationAxiom (ambiguity) (rule end)
	 
	 * </pre>
	 */
	protected void emit_Structure___LeftSquareBracketKeyword_4_0_RightSquareBracketKeyword_4_2__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
}
