/*
 * Copyright 2019 California Institute of Technology (\"Caltech\").
 * U.S. Government sponsorship acknowledged.
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.opencaesar.oml.dsl.services;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.service.AbstractElementFinder;
import org.eclipse.xtext.service.GrammarProvider;

@Singleton
public class OmlGrammarAccess extends AbstractElementFinder.AbstractGrammarElementFinder {
	
	public class OntologyElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Ontology");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cVocabularyBoxParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cDescriptionBoxParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//Ontology:
		//    VocabularyBox |
		//    DescriptionBox;
		@Override public ParserRule getRule() { return rule; }
		
		//VocabularyBox |
		//DescriptionBox
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//VocabularyBox
		public RuleCall getVocabularyBoxParserRuleCall_0() { return cVocabularyBoxParserRuleCall_0; }
		
		//DescriptionBox
		public RuleCall getDescriptionBoxParserRuleCall_1() { return cDescriptionBoxParserRuleCall_1; }
	}
	public class AnnotationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Annotation");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cCommercialAtKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Action cAnnotationAction_1 = (Action)cGroup.eContents().get(1);
		private final Assignment cPropertyAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final CrossReference cPropertyAnnotationPropertyCrossReference_2_0 = (CrossReference)cPropertyAssignment_2.eContents().get(0);
		private final RuleCall cPropertyAnnotationPropertyRefParserRuleCall_2_0_1 = (RuleCall)cPropertyAnnotationPropertyCrossReference_2_0.eContents().get(1);
		private final Alternatives cAlternatives_3 = (Alternatives)cGroup.eContents().get(3);
		private final Assignment cValueAssignment_3_0 = (Assignment)cAlternatives_3.eContents().get(0);
		private final RuleCall cValueLiteralParserRuleCall_3_0_0 = (RuleCall)cValueAssignment_3_0.eContents().get(0);
		private final Assignment cReferenceValueAssignment_3_1 = (Assignment)cAlternatives_3.eContents().get(1);
		private final CrossReference cReferenceValueMemberCrossReference_3_1_0 = (CrossReference)cReferenceValueAssignment_3_1.eContents().get(0);
		private final RuleCall cReferenceValueMemberRefParserRuleCall_3_1_0_1 = (RuleCall)cReferenceValueMemberCrossReference_3_1_0.eContents().get(1);
		
		//Annotation:
		//    '@' {Annotation} property=[AnnotationProperty|Ref] (value=Literal | referenceValue=[Member|Ref])?;
		@Override public ParserRule getRule() { return rule; }
		
		//'@' {Annotation} property=[AnnotationProperty|Ref] (value=Literal | referenceValue=[Member|Ref])?
		public Group getGroup() { return cGroup; }
		
		//'@'
		public Keyword getCommercialAtKeyword_0() { return cCommercialAtKeyword_0; }
		
		//{Annotation}
		public Action getAnnotationAction_1() { return cAnnotationAction_1; }
		
		//property=[AnnotationProperty|Ref]
		public Assignment getPropertyAssignment_2() { return cPropertyAssignment_2; }
		
		//[AnnotationProperty|Ref]
		public CrossReference getPropertyAnnotationPropertyCrossReference_2_0() { return cPropertyAnnotationPropertyCrossReference_2_0; }
		
		//Ref
		public RuleCall getPropertyAnnotationPropertyRefParserRuleCall_2_0_1() { return cPropertyAnnotationPropertyRefParserRuleCall_2_0_1; }
		
		//(value=Literal | referenceValue=[Member|Ref])?
		public Alternatives getAlternatives_3() { return cAlternatives_3; }
		
		//value=Literal
		public Assignment getValueAssignment_3_0() { return cValueAssignment_3_0; }
		
		//Literal
		public RuleCall getValueLiteralParserRuleCall_3_0_0() { return cValueLiteralParserRuleCall_3_0_0; }
		
		//referenceValue=[Member|Ref]
		public Assignment getReferenceValueAssignment_3_1() { return cReferenceValueAssignment_3_1; }
		
		//[Member|Ref]
		public CrossReference getReferenceValueMemberCrossReference_3_1_0() { return cReferenceValueMemberCrossReference_3_1_0; }
		
		//Ref
		public RuleCall getReferenceValueMemberRefParserRuleCall_3_1_0_1() { return cReferenceValueMemberRefParserRuleCall_3_1_0_1; }
	}
	public class VocabularyBoxElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.VocabularyBox");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cVocabularyParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cVocabularyBundleParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//VocabularyBox:
		//    Vocabulary |
		//    VocabularyBundle;
		@Override public ParserRule getRule() { return rule; }
		
		//Vocabulary |
		//VocabularyBundle
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//Vocabulary
		public RuleCall getVocabularyParserRuleCall_0() { return cVocabularyParserRuleCall_0; }
		
		//VocabularyBundle
		public RuleCall getVocabularyBundleParserRuleCall_1() { return cVocabularyBundleParserRuleCall_1; }
	}
	public class VocabularyElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Vocabulary");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cVocabularyKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNamespaceAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNamespaceNAMESPACETerminalRuleCall_2_0 = (RuleCall)cNamespaceAssignment_2.eContents().get(0);
		private final Keyword cAsKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cPrefixAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cPrefixIDTerminalRuleCall_4_0 = (RuleCall)cPrefixAssignment_4.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Assignment cOwnedImportsAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cOwnedImportsVocabularyImportParserRuleCall_6_0 = (RuleCall)cOwnedImportsAssignment_6.eContents().get(0);
		private final Assignment cOwnedStatementsAssignment_7 = (Assignment)cGroup.eContents().get(7);
		private final RuleCall cOwnedStatementsVocabularyStatementParserRuleCall_7_0 = (RuleCall)cOwnedStatementsAssignment_7.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_8 = (Keyword)cGroup.eContents().get(8);
		
		//Vocabulary:
		//    ownedAnnotations+=Annotation*
		//    'vocabulary' namespace=NAMESPACE 'as' prefix=ID  '{'
		//        ownedImports+=VocabularyImport*
		//        ownedStatements+=VocabularyStatement*
		//    '}';
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'vocabulary' namespace=NAMESPACE 'as' prefix=ID  '{'
		//    ownedImports+=VocabularyImport*
		//    ownedStatements+=VocabularyStatement*
		//'}'
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'vocabulary'
		public Keyword getVocabularyKeyword_1() { return cVocabularyKeyword_1; }
		
		//namespace=NAMESPACE
		public Assignment getNamespaceAssignment_2() { return cNamespaceAssignment_2; }
		
		//NAMESPACE
		public RuleCall getNamespaceNAMESPACETerminalRuleCall_2_0() { return cNamespaceNAMESPACETerminalRuleCall_2_0; }
		
		//'as'
		public Keyword getAsKeyword_3() { return cAsKeyword_3; }
		
		//prefix=ID
		public Assignment getPrefixAssignment_4() { return cPrefixAssignment_4; }
		
		//ID
		public RuleCall getPrefixIDTerminalRuleCall_4_0() { return cPrefixIDTerminalRuleCall_4_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_5() { return cLeftCurlyBracketKeyword_5; }
		
		//ownedImports+=VocabularyImport*
		public Assignment getOwnedImportsAssignment_6() { return cOwnedImportsAssignment_6; }
		
		//VocabularyImport
		public RuleCall getOwnedImportsVocabularyImportParserRuleCall_6_0() { return cOwnedImportsVocabularyImportParserRuleCall_6_0; }
		
		//ownedStatements+=VocabularyStatement*
		public Assignment getOwnedStatementsAssignment_7() { return cOwnedStatementsAssignment_7; }
		
		//VocabularyStatement
		public RuleCall getOwnedStatementsVocabularyStatementParserRuleCall_7_0() { return cOwnedStatementsVocabularyStatementParserRuleCall_7_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_8() { return cRightCurlyBracketKeyword_8; }
	}
	public class VocabularyBundleElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.VocabularyBundle");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cVocabularyKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cBundleKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cNamespaceAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cNamespaceNAMESPACETerminalRuleCall_3_0 = (RuleCall)cNamespaceAssignment_3.eContents().get(0);
		private final Keyword cAsKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cPrefixAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final RuleCall cPrefixIDTerminalRuleCall_5_0 = (RuleCall)cPrefixAssignment_5.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_6 = (Keyword)cGroup.eContents().get(6);
		private final Assignment cOwnedImportsAssignment_7 = (Assignment)cGroup.eContents().get(7);
		private final RuleCall cOwnedImportsVocabularyBundleImportParserRuleCall_7_0 = (RuleCall)cOwnedImportsAssignment_7.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_8 = (Keyword)cGroup.eContents().get(8);
		
		//VocabularyBundle:
		//    ownedAnnotations+=Annotation*
		//    'vocabulary' 'bundle' namespace=NAMESPACE 'as' prefix=ID '{'
		//        ownedImports+=VocabularyBundleImport*
		//    '}';
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'vocabulary' 'bundle' namespace=NAMESPACE 'as' prefix=ID '{'
		//    ownedImports+=VocabularyBundleImport*
		//'}'
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'vocabulary'
		public Keyword getVocabularyKeyword_1() { return cVocabularyKeyword_1; }
		
		//'bundle'
		public Keyword getBundleKeyword_2() { return cBundleKeyword_2; }
		
		//namespace=NAMESPACE
		public Assignment getNamespaceAssignment_3() { return cNamespaceAssignment_3; }
		
		//NAMESPACE
		public RuleCall getNamespaceNAMESPACETerminalRuleCall_3_0() { return cNamespaceNAMESPACETerminalRuleCall_3_0; }
		
		//'as'
		public Keyword getAsKeyword_4() { return cAsKeyword_4; }
		
		//prefix=ID
		public Assignment getPrefixAssignment_5() { return cPrefixAssignment_5; }
		
		//ID
		public RuleCall getPrefixIDTerminalRuleCall_5_0() { return cPrefixIDTerminalRuleCall_5_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_6() { return cLeftCurlyBracketKeyword_6; }
		
		//ownedImports+=VocabularyBundleImport*
		public Assignment getOwnedImportsAssignment_7() { return cOwnedImportsAssignment_7; }
		
		//VocabularyBundleImport
		public RuleCall getOwnedImportsVocabularyBundleImportParserRuleCall_7_0() { return cOwnedImportsVocabularyBundleImportParserRuleCall_7_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_8() { return cRightCurlyBracketKeyword_8; }
	}
	public class DescriptionBoxElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.DescriptionBox");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cDescriptionParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cDescriptionBundleParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//DescriptionBox:
		//    Description |
		//    DescriptionBundle;
		@Override public ParserRule getRule() { return rule; }
		
		//Description |
		//DescriptionBundle
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//Description
		public RuleCall getDescriptionParserRuleCall_0() { return cDescriptionParserRuleCall_0; }
		
		//DescriptionBundle
		public RuleCall getDescriptionBundleParserRuleCall_1() { return cDescriptionBundleParserRuleCall_1; }
	}
	public class DescriptionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Description");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cDescriptionKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNamespaceAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNamespaceNAMESPACETerminalRuleCall_2_0 = (RuleCall)cNamespaceAssignment_2.eContents().get(0);
		private final Keyword cAsKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cPrefixAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cPrefixIDTerminalRuleCall_4_0 = (RuleCall)cPrefixAssignment_4.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Assignment cOwnedImportsAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cOwnedImportsDescriptionImportParserRuleCall_6_0 = (RuleCall)cOwnedImportsAssignment_6.eContents().get(0);
		private final Assignment cOwnedStatementsAssignment_7 = (Assignment)cGroup.eContents().get(7);
		private final RuleCall cOwnedStatementsDescriptionStatementParserRuleCall_7_0 = (RuleCall)cOwnedStatementsAssignment_7.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_8 = (Keyword)cGroup.eContents().get(8);
		
		//Description:
		//    ownedAnnotations+=Annotation*
		//    'description' namespace=NAMESPACE 'as' prefix=ID '{'
		//        ownedImports+=DescriptionImport*
		//        ownedStatements+=DescriptionStatement*
		//    '}';
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'description' namespace=NAMESPACE 'as' prefix=ID '{'
		//    ownedImports+=DescriptionImport*
		//    ownedStatements+=DescriptionStatement*
		//'}'
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'description'
		public Keyword getDescriptionKeyword_1() { return cDescriptionKeyword_1; }
		
		//namespace=NAMESPACE
		public Assignment getNamespaceAssignment_2() { return cNamespaceAssignment_2; }
		
		//NAMESPACE
		public RuleCall getNamespaceNAMESPACETerminalRuleCall_2_0() { return cNamespaceNAMESPACETerminalRuleCall_2_0; }
		
		//'as'
		public Keyword getAsKeyword_3() { return cAsKeyword_3; }
		
		//prefix=ID
		public Assignment getPrefixAssignment_4() { return cPrefixAssignment_4; }
		
		//ID
		public RuleCall getPrefixIDTerminalRuleCall_4_0() { return cPrefixIDTerminalRuleCall_4_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_5() { return cLeftCurlyBracketKeyword_5; }
		
		//ownedImports+=DescriptionImport*
		public Assignment getOwnedImportsAssignment_6() { return cOwnedImportsAssignment_6; }
		
		//DescriptionImport
		public RuleCall getOwnedImportsDescriptionImportParserRuleCall_6_0() { return cOwnedImportsDescriptionImportParserRuleCall_6_0; }
		
		//ownedStatements+=DescriptionStatement*
		public Assignment getOwnedStatementsAssignment_7() { return cOwnedStatementsAssignment_7; }
		
		//DescriptionStatement
		public RuleCall getOwnedStatementsDescriptionStatementParserRuleCall_7_0() { return cOwnedStatementsDescriptionStatementParserRuleCall_7_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_8() { return cRightCurlyBracketKeyword_8; }
	}
	public class DescriptionBundleElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.DescriptionBundle");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cDescriptionKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cBundleKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cNamespaceAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cNamespaceNAMESPACETerminalRuleCall_3_0 = (RuleCall)cNamespaceAssignment_3.eContents().get(0);
		private final Keyword cAsKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cPrefixAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final RuleCall cPrefixIDTerminalRuleCall_5_0 = (RuleCall)cPrefixAssignment_5.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_6 = (Keyword)cGroup.eContents().get(6);
		private final Assignment cOwnedImportsAssignment_7 = (Assignment)cGroup.eContents().get(7);
		private final RuleCall cOwnedImportsDescriptionBundleImportParserRuleCall_7_0 = (RuleCall)cOwnedImportsAssignment_7.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_8 = (Keyword)cGroup.eContents().get(8);
		
		//DescriptionBundle:
		//    ownedAnnotations+=Annotation*
		//    'description' 'bundle' namespace=NAMESPACE 'as' prefix=ID '{'
		//        ownedImports+=DescriptionBundleImport*
		//    '}';
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'description' 'bundle' namespace=NAMESPACE 'as' prefix=ID '{'
		//    ownedImports+=DescriptionBundleImport*
		//'}'
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'description'
		public Keyword getDescriptionKeyword_1() { return cDescriptionKeyword_1; }
		
		//'bundle'
		public Keyword getBundleKeyword_2() { return cBundleKeyword_2; }
		
		//namespace=NAMESPACE
		public Assignment getNamespaceAssignment_3() { return cNamespaceAssignment_3; }
		
		//NAMESPACE
		public RuleCall getNamespaceNAMESPACETerminalRuleCall_3_0() { return cNamespaceNAMESPACETerminalRuleCall_3_0; }
		
		//'as'
		public Keyword getAsKeyword_4() { return cAsKeyword_4; }
		
		//prefix=ID
		public Assignment getPrefixAssignment_5() { return cPrefixAssignment_5; }
		
		//ID
		public RuleCall getPrefixIDTerminalRuleCall_5_0() { return cPrefixIDTerminalRuleCall_5_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_6() { return cLeftCurlyBracketKeyword_6; }
		
		//ownedImports+=DescriptionBundleImport*
		public Assignment getOwnedImportsAssignment_7() { return cOwnedImportsAssignment_7; }
		
		//DescriptionBundleImport
		public RuleCall getOwnedImportsDescriptionBundleImportParserRuleCall_7_0() { return cOwnedImportsDescriptionBundleImportParserRuleCall_7_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_8() { return cRightCurlyBracketKeyword_8; }
	}
	public class SpecializableTermElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.SpecializableTerm");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cTypeParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cAnnotationPropertyParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cScalarPropertyParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cStructuredPropertyParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		
		//SpecializableTerm:
		//    Type |
		//    AnnotationProperty |
		//    ScalarProperty |
		//    StructuredProperty;
		@Override public ParserRule getRule() { return rule; }
		
		//Type |
		//AnnotationProperty |
		//ScalarProperty |
		//StructuredProperty
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//Type
		public RuleCall getTypeParserRuleCall_0() { return cTypeParserRuleCall_0; }
		
		//AnnotationProperty
		public RuleCall getAnnotationPropertyParserRuleCall_1() { return cAnnotationPropertyParserRuleCall_1; }
		
		//ScalarProperty
		public RuleCall getScalarPropertyParserRuleCall_2() { return cScalarPropertyParserRuleCall_2; }
		
		//StructuredProperty
		public RuleCall getStructuredPropertyParserRuleCall_3() { return cStructuredPropertyParserRuleCall_3; }
	}
	public class TypeElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Type");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cClassifierParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cScalarParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//Type:
		//    Classifier |
		//    Scalar;
		@Override public ParserRule getRule() { return rule; }
		
		//Classifier |
		//Scalar
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//Classifier
		public RuleCall getClassifierParserRuleCall_0() { return cClassifierParserRuleCall_0; }
		
		//Scalar
		public RuleCall getScalarParserRuleCall_1() { return cScalarParserRuleCall_1; }
	}
	public class ClassifierElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Classifier");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cEntityParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cStructureParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//Classifier:
		//    Entity |
		//    Structure;
		@Override public ParserRule getRule() { return rule; }
		
		//Entity |
		//Structure
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//Entity
		public RuleCall getEntityParserRuleCall_0() { return cEntityParserRuleCall_0; }
		
		//Structure
		public RuleCall getStructureParserRuleCall_1() { return cStructureParserRuleCall_1; }
	}
	public class EntityElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Entity");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cAspectParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cConceptParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cRelationEntityParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		//Entity:
		//    Aspect |
		//    Concept |
		//    RelationEntity;
		@Override public ParserRule getRule() { return rule; }
		
		//Aspect |
		//Concept |
		//RelationEntity
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//Aspect
		public RuleCall getAspectParserRuleCall_0() { return cAspectParserRuleCall_0; }
		
		//Concept
		public RuleCall getConceptParserRuleCall_1() { return cConceptParserRuleCall_1; }
		
		//RelationEntity
		public RuleCall getRelationEntityParserRuleCall_2() { return cRelationEntityParserRuleCall_2; }
	}
	public class AspectElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Aspect");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cAspectKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNameIDTerminalRuleCall_2_0 = (RuleCall)cNameAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cColonGreaterThanSignKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_3_1_0 = (RuleCall)cOwnedSpecializationsAssignment_3_1.eContents().get(0);
		private final Group cGroup_3_2 = (Group)cGroup_3.eContents().get(2);
		private final Keyword cCommaKeyword_3_2_0 = (Keyword)cGroup_3_2.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_3_2_1 = (Assignment)cGroup_3_2.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_3_2_1_0 = (RuleCall)cOwnedSpecializationsAssignment_3_2_1.eContents().get(0);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cLeftSquareBracketKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Alternatives cAlternatives_4_1 = (Alternatives)cGroup_4.eContents().get(1);
		private final Assignment cOwnedKeysAssignment_4_1_0 = (Assignment)cAlternatives_4_1.eContents().get(0);
		private final RuleCall cOwnedKeysKeyAxiomParserRuleCall_4_1_0_0 = (RuleCall)cOwnedKeysAssignment_4_1_0.eContents().get(0);
		private final Assignment cOwnedPropertyRestrictionsAssignment_4_1_1 = (Assignment)cAlternatives_4_1.eContents().get(1);
		private final RuleCall cOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_4_1_1_0 = (RuleCall)cOwnedPropertyRestrictionsAssignment_4_1_1.eContents().get(0);
		private final Assignment cOwnedRelationRestrictionsAssignment_4_1_2 = (Assignment)cAlternatives_4_1.eContents().get(2);
		private final RuleCall cOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_4_1_2_0 = (RuleCall)cOwnedRelationRestrictionsAssignment_4_1_2.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_4_2 = (Keyword)cGroup_4.eContents().get(2);
		
		//Aspect:
		//    ownedAnnotations+=Annotation*
		//    'aspect' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//        (ownedKeys+=KeyAxiom |
		//         ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		//         ownedRelationRestrictions+=RelationRestrictionAxiom)*
		//    ']')?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'aspect' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//    (ownedKeys+=KeyAxiom |
		//     ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		//     ownedRelationRestrictions+=RelationRestrictionAxiom)*
		//']')?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'aspect'
		public Keyword getAspectKeyword_1() { return cAspectKeyword_1; }
		
		//name=ID
		public Assignment getNameAssignment_2() { return cNameAssignment_2; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_2_0() { return cNameIDTerminalRuleCall_2_0; }
		
		//(':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup_3() { return cGroup_3; }
		
		//':>'
		public Keyword getColonGreaterThanSignKeyword_3_0() { return cColonGreaterThanSignKeyword_3_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_3_1() { return cOwnedSpecializationsAssignment_3_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_3_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_3_1_0; }
		
		//(',' ownedSpecializations+=SpecializationAxiom)*
		public Group getGroup_3_2() { return cGroup_3_2; }
		
		//','
		public Keyword getCommaKeyword_3_2_0() { return cCommaKeyword_3_2_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_3_2_1() { return cOwnedSpecializationsAssignment_3_2_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_3_2_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_3_2_1_0; }
		
		//('['
		//       (ownedKeys+=KeyAxiom |
		//        ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		//        ownedRelationRestrictions+=RelationRestrictionAxiom)*
		//   ']')?
		public Group getGroup_4() { return cGroup_4; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_4_0() { return cLeftSquareBracketKeyword_4_0; }
		
		//(ownedKeys+=KeyAxiom |
		// ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		// ownedRelationRestrictions+=RelationRestrictionAxiom)*
		public Alternatives getAlternatives_4_1() { return cAlternatives_4_1; }
		
		//ownedKeys+=KeyAxiom
		public Assignment getOwnedKeysAssignment_4_1_0() { return cOwnedKeysAssignment_4_1_0; }
		
		//KeyAxiom
		public RuleCall getOwnedKeysKeyAxiomParserRuleCall_4_1_0_0() { return cOwnedKeysKeyAxiomParserRuleCall_4_1_0_0; }
		
		//ownedPropertyRestrictions+=PropertyRestrictionAxiom
		public Assignment getOwnedPropertyRestrictionsAssignment_4_1_1() { return cOwnedPropertyRestrictionsAssignment_4_1_1; }
		
		//PropertyRestrictionAxiom
		public RuleCall getOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_4_1_1_0() { return cOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_4_1_1_0; }
		
		//ownedRelationRestrictions+=RelationRestrictionAxiom
		public Assignment getOwnedRelationRestrictionsAssignment_4_1_2() { return cOwnedRelationRestrictionsAssignment_4_1_2; }
		
		//RelationRestrictionAxiom
		public RuleCall getOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_4_1_2_0() { return cOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_4_1_2_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_4_2() { return cRightSquareBracketKeyword_4_2; }
	}
	public class ConceptElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Concept");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cConceptKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNameIDTerminalRuleCall_2_0 = (RuleCall)cNameAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cColonGreaterThanSignKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_3_1_0 = (RuleCall)cOwnedSpecializationsAssignment_3_1.eContents().get(0);
		private final Group cGroup_3_2 = (Group)cGroup_3.eContents().get(2);
		private final Keyword cCommaKeyword_3_2_0 = (Keyword)cGroup_3_2.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_3_2_1 = (Assignment)cGroup_3_2.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_3_2_1_0 = (RuleCall)cOwnedSpecializationsAssignment_3_2_1.eContents().get(0);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cLeftSquareBracketKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Alternatives cAlternatives_4_1 = (Alternatives)cGroup_4.eContents().get(1);
		private final Assignment cOwnedKeysAssignment_4_1_0 = (Assignment)cAlternatives_4_1.eContents().get(0);
		private final RuleCall cOwnedKeysKeyAxiomParserRuleCall_4_1_0_0 = (RuleCall)cOwnedKeysAssignment_4_1_0.eContents().get(0);
		private final Assignment cOwnedPropertyRestrictionsAssignment_4_1_1 = (Assignment)cAlternatives_4_1.eContents().get(1);
		private final RuleCall cOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_4_1_1_0 = (RuleCall)cOwnedPropertyRestrictionsAssignment_4_1_1.eContents().get(0);
		private final Assignment cOwnedRelationRestrictionsAssignment_4_1_2 = (Assignment)cAlternatives_4_1.eContents().get(2);
		private final RuleCall cOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_4_1_2_0 = (RuleCall)cOwnedRelationRestrictionsAssignment_4_1_2.eContents().get(0);
		private final Group cGroup_4_2 = (Group)cGroup_4.eContents().get(2);
		private final Keyword cEnumeratesKeyword_4_2_0 = (Keyword)cGroup_4_2.eContents().get(0);
		private final Assignment cEnumeratedInstancesAssignment_4_2_1 = (Assignment)cGroup_4_2.eContents().get(1);
		private final CrossReference cEnumeratedInstancesConceptInstanceCrossReference_4_2_1_0 = (CrossReference)cEnumeratedInstancesAssignment_4_2_1.eContents().get(0);
		private final RuleCall cEnumeratedInstancesConceptInstanceRefParserRuleCall_4_2_1_0_1 = (RuleCall)cEnumeratedInstancesConceptInstanceCrossReference_4_2_1_0.eContents().get(1);
		private final Group cGroup_4_2_2 = (Group)cGroup_4_2.eContents().get(2);
		private final Keyword cCommaKeyword_4_2_2_0 = (Keyword)cGroup_4_2_2.eContents().get(0);
		private final Assignment cEnumeratedInstancesAssignment_4_2_2_1 = (Assignment)cGroup_4_2_2.eContents().get(1);
		private final CrossReference cEnumeratedInstancesConceptInstanceCrossReference_4_2_2_1_0 = (CrossReference)cEnumeratedInstancesAssignment_4_2_2_1.eContents().get(0);
		private final RuleCall cEnumeratedInstancesConceptInstanceRefParserRuleCall_4_2_2_1_0_1 = (RuleCall)cEnumeratedInstancesConceptInstanceCrossReference_4_2_2_1_0.eContents().get(1);
		private final Keyword cRightSquareBracketKeyword_4_3 = (Keyword)cGroup_4.eContents().get(3);
		
		//Concept:
		//    ownedAnnotations+=Annotation*
		//    'concept' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//        (ownedKeys+=KeyAxiom |
		//         ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		//         ownedRelationRestrictions+=RelationRestrictionAxiom)*
		//        ('enumerates' enumeratedInstances+=[ConceptInstance|Ref] (',' enumeratedInstances+=[ConceptInstance|Ref])*)?
		//    ']')?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'concept' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//    (ownedKeys+=KeyAxiom |
		//     ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		//     ownedRelationRestrictions+=RelationRestrictionAxiom)*
		//    ('enumerates' enumeratedInstances+=[ConceptInstance|Ref] (',' enumeratedInstances+=[ConceptInstance|Ref])*)?
		//']')?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'concept'
		public Keyword getConceptKeyword_1() { return cConceptKeyword_1; }
		
		//name=ID
		public Assignment getNameAssignment_2() { return cNameAssignment_2; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_2_0() { return cNameIDTerminalRuleCall_2_0; }
		
		//(':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup_3() { return cGroup_3; }
		
		//':>'
		public Keyword getColonGreaterThanSignKeyword_3_0() { return cColonGreaterThanSignKeyword_3_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_3_1() { return cOwnedSpecializationsAssignment_3_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_3_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_3_1_0; }
		
		//(',' ownedSpecializations+=SpecializationAxiom)*
		public Group getGroup_3_2() { return cGroup_3_2; }
		
		//','
		public Keyword getCommaKeyword_3_2_0() { return cCommaKeyword_3_2_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_3_2_1() { return cOwnedSpecializationsAssignment_3_2_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_3_2_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_3_2_1_0; }
		
		//('['
		//       (ownedKeys+=KeyAxiom |
		//        ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		//        ownedRelationRestrictions+=RelationRestrictionAxiom)*
		//       ('enumerates' enumeratedInstances+=[ConceptInstance|Ref] (',' enumeratedInstances+=[ConceptInstance|Ref])*)?
		//   ']')?
		public Group getGroup_4() { return cGroup_4; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_4_0() { return cLeftSquareBracketKeyword_4_0; }
		
		//(ownedKeys+=KeyAxiom |
		// ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		// ownedRelationRestrictions+=RelationRestrictionAxiom)*
		public Alternatives getAlternatives_4_1() { return cAlternatives_4_1; }
		
		//ownedKeys+=KeyAxiom
		public Assignment getOwnedKeysAssignment_4_1_0() { return cOwnedKeysAssignment_4_1_0; }
		
		//KeyAxiom
		public RuleCall getOwnedKeysKeyAxiomParserRuleCall_4_1_0_0() { return cOwnedKeysKeyAxiomParserRuleCall_4_1_0_0; }
		
		//ownedPropertyRestrictions+=PropertyRestrictionAxiom
		public Assignment getOwnedPropertyRestrictionsAssignment_4_1_1() { return cOwnedPropertyRestrictionsAssignment_4_1_1; }
		
		//PropertyRestrictionAxiom
		public RuleCall getOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_4_1_1_0() { return cOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_4_1_1_0; }
		
		//ownedRelationRestrictions+=RelationRestrictionAxiom
		public Assignment getOwnedRelationRestrictionsAssignment_4_1_2() { return cOwnedRelationRestrictionsAssignment_4_1_2; }
		
		//RelationRestrictionAxiom
		public RuleCall getOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_4_1_2_0() { return cOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_4_1_2_0; }
		
		//('enumerates' enumeratedInstances+=[ConceptInstance|Ref] (',' enumeratedInstances+=[ConceptInstance|Ref])*)?
		public Group getGroup_4_2() { return cGroup_4_2; }
		
		//'enumerates'
		public Keyword getEnumeratesKeyword_4_2_0() { return cEnumeratesKeyword_4_2_0; }
		
		//enumeratedInstances+=[ConceptInstance|Ref]
		public Assignment getEnumeratedInstancesAssignment_4_2_1() { return cEnumeratedInstancesAssignment_4_2_1; }
		
		//[ConceptInstance|Ref]
		public CrossReference getEnumeratedInstancesConceptInstanceCrossReference_4_2_1_0() { return cEnumeratedInstancesConceptInstanceCrossReference_4_2_1_0; }
		
		//Ref
		public RuleCall getEnumeratedInstancesConceptInstanceRefParserRuleCall_4_2_1_0_1() { return cEnumeratedInstancesConceptInstanceRefParserRuleCall_4_2_1_0_1; }
		
		//(',' enumeratedInstances+=[ConceptInstance|Ref])*
		public Group getGroup_4_2_2() { return cGroup_4_2_2; }
		
		//','
		public Keyword getCommaKeyword_4_2_2_0() { return cCommaKeyword_4_2_2_0; }
		
		//enumeratedInstances+=[ConceptInstance|Ref]
		public Assignment getEnumeratedInstancesAssignment_4_2_2_1() { return cEnumeratedInstancesAssignment_4_2_2_1; }
		
		//[ConceptInstance|Ref]
		public CrossReference getEnumeratedInstancesConceptInstanceCrossReference_4_2_2_1_0() { return cEnumeratedInstancesConceptInstanceCrossReference_4_2_2_1_0; }
		
		//Ref
		public RuleCall getEnumeratedInstancesConceptInstanceRefParserRuleCall_4_2_2_1_0_1() { return cEnumeratedInstancesConceptInstanceRefParserRuleCall_4_2_2_1_0_1; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_4_3() { return cRightSquareBracketKeyword_4_3; }
	}
	public class RelationEntityElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.RelationEntity");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cRelationKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cEntityKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cNameAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cNameIDTerminalRuleCall_3_0 = (RuleCall)cNameAssignment_3.eContents().get(0);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cColonGreaterThanSignKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0 = (RuleCall)cOwnedSpecializationsAssignment_4_1.eContents().get(0);
		private final Group cGroup_4_2 = (Group)cGroup_4.eContents().get(2);
		private final Keyword cCommaKeyword_4_2_0 = (Keyword)cGroup_4_2.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_4_2_1 = (Assignment)cGroup_4_2.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0 = (RuleCall)cOwnedSpecializationsAssignment_4_2_1.eContents().get(0);
		private final Keyword cLeftSquareBracketKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Keyword cFromKeyword_6 = (Keyword)cGroup.eContents().get(6);
		private final Assignment cSourceAssignment_7 = (Assignment)cGroup.eContents().get(7);
		private final CrossReference cSourceEntityCrossReference_7_0 = (CrossReference)cSourceAssignment_7.eContents().get(0);
		private final RuleCall cSourceEntityRefParserRuleCall_7_0_1 = (RuleCall)cSourceEntityCrossReference_7_0.eContents().get(1);
		private final Keyword cToKeyword_8 = (Keyword)cGroup.eContents().get(8);
		private final Assignment cTargetAssignment_9 = (Assignment)cGroup.eContents().get(9);
		private final CrossReference cTargetEntityCrossReference_9_0 = (CrossReference)cTargetAssignment_9.eContents().get(0);
		private final RuleCall cTargetEntityRefParserRuleCall_9_0_1 = (RuleCall)cTargetEntityCrossReference_9_0.eContents().get(1);
		private final UnorderedGroup cUnorderedGroup_10 = (UnorderedGroup)cGroup.eContents().get(10);
		private final Assignment cForwardRelationAssignment_10_0 = (Assignment)cUnorderedGroup_10.eContents().get(0);
		private final RuleCall cForwardRelationForwardRelationParserRuleCall_10_0_0 = (RuleCall)cForwardRelationAssignment_10_0.eContents().get(0);
		private final Assignment cReverseRelationAssignment_10_1 = (Assignment)cUnorderedGroup_10.eContents().get(1);
		private final RuleCall cReverseRelationReverseRelationParserRuleCall_10_1_0 = (RuleCall)cReverseRelationAssignment_10_1.eContents().get(0);
		private final UnorderedGroup cUnorderedGroup_11 = (UnorderedGroup)cGroup.eContents().get(11);
		private final Assignment cFunctionalAssignment_11_0 = (Assignment)cUnorderedGroup_11.eContents().get(0);
		private final Keyword cFunctionalFunctionalKeyword_11_0_0 = (Keyword)cFunctionalAssignment_11_0.eContents().get(0);
		private final Group cGroup_11_1 = (Group)cUnorderedGroup_11.eContents().get(1);
		private final Assignment cInverseFunctionalAssignment_11_1_0 = (Assignment)cGroup_11_1.eContents().get(0);
		private final Keyword cInverseFunctionalInverseKeyword_11_1_0_0 = (Keyword)cInverseFunctionalAssignment_11_1_0.eContents().get(0);
		private final Keyword cFunctionalKeyword_11_1_1 = (Keyword)cGroup_11_1.eContents().get(1);
		private final Assignment cSymmetricAssignment_11_2 = (Assignment)cUnorderedGroup_11.eContents().get(2);
		private final Keyword cSymmetricSymmetricKeyword_11_2_0 = (Keyword)cSymmetricAssignment_11_2.eContents().get(0);
		private final Assignment cAsymmetricAssignment_11_3 = (Assignment)cUnorderedGroup_11.eContents().get(3);
		private final Keyword cAsymmetricAsymmetricKeyword_11_3_0 = (Keyword)cAsymmetricAssignment_11_3.eContents().get(0);
		private final Assignment cReflexiveAssignment_11_4 = (Assignment)cUnorderedGroup_11.eContents().get(4);
		private final Keyword cReflexiveReflexiveKeyword_11_4_0 = (Keyword)cReflexiveAssignment_11_4.eContents().get(0);
		private final Assignment cIrreflexiveAssignment_11_5 = (Assignment)cUnorderedGroup_11.eContents().get(5);
		private final Keyword cIrreflexiveIrreflexiveKeyword_11_5_0 = (Keyword)cIrreflexiveAssignment_11_5.eContents().get(0);
		private final Assignment cTransitiveAssignment_11_6 = (Assignment)cUnorderedGroup_11.eContents().get(6);
		private final Keyword cTransitiveTransitiveKeyword_11_6_0 = (Keyword)cTransitiveAssignment_11_6.eContents().get(0);
		private final Alternatives cAlternatives_12 = (Alternatives)cGroup.eContents().get(12);
		private final Assignment cOwnedKeysAssignment_12_0 = (Assignment)cAlternatives_12.eContents().get(0);
		private final RuleCall cOwnedKeysKeyAxiomParserRuleCall_12_0_0 = (RuleCall)cOwnedKeysAssignment_12_0.eContents().get(0);
		private final Assignment cOwnedPropertyRestrictionsAssignment_12_1 = (Assignment)cAlternatives_12.eContents().get(1);
		private final RuleCall cOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_12_1_0 = (RuleCall)cOwnedPropertyRestrictionsAssignment_12_1.eContents().get(0);
		private final Assignment cOwnedRelationRestrictionsAssignment_12_2 = (Assignment)cAlternatives_12.eContents().get(2);
		private final RuleCall cOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_12_2_0 = (RuleCall)cOwnedRelationRestrictionsAssignment_12_2.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_13 = (Keyword)cGroup.eContents().get(13);
		
		//RelationEntity:
		//    ownedAnnotations+=Annotation*
		//    'relation' 'entity' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? '['
		//        'from' source=[Entity|Ref]
		//        'to' target=[Entity|Ref]
		//        ((forwardRelation=ForwardRelation)? &
		//         (reverseRelation=ReverseRelation)?)
		//        ((functional?='functional')? &
		//         (inverseFunctional?='inverse' 'functional')? &
		//         (symmetric?='symmetric')? &
		//         (asymmetric?='asymmetric')? &
		//         (reflexive?='reflexive')? &
		//         (irreflexive?='irreflexive')? &
		//         (transitive?='transitive')?)
		//        (ownedKeys+=KeyAxiom |
		//         ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		//         ownedRelationRestrictions+=RelationRestrictionAxiom)*
		//    ']';
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'relation' 'entity' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? '['
		//    'from' source=[Entity|Ref]
		//    'to' target=[Entity|Ref]
		//    ((forwardRelation=ForwardRelation)? &
		//     (reverseRelation=ReverseRelation)?)
		//    ((functional?='functional')? &
		//     (inverseFunctional?='inverse' 'functional')? &
		//     (symmetric?='symmetric')? &
		//     (asymmetric?='asymmetric')? &
		//     (reflexive?='reflexive')? &
		//     (irreflexive?='irreflexive')? &
		//     (transitive?='transitive')?)
		//    (ownedKeys+=KeyAxiom |
		//     ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		//     ownedRelationRestrictions+=RelationRestrictionAxiom)*
		//']'
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'relation'
		public Keyword getRelationKeyword_1() { return cRelationKeyword_1; }
		
		//'entity'
		public Keyword getEntityKeyword_2() { return cEntityKeyword_2; }
		
		//name=ID
		public Assignment getNameAssignment_3() { return cNameAssignment_3; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_3_0() { return cNameIDTerminalRuleCall_3_0; }
		
		//(':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup_4() { return cGroup_4; }
		
		//':>'
		public Keyword getColonGreaterThanSignKeyword_4_0() { return cColonGreaterThanSignKeyword_4_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_4_1() { return cOwnedSpecializationsAssignment_4_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0; }
		
		//(',' ownedSpecializations+=SpecializationAxiom)*
		public Group getGroup_4_2() { return cGroup_4_2; }
		
		//','
		public Keyword getCommaKeyword_4_2_0() { return cCommaKeyword_4_2_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_4_2_1() { return cOwnedSpecializationsAssignment_4_2_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_5() { return cLeftSquareBracketKeyword_5; }
		
		//'from'
		public Keyword getFromKeyword_6() { return cFromKeyword_6; }
		
		//source=[Entity|Ref]
		public Assignment getSourceAssignment_7() { return cSourceAssignment_7; }
		
		//[Entity|Ref]
		public CrossReference getSourceEntityCrossReference_7_0() { return cSourceEntityCrossReference_7_0; }
		
		//Ref
		public RuleCall getSourceEntityRefParserRuleCall_7_0_1() { return cSourceEntityRefParserRuleCall_7_0_1; }
		
		//'to'
		public Keyword getToKeyword_8() { return cToKeyword_8; }
		
		//target=[Entity|Ref]
		public Assignment getTargetAssignment_9() { return cTargetAssignment_9; }
		
		//[Entity|Ref]
		public CrossReference getTargetEntityCrossReference_9_0() { return cTargetEntityCrossReference_9_0; }
		
		//Ref
		public RuleCall getTargetEntityRefParserRuleCall_9_0_1() { return cTargetEntityRefParserRuleCall_9_0_1; }
		
		//((forwardRelation=ForwardRelation)? &
		// (reverseRelation=ReverseRelation)?)
		public UnorderedGroup getUnorderedGroup_10() { return cUnorderedGroup_10; }
		
		//(forwardRelation=ForwardRelation)?
		public Assignment getForwardRelationAssignment_10_0() { return cForwardRelationAssignment_10_0; }
		
		//ForwardRelation
		public RuleCall getForwardRelationForwardRelationParserRuleCall_10_0_0() { return cForwardRelationForwardRelationParserRuleCall_10_0_0; }
		
		//(reverseRelation=ReverseRelation)?
		public Assignment getReverseRelationAssignment_10_1() { return cReverseRelationAssignment_10_1; }
		
		//ReverseRelation
		public RuleCall getReverseRelationReverseRelationParserRuleCall_10_1_0() { return cReverseRelationReverseRelationParserRuleCall_10_1_0; }
		
		//((functional?='functional')? &
		// (inverseFunctional?='inverse' 'functional')? &
		// (symmetric?='symmetric')? &
		// (asymmetric?='asymmetric')? &
		// (reflexive?='reflexive')? &
		// (irreflexive?='irreflexive')? &
		// (transitive?='transitive')?)
		public UnorderedGroup getUnorderedGroup_11() { return cUnorderedGroup_11; }
		
		//(functional?='functional')?
		public Assignment getFunctionalAssignment_11_0() { return cFunctionalAssignment_11_0; }
		
		//'functional'
		public Keyword getFunctionalFunctionalKeyword_11_0_0() { return cFunctionalFunctionalKeyword_11_0_0; }
		
		//(inverseFunctional?='inverse' 'functional')?
		public Group getGroup_11_1() { return cGroup_11_1; }
		
		//inverseFunctional?='inverse'
		public Assignment getInverseFunctionalAssignment_11_1_0() { return cInverseFunctionalAssignment_11_1_0; }
		
		//'inverse'
		public Keyword getInverseFunctionalInverseKeyword_11_1_0_0() { return cInverseFunctionalInverseKeyword_11_1_0_0; }
		
		//'functional'
		public Keyword getFunctionalKeyword_11_1_1() { return cFunctionalKeyword_11_1_1; }
		
		//(symmetric?='symmetric')?
		public Assignment getSymmetricAssignment_11_2() { return cSymmetricAssignment_11_2; }
		
		//'symmetric'
		public Keyword getSymmetricSymmetricKeyword_11_2_0() { return cSymmetricSymmetricKeyword_11_2_0; }
		
		//(asymmetric?='asymmetric')?
		public Assignment getAsymmetricAssignment_11_3() { return cAsymmetricAssignment_11_3; }
		
		//'asymmetric'
		public Keyword getAsymmetricAsymmetricKeyword_11_3_0() { return cAsymmetricAsymmetricKeyword_11_3_0; }
		
		//(reflexive?='reflexive')?
		public Assignment getReflexiveAssignment_11_4() { return cReflexiveAssignment_11_4; }
		
		//'reflexive'
		public Keyword getReflexiveReflexiveKeyword_11_4_0() { return cReflexiveReflexiveKeyword_11_4_0; }
		
		//(irreflexive?='irreflexive')?
		public Assignment getIrreflexiveAssignment_11_5() { return cIrreflexiveAssignment_11_5; }
		
		//'irreflexive'
		public Keyword getIrreflexiveIrreflexiveKeyword_11_5_0() { return cIrreflexiveIrreflexiveKeyword_11_5_0; }
		
		//(transitive?='transitive')?
		public Assignment getTransitiveAssignment_11_6() { return cTransitiveAssignment_11_6; }
		
		//'transitive'
		public Keyword getTransitiveTransitiveKeyword_11_6_0() { return cTransitiveTransitiveKeyword_11_6_0; }
		
		//(ownedKeys+=KeyAxiom |
		// ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		// ownedRelationRestrictions+=RelationRestrictionAxiom)*
		public Alternatives getAlternatives_12() { return cAlternatives_12; }
		
		//ownedKeys+=KeyAxiom
		public Assignment getOwnedKeysAssignment_12_0() { return cOwnedKeysAssignment_12_0; }
		
		//KeyAxiom
		public RuleCall getOwnedKeysKeyAxiomParserRuleCall_12_0_0() { return cOwnedKeysKeyAxiomParserRuleCall_12_0_0; }
		
		//ownedPropertyRestrictions+=PropertyRestrictionAxiom
		public Assignment getOwnedPropertyRestrictionsAssignment_12_1() { return cOwnedPropertyRestrictionsAssignment_12_1; }
		
		//PropertyRestrictionAxiom
		public RuleCall getOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_12_1_0() { return cOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_12_1_0; }
		
		//ownedRelationRestrictions+=RelationRestrictionAxiom
		public Assignment getOwnedRelationRestrictionsAssignment_12_2() { return cOwnedRelationRestrictionsAssignment_12_2; }
		
		//RelationRestrictionAxiom
		public RuleCall getOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_12_2_0() { return cOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_12_2_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_13() { return cRightSquareBracketKeyword_13; }
	}
	public class StructureElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Structure");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cStructureKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNameIDTerminalRuleCall_2_0 = (RuleCall)cNameAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cColonGreaterThanSignKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_3_1_0 = (RuleCall)cOwnedSpecializationsAssignment_3_1.eContents().get(0);
		private final Group cGroup_3_2 = (Group)cGroup_3.eContents().get(2);
		private final Keyword cCommaKeyword_3_2_0 = (Keyword)cGroup_3_2.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_3_2_1 = (Assignment)cGroup_3_2.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_3_2_1_0 = (RuleCall)cOwnedSpecializationsAssignment_3_2_1.eContents().get(0);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cLeftSquareBracketKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Assignment cOwnedPropertyRestrictionsAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final RuleCall cOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_4_1_0 = (RuleCall)cOwnedPropertyRestrictionsAssignment_4_1.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_4_2 = (Keyword)cGroup_4.eContents().get(2);
		
		//Structure:
		//    ownedAnnotations+=Annotation*
		//    'structure' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//        ownedPropertyRestrictions+=PropertyRestrictionAxiom*
		//    ']')?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'structure' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//    ownedPropertyRestrictions+=PropertyRestrictionAxiom*
		//']')?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'structure'
		public Keyword getStructureKeyword_1() { return cStructureKeyword_1; }
		
		//name=ID
		public Assignment getNameAssignment_2() { return cNameAssignment_2; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_2_0() { return cNameIDTerminalRuleCall_2_0; }
		
		//(':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup_3() { return cGroup_3; }
		
		//':>'
		public Keyword getColonGreaterThanSignKeyword_3_0() { return cColonGreaterThanSignKeyword_3_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_3_1() { return cOwnedSpecializationsAssignment_3_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_3_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_3_1_0; }
		
		//(',' ownedSpecializations+=SpecializationAxiom)*
		public Group getGroup_3_2() { return cGroup_3_2; }
		
		//','
		public Keyword getCommaKeyword_3_2_0() { return cCommaKeyword_3_2_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_3_2_1() { return cOwnedSpecializationsAssignment_3_2_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_3_2_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_3_2_1_0; }
		
		//('['
		//       ownedPropertyRestrictions+=PropertyRestrictionAxiom*
		//   ']')?
		public Group getGroup_4() { return cGroup_4; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_4_0() { return cLeftSquareBracketKeyword_4_0; }
		
		//ownedPropertyRestrictions+=PropertyRestrictionAxiom*
		public Assignment getOwnedPropertyRestrictionsAssignment_4_1() { return cOwnedPropertyRestrictionsAssignment_4_1; }
		
		//PropertyRestrictionAxiom
		public RuleCall getOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_4_1_0() { return cOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_4_1_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_4_2() { return cRightSquareBracketKeyword_4_2; }
	}
	public class FeatureElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Feature");
		private final RuleCall cPropertyParserRuleCall = (RuleCall)rule.eContents().get(1);
		
		//Feature:
		//    Property;
		@Override public ParserRule getRule() { return rule; }
		
		//Property
		public RuleCall getPropertyParserRuleCall() { return cPropertyParserRuleCall; }
	}
	public class PropertyElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Property");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cAnnotationPropertyParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cSemanticPropertyParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//Property:
		//    AnnotationProperty |
		//    SemanticProperty;
		@Override public ParserRule getRule() { return rule; }
		
		//AnnotationProperty |
		//SemanticProperty
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//AnnotationProperty
		public RuleCall getAnnotationPropertyParserRuleCall_0() { return cAnnotationPropertyParserRuleCall_0; }
		
		//SemanticProperty
		public RuleCall getSemanticPropertyParserRuleCall_1() { return cSemanticPropertyParserRuleCall_1; }
	}
	public class AnnotationPropertyElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.AnnotationProperty");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cAnnotationKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cPropertyKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cNameAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cNameIDTerminalRuleCall_3_0 = (RuleCall)cNameAssignment_3.eContents().get(0);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cColonGreaterThanSignKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0 = (RuleCall)cOwnedSpecializationsAssignment_4_1.eContents().get(0);
		private final Group cGroup_4_2 = (Group)cGroup_4.eContents().get(2);
		private final Keyword cCommaKeyword_4_2_0 = (Keyword)cGroup_4_2.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_4_2_1 = (Assignment)cGroup_4_2.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0 = (RuleCall)cOwnedSpecializationsAssignment_4_2_1.eContents().get(0);
		
		//AnnotationProperty:
		//    ownedAnnotations+=Annotation*
		//    'annotation' 'property' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'annotation' 'property' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'annotation'
		public Keyword getAnnotationKeyword_1() { return cAnnotationKeyword_1; }
		
		//'property'
		public Keyword getPropertyKeyword_2() { return cPropertyKeyword_2; }
		
		//name=ID
		public Assignment getNameAssignment_3() { return cNameAssignment_3; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_3_0() { return cNameIDTerminalRuleCall_3_0; }
		
		//(':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup_4() { return cGroup_4; }
		
		//':>'
		public Keyword getColonGreaterThanSignKeyword_4_0() { return cColonGreaterThanSignKeyword_4_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_4_1() { return cOwnedSpecializationsAssignment_4_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0; }
		
		//(',' ownedSpecializations+=SpecializationAxiom)*
		public Group getGroup_4_2() { return cGroup_4_2; }
		
		//','
		public Keyword getCommaKeyword_4_2_0() { return cCommaKeyword_4_2_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_4_2_1() { return cOwnedSpecializationsAssignment_4_2_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0; }
	}
	public class SemanticPropertyElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.SemanticProperty");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cScalarPropertyParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cStructuredPropertyParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//SemanticProperty:
		//    ScalarProperty |
		//    StructuredProperty;
		@Override public ParserRule getRule() { return rule; }
		
		//ScalarProperty |
		//StructuredProperty
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//ScalarProperty
		public RuleCall getScalarPropertyParserRuleCall_0() { return cScalarPropertyParserRuleCall_0; }
		
		//StructuredProperty
		public RuleCall getStructuredPropertyParserRuleCall_1() { return cStructuredPropertyParserRuleCall_1; }
	}
	public class ScalarPropertyElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.ScalarProperty");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cScalarKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cPropertyKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cNameAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cNameIDTerminalRuleCall_3_0 = (RuleCall)cNameAssignment_3.eContents().get(0);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cColonGreaterThanSignKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0 = (RuleCall)cOwnedSpecializationsAssignment_4_1.eContents().get(0);
		private final Group cGroup_4_2 = (Group)cGroup_4.eContents().get(2);
		private final Keyword cCommaKeyword_4_2_0 = (Keyword)cGroup_4_2.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_4_2_1 = (Assignment)cGroup_4_2.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0 = (RuleCall)cOwnedSpecializationsAssignment_4_2_1.eContents().get(0);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cLeftSquareBracketKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Keyword cDomainKeyword_5_1 = (Keyword)cGroup_5.eContents().get(1);
		private final Assignment cDomainAssignment_5_2 = (Assignment)cGroup_5.eContents().get(2);
		private final CrossReference cDomainClassifierCrossReference_5_2_0 = (CrossReference)cDomainAssignment_5_2.eContents().get(0);
		private final RuleCall cDomainClassifierRefParserRuleCall_5_2_0_1 = (RuleCall)cDomainClassifierCrossReference_5_2_0.eContents().get(1);
		private final Keyword cRangeKeyword_5_3 = (Keyword)cGroup_5.eContents().get(3);
		private final Assignment cRangeAssignment_5_4 = (Assignment)cGroup_5.eContents().get(4);
		private final CrossReference cRangeScalarCrossReference_5_4_0 = (CrossReference)cRangeAssignment_5_4.eContents().get(0);
		private final RuleCall cRangeScalarRefParserRuleCall_5_4_0_1 = (RuleCall)cRangeScalarCrossReference_5_4_0.eContents().get(1);
		private final Assignment cFunctionalAssignment_5_5 = (Assignment)cGroup_5.eContents().get(5);
		private final Keyword cFunctionalFunctionalKeyword_5_5_0 = (Keyword)cFunctionalAssignment_5_5.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_5_6 = (Keyword)cGroup_5.eContents().get(6);
		
		//ScalarProperty:
		//    ownedAnnotations+=Annotation*
		//    'scalar' 'property' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//        'domain' domain=[Classifier|Ref]
		//        'range' range=[Scalar|Ref]
		//        (functional?='functional')?
		//    ']')?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'scalar' 'property' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//    'domain' domain=[Classifier|Ref]
		//    'range' range=[Scalar|Ref]
		//    (functional?='functional')?
		//']')?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'scalar'
		public Keyword getScalarKeyword_1() { return cScalarKeyword_1; }
		
		//'property'
		public Keyword getPropertyKeyword_2() { return cPropertyKeyword_2; }
		
		//name=ID
		public Assignment getNameAssignment_3() { return cNameAssignment_3; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_3_0() { return cNameIDTerminalRuleCall_3_0; }
		
		//(':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup_4() { return cGroup_4; }
		
		//':>'
		public Keyword getColonGreaterThanSignKeyword_4_0() { return cColonGreaterThanSignKeyword_4_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_4_1() { return cOwnedSpecializationsAssignment_4_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0; }
		
		//(',' ownedSpecializations+=SpecializationAxiom)*
		public Group getGroup_4_2() { return cGroup_4_2; }
		
		//','
		public Keyword getCommaKeyword_4_2_0() { return cCommaKeyword_4_2_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_4_2_1() { return cOwnedSpecializationsAssignment_4_2_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0; }
		
		//('['
		//       'domain' domain=[Classifier|Ref]
		//       'range' range=[Scalar|Ref]
		//       (functional?='functional')?
		//   ']')?
		public Group getGroup_5() { return cGroup_5; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_5_0() { return cLeftSquareBracketKeyword_5_0; }
		
		//'domain'
		public Keyword getDomainKeyword_5_1() { return cDomainKeyword_5_1; }
		
		//domain=[Classifier|Ref]
		public Assignment getDomainAssignment_5_2() { return cDomainAssignment_5_2; }
		
		//[Classifier|Ref]
		public CrossReference getDomainClassifierCrossReference_5_2_0() { return cDomainClassifierCrossReference_5_2_0; }
		
		//Ref
		public RuleCall getDomainClassifierRefParserRuleCall_5_2_0_1() { return cDomainClassifierRefParserRuleCall_5_2_0_1; }
		
		//'range'
		public Keyword getRangeKeyword_5_3() { return cRangeKeyword_5_3; }
		
		//range=[Scalar|Ref]
		public Assignment getRangeAssignment_5_4() { return cRangeAssignment_5_4; }
		
		//[Scalar|Ref]
		public CrossReference getRangeScalarCrossReference_5_4_0() { return cRangeScalarCrossReference_5_4_0; }
		
		//Ref
		public RuleCall getRangeScalarRefParserRuleCall_5_4_0_1() { return cRangeScalarRefParserRuleCall_5_4_0_1; }
		
		//(functional?='functional')?
		public Assignment getFunctionalAssignment_5_5() { return cFunctionalAssignment_5_5; }
		
		//'functional'
		public Keyword getFunctionalFunctionalKeyword_5_5_0() { return cFunctionalFunctionalKeyword_5_5_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_5_6() { return cRightSquareBracketKeyword_5_6; }
	}
	public class StructuredPropertyElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.StructuredProperty");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cStructuredKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cPropertyKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cNameAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cNameIDTerminalRuleCall_3_0 = (RuleCall)cNameAssignment_3.eContents().get(0);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cColonGreaterThanSignKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0 = (RuleCall)cOwnedSpecializationsAssignment_4_1.eContents().get(0);
		private final Group cGroup_4_2 = (Group)cGroup_4.eContents().get(2);
		private final Keyword cCommaKeyword_4_2_0 = (Keyword)cGroup_4_2.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_4_2_1 = (Assignment)cGroup_4_2.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0 = (RuleCall)cOwnedSpecializationsAssignment_4_2_1.eContents().get(0);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cLeftSquareBracketKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Keyword cDomainKeyword_5_1 = (Keyword)cGroup_5.eContents().get(1);
		private final Assignment cDomainAssignment_5_2 = (Assignment)cGroup_5.eContents().get(2);
		private final CrossReference cDomainClassifierCrossReference_5_2_0 = (CrossReference)cDomainAssignment_5_2.eContents().get(0);
		private final RuleCall cDomainClassifierRefParserRuleCall_5_2_0_1 = (RuleCall)cDomainClassifierCrossReference_5_2_0.eContents().get(1);
		private final Keyword cRangeKeyword_5_3 = (Keyword)cGroup_5.eContents().get(3);
		private final Assignment cRangeAssignment_5_4 = (Assignment)cGroup_5.eContents().get(4);
		private final CrossReference cRangeStructureCrossReference_5_4_0 = (CrossReference)cRangeAssignment_5_4.eContents().get(0);
		private final RuleCall cRangeStructureRefParserRuleCall_5_4_0_1 = (RuleCall)cRangeStructureCrossReference_5_4_0.eContents().get(1);
		private final Assignment cFunctionalAssignment_5_5 = (Assignment)cGroup_5.eContents().get(5);
		private final Keyword cFunctionalFunctionalKeyword_5_5_0 = (Keyword)cFunctionalAssignment_5_5.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_5_6 = (Keyword)cGroup_5.eContents().get(6);
		
		//StructuredProperty:
		//    ownedAnnotations+=Annotation*
		//    'structured' 'property' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//        'domain' domain=[Classifier|Ref]
		//        'range' range=[Structure|Ref]
		//        (functional?='functional')?
		//    ']')?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'structured' 'property' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//    'domain' domain=[Classifier|Ref]
		//    'range' range=[Structure|Ref]
		//    (functional?='functional')?
		//']')?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'structured'
		public Keyword getStructuredKeyword_1() { return cStructuredKeyword_1; }
		
		//'property'
		public Keyword getPropertyKeyword_2() { return cPropertyKeyword_2; }
		
		//name=ID
		public Assignment getNameAssignment_3() { return cNameAssignment_3; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_3_0() { return cNameIDTerminalRuleCall_3_0; }
		
		//(':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup_4() { return cGroup_4; }
		
		//':>'
		public Keyword getColonGreaterThanSignKeyword_4_0() { return cColonGreaterThanSignKeyword_4_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_4_1() { return cOwnedSpecializationsAssignment_4_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0; }
		
		//(',' ownedSpecializations+=SpecializationAxiom)*
		public Group getGroup_4_2() { return cGroup_4_2; }
		
		//','
		public Keyword getCommaKeyword_4_2_0() { return cCommaKeyword_4_2_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_4_2_1() { return cOwnedSpecializationsAssignment_4_2_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0; }
		
		//('['
		//       'domain' domain=[Classifier|Ref]
		//       'range' range=[Structure|Ref]
		//       (functional?='functional')?
		//   ']')?
		public Group getGroup_5() { return cGroup_5; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_5_0() { return cLeftSquareBracketKeyword_5_0; }
		
		//'domain'
		public Keyword getDomainKeyword_5_1() { return cDomainKeyword_5_1; }
		
		//domain=[Classifier|Ref]
		public Assignment getDomainAssignment_5_2() { return cDomainAssignment_5_2; }
		
		//[Classifier|Ref]
		public CrossReference getDomainClassifierCrossReference_5_2_0() { return cDomainClassifierCrossReference_5_2_0; }
		
		//Ref
		public RuleCall getDomainClassifierRefParserRuleCall_5_2_0_1() { return cDomainClassifierRefParserRuleCall_5_2_0_1; }
		
		//'range'
		public Keyword getRangeKeyword_5_3() { return cRangeKeyword_5_3; }
		
		//range=[Structure|Ref]
		public Assignment getRangeAssignment_5_4() { return cRangeAssignment_5_4; }
		
		//[Structure|Ref]
		public CrossReference getRangeStructureCrossReference_5_4_0() { return cRangeStructureCrossReference_5_4_0; }
		
		//Ref
		public RuleCall getRangeStructureRefParserRuleCall_5_4_0_1() { return cRangeStructureRefParserRuleCall_5_4_0_1; }
		
		//(functional?='functional')?
		public Assignment getFunctionalAssignment_5_5() { return cFunctionalAssignment_5_5; }
		
		//'functional'
		public Keyword getFunctionalFunctionalKeyword_5_5_0() { return cFunctionalFunctionalKeyword_5_5_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_5_6() { return cRightSquareBracketKeyword_5_6; }
	}
	public class ScalarElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Scalar");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cFacetedScalarParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cEnumeratedScalarParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//Scalar:
		//    FacetedScalar |
		//    EnumeratedScalar;
		@Override public ParserRule getRule() { return rule; }
		
		//FacetedScalar |
		//EnumeratedScalar
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//FacetedScalar
		public RuleCall getFacetedScalarParserRuleCall_0() { return cFacetedScalarParserRuleCall_0; }
		
		//EnumeratedScalar
		public RuleCall getEnumeratedScalarParserRuleCall_1() { return cEnumeratedScalarParserRuleCall_1; }
	}
	public class FacetedScalarElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.FacetedScalar");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cScalarKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNameIDTerminalRuleCall_2_0 = (RuleCall)cNameAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cColonGreaterThanSignKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_3_1_0 = (RuleCall)cOwnedSpecializationsAssignment_3_1.eContents().get(0);
		private final Group cGroup_3_2 = (Group)cGroup_3.eContents().get(2);
		private final Keyword cCommaKeyword_3_2_0 = (Keyword)cGroup_3_2.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_3_2_1 = (Assignment)cGroup_3_2.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_3_2_1_0 = (RuleCall)cOwnedSpecializationsAssignment_3_2_1.eContents().get(0);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cLeftSquareBracketKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final UnorderedGroup cUnorderedGroup_4_1 = (UnorderedGroup)cGroup_4.eContents().get(1);
		private final Group cGroup_4_1_0 = (Group)cUnorderedGroup_4_1.eContents().get(0);
		private final Keyword cLengthKeyword_4_1_0_0 = (Keyword)cGroup_4_1_0.eContents().get(0);
		private final Assignment cLengthAssignment_4_1_0_1 = (Assignment)cGroup_4_1_0.eContents().get(1);
		private final RuleCall cLengthUnsignedIntegerParserRuleCall_4_1_0_1_0 = (RuleCall)cLengthAssignment_4_1_0_1.eContents().get(0);
		private final Group cGroup_4_1_1 = (Group)cUnorderedGroup_4_1.eContents().get(1);
		private final Keyword cMinLengthKeyword_4_1_1_0 = (Keyword)cGroup_4_1_1.eContents().get(0);
		private final Assignment cMinLengthAssignment_4_1_1_1 = (Assignment)cGroup_4_1_1.eContents().get(1);
		private final RuleCall cMinLengthUnsignedIntegerParserRuleCall_4_1_1_1_0 = (RuleCall)cMinLengthAssignment_4_1_1_1.eContents().get(0);
		private final Group cGroup_4_1_2 = (Group)cUnorderedGroup_4_1.eContents().get(2);
		private final Keyword cMaxLengthKeyword_4_1_2_0 = (Keyword)cGroup_4_1_2.eContents().get(0);
		private final Assignment cMaxLengthAssignment_4_1_2_1 = (Assignment)cGroup_4_1_2.eContents().get(1);
		private final RuleCall cMaxLengthUnsignedIntegerParserRuleCall_4_1_2_1_0 = (RuleCall)cMaxLengthAssignment_4_1_2_1.eContents().get(0);
		private final Group cGroup_4_1_3 = (Group)cUnorderedGroup_4_1.eContents().get(3);
		private final Keyword cPatternKeyword_4_1_3_0 = (Keyword)cGroup_4_1_3.eContents().get(0);
		private final Assignment cPatternAssignment_4_1_3_1 = (Assignment)cGroup_4_1_3.eContents().get(1);
		private final RuleCall cPatternSTRINGTerminalRuleCall_4_1_3_1_0 = (RuleCall)cPatternAssignment_4_1_3_1.eContents().get(0);
		private final Group cGroup_4_1_4 = (Group)cUnorderedGroup_4_1.eContents().get(4);
		private final Keyword cLanguageKeyword_4_1_4_0 = (Keyword)cGroup_4_1_4.eContents().get(0);
		private final Assignment cLanguageAssignment_4_1_4_1 = (Assignment)cGroup_4_1_4.eContents().get(1);
		private final RuleCall cLanguageIDTerminalRuleCall_4_1_4_1_0 = (RuleCall)cLanguageAssignment_4_1_4_1.eContents().get(0);
		private final Group cGroup_4_1_5 = (Group)cUnorderedGroup_4_1.eContents().get(5);
		private final Keyword cMinInclusiveKeyword_4_1_5_0 = (Keyword)cGroup_4_1_5.eContents().get(0);
		private final Assignment cMinInclusiveAssignment_4_1_5_1 = (Assignment)cGroup_4_1_5.eContents().get(1);
		private final RuleCall cMinInclusiveLiteralParserRuleCall_4_1_5_1_0 = (RuleCall)cMinInclusiveAssignment_4_1_5_1.eContents().get(0);
		private final Group cGroup_4_1_6 = (Group)cUnorderedGroup_4_1.eContents().get(6);
		private final Keyword cMinExclusiveKeyword_4_1_6_0 = (Keyword)cGroup_4_1_6.eContents().get(0);
		private final Assignment cMinExclusiveAssignment_4_1_6_1 = (Assignment)cGroup_4_1_6.eContents().get(1);
		private final RuleCall cMinExclusiveLiteralParserRuleCall_4_1_6_1_0 = (RuleCall)cMinExclusiveAssignment_4_1_6_1.eContents().get(0);
		private final Group cGroup_4_1_7 = (Group)cUnorderedGroup_4_1.eContents().get(7);
		private final Keyword cMaxInclusiveKeyword_4_1_7_0 = (Keyword)cGroup_4_1_7.eContents().get(0);
		private final Assignment cMaxInclusiveAssignment_4_1_7_1 = (Assignment)cGroup_4_1_7.eContents().get(1);
		private final RuleCall cMaxInclusiveLiteralParserRuleCall_4_1_7_1_0 = (RuleCall)cMaxInclusiveAssignment_4_1_7_1.eContents().get(0);
		private final Group cGroup_4_1_8 = (Group)cUnorderedGroup_4_1.eContents().get(8);
		private final Keyword cMaxExclusiveKeyword_4_1_8_0 = (Keyword)cGroup_4_1_8.eContents().get(0);
		private final Assignment cMaxExclusiveAssignment_4_1_8_1 = (Assignment)cGroup_4_1_8.eContents().get(1);
		private final RuleCall cMaxExclusiveLiteralParserRuleCall_4_1_8_1_0 = (RuleCall)cMaxExclusiveAssignment_4_1_8_1.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_4_2 = (Keyword)cGroup_4.eContents().get(2);
		
		//FacetedScalar:
		//    ownedAnnotations+=Annotation*
		//    'scalar' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//         (('length' length=UnsignedInteger)? &
		//         ('minLength' minLength=UnsignedInteger)? &
		//         ('maxLength' maxLength=UnsignedInteger)? &
		//         ('pattern' pattern=STRING)? &
		//         ('language' language=ID)? &
		//         ('minInclusive' minInclusive=Literal)? &
		//         ('minExclusive' minExclusive=Literal)? &
		//         ('maxInclusive' maxInclusive=Literal)? &
		//         ('maxExclusive' maxExclusive=Literal)?)
		//    ']')?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'scalar' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//     (('length' length=UnsignedInteger)? &
		//     ('minLength' minLength=UnsignedInteger)? &
		//     ('maxLength' maxLength=UnsignedInteger)? &
		//     ('pattern' pattern=STRING)? &
		//     ('language' language=ID)? &
		//     ('minInclusive' minInclusive=Literal)? &
		//     ('minExclusive' minExclusive=Literal)? &
		//     ('maxInclusive' maxInclusive=Literal)? &
		//     ('maxExclusive' maxExclusive=Literal)?)
		//']')?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'scalar'
		public Keyword getScalarKeyword_1() { return cScalarKeyword_1; }
		
		//name=ID
		public Assignment getNameAssignment_2() { return cNameAssignment_2; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_2_0() { return cNameIDTerminalRuleCall_2_0; }
		
		//(':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup_3() { return cGroup_3; }
		
		//':>'
		public Keyword getColonGreaterThanSignKeyword_3_0() { return cColonGreaterThanSignKeyword_3_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_3_1() { return cOwnedSpecializationsAssignment_3_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_3_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_3_1_0; }
		
		//(',' ownedSpecializations+=SpecializationAxiom)*
		public Group getGroup_3_2() { return cGroup_3_2; }
		
		//','
		public Keyword getCommaKeyword_3_2_0() { return cCommaKeyword_3_2_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_3_2_1() { return cOwnedSpecializationsAssignment_3_2_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_3_2_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_3_2_1_0; }
		
		//('['
		//        (('length' length=UnsignedInteger)? &
		//        ('minLength' minLength=UnsignedInteger)? &
		//        ('maxLength' maxLength=UnsignedInteger)? &
		//        ('pattern' pattern=STRING)? &
		//        ('language' language=ID)? &
		//        ('minInclusive' minInclusive=Literal)? &
		//        ('minExclusive' minExclusive=Literal)? &
		//        ('maxInclusive' maxInclusive=Literal)? &
		//        ('maxExclusive' maxExclusive=Literal)?)
		//   ']')?
		public Group getGroup_4() { return cGroup_4; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_4_0() { return cLeftSquareBracketKeyword_4_0; }
		
		//(('length' length=UnsignedInteger)? &
		//('minLength' minLength=UnsignedInteger)? &
		//('maxLength' maxLength=UnsignedInteger)? &
		//('pattern' pattern=STRING)? &
		//('language' language=ID)? &
		//('minInclusive' minInclusive=Literal)? &
		//('minExclusive' minExclusive=Literal)? &
		//('maxInclusive' maxInclusive=Literal)? &
		//('maxExclusive' maxExclusive=Literal)?)
		public UnorderedGroup getUnorderedGroup_4_1() { return cUnorderedGroup_4_1; }
		
		//('length' length=UnsignedInteger)?
		public Group getGroup_4_1_0() { return cGroup_4_1_0; }
		
		//'length'
		public Keyword getLengthKeyword_4_1_0_0() { return cLengthKeyword_4_1_0_0; }
		
		//length=UnsignedInteger
		public Assignment getLengthAssignment_4_1_0_1() { return cLengthAssignment_4_1_0_1; }
		
		//UnsignedInteger
		public RuleCall getLengthUnsignedIntegerParserRuleCall_4_1_0_1_0() { return cLengthUnsignedIntegerParserRuleCall_4_1_0_1_0; }
		
		//('minLength' minLength=UnsignedInteger)?
		public Group getGroup_4_1_1() { return cGroup_4_1_1; }
		
		//'minLength'
		public Keyword getMinLengthKeyword_4_1_1_0() { return cMinLengthKeyword_4_1_1_0; }
		
		//minLength=UnsignedInteger
		public Assignment getMinLengthAssignment_4_1_1_1() { return cMinLengthAssignment_4_1_1_1; }
		
		//UnsignedInteger
		public RuleCall getMinLengthUnsignedIntegerParserRuleCall_4_1_1_1_0() { return cMinLengthUnsignedIntegerParserRuleCall_4_1_1_1_0; }
		
		//('maxLength' maxLength=UnsignedInteger)?
		public Group getGroup_4_1_2() { return cGroup_4_1_2; }
		
		//'maxLength'
		public Keyword getMaxLengthKeyword_4_1_2_0() { return cMaxLengthKeyword_4_1_2_0; }
		
		//maxLength=UnsignedInteger
		public Assignment getMaxLengthAssignment_4_1_2_1() { return cMaxLengthAssignment_4_1_2_1; }
		
		//UnsignedInteger
		public RuleCall getMaxLengthUnsignedIntegerParserRuleCall_4_1_2_1_0() { return cMaxLengthUnsignedIntegerParserRuleCall_4_1_2_1_0; }
		
		//('pattern' pattern=STRING)?
		public Group getGroup_4_1_3() { return cGroup_4_1_3; }
		
		//'pattern'
		public Keyword getPatternKeyword_4_1_3_0() { return cPatternKeyword_4_1_3_0; }
		
		//pattern=STRING
		public Assignment getPatternAssignment_4_1_3_1() { return cPatternAssignment_4_1_3_1; }
		
		//STRING
		public RuleCall getPatternSTRINGTerminalRuleCall_4_1_3_1_0() { return cPatternSTRINGTerminalRuleCall_4_1_3_1_0; }
		
		//('language' language=ID)?
		public Group getGroup_4_1_4() { return cGroup_4_1_4; }
		
		//'language'
		public Keyword getLanguageKeyword_4_1_4_0() { return cLanguageKeyword_4_1_4_0; }
		
		//language=ID
		public Assignment getLanguageAssignment_4_1_4_1() { return cLanguageAssignment_4_1_4_1; }
		
		//ID
		public RuleCall getLanguageIDTerminalRuleCall_4_1_4_1_0() { return cLanguageIDTerminalRuleCall_4_1_4_1_0; }
		
		//('minInclusive' minInclusive=Literal)?
		public Group getGroup_4_1_5() { return cGroup_4_1_5; }
		
		//'minInclusive'
		public Keyword getMinInclusiveKeyword_4_1_5_0() { return cMinInclusiveKeyword_4_1_5_0; }
		
		//minInclusive=Literal
		public Assignment getMinInclusiveAssignment_4_1_5_1() { return cMinInclusiveAssignment_4_1_5_1; }
		
		//Literal
		public RuleCall getMinInclusiveLiteralParserRuleCall_4_1_5_1_0() { return cMinInclusiveLiteralParserRuleCall_4_1_5_1_0; }
		
		//('minExclusive' minExclusive=Literal)?
		public Group getGroup_4_1_6() { return cGroup_4_1_6; }
		
		//'minExclusive'
		public Keyword getMinExclusiveKeyword_4_1_6_0() { return cMinExclusiveKeyword_4_1_6_0; }
		
		//minExclusive=Literal
		public Assignment getMinExclusiveAssignment_4_1_6_1() { return cMinExclusiveAssignment_4_1_6_1; }
		
		//Literal
		public RuleCall getMinExclusiveLiteralParserRuleCall_4_1_6_1_0() { return cMinExclusiveLiteralParserRuleCall_4_1_6_1_0; }
		
		//('maxInclusive' maxInclusive=Literal)?
		public Group getGroup_4_1_7() { return cGroup_4_1_7; }
		
		//'maxInclusive'
		public Keyword getMaxInclusiveKeyword_4_1_7_0() { return cMaxInclusiveKeyword_4_1_7_0; }
		
		//maxInclusive=Literal
		public Assignment getMaxInclusiveAssignment_4_1_7_1() { return cMaxInclusiveAssignment_4_1_7_1; }
		
		//Literal
		public RuleCall getMaxInclusiveLiteralParserRuleCall_4_1_7_1_0() { return cMaxInclusiveLiteralParserRuleCall_4_1_7_1_0; }
		
		//('maxExclusive' maxExclusive=Literal)?
		public Group getGroup_4_1_8() { return cGroup_4_1_8; }
		
		//'maxExclusive'
		public Keyword getMaxExclusiveKeyword_4_1_8_0() { return cMaxExclusiveKeyword_4_1_8_0; }
		
		//maxExclusive=Literal
		public Assignment getMaxExclusiveAssignment_4_1_8_1() { return cMaxExclusiveAssignment_4_1_8_1; }
		
		//Literal
		public RuleCall getMaxExclusiveLiteralParserRuleCall_4_1_8_1_0() { return cMaxExclusiveLiteralParserRuleCall_4_1_8_1_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_4_2() { return cRightSquareBracketKeyword_4_2; }
	}
	public class EnumeratedScalarElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.EnumeratedScalar");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cEnumeratedKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cScalarKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cNameAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cNameIDTerminalRuleCall_3_0 = (RuleCall)cNameAssignment_3.eContents().get(0);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cColonGreaterThanSignKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0 = (RuleCall)cOwnedSpecializationsAssignment_4_1.eContents().get(0);
		private final Group cGroup_4_2 = (Group)cGroup_4.eContents().get(2);
		private final Keyword cCommaKeyword_4_2_0 = (Keyword)cGroup_4_2.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_4_2_1 = (Assignment)cGroup_4_2.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0 = (RuleCall)cOwnedSpecializationsAssignment_4_2_1.eContents().get(0);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cLeftSquareBracketKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Group cGroup_5_1 = (Group)cGroup_5.eContents().get(1);
		private final Assignment cLiteralsAssignment_5_1_0 = (Assignment)cGroup_5_1.eContents().get(0);
		private final RuleCall cLiteralsLiteralParserRuleCall_5_1_0_0 = (RuleCall)cLiteralsAssignment_5_1_0.eContents().get(0);
		private final Group cGroup_5_1_1 = (Group)cGroup_5_1.eContents().get(1);
		private final Keyword cCommaKeyword_5_1_1_0 = (Keyword)cGroup_5_1_1.eContents().get(0);
		private final Assignment cLiteralsAssignment_5_1_1_1 = (Assignment)cGroup_5_1_1.eContents().get(1);
		private final RuleCall cLiteralsLiteralParserRuleCall_5_1_1_1_0 = (RuleCall)cLiteralsAssignment_5_1_1_1.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_5_2 = (Keyword)cGroup_5.eContents().get(2);
		
		//EnumeratedScalar:
		//    ownedAnnotations+=Annotation*
		//    'enumerated' 'scalar' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//        (literals+=Literal (',' literals+=Literal)*)?
		//    ']')?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'enumerated' 'scalar' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//    (literals+=Literal (',' literals+=Literal)*)?
		//']')?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'enumerated'
		public Keyword getEnumeratedKeyword_1() { return cEnumeratedKeyword_1; }
		
		//'scalar'
		public Keyword getScalarKeyword_2() { return cScalarKeyword_2; }
		
		//name=ID
		public Assignment getNameAssignment_3() { return cNameAssignment_3; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_3_0() { return cNameIDTerminalRuleCall_3_0; }
		
		//(':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup_4() { return cGroup_4; }
		
		//':>'
		public Keyword getColonGreaterThanSignKeyword_4_0() { return cColonGreaterThanSignKeyword_4_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_4_1() { return cOwnedSpecializationsAssignment_4_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0; }
		
		//(',' ownedSpecializations+=SpecializationAxiom)*
		public Group getGroup_4_2() { return cGroup_4_2; }
		
		//','
		public Keyword getCommaKeyword_4_2_0() { return cCommaKeyword_4_2_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_4_2_1() { return cOwnedSpecializationsAssignment_4_2_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0; }
		
		//('['
		//       (literals+=Literal (',' literals+=Literal)*)?
		//   ']')?
		public Group getGroup_5() { return cGroup_5; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_5_0() { return cLeftSquareBracketKeyword_5_0; }
		
		//(literals+=Literal (',' literals+=Literal)*)?
		public Group getGroup_5_1() { return cGroup_5_1; }
		
		//literals+=Literal
		public Assignment getLiteralsAssignment_5_1_0() { return cLiteralsAssignment_5_1_0; }
		
		//Literal
		public RuleCall getLiteralsLiteralParserRuleCall_5_1_0_0() { return cLiteralsLiteralParserRuleCall_5_1_0_0; }
		
		//(',' literals+=Literal)*
		public Group getGroup_5_1_1() { return cGroup_5_1_1; }
		
		//','
		public Keyword getCommaKeyword_5_1_1_0() { return cCommaKeyword_5_1_1_0; }
		
		//literals+=Literal
		public Assignment getLiteralsAssignment_5_1_1_1() { return cLiteralsAssignment_5_1_1_1; }
		
		//Literal
		public RuleCall getLiteralsLiteralParserRuleCall_5_1_1_1_0() { return cLiteralsLiteralParserRuleCall_5_1_1_1_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_5_2() { return cRightSquareBracketKeyword_5_2; }
	}
	public class RelationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Relation");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cForwardRelationParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cReverseRelationParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//Relation:
		//    ForwardRelation |
		//    ReverseRelation;
		@Override public ParserRule getRule() { return rule; }
		
		//ForwardRelation |
		//ReverseRelation
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//ForwardRelation
		public RuleCall getForwardRelationParserRuleCall_0() { return cForwardRelationParserRuleCall_0; }
		
		//ReverseRelation
		public RuleCall getReverseRelationParserRuleCall_1() { return cReverseRelationParserRuleCall_1; }
	}
	public class ForwardRelationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.ForwardRelation");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cForwardKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNameIDTerminalRuleCall_2_0 = (RuleCall)cNameAssignment_2.eContents().get(0);
		
		//ForwardRelation:
		//    ownedAnnotations+=Annotation*
		//    'forward' name=ID;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'forward' name=ID
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'forward'
		public Keyword getForwardKeyword_1() { return cForwardKeyword_1; }
		
		//name=ID
		public Assignment getNameAssignment_2() { return cNameAssignment_2; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_2_0() { return cNameIDTerminalRuleCall_2_0; }
	}
	public class ReverseRelationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.ReverseRelation");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cReverseKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNameIDTerminalRuleCall_2_0 = (RuleCall)cNameAssignment_2.eContents().get(0);
		
		//ReverseRelation:
		//    ownedAnnotations+=Annotation*
		//    'reverse' name=ID;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'reverse' name=ID
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'reverse'
		public Keyword getReverseKeyword_1() { return cReverseKeyword_1; }
		
		//name=ID
		public Assignment getNameAssignment_2() { return cNameAssignment_2; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_2_0() { return cNameIDTerminalRuleCall_2_0; }
	}
	public class RuleElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Rule");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cRuleKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNameIDTerminalRuleCall_2_0 = (RuleCall)cNameAssignment_2.eContents().get(0);
		private final Keyword cLeftSquareBracketKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cAntecedentAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cAntecedentPredicateParserRuleCall_4_0 = (RuleCall)cAntecedentAssignment_4.eContents().get(0);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cCircumflexAccentKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Assignment cAntecedentAssignment_5_1 = (Assignment)cGroup_5.eContents().get(1);
		private final RuleCall cAntecedentPredicateParserRuleCall_5_1_0 = (RuleCall)cAntecedentAssignment_5_1.eContents().get(0);
		private final Keyword cHyphenMinusGreaterThanSignKeyword_6 = (Keyword)cGroup.eContents().get(6);
		private final Assignment cConsequentAssignment_7 = (Assignment)cGroup.eContents().get(7);
		private final RuleCall cConsequentPredicateParserRuleCall_7_0 = (RuleCall)cConsequentAssignment_7.eContents().get(0);
		private final Group cGroup_8 = (Group)cGroup.eContents().get(8);
		private final Keyword cCircumflexAccentKeyword_8_0 = (Keyword)cGroup_8.eContents().get(0);
		private final Assignment cConsequentAssignment_8_1 = (Assignment)cGroup_8.eContents().get(1);
		private final RuleCall cConsequentPredicateParserRuleCall_8_1_0 = (RuleCall)cConsequentAssignment_8_1.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_9 = (Keyword)cGroup.eContents().get(9);
		
		//Rule:
		//    ownedAnnotations+=Annotation*
		//    'rule' name=ID '['
		//        antecedent+=Predicate ('^' antecedent+=Predicate)* '->' consequent+=Predicate ('^' consequent+=Predicate)*
		//    ']';
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'rule' name=ID '['
		//    antecedent+=Predicate ('^' antecedent+=Predicate)* '->' consequent+=Predicate ('^' consequent+=Predicate)*
		//']'
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'rule'
		public Keyword getRuleKeyword_1() { return cRuleKeyword_1; }
		
		//name=ID
		public Assignment getNameAssignment_2() { return cNameAssignment_2; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_2_0() { return cNameIDTerminalRuleCall_2_0; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_3() { return cLeftSquareBracketKeyword_3; }
		
		//antecedent+=Predicate
		public Assignment getAntecedentAssignment_4() { return cAntecedentAssignment_4; }
		
		//Predicate
		public RuleCall getAntecedentPredicateParserRuleCall_4_0() { return cAntecedentPredicateParserRuleCall_4_0; }
		
		//('^' antecedent+=Predicate)*
		public Group getGroup_5() { return cGroup_5; }
		
		//'^'
		public Keyword getCircumflexAccentKeyword_5_0() { return cCircumflexAccentKeyword_5_0; }
		
		//antecedent+=Predicate
		public Assignment getAntecedentAssignment_5_1() { return cAntecedentAssignment_5_1; }
		
		//Predicate
		public RuleCall getAntecedentPredicateParserRuleCall_5_1_0() { return cAntecedentPredicateParserRuleCall_5_1_0; }
		
		//'->'
		public Keyword getHyphenMinusGreaterThanSignKeyword_6() { return cHyphenMinusGreaterThanSignKeyword_6; }
		
		//consequent+=Predicate
		public Assignment getConsequentAssignment_7() { return cConsequentAssignment_7; }
		
		//Predicate
		public RuleCall getConsequentPredicateParserRuleCall_7_0() { return cConsequentPredicateParserRuleCall_7_0; }
		
		//('^' consequent+=Predicate)*
		public Group getGroup_8() { return cGroup_8; }
		
		//'^'
		public Keyword getCircumflexAccentKeyword_8_0() { return cCircumflexAccentKeyword_8_0; }
		
		//consequent+=Predicate
		public Assignment getConsequentAssignment_8_1() { return cConsequentAssignment_8_1; }
		
		//Predicate
		public RuleCall getConsequentPredicateParserRuleCall_8_1_0() { return cConsequentPredicateParserRuleCall_8_1_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_9() { return cRightSquareBracketKeyword_9; }
	}
	public class StructureInstanceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.StructureInstance");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cTypeAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cTypeStructureCrossReference_0_0 = (CrossReference)cTypeAssignment_0.eContents().get(0);
		private final RuleCall cTypeStructureRefParserRuleCall_0_0_1 = (RuleCall)cTypeStructureCrossReference_0_0.eContents().get(1);
		private final Keyword cLeftSquareBracketKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cOwnedPropertyValuesAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cOwnedPropertyValuesPropertyValueAssertionParserRuleCall_2_0 = (RuleCall)cOwnedPropertyValuesAssignment_2.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//StructureInstance:
		//    type=[Structure|Ref] '['
		//        ownedPropertyValues+=PropertyValueAssertion*
		//    ']';
		@Override public ParserRule getRule() { return rule; }
		
		//type=[Structure|Ref] '['
		//    ownedPropertyValues+=PropertyValueAssertion*
		//']'
		public Group getGroup() { return cGroup; }
		
		//type=[Structure|Ref]
		public Assignment getTypeAssignment_0() { return cTypeAssignment_0; }
		
		//[Structure|Ref]
		public CrossReference getTypeStructureCrossReference_0_0() { return cTypeStructureCrossReference_0_0; }
		
		//Ref
		public RuleCall getTypeStructureRefParserRuleCall_0_0_1() { return cTypeStructureRefParserRuleCall_0_0_1; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_1() { return cLeftSquareBracketKeyword_1; }
		
		//ownedPropertyValues+=PropertyValueAssertion*
		public Assignment getOwnedPropertyValuesAssignment_2() { return cOwnedPropertyValuesAssignment_2; }
		
		//PropertyValueAssertion
		public RuleCall getOwnedPropertyValuesPropertyValueAssertionParserRuleCall_2_0() { return cOwnedPropertyValuesPropertyValueAssertionParserRuleCall_2_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_3() { return cRightSquareBracketKeyword_3; }
	}
	public class NamedInstanceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.NamedInstance");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cConceptInstanceParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cRelationInstanceParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//NamedInstance:
		//    ConceptInstance |
		//    RelationInstance;
		@Override public ParserRule getRule() { return rule; }
		
		//ConceptInstance |
		//RelationInstance
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//ConceptInstance
		public RuleCall getConceptInstanceParserRuleCall_0() { return cConceptInstanceParserRuleCall_0; }
		
		//RelationInstance
		public RuleCall getRelationInstanceParserRuleCall_1() { return cRelationInstanceParserRuleCall_1; }
	}
	public class ConceptInstanceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.ConceptInstance");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cCiKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNameIDTerminalRuleCall_2_0 = (RuleCall)cNameAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cColonKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cOwnedTypesAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cOwnedTypesConceptTypeAssertionParserRuleCall_3_1_0 = (RuleCall)cOwnedTypesAssignment_3_1.eContents().get(0);
		private final Group cGroup_3_2 = (Group)cGroup_3.eContents().get(2);
		private final Keyword cCommaKeyword_3_2_0 = (Keyword)cGroup_3_2.eContents().get(0);
		private final Assignment cOwnedTypesAssignment_3_2_1 = (Assignment)cGroup_3_2.eContents().get(1);
		private final RuleCall cOwnedTypesConceptTypeAssertionParserRuleCall_3_2_1_0 = (RuleCall)cOwnedTypesAssignment_3_2_1.eContents().get(0);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cLeftSquareBracketKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Alternatives cAlternatives_4_1 = (Alternatives)cGroup_4.eContents().get(1);
		private final Assignment cOwnedPropertyValuesAssignment_4_1_0 = (Assignment)cAlternatives_4_1.eContents().get(0);
		private final RuleCall cOwnedPropertyValuesPropertyValueAssertionParserRuleCall_4_1_0_0 = (RuleCall)cOwnedPropertyValuesAssignment_4_1_0.eContents().get(0);
		private final Assignment cOwnedLinksAssignment_4_1_1 = (Assignment)cAlternatives_4_1.eContents().get(1);
		private final RuleCall cOwnedLinksLinkAssertionParserRuleCall_4_1_1_0 = (RuleCall)cOwnedLinksAssignment_4_1_1.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_4_2 = (Keyword)cGroup_4.eContents().get(2);
		
		//ConceptInstance:
		//    ownedAnnotations+=Annotation*
		//    'ci' name=ID (':' ownedTypes+=ConceptTypeAssertion (',' ownedTypes+=ConceptTypeAssertion)*)? ('['
		//        (ownedPropertyValues+=PropertyValueAssertion |
		//         ownedLinks+=LinkAssertion)*
		//    ']')?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'ci' name=ID (':' ownedTypes+=ConceptTypeAssertion (',' ownedTypes+=ConceptTypeAssertion)*)? ('['
		//    (ownedPropertyValues+=PropertyValueAssertion |
		//     ownedLinks+=LinkAssertion)*
		//']')?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'ci'
		public Keyword getCiKeyword_1() { return cCiKeyword_1; }
		
		//name=ID
		public Assignment getNameAssignment_2() { return cNameAssignment_2; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_2_0() { return cNameIDTerminalRuleCall_2_0; }
		
		//(':' ownedTypes+=ConceptTypeAssertion (',' ownedTypes+=ConceptTypeAssertion)*)?
		public Group getGroup_3() { return cGroup_3; }
		
		//':'
		public Keyword getColonKeyword_3_0() { return cColonKeyword_3_0; }
		
		//ownedTypes+=ConceptTypeAssertion
		public Assignment getOwnedTypesAssignment_3_1() { return cOwnedTypesAssignment_3_1; }
		
		//ConceptTypeAssertion
		public RuleCall getOwnedTypesConceptTypeAssertionParserRuleCall_3_1_0() { return cOwnedTypesConceptTypeAssertionParserRuleCall_3_1_0; }
		
		//(',' ownedTypes+=ConceptTypeAssertion)*
		public Group getGroup_3_2() { return cGroup_3_2; }
		
		//','
		public Keyword getCommaKeyword_3_2_0() { return cCommaKeyword_3_2_0; }
		
		//ownedTypes+=ConceptTypeAssertion
		public Assignment getOwnedTypesAssignment_3_2_1() { return cOwnedTypesAssignment_3_2_1; }
		
		//ConceptTypeAssertion
		public RuleCall getOwnedTypesConceptTypeAssertionParserRuleCall_3_2_1_0() { return cOwnedTypesConceptTypeAssertionParserRuleCall_3_2_1_0; }
		
		//('['
		//       (ownedPropertyValues+=PropertyValueAssertion |
		//        ownedLinks+=LinkAssertion)*
		//   ']')?
		public Group getGroup_4() { return cGroup_4; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_4_0() { return cLeftSquareBracketKeyword_4_0; }
		
		//(ownedPropertyValues+=PropertyValueAssertion |
		// ownedLinks+=LinkAssertion)*
		public Alternatives getAlternatives_4_1() { return cAlternatives_4_1; }
		
		//ownedPropertyValues+=PropertyValueAssertion
		public Assignment getOwnedPropertyValuesAssignment_4_1_0() { return cOwnedPropertyValuesAssignment_4_1_0; }
		
		//PropertyValueAssertion
		public RuleCall getOwnedPropertyValuesPropertyValueAssertionParserRuleCall_4_1_0_0() { return cOwnedPropertyValuesPropertyValueAssertionParserRuleCall_4_1_0_0; }
		
		//ownedLinks+=LinkAssertion
		public Assignment getOwnedLinksAssignment_4_1_1() { return cOwnedLinksAssignment_4_1_1; }
		
		//LinkAssertion
		public RuleCall getOwnedLinksLinkAssertionParserRuleCall_4_1_1_0() { return cOwnedLinksLinkAssertionParserRuleCall_4_1_1_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_4_2() { return cRightSquareBracketKeyword_4_2; }
	}
	public class RelationInstanceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.RelationInstance");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cRiKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNameIDTerminalRuleCall_2_0 = (RuleCall)cNameAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cColonKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cOwnedTypesAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cOwnedTypesRelationTypeAssertionParserRuleCall_3_1_0 = (RuleCall)cOwnedTypesAssignment_3_1.eContents().get(0);
		private final Group cGroup_3_2 = (Group)cGroup_3.eContents().get(2);
		private final Keyword cCommaKeyword_3_2_0 = (Keyword)cGroup_3_2.eContents().get(0);
		private final Assignment cOwnedTypesAssignment_3_2_1 = (Assignment)cGroup_3_2.eContents().get(1);
		private final RuleCall cOwnedTypesRelationTypeAssertionParserRuleCall_3_2_1_0 = (RuleCall)cOwnedTypesAssignment_3_2_1.eContents().get(0);
		private final Keyword cLeftSquareBracketKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Keyword cFromKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Assignment cSourcesAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final CrossReference cSourcesNamedInstanceCrossReference_6_0 = (CrossReference)cSourcesAssignment_6.eContents().get(0);
		private final RuleCall cSourcesNamedInstanceRefParserRuleCall_6_0_1 = (RuleCall)cSourcesNamedInstanceCrossReference_6_0.eContents().get(1);
		private final Group cGroup_7 = (Group)cGroup.eContents().get(7);
		private final Keyword cCommaKeyword_7_0 = (Keyword)cGroup_7.eContents().get(0);
		private final Assignment cSourcesAssignment_7_1 = (Assignment)cGroup_7.eContents().get(1);
		private final CrossReference cSourcesNamedInstanceCrossReference_7_1_0 = (CrossReference)cSourcesAssignment_7_1.eContents().get(0);
		private final RuleCall cSourcesNamedInstanceRefParserRuleCall_7_1_0_1 = (RuleCall)cSourcesNamedInstanceCrossReference_7_1_0.eContents().get(1);
		private final Keyword cToKeyword_8 = (Keyword)cGroup.eContents().get(8);
		private final Assignment cTargetsAssignment_9 = (Assignment)cGroup.eContents().get(9);
		private final CrossReference cTargetsNamedInstanceCrossReference_9_0 = (CrossReference)cTargetsAssignment_9.eContents().get(0);
		private final RuleCall cTargetsNamedInstanceRefParserRuleCall_9_0_1 = (RuleCall)cTargetsNamedInstanceCrossReference_9_0.eContents().get(1);
		private final Group cGroup_10 = (Group)cGroup.eContents().get(10);
		private final Keyword cCommaKeyword_10_0 = (Keyword)cGroup_10.eContents().get(0);
		private final Assignment cTargetsAssignment_10_1 = (Assignment)cGroup_10.eContents().get(1);
		private final CrossReference cTargetsNamedInstanceCrossReference_10_1_0 = (CrossReference)cTargetsAssignment_10_1.eContents().get(0);
		private final RuleCall cTargetsNamedInstanceRefParserRuleCall_10_1_0_1 = (RuleCall)cTargetsNamedInstanceCrossReference_10_1_0.eContents().get(1);
		private final Alternatives cAlternatives_11 = (Alternatives)cGroup.eContents().get(11);
		private final Assignment cOwnedPropertyValuesAssignment_11_0 = (Assignment)cAlternatives_11.eContents().get(0);
		private final RuleCall cOwnedPropertyValuesPropertyValueAssertionParserRuleCall_11_0_0 = (RuleCall)cOwnedPropertyValuesAssignment_11_0.eContents().get(0);
		private final Assignment cOwnedLinksAssignment_11_1 = (Assignment)cAlternatives_11.eContents().get(1);
		private final RuleCall cOwnedLinksLinkAssertionParserRuleCall_11_1_0 = (RuleCall)cOwnedLinksAssignment_11_1.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_12 = (Keyword)cGroup.eContents().get(12);
		
		//RelationInstance:
		//    ownedAnnotations+=Annotation*
		//    'ri' name=ID (':' ownedTypes+=RelationTypeAssertion (',' ownedTypes+=RelationTypeAssertion)*)? '['
		//        'from' sources+=[NamedInstance|Ref] (',' sources+=[NamedInstance|Ref])*
		//        'to' targets+=[NamedInstance|Ref] (',' targets+=[NamedInstance|Ref])*
		//        (ownedPropertyValues+=PropertyValueAssertion |
		//         ownedLinks+=LinkAssertion)*
		//    ']';
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'ri' name=ID (':' ownedTypes+=RelationTypeAssertion (',' ownedTypes+=RelationTypeAssertion)*)? '['
		//    'from' sources+=[NamedInstance|Ref] (',' sources+=[NamedInstance|Ref])*
		//    'to' targets+=[NamedInstance|Ref] (',' targets+=[NamedInstance|Ref])*
		//    (ownedPropertyValues+=PropertyValueAssertion |
		//     ownedLinks+=LinkAssertion)*
		//']'
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'ri'
		public Keyword getRiKeyword_1() { return cRiKeyword_1; }
		
		//name=ID
		public Assignment getNameAssignment_2() { return cNameAssignment_2; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_2_0() { return cNameIDTerminalRuleCall_2_0; }
		
		//(':' ownedTypes+=RelationTypeAssertion (',' ownedTypes+=RelationTypeAssertion)*)?
		public Group getGroup_3() { return cGroup_3; }
		
		//':'
		public Keyword getColonKeyword_3_0() { return cColonKeyword_3_0; }
		
		//ownedTypes+=RelationTypeAssertion
		public Assignment getOwnedTypesAssignment_3_1() { return cOwnedTypesAssignment_3_1; }
		
		//RelationTypeAssertion
		public RuleCall getOwnedTypesRelationTypeAssertionParserRuleCall_3_1_0() { return cOwnedTypesRelationTypeAssertionParserRuleCall_3_1_0; }
		
		//(',' ownedTypes+=RelationTypeAssertion)*
		public Group getGroup_3_2() { return cGroup_3_2; }
		
		//','
		public Keyword getCommaKeyword_3_2_0() { return cCommaKeyword_3_2_0; }
		
		//ownedTypes+=RelationTypeAssertion
		public Assignment getOwnedTypesAssignment_3_2_1() { return cOwnedTypesAssignment_3_2_1; }
		
		//RelationTypeAssertion
		public RuleCall getOwnedTypesRelationTypeAssertionParserRuleCall_3_2_1_0() { return cOwnedTypesRelationTypeAssertionParserRuleCall_3_2_1_0; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_4() { return cLeftSquareBracketKeyword_4; }
		
		//'from'
		public Keyword getFromKeyword_5() { return cFromKeyword_5; }
		
		//sources+=[NamedInstance|Ref]
		public Assignment getSourcesAssignment_6() { return cSourcesAssignment_6; }
		
		//[NamedInstance|Ref]
		public CrossReference getSourcesNamedInstanceCrossReference_6_0() { return cSourcesNamedInstanceCrossReference_6_0; }
		
		//Ref
		public RuleCall getSourcesNamedInstanceRefParserRuleCall_6_0_1() { return cSourcesNamedInstanceRefParserRuleCall_6_0_1; }
		
		//(',' sources+=[NamedInstance|Ref])*
		public Group getGroup_7() { return cGroup_7; }
		
		//','
		public Keyword getCommaKeyword_7_0() { return cCommaKeyword_7_0; }
		
		//sources+=[NamedInstance|Ref]
		public Assignment getSourcesAssignment_7_1() { return cSourcesAssignment_7_1; }
		
		//[NamedInstance|Ref]
		public CrossReference getSourcesNamedInstanceCrossReference_7_1_0() { return cSourcesNamedInstanceCrossReference_7_1_0; }
		
		//Ref
		public RuleCall getSourcesNamedInstanceRefParserRuleCall_7_1_0_1() { return cSourcesNamedInstanceRefParserRuleCall_7_1_0_1; }
		
		//'to'
		public Keyword getToKeyword_8() { return cToKeyword_8; }
		
		//targets+=[NamedInstance|Ref]
		public Assignment getTargetsAssignment_9() { return cTargetsAssignment_9; }
		
		//[NamedInstance|Ref]
		public CrossReference getTargetsNamedInstanceCrossReference_9_0() { return cTargetsNamedInstanceCrossReference_9_0; }
		
		//Ref
		public RuleCall getTargetsNamedInstanceRefParserRuleCall_9_0_1() { return cTargetsNamedInstanceRefParserRuleCall_9_0_1; }
		
		//(',' targets+=[NamedInstance|Ref])*
		public Group getGroup_10() { return cGroup_10; }
		
		//','
		public Keyword getCommaKeyword_10_0() { return cCommaKeyword_10_0; }
		
		//targets+=[NamedInstance|Ref]
		public Assignment getTargetsAssignment_10_1() { return cTargetsAssignment_10_1; }
		
		//[NamedInstance|Ref]
		public CrossReference getTargetsNamedInstanceCrossReference_10_1_0() { return cTargetsNamedInstanceCrossReference_10_1_0; }
		
		//Ref
		public RuleCall getTargetsNamedInstanceRefParserRuleCall_10_1_0_1() { return cTargetsNamedInstanceRefParserRuleCall_10_1_0_1; }
		
		//(ownedPropertyValues+=PropertyValueAssertion |
		// ownedLinks+=LinkAssertion)*
		public Alternatives getAlternatives_11() { return cAlternatives_11; }
		
		//ownedPropertyValues+=PropertyValueAssertion
		public Assignment getOwnedPropertyValuesAssignment_11_0() { return cOwnedPropertyValuesAssignment_11_0; }
		
		//PropertyValueAssertion
		public RuleCall getOwnedPropertyValuesPropertyValueAssertionParserRuleCall_11_0_0() { return cOwnedPropertyValuesPropertyValueAssertionParserRuleCall_11_0_0; }
		
		//ownedLinks+=LinkAssertion
		public Assignment getOwnedLinksAssignment_11_1() { return cOwnedLinksAssignment_11_1; }
		
		//LinkAssertion
		public RuleCall getOwnedLinksLinkAssertionParserRuleCall_11_1_0() { return cOwnedLinksLinkAssertionParserRuleCall_11_1_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_12() { return cRightSquareBracketKeyword_12; }
	}
	public class SpecializableTermReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.SpecializableTermReference");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cClassifierReferenceParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cFacetedScalarReferenceParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cEnumeratedScalarReferenceParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cAnnotationPropertyReferenceParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		private final RuleCall cScalarPropertyReferenceParserRuleCall_4 = (RuleCall)cAlternatives.eContents().get(4);
		private final RuleCall cStructuredPropertyReferenceParserRuleCall_5 = (RuleCall)cAlternatives.eContents().get(5);
		
		//SpecializableTermReference:
		//    ClassifierReference |
		//    FacetedScalarReference |
		//    EnumeratedScalarReference |
		//    AnnotationPropertyReference |
		//    ScalarPropertyReference |
		//    StructuredPropertyReference;
		@Override public ParserRule getRule() { return rule; }
		
		//ClassifierReference |
		//FacetedScalarReference |
		//EnumeratedScalarReference |
		//AnnotationPropertyReference |
		//ScalarPropertyReference |
		//StructuredPropertyReference
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//ClassifierReference
		public RuleCall getClassifierReferenceParserRuleCall_0() { return cClassifierReferenceParserRuleCall_0; }
		
		//FacetedScalarReference
		public RuleCall getFacetedScalarReferenceParserRuleCall_1() { return cFacetedScalarReferenceParserRuleCall_1; }
		
		//EnumeratedScalarReference
		public RuleCall getEnumeratedScalarReferenceParserRuleCall_2() { return cEnumeratedScalarReferenceParserRuleCall_2; }
		
		//AnnotationPropertyReference
		public RuleCall getAnnotationPropertyReferenceParserRuleCall_3() { return cAnnotationPropertyReferenceParserRuleCall_3; }
		
		//ScalarPropertyReference
		public RuleCall getScalarPropertyReferenceParserRuleCall_4() { return cScalarPropertyReferenceParserRuleCall_4; }
		
		//StructuredPropertyReference
		public RuleCall getStructuredPropertyReferenceParserRuleCall_5() { return cStructuredPropertyReferenceParserRuleCall_5; }
	}
	public class ClassifierReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.ClassifierReference");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cEntityReferenceParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cStructureReferenceParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//ClassifierReference:
		//    EntityReference |
		//    StructureReference;
		@Override public ParserRule getRule() { return rule; }
		
		//EntityReference |
		//StructureReference
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//EntityReference
		public RuleCall getEntityReferenceParserRuleCall_0() { return cEntityReferenceParserRuleCall_0; }
		
		//StructureReference
		public RuleCall getStructureReferenceParserRuleCall_1() { return cStructureReferenceParserRuleCall_1; }
	}
	public class EntityReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.EntityReference");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cAspectReferenceParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cConceptReferenceParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cRelationEntityReferenceParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		//EntityReference:
		//    AspectReference |
		//    ConceptReference |
		//    RelationEntityReference;
		@Override public ParserRule getRule() { return rule; }
		
		//AspectReference |
		//ConceptReference |
		//RelationEntityReference
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//AspectReference
		public RuleCall getAspectReferenceParserRuleCall_0() { return cAspectReferenceParserRuleCall_0; }
		
		//ConceptReference
		public RuleCall getConceptReferenceParserRuleCall_1() { return cConceptReferenceParserRuleCall_1; }
		
		//RelationEntityReference
		public RuleCall getRelationEntityReferenceParserRuleCall_2() { return cRelationEntityReferenceParserRuleCall_2; }
	}
	public class AspectReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.AspectReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cRefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cAspectKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cAspectAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cAspectAspectCrossReference_3_0 = (CrossReference)cAspectAssignment_3.eContents().get(0);
		private final RuleCall cAspectAspectRefParserRuleCall_3_0_1 = (RuleCall)cAspectAspectCrossReference_3_0.eContents().get(1);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cColonGreaterThanSignKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0 = (RuleCall)cOwnedSpecializationsAssignment_4_1.eContents().get(0);
		private final Group cGroup_4_2 = (Group)cGroup_4.eContents().get(2);
		private final Keyword cCommaKeyword_4_2_0 = (Keyword)cGroup_4_2.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_4_2_1 = (Assignment)cGroup_4_2.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0 = (RuleCall)cOwnedSpecializationsAssignment_4_2_1.eContents().get(0);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cLeftSquareBracketKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Alternatives cAlternatives_5_1 = (Alternatives)cGroup_5.eContents().get(1);
		private final Assignment cOwnedKeysAssignment_5_1_0 = (Assignment)cAlternatives_5_1.eContents().get(0);
		private final RuleCall cOwnedKeysKeyAxiomParserRuleCall_5_1_0_0 = (RuleCall)cOwnedKeysAssignment_5_1_0.eContents().get(0);
		private final Assignment cOwnedPropertyRestrictionsAssignment_5_1_1 = (Assignment)cAlternatives_5_1.eContents().get(1);
		private final RuleCall cOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_5_1_1_0 = (RuleCall)cOwnedPropertyRestrictionsAssignment_5_1_1.eContents().get(0);
		private final Assignment cOwnedRelationRestrictionsAssignment_5_1_2 = (Assignment)cAlternatives_5_1.eContents().get(2);
		private final RuleCall cOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_5_1_2_0 = (RuleCall)cOwnedRelationRestrictionsAssignment_5_1_2.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_5_2 = (Keyword)cGroup_5.eContents().get(2);
		
		//AspectReference:
		//    ownedAnnotations+=Annotation*
		//    'ref' 'aspect' aspect=[Aspect|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//        (ownedKeys+=KeyAxiom |
		//         ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		//         ownedRelationRestrictions+=RelationRestrictionAxiom)*
		//    ']')?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'ref' 'aspect' aspect=[Aspect|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//    (ownedKeys+=KeyAxiom |
		//     ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		//     ownedRelationRestrictions+=RelationRestrictionAxiom)*
		//']')?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'ref'
		public Keyword getRefKeyword_1() { return cRefKeyword_1; }
		
		//'aspect'
		public Keyword getAspectKeyword_2() { return cAspectKeyword_2; }
		
		//aspect=[Aspect|Ref]
		public Assignment getAspectAssignment_3() { return cAspectAssignment_3; }
		
		//[Aspect|Ref]
		public CrossReference getAspectAspectCrossReference_3_0() { return cAspectAspectCrossReference_3_0; }
		
		//Ref
		public RuleCall getAspectAspectRefParserRuleCall_3_0_1() { return cAspectAspectRefParserRuleCall_3_0_1; }
		
		//(':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup_4() { return cGroup_4; }
		
		//':>'
		public Keyword getColonGreaterThanSignKeyword_4_0() { return cColonGreaterThanSignKeyword_4_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_4_1() { return cOwnedSpecializationsAssignment_4_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0; }
		
		//(',' ownedSpecializations+=SpecializationAxiom)*
		public Group getGroup_4_2() { return cGroup_4_2; }
		
		//','
		public Keyword getCommaKeyword_4_2_0() { return cCommaKeyword_4_2_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_4_2_1() { return cOwnedSpecializationsAssignment_4_2_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0; }
		
		//('['
		//       (ownedKeys+=KeyAxiom |
		//        ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		//        ownedRelationRestrictions+=RelationRestrictionAxiom)*
		//   ']')?
		public Group getGroup_5() { return cGroup_5; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_5_0() { return cLeftSquareBracketKeyword_5_0; }
		
		//(ownedKeys+=KeyAxiom |
		// ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		// ownedRelationRestrictions+=RelationRestrictionAxiom)*
		public Alternatives getAlternatives_5_1() { return cAlternatives_5_1; }
		
		//ownedKeys+=KeyAxiom
		public Assignment getOwnedKeysAssignment_5_1_0() { return cOwnedKeysAssignment_5_1_0; }
		
		//KeyAxiom
		public RuleCall getOwnedKeysKeyAxiomParserRuleCall_5_1_0_0() { return cOwnedKeysKeyAxiomParserRuleCall_5_1_0_0; }
		
		//ownedPropertyRestrictions+=PropertyRestrictionAxiom
		public Assignment getOwnedPropertyRestrictionsAssignment_5_1_1() { return cOwnedPropertyRestrictionsAssignment_5_1_1; }
		
		//PropertyRestrictionAxiom
		public RuleCall getOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_5_1_1_0() { return cOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_5_1_1_0; }
		
		//ownedRelationRestrictions+=RelationRestrictionAxiom
		public Assignment getOwnedRelationRestrictionsAssignment_5_1_2() { return cOwnedRelationRestrictionsAssignment_5_1_2; }
		
		//RelationRestrictionAxiom
		public RuleCall getOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_5_1_2_0() { return cOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_5_1_2_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_5_2() { return cRightSquareBracketKeyword_5_2; }
	}
	public class ConceptReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.ConceptReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cRefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cConceptKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cConceptAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cConceptConceptCrossReference_3_0 = (CrossReference)cConceptAssignment_3.eContents().get(0);
		private final RuleCall cConceptConceptRefParserRuleCall_3_0_1 = (RuleCall)cConceptConceptCrossReference_3_0.eContents().get(1);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cColonGreaterThanSignKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0 = (RuleCall)cOwnedSpecializationsAssignment_4_1.eContents().get(0);
		private final Group cGroup_4_2 = (Group)cGroup_4.eContents().get(2);
		private final Keyword cCommaKeyword_4_2_0 = (Keyword)cGroup_4_2.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_4_2_1 = (Assignment)cGroup_4_2.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0 = (RuleCall)cOwnedSpecializationsAssignment_4_2_1.eContents().get(0);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cLeftSquareBracketKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Alternatives cAlternatives_5_1 = (Alternatives)cGroup_5.eContents().get(1);
		private final Assignment cOwnedKeysAssignment_5_1_0 = (Assignment)cAlternatives_5_1.eContents().get(0);
		private final RuleCall cOwnedKeysKeyAxiomParserRuleCall_5_1_0_0 = (RuleCall)cOwnedKeysAssignment_5_1_0.eContents().get(0);
		private final Assignment cOwnedPropertyRestrictionsAssignment_5_1_1 = (Assignment)cAlternatives_5_1.eContents().get(1);
		private final RuleCall cOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_5_1_1_0 = (RuleCall)cOwnedPropertyRestrictionsAssignment_5_1_1.eContents().get(0);
		private final Assignment cOwnedRelationRestrictionsAssignment_5_1_2 = (Assignment)cAlternatives_5_1.eContents().get(2);
		private final RuleCall cOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_5_1_2_0 = (RuleCall)cOwnedRelationRestrictionsAssignment_5_1_2.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_5_2 = (Keyword)cGroup_5.eContents().get(2);
		
		//ConceptReference:
		//    ownedAnnotations+=Annotation*
		//    'ref' 'concept' concept=[Concept|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//        (ownedKeys+=KeyAxiom |
		//         ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		//         ownedRelationRestrictions+=RelationRestrictionAxiom)*
		//    ']')?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'ref' 'concept' concept=[Concept|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//    (ownedKeys+=KeyAxiom |
		//     ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		//     ownedRelationRestrictions+=RelationRestrictionAxiom)*
		//']')?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'ref'
		public Keyword getRefKeyword_1() { return cRefKeyword_1; }
		
		//'concept'
		public Keyword getConceptKeyword_2() { return cConceptKeyword_2; }
		
		//concept=[Concept|Ref]
		public Assignment getConceptAssignment_3() { return cConceptAssignment_3; }
		
		//[Concept|Ref]
		public CrossReference getConceptConceptCrossReference_3_0() { return cConceptConceptCrossReference_3_0; }
		
		//Ref
		public RuleCall getConceptConceptRefParserRuleCall_3_0_1() { return cConceptConceptRefParserRuleCall_3_0_1; }
		
		//(':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup_4() { return cGroup_4; }
		
		//':>'
		public Keyword getColonGreaterThanSignKeyword_4_0() { return cColonGreaterThanSignKeyword_4_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_4_1() { return cOwnedSpecializationsAssignment_4_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0; }
		
		//(',' ownedSpecializations+=SpecializationAxiom)*
		public Group getGroup_4_2() { return cGroup_4_2; }
		
		//','
		public Keyword getCommaKeyword_4_2_0() { return cCommaKeyword_4_2_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_4_2_1() { return cOwnedSpecializationsAssignment_4_2_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0; }
		
		//('['
		//       (ownedKeys+=KeyAxiom |
		//        ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		//        ownedRelationRestrictions+=RelationRestrictionAxiom)*
		//   ']')?
		public Group getGroup_5() { return cGroup_5; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_5_0() { return cLeftSquareBracketKeyword_5_0; }
		
		//(ownedKeys+=KeyAxiom |
		// ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		// ownedRelationRestrictions+=RelationRestrictionAxiom)*
		public Alternatives getAlternatives_5_1() { return cAlternatives_5_1; }
		
		//ownedKeys+=KeyAxiom
		public Assignment getOwnedKeysAssignment_5_1_0() { return cOwnedKeysAssignment_5_1_0; }
		
		//KeyAxiom
		public RuleCall getOwnedKeysKeyAxiomParserRuleCall_5_1_0_0() { return cOwnedKeysKeyAxiomParserRuleCall_5_1_0_0; }
		
		//ownedPropertyRestrictions+=PropertyRestrictionAxiom
		public Assignment getOwnedPropertyRestrictionsAssignment_5_1_1() { return cOwnedPropertyRestrictionsAssignment_5_1_1; }
		
		//PropertyRestrictionAxiom
		public RuleCall getOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_5_1_1_0() { return cOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_5_1_1_0; }
		
		//ownedRelationRestrictions+=RelationRestrictionAxiom
		public Assignment getOwnedRelationRestrictionsAssignment_5_1_2() { return cOwnedRelationRestrictionsAssignment_5_1_2; }
		
		//RelationRestrictionAxiom
		public RuleCall getOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_5_1_2_0() { return cOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_5_1_2_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_5_2() { return cRightSquareBracketKeyword_5_2; }
	}
	public class RelationEntityReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.RelationEntityReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cRefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cRelationKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Keyword cEntityKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cEntityAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final CrossReference cEntityRelationEntityCrossReference_4_0 = (CrossReference)cEntityAssignment_4.eContents().get(0);
		private final RuleCall cEntityRelationEntityRefParserRuleCall_4_0_1 = (RuleCall)cEntityRelationEntityCrossReference_4_0.eContents().get(1);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cColonGreaterThanSignKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_5_1 = (Assignment)cGroup_5.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0 = (RuleCall)cOwnedSpecializationsAssignment_5_1.eContents().get(0);
		private final Group cGroup_5_2 = (Group)cGroup_5.eContents().get(2);
		private final Keyword cCommaKeyword_5_2_0 = (Keyword)cGroup_5_2.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_5_2_1 = (Assignment)cGroup_5_2.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0 = (RuleCall)cOwnedSpecializationsAssignment_5_2_1.eContents().get(0);
		private final Group cGroup_6 = (Group)cGroup.eContents().get(6);
		private final Keyword cLeftSquareBracketKeyword_6_0 = (Keyword)cGroup_6.eContents().get(0);
		private final Alternatives cAlternatives_6_1 = (Alternatives)cGroup_6.eContents().get(1);
		private final Assignment cOwnedKeysAssignment_6_1_0 = (Assignment)cAlternatives_6_1.eContents().get(0);
		private final RuleCall cOwnedKeysKeyAxiomParserRuleCall_6_1_0_0 = (RuleCall)cOwnedKeysAssignment_6_1_0.eContents().get(0);
		private final Assignment cOwnedPropertyRestrictionsAssignment_6_1_1 = (Assignment)cAlternatives_6_1.eContents().get(1);
		private final RuleCall cOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_6_1_1_0 = (RuleCall)cOwnedPropertyRestrictionsAssignment_6_1_1.eContents().get(0);
		private final Assignment cOwnedRelationRestrictionsAssignment_6_1_2 = (Assignment)cAlternatives_6_1.eContents().get(2);
		private final RuleCall cOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_6_1_2_0 = (RuleCall)cOwnedRelationRestrictionsAssignment_6_1_2.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_6_2 = (Keyword)cGroup_6.eContents().get(2);
		
		//RelationEntityReference:
		//    ownedAnnotations+=Annotation*
		//    'ref' 'relation' 'entity' entity=[RelationEntity|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//        (ownedKeys+=KeyAxiom |
		//         ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		//         ownedRelationRestrictions+=RelationRestrictionAxiom)*
		//    ']')?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'ref' 'relation' 'entity' entity=[RelationEntity|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//    (ownedKeys+=KeyAxiom |
		//     ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		//     ownedRelationRestrictions+=RelationRestrictionAxiom)*
		//']')?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'ref'
		public Keyword getRefKeyword_1() { return cRefKeyword_1; }
		
		//'relation'
		public Keyword getRelationKeyword_2() { return cRelationKeyword_2; }
		
		//'entity'
		public Keyword getEntityKeyword_3() { return cEntityKeyword_3; }
		
		//entity=[RelationEntity|Ref]
		public Assignment getEntityAssignment_4() { return cEntityAssignment_4; }
		
		//[RelationEntity|Ref]
		public CrossReference getEntityRelationEntityCrossReference_4_0() { return cEntityRelationEntityCrossReference_4_0; }
		
		//Ref
		public RuleCall getEntityRelationEntityRefParserRuleCall_4_0_1() { return cEntityRelationEntityRefParserRuleCall_4_0_1; }
		
		//(':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup_5() { return cGroup_5; }
		
		//':>'
		public Keyword getColonGreaterThanSignKeyword_5_0() { return cColonGreaterThanSignKeyword_5_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_5_1() { return cOwnedSpecializationsAssignment_5_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0; }
		
		//(',' ownedSpecializations+=SpecializationAxiom)*
		public Group getGroup_5_2() { return cGroup_5_2; }
		
		//','
		public Keyword getCommaKeyword_5_2_0() { return cCommaKeyword_5_2_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_5_2_1() { return cOwnedSpecializationsAssignment_5_2_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0; }
		
		//('['
		//       (ownedKeys+=KeyAxiom |
		//        ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		//        ownedRelationRestrictions+=RelationRestrictionAxiom)*
		//   ']')?
		public Group getGroup_6() { return cGroup_6; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_6_0() { return cLeftSquareBracketKeyword_6_0; }
		
		//(ownedKeys+=KeyAxiom |
		// ownedPropertyRestrictions+=PropertyRestrictionAxiom |
		// ownedRelationRestrictions+=RelationRestrictionAxiom)*
		public Alternatives getAlternatives_6_1() { return cAlternatives_6_1; }
		
		//ownedKeys+=KeyAxiom
		public Assignment getOwnedKeysAssignment_6_1_0() { return cOwnedKeysAssignment_6_1_0; }
		
		//KeyAxiom
		public RuleCall getOwnedKeysKeyAxiomParserRuleCall_6_1_0_0() { return cOwnedKeysKeyAxiomParserRuleCall_6_1_0_0; }
		
		//ownedPropertyRestrictions+=PropertyRestrictionAxiom
		public Assignment getOwnedPropertyRestrictionsAssignment_6_1_1() { return cOwnedPropertyRestrictionsAssignment_6_1_1; }
		
		//PropertyRestrictionAxiom
		public RuleCall getOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_6_1_1_0() { return cOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_6_1_1_0; }
		
		//ownedRelationRestrictions+=RelationRestrictionAxiom
		public Assignment getOwnedRelationRestrictionsAssignment_6_1_2() { return cOwnedRelationRestrictionsAssignment_6_1_2; }
		
		//RelationRestrictionAxiom
		public RuleCall getOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_6_1_2_0() { return cOwnedRelationRestrictionsRelationRestrictionAxiomParserRuleCall_6_1_2_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_6_2() { return cRightSquareBracketKeyword_6_2; }
	}
	public class StructureReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.StructureReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cRefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cStructureKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cStructureAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cStructureStructureCrossReference_3_0 = (CrossReference)cStructureAssignment_3.eContents().get(0);
		private final RuleCall cStructureStructureRefParserRuleCall_3_0_1 = (RuleCall)cStructureStructureCrossReference_3_0.eContents().get(1);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cColonGreaterThanSignKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0 = (RuleCall)cOwnedSpecializationsAssignment_4_1.eContents().get(0);
		private final Group cGroup_4_2 = (Group)cGroup_4.eContents().get(2);
		private final Keyword cCommaKeyword_4_2_0 = (Keyword)cGroup_4_2.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_4_2_1 = (Assignment)cGroup_4_2.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0 = (RuleCall)cOwnedSpecializationsAssignment_4_2_1.eContents().get(0);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cLeftSquareBracketKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Assignment cOwnedPropertyRestrictionsAssignment_5_1 = (Assignment)cGroup_5.eContents().get(1);
		private final RuleCall cOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_5_1_0 = (RuleCall)cOwnedPropertyRestrictionsAssignment_5_1.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_5_2 = (Keyword)cGroup_5.eContents().get(2);
		
		//StructureReference:
		//    ownedAnnotations+=Annotation*
		//    'ref' 'structure' structure=[Structure|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//        ownedPropertyRestrictions+=PropertyRestrictionAxiom*
		//    ']')?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'ref' 'structure' structure=[Structure|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
		//    ownedPropertyRestrictions+=PropertyRestrictionAxiom*
		//']')?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'ref'
		public Keyword getRefKeyword_1() { return cRefKeyword_1; }
		
		//'structure'
		public Keyword getStructureKeyword_2() { return cStructureKeyword_2; }
		
		//structure=[Structure|Ref]
		public Assignment getStructureAssignment_3() { return cStructureAssignment_3; }
		
		//[Structure|Ref]
		public CrossReference getStructureStructureCrossReference_3_0() { return cStructureStructureCrossReference_3_0; }
		
		//Ref
		public RuleCall getStructureStructureRefParserRuleCall_3_0_1() { return cStructureStructureRefParserRuleCall_3_0_1; }
		
		//(':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup_4() { return cGroup_4; }
		
		//':>'
		public Keyword getColonGreaterThanSignKeyword_4_0() { return cColonGreaterThanSignKeyword_4_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_4_1() { return cOwnedSpecializationsAssignment_4_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0; }
		
		//(',' ownedSpecializations+=SpecializationAxiom)*
		public Group getGroup_4_2() { return cGroup_4_2; }
		
		//','
		public Keyword getCommaKeyword_4_2_0() { return cCommaKeyword_4_2_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_4_2_1() { return cOwnedSpecializationsAssignment_4_2_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0; }
		
		//('['
		//       ownedPropertyRestrictions+=PropertyRestrictionAxiom*
		//   ']')?
		public Group getGroup_5() { return cGroup_5; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_5_0() { return cLeftSquareBracketKeyword_5_0; }
		
		//ownedPropertyRestrictions+=PropertyRestrictionAxiom*
		public Assignment getOwnedPropertyRestrictionsAssignment_5_1() { return cOwnedPropertyRestrictionsAssignment_5_1; }
		
		//PropertyRestrictionAxiom
		public RuleCall getOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_5_1_0() { return cOwnedPropertyRestrictionsPropertyRestrictionAxiomParserRuleCall_5_1_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_5_2() { return cRightSquareBracketKeyword_5_2; }
	}
	public class AnnotationPropertyReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.AnnotationPropertyReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cRefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cAnnotationKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Keyword cPropertyKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cPropertyAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final CrossReference cPropertyAnnotationPropertyCrossReference_4_0 = (CrossReference)cPropertyAssignment_4.eContents().get(0);
		private final RuleCall cPropertyAnnotationPropertyRefParserRuleCall_4_0_1 = (RuleCall)cPropertyAnnotationPropertyCrossReference_4_0.eContents().get(1);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cColonGreaterThanSignKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_5_1 = (Assignment)cGroup_5.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0 = (RuleCall)cOwnedSpecializationsAssignment_5_1.eContents().get(0);
		private final Group cGroup_5_2 = (Group)cGroup_5.eContents().get(2);
		private final Keyword cCommaKeyword_5_2_0 = (Keyword)cGroup_5_2.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_5_2_1 = (Assignment)cGroup_5_2.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0 = (RuleCall)cOwnedSpecializationsAssignment_5_2_1.eContents().get(0);
		
		//AnnotationPropertyReference:
		//    ownedAnnotations+=Annotation*
		//    'ref' 'annotation' 'property' property=[AnnotationProperty|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'ref' 'annotation' 'property' property=[AnnotationProperty|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'ref'
		public Keyword getRefKeyword_1() { return cRefKeyword_1; }
		
		//'annotation'
		public Keyword getAnnotationKeyword_2() { return cAnnotationKeyword_2; }
		
		//'property'
		public Keyword getPropertyKeyword_3() { return cPropertyKeyword_3; }
		
		//property=[AnnotationProperty|Ref]
		public Assignment getPropertyAssignment_4() { return cPropertyAssignment_4; }
		
		//[AnnotationProperty|Ref]
		public CrossReference getPropertyAnnotationPropertyCrossReference_4_0() { return cPropertyAnnotationPropertyCrossReference_4_0; }
		
		//Ref
		public RuleCall getPropertyAnnotationPropertyRefParserRuleCall_4_0_1() { return cPropertyAnnotationPropertyRefParserRuleCall_4_0_1; }
		
		//(':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup_5() { return cGroup_5; }
		
		//':>'
		public Keyword getColonGreaterThanSignKeyword_5_0() { return cColonGreaterThanSignKeyword_5_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_5_1() { return cOwnedSpecializationsAssignment_5_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0; }
		
		//(',' ownedSpecializations+=SpecializationAxiom)*
		public Group getGroup_5_2() { return cGroup_5_2; }
		
		//','
		public Keyword getCommaKeyword_5_2_0() { return cCommaKeyword_5_2_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_5_2_1() { return cOwnedSpecializationsAssignment_5_2_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0; }
	}
	public class ScalarPropertyReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.ScalarPropertyReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cRefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cScalarKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Keyword cPropertyKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cPropertyAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final CrossReference cPropertyScalarPropertyCrossReference_4_0 = (CrossReference)cPropertyAssignment_4.eContents().get(0);
		private final RuleCall cPropertyScalarPropertyRefParserRuleCall_4_0_1 = (RuleCall)cPropertyScalarPropertyCrossReference_4_0.eContents().get(1);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cColonGreaterThanSignKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_5_1 = (Assignment)cGroup_5.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0 = (RuleCall)cOwnedSpecializationsAssignment_5_1.eContents().get(0);
		private final Group cGroup_5_2 = (Group)cGroup_5.eContents().get(2);
		private final Keyword cCommaKeyword_5_2_0 = (Keyword)cGroup_5_2.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_5_2_1 = (Assignment)cGroup_5_2.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0 = (RuleCall)cOwnedSpecializationsAssignment_5_2_1.eContents().get(0);
		
		//ScalarPropertyReference:
		//    ownedAnnotations+=Annotation*
		//    'ref' 'scalar' 'property' property=[ScalarProperty|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'ref' 'scalar' 'property' property=[ScalarProperty|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'ref'
		public Keyword getRefKeyword_1() { return cRefKeyword_1; }
		
		//'scalar'
		public Keyword getScalarKeyword_2() { return cScalarKeyword_2; }
		
		//'property'
		public Keyword getPropertyKeyword_3() { return cPropertyKeyword_3; }
		
		//property=[ScalarProperty|Ref]
		public Assignment getPropertyAssignment_4() { return cPropertyAssignment_4; }
		
		//[ScalarProperty|Ref]
		public CrossReference getPropertyScalarPropertyCrossReference_4_0() { return cPropertyScalarPropertyCrossReference_4_0; }
		
		//Ref
		public RuleCall getPropertyScalarPropertyRefParserRuleCall_4_0_1() { return cPropertyScalarPropertyRefParserRuleCall_4_0_1; }
		
		//(':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup_5() { return cGroup_5; }
		
		//':>'
		public Keyword getColonGreaterThanSignKeyword_5_0() { return cColonGreaterThanSignKeyword_5_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_5_1() { return cOwnedSpecializationsAssignment_5_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0; }
		
		//(',' ownedSpecializations+=SpecializationAxiom)*
		public Group getGroup_5_2() { return cGroup_5_2; }
		
		//','
		public Keyword getCommaKeyword_5_2_0() { return cCommaKeyword_5_2_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_5_2_1() { return cOwnedSpecializationsAssignment_5_2_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0; }
	}
	public class StructuredPropertyReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.StructuredPropertyReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cRefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cStructuredKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Keyword cPropertyKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cPropertyAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final CrossReference cPropertyStructuredPropertyCrossReference_4_0 = (CrossReference)cPropertyAssignment_4.eContents().get(0);
		private final RuleCall cPropertyStructuredPropertyRefParserRuleCall_4_0_1 = (RuleCall)cPropertyStructuredPropertyCrossReference_4_0.eContents().get(1);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cColonGreaterThanSignKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_5_1 = (Assignment)cGroup_5.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0 = (RuleCall)cOwnedSpecializationsAssignment_5_1.eContents().get(0);
		private final Group cGroup_5_2 = (Group)cGroup_5.eContents().get(2);
		private final Keyword cCommaKeyword_5_2_0 = (Keyword)cGroup_5_2.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_5_2_1 = (Assignment)cGroup_5_2.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0 = (RuleCall)cOwnedSpecializationsAssignment_5_2_1.eContents().get(0);
		
		//StructuredPropertyReference:
		//    ownedAnnotations+=Annotation*
		//    'ref' 'structured' 'property' property=[StructuredProperty|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'ref' 'structured' 'property' property=[StructuredProperty|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'ref'
		public Keyword getRefKeyword_1() { return cRefKeyword_1; }
		
		//'structured'
		public Keyword getStructuredKeyword_2() { return cStructuredKeyword_2; }
		
		//'property'
		public Keyword getPropertyKeyword_3() { return cPropertyKeyword_3; }
		
		//property=[StructuredProperty|Ref]
		public Assignment getPropertyAssignment_4() { return cPropertyAssignment_4; }
		
		//[StructuredProperty|Ref]
		public CrossReference getPropertyStructuredPropertyCrossReference_4_0() { return cPropertyStructuredPropertyCrossReference_4_0; }
		
		//Ref
		public RuleCall getPropertyStructuredPropertyRefParserRuleCall_4_0_1() { return cPropertyStructuredPropertyRefParserRuleCall_4_0_1; }
		
		//(':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup_5() { return cGroup_5; }
		
		//':>'
		public Keyword getColonGreaterThanSignKeyword_5_0() { return cColonGreaterThanSignKeyword_5_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_5_1() { return cOwnedSpecializationsAssignment_5_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0; }
		
		//(',' ownedSpecializations+=SpecializationAxiom)*
		public Group getGroup_5_2() { return cGroup_5_2; }
		
		//','
		public Keyword getCommaKeyword_5_2_0() { return cCommaKeyword_5_2_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_5_2_1() { return cOwnedSpecializationsAssignment_5_2_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0; }
	}
	public class FacetedScalarReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.FacetedScalarReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cRefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cScalarKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cScalarAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cScalarFacetedScalarCrossReference_3_0 = (CrossReference)cScalarAssignment_3.eContents().get(0);
		private final RuleCall cScalarFacetedScalarRefParserRuleCall_3_0_1 = (RuleCall)cScalarFacetedScalarCrossReference_3_0.eContents().get(1);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cColonGreaterThanSignKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0 = (RuleCall)cOwnedSpecializationsAssignment_4_1.eContents().get(0);
		private final Group cGroup_4_2 = (Group)cGroup_4.eContents().get(2);
		private final Keyword cCommaKeyword_4_2_0 = (Keyword)cGroup_4_2.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_4_2_1 = (Assignment)cGroup_4_2.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0 = (RuleCall)cOwnedSpecializationsAssignment_4_2_1.eContents().get(0);
		
		//FacetedScalarReference:
		//    ownedAnnotations+=Annotation*
		//    'ref' 'scalar' scalar=[FacetedScalar|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'ref' 'scalar' scalar=[FacetedScalar|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'ref'
		public Keyword getRefKeyword_1() { return cRefKeyword_1; }
		
		//'scalar'
		public Keyword getScalarKeyword_2() { return cScalarKeyword_2; }
		
		//scalar=[FacetedScalar|Ref]
		public Assignment getScalarAssignment_3() { return cScalarAssignment_3; }
		
		//[FacetedScalar|Ref]
		public CrossReference getScalarFacetedScalarCrossReference_3_0() { return cScalarFacetedScalarCrossReference_3_0; }
		
		//Ref
		public RuleCall getScalarFacetedScalarRefParserRuleCall_3_0_1() { return cScalarFacetedScalarRefParserRuleCall_3_0_1; }
		
		//(':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup_4() { return cGroup_4; }
		
		//':>'
		public Keyword getColonGreaterThanSignKeyword_4_0() { return cColonGreaterThanSignKeyword_4_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_4_1() { return cOwnedSpecializationsAssignment_4_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_1_0; }
		
		//(',' ownedSpecializations+=SpecializationAxiom)*
		public Group getGroup_4_2() { return cGroup_4_2; }
		
		//','
		public Keyword getCommaKeyword_4_2_0() { return cCommaKeyword_4_2_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_4_2_1() { return cOwnedSpecializationsAssignment_4_2_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_4_2_1_0; }
	}
	public class EnumeratedScalarReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.EnumeratedScalarReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cRefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cEnumeratedKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Keyword cScalarKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cScalarAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final CrossReference cScalarEnumeratedScalarCrossReference_4_0 = (CrossReference)cScalarAssignment_4.eContents().get(0);
		private final RuleCall cScalarEnumeratedScalarRefParserRuleCall_4_0_1 = (RuleCall)cScalarEnumeratedScalarCrossReference_4_0.eContents().get(1);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cColonGreaterThanSignKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_5_1 = (Assignment)cGroup_5.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0 = (RuleCall)cOwnedSpecializationsAssignment_5_1.eContents().get(0);
		private final Group cGroup_5_2 = (Group)cGroup_5.eContents().get(2);
		private final Keyword cCommaKeyword_5_2_0 = (Keyword)cGroup_5_2.eContents().get(0);
		private final Assignment cOwnedSpecializationsAssignment_5_2_1 = (Assignment)cGroup_5_2.eContents().get(1);
		private final RuleCall cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0 = (RuleCall)cOwnedSpecializationsAssignment_5_2_1.eContents().get(0);
		
		//EnumeratedScalarReference:
		//    ownedAnnotations+=Annotation*
		//    'ref' 'enumerated' 'scalar' scalar=[EnumeratedScalar|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'ref' 'enumerated' 'scalar' scalar=[EnumeratedScalar|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'ref'
		public Keyword getRefKeyword_1() { return cRefKeyword_1; }
		
		//'enumerated'
		public Keyword getEnumeratedKeyword_2() { return cEnumeratedKeyword_2; }
		
		//'scalar'
		public Keyword getScalarKeyword_3() { return cScalarKeyword_3; }
		
		//scalar=[EnumeratedScalar|Ref]
		public Assignment getScalarAssignment_4() { return cScalarAssignment_4; }
		
		//[EnumeratedScalar|Ref]
		public CrossReference getScalarEnumeratedScalarCrossReference_4_0() { return cScalarEnumeratedScalarCrossReference_4_0; }
		
		//Ref
		public RuleCall getScalarEnumeratedScalarRefParserRuleCall_4_0_1() { return cScalarEnumeratedScalarRefParserRuleCall_4_0_1; }
		
		//(':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?
		public Group getGroup_5() { return cGroup_5; }
		
		//':>'
		public Keyword getColonGreaterThanSignKeyword_5_0() { return cColonGreaterThanSignKeyword_5_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_5_1() { return cOwnedSpecializationsAssignment_5_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_1_0; }
		
		//(',' ownedSpecializations+=SpecializationAxiom)*
		public Group getGroup_5_2() { return cGroup_5_2; }
		
		//','
		public Keyword getCommaKeyword_5_2_0() { return cCommaKeyword_5_2_0; }
		
		//ownedSpecializations+=SpecializationAxiom
		public Assignment getOwnedSpecializationsAssignment_5_2_1() { return cOwnedSpecializationsAssignment_5_2_1; }
		
		//SpecializationAxiom
		public RuleCall getOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0() { return cOwnedSpecializationsSpecializationAxiomParserRuleCall_5_2_1_0; }
	}
	public class RelationReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.RelationReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cRefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cRelationKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cRelationAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cRelationRelationCrossReference_3_0 = (CrossReference)cRelationAssignment_3.eContents().get(0);
		private final RuleCall cRelationRelationRefParserRuleCall_3_0_1 = (RuleCall)cRelationRelationCrossReference_3_0.eContents().get(1);
		
		//RelationReference:
		//    ownedAnnotations+=Annotation*
		//    'ref' 'relation' relation=[Relation|Ref];
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'ref' 'relation' relation=[Relation|Ref]
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'ref'
		public Keyword getRefKeyword_1() { return cRefKeyword_1; }
		
		//'relation'
		public Keyword getRelationKeyword_2() { return cRelationKeyword_2; }
		
		//relation=[Relation|Ref]
		public Assignment getRelationAssignment_3() { return cRelationAssignment_3; }
		
		//[Relation|Ref]
		public CrossReference getRelationRelationCrossReference_3_0() { return cRelationRelationCrossReference_3_0; }
		
		//Ref
		public RuleCall getRelationRelationRefParserRuleCall_3_0_1() { return cRelationRelationRefParserRuleCall_3_0_1; }
	}
	public class RuleReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.RuleReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cRefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cRuleKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cRuleAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cRuleRuleCrossReference_3_0 = (CrossReference)cRuleAssignment_3.eContents().get(0);
		private final RuleCall cRuleRuleRefParserRuleCall_3_0_1 = (RuleCall)cRuleRuleCrossReference_3_0.eContents().get(1);
		
		//RuleReference:
		//    ownedAnnotations+=Annotation*
		//    'ref' 'rule' rule=[Rule|Ref];
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'ref' 'rule' rule=[Rule|Ref]
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'ref'
		public Keyword getRefKeyword_1() { return cRefKeyword_1; }
		
		//'rule'
		public Keyword getRuleKeyword_2() { return cRuleKeyword_2; }
		
		//rule=[Rule|Ref]
		public Assignment getRuleAssignment_3() { return cRuleAssignment_3; }
		
		//[Rule|Ref]
		public CrossReference getRuleRuleCrossReference_3_0() { return cRuleRuleCrossReference_3_0; }
		
		//Ref
		public RuleCall getRuleRuleRefParserRuleCall_3_0_1() { return cRuleRuleRefParserRuleCall_3_0_1; }
	}
	public class NamedInstanceReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.NamedInstanceReference");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cConceptInstanceReferenceParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cRelationInstanceReferenceParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//NamedInstanceReference:
		//    ConceptInstanceReference |
		//    RelationInstanceReference;
		@Override public ParserRule getRule() { return rule; }
		
		//ConceptInstanceReference |
		//RelationInstanceReference
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//ConceptInstanceReference
		public RuleCall getConceptInstanceReferenceParserRuleCall_0() { return cConceptInstanceReferenceParserRuleCall_0; }
		
		//RelationInstanceReference
		public RuleCall getRelationInstanceReferenceParserRuleCall_1() { return cRelationInstanceReferenceParserRuleCall_1; }
	}
	public class ConceptInstanceReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.ConceptInstanceReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cRefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cCiKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cInstanceAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cInstanceConceptInstanceCrossReference_3_0 = (CrossReference)cInstanceAssignment_3.eContents().get(0);
		private final RuleCall cInstanceConceptInstanceRefParserRuleCall_3_0_1 = (RuleCall)cInstanceConceptInstanceCrossReference_3_0.eContents().get(1);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cColonKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Assignment cOwnedTypesAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final RuleCall cOwnedTypesConceptTypeAssertionParserRuleCall_4_1_0 = (RuleCall)cOwnedTypesAssignment_4_1.eContents().get(0);
		private final Group cGroup_4_2 = (Group)cGroup_4.eContents().get(2);
		private final Keyword cCommaKeyword_4_2_0 = (Keyword)cGroup_4_2.eContents().get(0);
		private final Assignment cOwnedTypesAssignment_4_2_1 = (Assignment)cGroup_4_2.eContents().get(1);
		private final RuleCall cOwnedTypesConceptTypeAssertionParserRuleCall_4_2_1_0 = (RuleCall)cOwnedTypesAssignment_4_2_1.eContents().get(0);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cLeftSquareBracketKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Assignment cOwnedPropertyValuesAssignment_5_1 = (Assignment)cGroup_5.eContents().get(1);
		private final RuleCall cOwnedPropertyValuesPropertyValueAssertionParserRuleCall_5_1_0 = (RuleCall)cOwnedPropertyValuesAssignment_5_1.eContents().get(0);
		private final Assignment cOwnedLinksAssignment_5_2 = (Assignment)cGroup_5.eContents().get(2);
		private final RuleCall cOwnedLinksLinkAssertionParserRuleCall_5_2_0 = (RuleCall)cOwnedLinksAssignment_5_2.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_5_3 = (Keyword)cGroup_5.eContents().get(3);
		
		//ConceptInstanceReference:
		//    ownedAnnotations+=Annotation*
		//    'ref' 'ci' instance=[ConceptInstance|Ref] (':' ownedTypes+=ConceptTypeAssertion (',' ownedTypes+=ConceptTypeAssertion)*)? ('['
		//        ownedPropertyValues+=PropertyValueAssertion*
		//        ownedLinks+=LinkAssertion*
		//    ']')?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'ref' 'ci' instance=[ConceptInstance|Ref] (':' ownedTypes+=ConceptTypeAssertion (',' ownedTypes+=ConceptTypeAssertion)*)? ('['
		//    ownedPropertyValues+=PropertyValueAssertion*
		//    ownedLinks+=LinkAssertion*
		//']')?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'ref'
		public Keyword getRefKeyword_1() { return cRefKeyword_1; }
		
		//'ci'
		public Keyword getCiKeyword_2() { return cCiKeyword_2; }
		
		//instance=[ConceptInstance|Ref]
		public Assignment getInstanceAssignment_3() { return cInstanceAssignment_3; }
		
		//[ConceptInstance|Ref]
		public CrossReference getInstanceConceptInstanceCrossReference_3_0() { return cInstanceConceptInstanceCrossReference_3_0; }
		
		//Ref
		public RuleCall getInstanceConceptInstanceRefParserRuleCall_3_0_1() { return cInstanceConceptInstanceRefParserRuleCall_3_0_1; }
		
		//(':' ownedTypes+=ConceptTypeAssertion (',' ownedTypes+=ConceptTypeAssertion)*)?
		public Group getGroup_4() { return cGroup_4; }
		
		//':'
		public Keyword getColonKeyword_4_0() { return cColonKeyword_4_0; }
		
		//ownedTypes+=ConceptTypeAssertion
		public Assignment getOwnedTypesAssignment_4_1() { return cOwnedTypesAssignment_4_1; }
		
		//ConceptTypeAssertion
		public RuleCall getOwnedTypesConceptTypeAssertionParserRuleCall_4_1_0() { return cOwnedTypesConceptTypeAssertionParserRuleCall_4_1_0; }
		
		//(',' ownedTypes+=ConceptTypeAssertion)*
		public Group getGroup_4_2() { return cGroup_4_2; }
		
		//','
		public Keyword getCommaKeyword_4_2_0() { return cCommaKeyword_4_2_0; }
		
		//ownedTypes+=ConceptTypeAssertion
		public Assignment getOwnedTypesAssignment_4_2_1() { return cOwnedTypesAssignment_4_2_1; }
		
		//ConceptTypeAssertion
		public RuleCall getOwnedTypesConceptTypeAssertionParserRuleCall_4_2_1_0() { return cOwnedTypesConceptTypeAssertionParserRuleCall_4_2_1_0; }
		
		//('['
		//       ownedPropertyValues+=PropertyValueAssertion*
		//       ownedLinks+=LinkAssertion*
		//   ']')?
		public Group getGroup_5() { return cGroup_5; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_5_0() { return cLeftSquareBracketKeyword_5_0; }
		
		//ownedPropertyValues+=PropertyValueAssertion*
		public Assignment getOwnedPropertyValuesAssignment_5_1() { return cOwnedPropertyValuesAssignment_5_1; }
		
		//PropertyValueAssertion
		public RuleCall getOwnedPropertyValuesPropertyValueAssertionParserRuleCall_5_1_0() { return cOwnedPropertyValuesPropertyValueAssertionParserRuleCall_5_1_0; }
		
		//ownedLinks+=LinkAssertion*
		public Assignment getOwnedLinksAssignment_5_2() { return cOwnedLinksAssignment_5_2; }
		
		//LinkAssertion
		public RuleCall getOwnedLinksLinkAssertionParserRuleCall_5_2_0() { return cOwnedLinksLinkAssertionParserRuleCall_5_2_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_5_3() { return cRightSquareBracketKeyword_5_3; }
	}
	public class RelationInstanceReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.RelationInstanceReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cRefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cRiKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cInstanceAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cInstanceRelationInstanceCrossReference_3_0 = (CrossReference)cInstanceAssignment_3.eContents().get(0);
		private final RuleCall cInstanceRelationInstanceRefParserRuleCall_3_0_1 = (RuleCall)cInstanceRelationInstanceCrossReference_3_0.eContents().get(1);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cColonKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Assignment cOwnedTypesAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final RuleCall cOwnedTypesRelationTypeAssertionParserRuleCall_4_1_0 = (RuleCall)cOwnedTypesAssignment_4_1.eContents().get(0);
		private final Group cGroup_4_2 = (Group)cGroup_4.eContents().get(2);
		private final Keyword cCommaKeyword_4_2_0 = (Keyword)cGroup_4_2.eContents().get(0);
		private final Assignment cOwnedTypesAssignment_4_2_1 = (Assignment)cGroup_4_2.eContents().get(1);
		private final RuleCall cOwnedTypesRelationTypeAssertionParserRuleCall_4_2_1_0 = (RuleCall)cOwnedTypesAssignment_4_2_1.eContents().get(0);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cLeftSquareBracketKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Assignment cOwnedPropertyValuesAssignment_5_1 = (Assignment)cGroup_5.eContents().get(1);
		private final RuleCall cOwnedPropertyValuesPropertyValueAssertionParserRuleCall_5_1_0 = (RuleCall)cOwnedPropertyValuesAssignment_5_1.eContents().get(0);
		private final Assignment cOwnedLinksAssignment_5_2 = (Assignment)cGroup_5.eContents().get(2);
		private final RuleCall cOwnedLinksLinkAssertionParserRuleCall_5_2_0 = (RuleCall)cOwnedLinksAssignment_5_2.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_5_3 = (Keyword)cGroup_5.eContents().get(3);
		
		//RelationInstanceReference:
		//    ownedAnnotations+=Annotation*
		//    'ref' 'ri' instance=[RelationInstance|Ref] (':' ownedTypes+=RelationTypeAssertion (',' ownedTypes+=RelationTypeAssertion)*)? ('['
		//        ownedPropertyValues+=PropertyValueAssertion*
		//        ownedLinks+=LinkAssertion*
		//    ']')?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'ref' 'ri' instance=[RelationInstance|Ref] (':' ownedTypes+=RelationTypeAssertion (',' ownedTypes+=RelationTypeAssertion)*)? ('['
		//    ownedPropertyValues+=PropertyValueAssertion*
		//    ownedLinks+=LinkAssertion*
		//']')?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'ref'
		public Keyword getRefKeyword_1() { return cRefKeyword_1; }
		
		//'ri'
		public Keyword getRiKeyword_2() { return cRiKeyword_2; }
		
		//instance=[RelationInstance|Ref]
		public Assignment getInstanceAssignment_3() { return cInstanceAssignment_3; }
		
		//[RelationInstance|Ref]
		public CrossReference getInstanceRelationInstanceCrossReference_3_0() { return cInstanceRelationInstanceCrossReference_3_0; }
		
		//Ref
		public RuleCall getInstanceRelationInstanceRefParserRuleCall_3_0_1() { return cInstanceRelationInstanceRefParserRuleCall_3_0_1; }
		
		//(':' ownedTypes+=RelationTypeAssertion (',' ownedTypes+=RelationTypeAssertion)*)?
		public Group getGroup_4() { return cGroup_4; }
		
		//':'
		public Keyword getColonKeyword_4_0() { return cColonKeyword_4_0; }
		
		//ownedTypes+=RelationTypeAssertion
		public Assignment getOwnedTypesAssignment_4_1() { return cOwnedTypesAssignment_4_1; }
		
		//RelationTypeAssertion
		public RuleCall getOwnedTypesRelationTypeAssertionParserRuleCall_4_1_0() { return cOwnedTypesRelationTypeAssertionParserRuleCall_4_1_0; }
		
		//(',' ownedTypes+=RelationTypeAssertion)*
		public Group getGroup_4_2() { return cGroup_4_2; }
		
		//','
		public Keyword getCommaKeyword_4_2_0() { return cCommaKeyword_4_2_0; }
		
		//ownedTypes+=RelationTypeAssertion
		public Assignment getOwnedTypesAssignment_4_2_1() { return cOwnedTypesAssignment_4_2_1; }
		
		//RelationTypeAssertion
		public RuleCall getOwnedTypesRelationTypeAssertionParserRuleCall_4_2_1_0() { return cOwnedTypesRelationTypeAssertionParserRuleCall_4_2_1_0; }
		
		//('['
		//       ownedPropertyValues+=PropertyValueAssertion*
		//       ownedLinks+=LinkAssertion*
		//   ']')?
		public Group getGroup_5() { return cGroup_5; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_5_0() { return cLeftSquareBracketKeyword_5_0; }
		
		//ownedPropertyValues+=PropertyValueAssertion*
		public Assignment getOwnedPropertyValuesAssignment_5_1() { return cOwnedPropertyValuesAssignment_5_1; }
		
		//PropertyValueAssertion
		public RuleCall getOwnedPropertyValuesPropertyValueAssertionParserRuleCall_5_1_0() { return cOwnedPropertyValuesPropertyValueAssertionParserRuleCall_5_1_0; }
		
		//ownedLinks+=LinkAssertion*
		public Assignment getOwnedLinksAssignment_5_2() { return cOwnedLinksAssignment_5_2; }
		
		//LinkAssertion
		public RuleCall getOwnedLinksLinkAssertionParserRuleCall_5_2_0() { return cOwnedLinksLinkAssertionParserRuleCall_5_2_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_5_3() { return cRightSquareBracketKeyword_5_3; }
	}
	public class VocabularyStatementElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.VocabularyStatement");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cRuleParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cRuleReferenceParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cSpecializableTermParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cSpecializableTermReferenceParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		private final RuleCall cRelationReferenceParserRuleCall_4 = (RuleCall)cAlternatives.eContents().get(4);
		
		//VocabularyStatement:
		//    Rule |
		//    RuleReference |
		//    SpecializableTerm |
		//    SpecializableTermReference |
		//    RelationReference;
		@Override public ParserRule getRule() { return rule; }
		
		//Rule |
		//RuleReference |
		//SpecializableTerm |
		//SpecializableTermReference |
		//RelationReference
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//Rule
		public RuleCall getRuleParserRuleCall_0() { return cRuleParserRuleCall_0; }
		
		//RuleReference
		public RuleCall getRuleReferenceParserRuleCall_1() { return cRuleReferenceParserRuleCall_1; }
		
		//SpecializableTerm
		public RuleCall getSpecializableTermParserRuleCall_2() { return cSpecializableTermParserRuleCall_2; }
		
		//SpecializableTermReference
		public RuleCall getSpecializableTermReferenceParserRuleCall_3() { return cSpecializableTermReferenceParserRuleCall_3; }
		
		//RelationReference
		public RuleCall getRelationReferenceParserRuleCall_4() { return cRelationReferenceParserRuleCall_4; }
	}
	public class DescriptionStatementElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.DescriptionStatement");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cNamedInstanceParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cNamedInstanceReferenceParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//DescriptionStatement:
		//    NamedInstance |
		//    NamedInstanceReference;
		@Override public ParserRule getRule() { return rule; }
		
		//NamedInstance |
		//NamedInstanceReference
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//NamedInstance
		public RuleCall getNamedInstanceParserRuleCall_0() { return cNamedInstanceParserRuleCall_0; }
		
		//NamedInstanceReference
		public RuleCall getNamedInstanceReferenceParserRuleCall_1() { return cNamedInstanceReferenceParserRuleCall_1; }
	}
	public class VocabularyImportElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.VocabularyImport");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cVocabularyExtensionParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cVocabularyUsageParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//VocabularyImport:
		//    VocabularyExtension |
		//    VocabularyUsage;
		@Override public ParserRule getRule() { return rule; }
		
		//VocabularyExtension |
		//VocabularyUsage
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//VocabularyExtension
		public RuleCall getVocabularyExtensionParserRuleCall_0() { return cVocabularyExtensionParserRuleCall_0; }
		
		//VocabularyUsage
		public RuleCall getVocabularyUsageParserRuleCall_1() { return cVocabularyUsageParserRuleCall_1; }
	}
	public class VocabularyExtensionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.VocabularyExtension");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cExtendsKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNamespaceAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNamespaceNAMESPACETerminalRuleCall_2_0 = (RuleCall)cNamespaceAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cAsKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cPrefixAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cPrefixIDTerminalRuleCall_3_1_0 = (RuleCall)cPrefixAssignment_3_1.eContents().get(0);
		
		//VocabularyExtension:
		//    ownedAnnotations+=Annotation*
		//    'extends' namespace=NAMESPACE ('as' prefix=ID)?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'extends' namespace=NAMESPACE ('as' prefix=ID)?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'extends'
		public Keyword getExtendsKeyword_1() { return cExtendsKeyword_1; }
		
		//namespace=NAMESPACE
		public Assignment getNamespaceAssignment_2() { return cNamespaceAssignment_2; }
		
		//NAMESPACE
		public RuleCall getNamespaceNAMESPACETerminalRuleCall_2_0() { return cNamespaceNAMESPACETerminalRuleCall_2_0; }
		
		//('as' prefix=ID)?
		public Group getGroup_3() { return cGroup_3; }
		
		//'as'
		public Keyword getAsKeyword_3_0() { return cAsKeyword_3_0; }
		
		//prefix=ID
		public Assignment getPrefixAssignment_3_1() { return cPrefixAssignment_3_1; }
		
		//ID
		public RuleCall getPrefixIDTerminalRuleCall_3_1_0() { return cPrefixIDTerminalRuleCall_3_1_0; }
	}
	public class VocabularyUsageElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.VocabularyUsage");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cUsesKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNamespaceAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNamespaceNAMESPACETerminalRuleCall_2_0 = (RuleCall)cNamespaceAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cAsKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cPrefixAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cPrefixIDTerminalRuleCall_3_1_0 = (RuleCall)cPrefixAssignment_3_1.eContents().get(0);
		
		//VocabularyUsage:
		//    ownedAnnotations+=Annotation*
		//    'uses' namespace=NAMESPACE ('as' prefix=ID)?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'uses' namespace=NAMESPACE ('as' prefix=ID)?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'uses'
		public Keyword getUsesKeyword_1() { return cUsesKeyword_1; }
		
		//namespace=NAMESPACE
		public Assignment getNamespaceAssignment_2() { return cNamespaceAssignment_2; }
		
		//NAMESPACE
		public RuleCall getNamespaceNAMESPACETerminalRuleCall_2_0() { return cNamespaceNAMESPACETerminalRuleCall_2_0; }
		
		//('as' prefix=ID)?
		public Group getGroup_3() { return cGroup_3; }
		
		//'as'
		public Keyword getAsKeyword_3_0() { return cAsKeyword_3_0; }
		
		//prefix=ID
		public Assignment getPrefixAssignment_3_1() { return cPrefixAssignment_3_1; }
		
		//ID
		public RuleCall getPrefixIDTerminalRuleCall_3_1_0() { return cPrefixIDTerminalRuleCall_3_1_0; }
	}
	public class VocabularyBundleImportElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.VocabularyBundleImport");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cVocabularyBundleExtensionParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cVocabularyBundleInclusionParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//VocabularyBundleImport:
		//    VocabularyBundleExtension |
		//    VocabularyBundleInclusion;
		@Override public ParserRule getRule() { return rule; }
		
		//VocabularyBundleExtension |
		//VocabularyBundleInclusion
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//VocabularyBundleExtension
		public RuleCall getVocabularyBundleExtensionParserRuleCall_0() { return cVocabularyBundleExtensionParserRuleCall_0; }
		
		//VocabularyBundleInclusion
		public RuleCall getVocabularyBundleInclusionParserRuleCall_1() { return cVocabularyBundleInclusionParserRuleCall_1; }
	}
	public class VocabularyBundleInclusionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.VocabularyBundleInclusion");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cIncludesKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNamespaceAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNamespaceNAMESPACETerminalRuleCall_2_0 = (RuleCall)cNamespaceAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cAsKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cPrefixAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cPrefixIDTerminalRuleCall_3_1_0 = (RuleCall)cPrefixAssignment_3_1.eContents().get(0);
		
		//VocabularyBundleInclusion:
		//    ownedAnnotations+=Annotation*
		//    'includes' namespace=NAMESPACE ('as' prefix=ID)?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'includes' namespace=NAMESPACE ('as' prefix=ID)?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'includes'
		public Keyword getIncludesKeyword_1() { return cIncludesKeyword_1; }
		
		//namespace=NAMESPACE
		public Assignment getNamespaceAssignment_2() { return cNamespaceAssignment_2; }
		
		//NAMESPACE
		public RuleCall getNamespaceNAMESPACETerminalRuleCall_2_0() { return cNamespaceNAMESPACETerminalRuleCall_2_0; }
		
		//('as' prefix=ID)?
		public Group getGroup_3() { return cGroup_3; }
		
		//'as'
		public Keyword getAsKeyword_3_0() { return cAsKeyword_3_0; }
		
		//prefix=ID
		public Assignment getPrefixAssignment_3_1() { return cPrefixAssignment_3_1; }
		
		//ID
		public RuleCall getPrefixIDTerminalRuleCall_3_1_0() { return cPrefixIDTerminalRuleCall_3_1_0; }
	}
	public class VocabularyBundleExtensionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.VocabularyBundleExtension");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cExtendsKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNamespaceAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNamespaceNAMESPACETerminalRuleCall_2_0 = (RuleCall)cNamespaceAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cAsKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cPrefixAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cPrefixIDTerminalRuleCall_3_1_0 = (RuleCall)cPrefixAssignment_3_1.eContents().get(0);
		
		//VocabularyBundleExtension:
		//    ownedAnnotations+=Annotation*
		//    'extends' namespace=NAMESPACE ('as' prefix=ID)?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'extends' namespace=NAMESPACE ('as' prefix=ID)?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'extends'
		public Keyword getExtendsKeyword_1() { return cExtendsKeyword_1; }
		
		//namespace=NAMESPACE
		public Assignment getNamespaceAssignment_2() { return cNamespaceAssignment_2; }
		
		//NAMESPACE
		public RuleCall getNamespaceNAMESPACETerminalRuleCall_2_0() { return cNamespaceNAMESPACETerminalRuleCall_2_0; }
		
		//('as' prefix=ID)?
		public Group getGroup_3() { return cGroup_3; }
		
		//'as'
		public Keyword getAsKeyword_3_0() { return cAsKeyword_3_0; }
		
		//prefix=ID
		public Assignment getPrefixAssignment_3_1() { return cPrefixAssignment_3_1; }
		
		//ID
		public RuleCall getPrefixIDTerminalRuleCall_3_1_0() { return cPrefixIDTerminalRuleCall_3_1_0; }
	}
	public class DescriptionImportElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.DescriptionImport");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cDescriptionExtensionParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cDescriptionUsageParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//DescriptionImport:
		//    DescriptionExtension |
		//    DescriptionUsage;
		@Override public ParserRule getRule() { return rule; }
		
		//DescriptionExtension |
		//DescriptionUsage
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//DescriptionExtension
		public RuleCall getDescriptionExtensionParserRuleCall_0() { return cDescriptionExtensionParserRuleCall_0; }
		
		//DescriptionUsage
		public RuleCall getDescriptionUsageParserRuleCall_1() { return cDescriptionUsageParserRuleCall_1; }
	}
	public class DescriptionUsageElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.DescriptionUsage");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cUsesKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNamespaceAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNamespaceNAMESPACETerminalRuleCall_2_0 = (RuleCall)cNamespaceAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cAsKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cPrefixAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cPrefixIDTerminalRuleCall_3_1_0 = (RuleCall)cPrefixAssignment_3_1.eContents().get(0);
		
		//DescriptionUsage:
		//    ownedAnnotations+=Annotation*
		//    'uses' namespace=NAMESPACE ('as' prefix=ID)?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'uses' namespace=NAMESPACE ('as' prefix=ID)?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'uses'
		public Keyword getUsesKeyword_1() { return cUsesKeyword_1; }
		
		//namespace=NAMESPACE
		public Assignment getNamespaceAssignment_2() { return cNamespaceAssignment_2; }
		
		//NAMESPACE
		public RuleCall getNamespaceNAMESPACETerminalRuleCall_2_0() { return cNamespaceNAMESPACETerminalRuleCall_2_0; }
		
		//('as' prefix=ID)?
		public Group getGroup_3() { return cGroup_3; }
		
		//'as'
		public Keyword getAsKeyword_3_0() { return cAsKeyword_3_0; }
		
		//prefix=ID
		public Assignment getPrefixAssignment_3_1() { return cPrefixAssignment_3_1; }
		
		//ID
		public RuleCall getPrefixIDTerminalRuleCall_3_1_0() { return cPrefixIDTerminalRuleCall_3_1_0; }
	}
	public class DescriptionExtensionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.DescriptionExtension");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cExtendsKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNamespaceAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNamespaceNAMESPACETerminalRuleCall_2_0 = (RuleCall)cNamespaceAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cAsKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cPrefixAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cPrefixIDTerminalRuleCall_3_1_0 = (RuleCall)cPrefixAssignment_3_1.eContents().get(0);
		
		//DescriptionExtension:
		//    ownedAnnotations+=Annotation*
		//    'extends' namespace=NAMESPACE ('as' prefix=ID)?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'extends' namespace=NAMESPACE ('as' prefix=ID)?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'extends'
		public Keyword getExtendsKeyword_1() { return cExtendsKeyword_1; }
		
		//namespace=NAMESPACE
		public Assignment getNamespaceAssignment_2() { return cNamespaceAssignment_2; }
		
		//NAMESPACE
		public RuleCall getNamespaceNAMESPACETerminalRuleCall_2_0() { return cNamespaceNAMESPACETerminalRuleCall_2_0; }
		
		//('as' prefix=ID)?
		public Group getGroup_3() { return cGroup_3; }
		
		//'as'
		public Keyword getAsKeyword_3_0() { return cAsKeyword_3_0; }
		
		//prefix=ID
		public Assignment getPrefixAssignment_3_1() { return cPrefixAssignment_3_1; }
		
		//ID
		public RuleCall getPrefixIDTerminalRuleCall_3_1_0() { return cPrefixIDTerminalRuleCall_3_1_0; }
	}
	public class DescriptionBundleImportElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.DescriptionBundleImport");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cDescriptionBundleExtensionParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cDescriptionBundleInclusionParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cDescriptionBundleUsageParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		//DescriptionBundleImport:
		//    DescriptionBundleExtension |
		//    DescriptionBundleInclusion |
		//    DescriptionBundleUsage;
		@Override public ParserRule getRule() { return rule; }
		
		//DescriptionBundleExtension |
		//DescriptionBundleInclusion |
		//DescriptionBundleUsage
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//DescriptionBundleExtension
		public RuleCall getDescriptionBundleExtensionParserRuleCall_0() { return cDescriptionBundleExtensionParserRuleCall_0; }
		
		//DescriptionBundleInclusion
		public RuleCall getDescriptionBundleInclusionParserRuleCall_1() { return cDescriptionBundleInclusionParserRuleCall_1; }
		
		//DescriptionBundleUsage
		public RuleCall getDescriptionBundleUsageParserRuleCall_2() { return cDescriptionBundleUsageParserRuleCall_2; }
	}
	public class DescriptionBundleInclusionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.DescriptionBundleInclusion");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cIncludesKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNamespaceAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNamespaceNAMESPACETerminalRuleCall_2_0 = (RuleCall)cNamespaceAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cAsKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cPrefixAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cPrefixIDTerminalRuleCall_3_1_0 = (RuleCall)cPrefixAssignment_3_1.eContents().get(0);
		
		//DescriptionBundleInclusion:
		//    ownedAnnotations+=Annotation*
		//    'includes' namespace=NAMESPACE ('as' prefix=ID)?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'includes' namespace=NAMESPACE ('as' prefix=ID)?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'includes'
		public Keyword getIncludesKeyword_1() { return cIncludesKeyword_1; }
		
		//namespace=NAMESPACE
		public Assignment getNamespaceAssignment_2() { return cNamespaceAssignment_2; }
		
		//NAMESPACE
		public RuleCall getNamespaceNAMESPACETerminalRuleCall_2_0() { return cNamespaceNAMESPACETerminalRuleCall_2_0; }
		
		//('as' prefix=ID)?
		public Group getGroup_3() { return cGroup_3; }
		
		//'as'
		public Keyword getAsKeyword_3_0() { return cAsKeyword_3_0; }
		
		//prefix=ID
		public Assignment getPrefixAssignment_3_1() { return cPrefixAssignment_3_1; }
		
		//ID
		public RuleCall getPrefixIDTerminalRuleCall_3_1_0() { return cPrefixIDTerminalRuleCall_3_1_0; }
	}
	public class DescriptionBundleExtensionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.DescriptionBundleExtension");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cExtendsKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNamespaceAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNamespaceNAMESPACETerminalRuleCall_2_0 = (RuleCall)cNamespaceAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cAsKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cPrefixAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cPrefixIDTerminalRuleCall_3_1_0 = (RuleCall)cPrefixAssignment_3_1.eContents().get(0);
		
		//DescriptionBundleExtension:
		//    ownedAnnotations+=Annotation*
		//    'extends' namespace=NAMESPACE ('as' prefix=ID)?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'extends' namespace=NAMESPACE ('as' prefix=ID)?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'extends'
		public Keyword getExtendsKeyword_1() { return cExtendsKeyword_1; }
		
		//namespace=NAMESPACE
		public Assignment getNamespaceAssignment_2() { return cNamespaceAssignment_2; }
		
		//NAMESPACE
		public RuleCall getNamespaceNAMESPACETerminalRuleCall_2_0() { return cNamespaceNAMESPACETerminalRuleCall_2_0; }
		
		//('as' prefix=ID)?
		public Group getGroup_3() { return cGroup_3; }
		
		//'as'
		public Keyword getAsKeyword_3_0() { return cAsKeyword_3_0; }
		
		//prefix=ID
		public Assignment getPrefixAssignment_3_1() { return cPrefixAssignment_3_1; }
		
		//ID
		public RuleCall getPrefixIDTerminalRuleCall_3_1_0() { return cPrefixIDTerminalRuleCall_3_1_0; }
	}
	public class DescriptionBundleUsageElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.DescriptionBundleUsage");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cOwnedAnnotationsAssignment_0.eContents().get(0);
		private final Keyword cUsesKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNamespaceAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNamespaceNAMESPACETerminalRuleCall_2_0 = (RuleCall)cNamespaceAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cAsKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cPrefixAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cPrefixIDTerminalRuleCall_3_1_0 = (RuleCall)cPrefixAssignment_3_1.eContents().get(0);
		
		//DescriptionBundleUsage:
		//    ownedAnnotations+=Annotation*
		//    'uses' namespace=NAMESPACE ('as' prefix=ID)?;
		@Override public ParserRule getRule() { return rule; }
		
		//ownedAnnotations+=Annotation*
		//'uses' namespace=NAMESPACE ('as' prefix=ID)?
		public Group getGroup() { return cGroup; }
		
		//ownedAnnotations+=Annotation*
		public Assignment getOwnedAnnotationsAssignment_0() { return cOwnedAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getOwnedAnnotationsAnnotationParserRuleCall_0_0() { return cOwnedAnnotationsAnnotationParserRuleCall_0_0; }
		
		//'uses'
		public Keyword getUsesKeyword_1() { return cUsesKeyword_1; }
		
		//namespace=NAMESPACE
		public Assignment getNamespaceAssignment_2() { return cNamespaceAssignment_2; }
		
		//NAMESPACE
		public RuleCall getNamespaceNAMESPACETerminalRuleCall_2_0() { return cNamespaceNAMESPACETerminalRuleCall_2_0; }
		
		//('as' prefix=ID)?
		public Group getGroup_3() { return cGroup_3; }
		
		//'as'
		public Keyword getAsKeyword_3_0() { return cAsKeyword_3_0; }
		
		//prefix=ID
		public Assignment getPrefixAssignment_3_1() { return cPrefixAssignment_3_1; }
		
		//ID
		public RuleCall getPrefixIDTerminalRuleCall_3_1_0() { return cPrefixIDTerminalRuleCall_3_1_0; }
	}
	public class SpecializationAxiomElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.SpecializationAxiom");
		private final Assignment cSpecializedTermAssignment = (Assignment)rule.eContents().get(1);
		private final CrossReference cSpecializedTermSpecializableTermCrossReference_0 = (CrossReference)cSpecializedTermAssignment.eContents().get(0);
		private final RuleCall cSpecializedTermSpecializableTermRefParserRuleCall_0_1 = (RuleCall)cSpecializedTermSpecializableTermCrossReference_0.eContents().get(1);
		
		//SpecializationAxiom:
		//    specializedTerm=[SpecializableTerm|Ref];
		@Override public ParserRule getRule() { return rule; }
		
		//specializedTerm=[SpecializableTerm|Ref]
		public Assignment getSpecializedTermAssignment() { return cSpecializedTermAssignment; }
		
		//[SpecializableTerm|Ref]
		public CrossReference getSpecializedTermSpecializableTermCrossReference_0() { return cSpecializedTermSpecializableTermCrossReference_0; }
		
		//Ref
		public RuleCall getSpecializedTermSpecializableTermRefParserRuleCall_0_1() { return cSpecializedTermSpecializableTermRefParserRuleCall_0_1; }
	}
	public class PropertyRestrictionAxiomElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.PropertyRestrictionAxiom");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cScalarPropertyRestrictionAxiomParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cStructuredPropertyRestrictionAxiomParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//PropertyRestrictionAxiom:
		//    ScalarPropertyRestrictionAxiom |
		//    StructuredPropertyRestrictionAxiom;
		@Override public ParserRule getRule() { return rule; }
		
		//ScalarPropertyRestrictionAxiom |
		//StructuredPropertyRestrictionAxiom
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//ScalarPropertyRestrictionAxiom
		public RuleCall getScalarPropertyRestrictionAxiomParserRuleCall_0() { return cScalarPropertyRestrictionAxiomParserRuleCall_0; }
		
		//StructuredPropertyRestrictionAxiom
		public RuleCall getStructuredPropertyRestrictionAxiomParserRuleCall_1() { return cStructuredPropertyRestrictionAxiomParserRuleCall_1; }
	}
	public class ScalarPropertyRestrictionAxiomElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.ScalarPropertyRestrictionAxiom");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cScalarPropertyRangeRestrictionAxiomParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cScalarPropertyCardinalityRestrictionAxiomParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cScalarPropertyValueRestrictionAxiomParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		//ScalarPropertyRestrictionAxiom:
		//    ScalarPropertyRangeRestrictionAxiom |
		//    ScalarPropertyCardinalityRestrictionAxiom |
		//    ScalarPropertyValueRestrictionAxiom;
		@Override public ParserRule getRule() { return rule; }
		
		//ScalarPropertyRangeRestrictionAxiom |
		//ScalarPropertyCardinalityRestrictionAxiom |
		//ScalarPropertyValueRestrictionAxiom
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//ScalarPropertyRangeRestrictionAxiom
		public RuleCall getScalarPropertyRangeRestrictionAxiomParserRuleCall_0() { return cScalarPropertyRangeRestrictionAxiomParserRuleCall_0; }
		
		//ScalarPropertyCardinalityRestrictionAxiom
		public RuleCall getScalarPropertyCardinalityRestrictionAxiomParserRuleCall_1() { return cScalarPropertyCardinalityRestrictionAxiomParserRuleCall_1; }
		
		//ScalarPropertyValueRestrictionAxiom
		public RuleCall getScalarPropertyValueRestrictionAxiomParserRuleCall_2() { return cScalarPropertyValueRestrictionAxiomParserRuleCall_2; }
	}
	public class ScalarPropertyRangeRestrictionAxiomElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.ScalarPropertyRangeRestrictionAxiom");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cRestrictsKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cKindAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cKindRangeRestrictionKindEnumRuleCall_1_0 = (RuleCall)cKindAssignment_1.eContents().get(0);
		private final Keyword cScalarKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Keyword cPropertyKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cPropertyAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final CrossReference cPropertyScalarPropertyCrossReference_4_0 = (CrossReference)cPropertyAssignment_4.eContents().get(0);
		private final RuleCall cPropertyScalarPropertyRefParserRuleCall_4_0_1 = (RuleCall)cPropertyScalarPropertyCrossReference_4_0.eContents().get(1);
		private final Keyword cToKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Assignment cRangeAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final CrossReference cRangeScalarCrossReference_6_0 = (CrossReference)cRangeAssignment_6.eContents().get(0);
		private final RuleCall cRangeScalarRefParserRuleCall_6_0_1 = (RuleCall)cRangeScalarCrossReference_6_0.eContents().get(1);
		
		//ScalarPropertyRangeRestrictionAxiom:
		//    'restricts' kind=RangeRestrictionKind 'scalar' 'property' property=[ScalarProperty|Ref] 'to' range=[Scalar|Ref];
		@Override public ParserRule getRule() { return rule; }
		
		//'restricts' kind=RangeRestrictionKind 'scalar' 'property' property=[ScalarProperty|Ref] 'to' range=[Scalar|Ref]
		public Group getGroup() { return cGroup; }
		
		//'restricts'
		public Keyword getRestrictsKeyword_0() { return cRestrictsKeyword_0; }
		
		//kind=RangeRestrictionKind
		public Assignment getKindAssignment_1() { return cKindAssignment_1; }
		
		//RangeRestrictionKind
		public RuleCall getKindRangeRestrictionKindEnumRuleCall_1_0() { return cKindRangeRestrictionKindEnumRuleCall_1_0; }
		
		//'scalar'
		public Keyword getScalarKeyword_2() { return cScalarKeyword_2; }
		
		//'property'
		public Keyword getPropertyKeyword_3() { return cPropertyKeyword_3; }
		
		//property=[ScalarProperty|Ref]
		public Assignment getPropertyAssignment_4() { return cPropertyAssignment_4; }
		
		//[ScalarProperty|Ref]
		public CrossReference getPropertyScalarPropertyCrossReference_4_0() { return cPropertyScalarPropertyCrossReference_4_0; }
		
		//Ref
		public RuleCall getPropertyScalarPropertyRefParserRuleCall_4_0_1() { return cPropertyScalarPropertyRefParserRuleCall_4_0_1; }
		
		//'to'
		public Keyword getToKeyword_5() { return cToKeyword_5; }
		
		//range=[Scalar|Ref]
		public Assignment getRangeAssignment_6() { return cRangeAssignment_6; }
		
		//[Scalar|Ref]
		public CrossReference getRangeScalarCrossReference_6_0() { return cRangeScalarCrossReference_6_0; }
		
		//Ref
		public RuleCall getRangeScalarRefParserRuleCall_6_0_1() { return cRangeScalarRefParserRuleCall_6_0_1; }
	}
	public class ScalarPropertyCardinalityRestrictionAxiomElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.ScalarPropertyCardinalityRestrictionAxiom");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cRestrictsKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cScalarKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cPropertyKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cPropertyAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cPropertyScalarPropertyCrossReference_3_0 = (CrossReference)cPropertyAssignment_3.eContents().get(0);
		private final RuleCall cPropertyScalarPropertyRefParserRuleCall_3_0_1 = (RuleCall)cPropertyScalarPropertyCrossReference_3_0.eContents().get(1);
		private final Keyword cToKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cKindAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final RuleCall cKindCardinalityRestrictionKindEnumRuleCall_5_0 = (RuleCall)cKindAssignment_5.eContents().get(0);
		private final Assignment cCardinalityAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cCardinalityUnsignedIntegerParserRuleCall_6_0 = (RuleCall)cCardinalityAssignment_6.eContents().get(0);
		private final Assignment cRangeAssignment_7 = (Assignment)cGroup.eContents().get(7);
		private final CrossReference cRangeScalarCrossReference_7_0 = (CrossReference)cRangeAssignment_7.eContents().get(0);
		private final RuleCall cRangeScalarRefParserRuleCall_7_0_1 = (RuleCall)cRangeScalarCrossReference_7_0.eContents().get(1);
		
		//ScalarPropertyCardinalityRestrictionAxiom:
		//    'restricts' 'scalar' 'property' property=[ScalarProperty|Ref] 'to' kind=CardinalityRestrictionKind cardinality=UnsignedInteger (range=[Scalar|Ref])?;
		@Override public ParserRule getRule() { return rule; }
		
		//'restricts' 'scalar' 'property' property=[ScalarProperty|Ref] 'to' kind=CardinalityRestrictionKind cardinality=UnsignedInteger (range=[Scalar|Ref])?
		public Group getGroup() { return cGroup; }
		
		//'restricts'
		public Keyword getRestrictsKeyword_0() { return cRestrictsKeyword_0; }
		
		//'scalar'
		public Keyword getScalarKeyword_1() { return cScalarKeyword_1; }
		
		//'property'
		public Keyword getPropertyKeyword_2() { return cPropertyKeyword_2; }
		
		//property=[ScalarProperty|Ref]
		public Assignment getPropertyAssignment_3() { return cPropertyAssignment_3; }
		
		//[ScalarProperty|Ref]
		public CrossReference getPropertyScalarPropertyCrossReference_3_0() { return cPropertyScalarPropertyCrossReference_3_0; }
		
		//Ref
		public RuleCall getPropertyScalarPropertyRefParserRuleCall_3_0_1() { return cPropertyScalarPropertyRefParserRuleCall_3_0_1; }
		
		//'to'
		public Keyword getToKeyword_4() { return cToKeyword_4; }
		
		//kind=CardinalityRestrictionKind
		public Assignment getKindAssignment_5() { return cKindAssignment_5; }
		
		//CardinalityRestrictionKind
		public RuleCall getKindCardinalityRestrictionKindEnumRuleCall_5_0() { return cKindCardinalityRestrictionKindEnumRuleCall_5_0; }
		
		//cardinality=UnsignedInteger
		public Assignment getCardinalityAssignment_6() { return cCardinalityAssignment_6; }
		
		//UnsignedInteger
		public RuleCall getCardinalityUnsignedIntegerParserRuleCall_6_0() { return cCardinalityUnsignedIntegerParserRuleCall_6_0; }
		
		//(range=[Scalar|Ref])?
		public Assignment getRangeAssignment_7() { return cRangeAssignment_7; }
		
		//[Scalar|Ref]
		public CrossReference getRangeScalarCrossReference_7_0() { return cRangeScalarCrossReference_7_0; }
		
		//Ref
		public RuleCall getRangeScalarRefParserRuleCall_7_0_1() { return cRangeScalarRefParserRuleCall_7_0_1; }
	}
	public class ScalarPropertyValueRestrictionAxiomElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.ScalarPropertyValueRestrictionAxiom");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cRestrictsKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cScalarKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cPropertyKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cPropertyAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cPropertyScalarPropertyCrossReference_3_0 = (CrossReference)cPropertyAssignment_3.eContents().get(0);
		private final RuleCall cPropertyScalarPropertyRefParserRuleCall_3_0_1 = (RuleCall)cPropertyScalarPropertyCrossReference_3_0.eContents().get(1);
		private final Keyword cToKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cValueAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final RuleCall cValueLiteralParserRuleCall_5_0 = (RuleCall)cValueAssignment_5.eContents().get(0);
		
		//ScalarPropertyValueRestrictionAxiom:
		//    'restricts' 'scalar' 'property' property=[ScalarProperty|Ref] 'to' value=Literal;
		@Override public ParserRule getRule() { return rule; }
		
		//'restricts' 'scalar' 'property' property=[ScalarProperty|Ref] 'to' value=Literal
		public Group getGroup() { return cGroup; }
		
		//'restricts'
		public Keyword getRestrictsKeyword_0() { return cRestrictsKeyword_0; }
		
		//'scalar'
		public Keyword getScalarKeyword_1() { return cScalarKeyword_1; }
		
		//'property'
		public Keyword getPropertyKeyword_2() { return cPropertyKeyword_2; }
		
		//property=[ScalarProperty|Ref]
		public Assignment getPropertyAssignment_3() { return cPropertyAssignment_3; }
		
		//[ScalarProperty|Ref]
		public CrossReference getPropertyScalarPropertyCrossReference_3_0() { return cPropertyScalarPropertyCrossReference_3_0; }
		
		//Ref
		public RuleCall getPropertyScalarPropertyRefParserRuleCall_3_0_1() { return cPropertyScalarPropertyRefParserRuleCall_3_0_1; }
		
		//'to'
		public Keyword getToKeyword_4() { return cToKeyword_4; }
		
		//value=Literal
		public Assignment getValueAssignment_5() { return cValueAssignment_5; }
		
		//Literal
		public RuleCall getValueLiteralParserRuleCall_5_0() { return cValueLiteralParserRuleCall_5_0; }
	}
	public class StructuredPropertyRestrictionAxiomElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.StructuredPropertyRestrictionAxiom");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cStructuredPropertyRangeRestrictionAxiomParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cStructuredPropertyCardinalityRestrictionAxiomParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cStructuredPropertyValueRestrictionAxiomParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		//StructuredPropertyRestrictionAxiom:
		//    StructuredPropertyRangeRestrictionAxiom |
		//    StructuredPropertyCardinalityRestrictionAxiom |
		//    StructuredPropertyValueRestrictionAxiom;
		@Override public ParserRule getRule() { return rule; }
		
		//StructuredPropertyRangeRestrictionAxiom |
		//StructuredPropertyCardinalityRestrictionAxiom |
		//StructuredPropertyValueRestrictionAxiom
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//StructuredPropertyRangeRestrictionAxiom
		public RuleCall getStructuredPropertyRangeRestrictionAxiomParserRuleCall_0() { return cStructuredPropertyRangeRestrictionAxiomParserRuleCall_0; }
		
		//StructuredPropertyCardinalityRestrictionAxiom
		public RuleCall getStructuredPropertyCardinalityRestrictionAxiomParserRuleCall_1() { return cStructuredPropertyCardinalityRestrictionAxiomParserRuleCall_1; }
		
		//StructuredPropertyValueRestrictionAxiom
		public RuleCall getStructuredPropertyValueRestrictionAxiomParserRuleCall_2() { return cStructuredPropertyValueRestrictionAxiomParserRuleCall_2; }
	}
	public class StructuredPropertyRangeRestrictionAxiomElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.StructuredPropertyRangeRestrictionAxiom");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cRestrictsKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cKindAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cKindRangeRestrictionKindEnumRuleCall_1_0 = (RuleCall)cKindAssignment_1.eContents().get(0);
		private final Keyword cStructuredKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Keyword cPropertyKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cPropertyAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final CrossReference cPropertyStructuredPropertyCrossReference_4_0 = (CrossReference)cPropertyAssignment_4.eContents().get(0);
		private final RuleCall cPropertyStructuredPropertyRefParserRuleCall_4_0_1 = (RuleCall)cPropertyStructuredPropertyCrossReference_4_0.eContents().get(1);
		private final Keyword cToKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Assignment cRangeAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final CrossReference cRangeStructureCrossReference_6_0 = (CrossReference)cRangeAssignment_6.eContents().get(0);
		private final RuleCall cRangeStructureRefParserRuleCall_6_0_1 = (RuleCall)cRangeStructureCrossReference_6_0.eContents().get(1);
		
		//StructuredPropertyRangeRestrictionAxiom:
		//    'restricts' kind=RangeRestrictionKind 'structured' 'property' property=[StructuredProperty|Ref] 'to' range=[Structure|Ref];
		@Override public ParserRule getRule() { return rule; }
		
		//'restricts' kind=RangeRestrictionKind 'structured' 'property' property=[StructuredProperty|Ref] 'to' range=[Structure|Ref]
		public Group getGroup() { return cGroup; }
		
		//'restricts'
		public Keyword getRestrictsKeyword_0() { return cRestrictsKeyword_0; }
		
		//kind=RangeRestrictionKind
		public Assignment getKindAssignment_1() { return cKindAssignment_1; }
		
		//RangeRestrictionKind
		public RuleCall getKindRangeRestrictionKindEnumRuleCall_1_0() { return cKindRangeRestrictionKindEnumRuleCall_1_0; }
		
		//'structured'
		public Keyword getStructuredKeyword_2() { return cStructuredKeyword_2; }
		
		//'property'
		public Keyword getPropertyKeyword_3() { return cPropertyKeyword_3; }
		
		//property=[StructuredProperty|Ref]
		public Assignment getPropertyAssignment_4() { return cPropertyAssignment_4; }
		
		//[StructuredProperty|Ref]
		public CrossReference getPropertyStructuredPropertyCrossReference_4_0() { return cPropertyStructuredPropertyCrossReference_4_0; }
		
		//Ref
		public RuleCall getPropertyStructuredPropertyRefParserRuleCall_4_0_1() { return cPropertyStructuredPropertyRefParserRuleCall_4_0_1; }
		
		//'to'
		public Keyword getToKeyword_5() { return cToKeyword_5; }
		
		//range=[Structure|Ref]
		public Assignment getRangeAssignment_6() { return cRangeAssignment_6; }
		
		//[Structure|Ref]
		public CrossReference getRangeStructureCrossReference_6_0() { return cRangeStructureCrossReference_6_0; }
		
		//Ref
		public RuleCall getRangeStructureRefParserRuleCall_6_0_1() { return cRangeStructureRefParserRuleCall_6_0_1; }
	}
	public class StructuredPropertyCardinalityRestrictionAxiomElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.StructuredPropertyCardinalityRestrictionAxiom");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cRestrictsKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cStructuredKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cPropertyKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cPropertyAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cPropertyStructuredPropertyCrossReference_3_0 = (CrossReference)cPropertyAssignment_3.eContents().get(0);
		private final RuleCall cPropertyStructuredPropertyRefParserRuleCall_3_0_1 = (RuleCall)cPropertyStructuredPropertyCrossReference_3_0.eContents().get(1);
		private final Keyword cToKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cKindAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final RuleCall cKindCardinalityRestrictionKindEnumRuleCall_5_0 = (RuleCall)cKindAssignment_5.eContents().get(0);
		private final Assignment cCardinalityAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cCardinalityUnsignedIntegerParserRuleCall_6_0 = (RuleCall)cCardinalityAssignment_6.eContents().get(0);
		private final Assignment cRangeAssignment_7 = (Assignment)cGroup.eContents().get(7);
		private final CrossReference cRangeStructureCrossReference_7_0 = (CrossReference)cRangeAssignment_7.eContents().get(0);
		private final RuleCall cRangeStructureRefParserRuleCall_7_0_1 = (RuleCall)cRangeStructureCrossReference_7_0.eContents().get(1);
		
		//StructuredPropertyCardinalityRestrictionAxiom:
		//    'restricts' 'structured' 'property' property=[StructuredProperty|Ref] 'to' kind=CardinalityRestrictionKind cardinality=UnsignedInteger (range=[Structure|Ref])?;
		@Override public ParserRule getRule() { return rule; }
		
		//'restricts' 'structured' 'property' property=[StructuredProperty|Ref] 'to' kind=CardinalityRestrictionKind cardinality=UnsignedInteger (range=[Structure|Ref])?
		public Group getGroup() { return cGroup; }
		
		//'restricts'
		public Keyword getRestrictsKeyword_0() { return cRestrictsKeyword_0; }
		
		//'structured'
		public Keyword getStructuredKeyword_1() { return cStructuredKeyword_1; }
		
		//'property'
		public Keyword getPropertyKeyword_2() { return cPropertyKeyword_2; }
		
		//property=[StructuredProperty|Ref]
		public Assignment getPropertyAssignment_3() { return cPropertyAssignment_3; }
		
		//[StructuredProperty|Ref]
		public CrossReference getPropertyStructuredPropertyCrossReference_3_0() { return cPropertyStructuredPropertyCrossReference_3_0; }
		
		//Ref
		public RuleCall getPropertyStructuredPropertyRefParserRuleCall_3_0_1() { return cPropertyStructuredPropertyRefParserRuleCall_3_0_1; }
		
		//'to'
		public Keyword getToKeyword_4() { return cToKeyword_4; }
		
		//kind=CardinalityRestrictionKind
		public Assignment getKindAssignment_5() { return cKindAssignment_5; }
		
		//CardinalityRestrictionKind
		public RuleCall getKindCardinalityRestrictionKindEnumRuleCall_5_0() { return cKindCardinalityRestrictionKindEnumRuleCall_5_0; }
		
		//cardinality=UnsignedInteger
		public Assignment getCardinalityAssignment_6() { return cCardinalityAssignment_6; }
		
		//UnsignedInteger
		public RuleCall getCardinalityUnsignedIntegerParserRuleCall_6_0() { return cCardinalityUnsignedIntegerParserRuleCall_6_0; }
		
		//(range=[Structure|Ref])?
		public Assignment getRangeAssignment_7() { return cRangeAssignment_7; }
		
		//[Structure|Ref]
		public CrossReference getRangeStructureCrossReference_7_0() { return cRangeStructureCrossReference_7_0; }
		
		//Ref
		public RuleCall getRangeStructureRefParserRuleCall_7_0_1() { return cRangeStructureRefParserRuleCall_7_0_1; }
	}
	public class StructuredPropertyValueRestrictionAxiomElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.StructuredPropertyValueRestrictionAxiom");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cRestrictsKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cStructuredKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cPropertyKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cPropertyAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cPropertyStructuredPropertyCrossReference_3_0 = (CrossReference)cPropertyAssignment_3.eContents().get(0);
		private final RuleCall cPropertyStructuredPropertyRefParserRuleCall_3_0_1 = (RuleCall)cPropertyStructuredPropertyCrossReference_3_0.eContents().get(1);
		private final Keyword cToKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cValueAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final RuleCall cValueStructureInstanceParserRuleCall_5_0 = (RuleCall)cValueAssignment_5.eContents().get(0);
		
		//StructuredPropertyValueRestrictionAxiom:
		//    'restricts' 'structured' 'property' property=[StructuredProperty|Ref] 'to' value=StructureInstance;
		@Override public ParserRule getRule() { return rule; }
		
		//'restricts' 'structured' 'property' property=[StructuredProperty|Ref] 'to' value=StructureInstance
		public Group getGroup() { return cGroup; }
		
		//'restricts'
		public Keyword getRestrictsKeyword_0() { return cRestrictsKeyword_0; }
		
		//'structured'
		public Keyword getStructuredKeyword_1() { return cStructuredKeyword_1; }
		
		//'property'
		public Keyword getPropertyKeyword_2() { return cPropertyKeyword_2; }
		
		//property=[StructuredProperty|Ref]
		public Assignment getPropertyAssignment_3() { return cPropertyAssignment_3; }
		
		//[StructuredProperty|Ref]
		public CrossReference getPropertyStructuredPropertyCrossReference_3_0() { return cPropertyStructuredPropertyCrossReference_3_0; }
		
		//Ref
		public RuleCall getPropertyStructuredPropertyRefParserRuleCall_3_0_1() { return cPropertyStructuredPropertyRefParserRuleCall_3_0_1; }
		
		//'to'
		public Keyword getToKeyword_4() { return cToKeyword_4; }
		
		//value=StructureInstance
		public Assignment getValueAssignment_5() { return cValueAssignment_5; }
		
		//StructureInstance
		public RuleCall getValueStructureInstanceParserRuleCall_5_0() { return cValueStructureInstanceParserRuleCall_5_0; }
	}
	public class RelationRestrictionAxiomElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.RelationRestrictionAxiom");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cRelationRangeRestrictionAxiomParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cRelationCardinalityRestrictionAxiomParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cRelationTargetRestrictionAxiomParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		//RelationRestrictionAxiom:
		//    RelationRangeRestrictionAxiom |
		//    RelationCardinalityRestrictionAxiom |
		//    RelationTargetRestrictionAxiom;
		@Override public ParserRule getRule() { return rule; }
		
		//RelationRangeRestrictionAxiom |
		//RelationCardinalityRestrictionAxiom |
		//RelationTargetRestrictionAxiom
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//RelationRangeRestrictionAxiom
		public RuleCall getRelationRangeRestrictionAxiomParserRuleCall_0() { return cRelationRangeRestrictionAxiomParserRuleCall_0; }
		
		//RelationCardinalityRestrictionAxiom
		public RuleCall getRelationCardinalityRestrictionAxiomParserRuleCall_1() { return cRelationCardinalityRestrictionAxiomParserRuleCall_1; }
		
		//RelationTargetRestrictionAxiom
		public RuleCall getRelationTargetRestrictionAxiomParserRuleCall_2() { return cRelationTargetRestrictionAxiomParserRuleCall_2; }
	}
	public class RelationRangeRestrictionAxiomElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.RelationRangeRestrictionAxiom");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cRestrictsKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cKindAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cKindRangeRestrictionKindEnumRuleCall_1_0 = (RuleCall)cKindAssignment_1.eContents().get(0);
		private final Keyword cRelationKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cRelationAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cRelationRelationCrossReference_3_0 = (CrossReference)cRelationAssignment_3.eContents().get(0);
		private final RuleCall cRelationRelationRefParserRuleCall_3_0_1 = (RuleCall)cRelationRelationCrossReference_3_0.eContents().get(1);
		private final Keyword cToKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cRangeAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final CrossReference cRangeEntityCrossReference_5_0 = (CrossReference)cRangeAssignment_5.eContents().get(0);
		private final RuleCall cRangeEntityRefParserRuleCall_5_0_1 = (RuleCall)cRangeEntityCrossReference_5_0.eContents().get(1);
		
		//RelationRangeRestrictionAxiom:
		//    'restricts' kind=RangeRestrictionKind 'relation' relation=[Relation|Ref] 'to' range=[Entity|Ref];
		@Override public ParserRule getRule() { return rule; }
		
		//'restricts' kind=RangeRestrictionKind 'relation' relation=[Relation|Ref] 'to' range=[Entity|Ref]
		public Group getGroup() { return cGroup; }
		
		//'restricts'
		public Keyword getRestrictsKeyword_0() { return cRestrictsKeyword_0; }
		
		//kind=RangeRestrictionKind
		public Assignment getKindAssignment_1() { return cKindAssignment_1; }
		
		//RangeRestrictionKind
		public RuleCall getKindRangeRestrictionKindEnumRuleCall_1_0() { return cKindRangeRestrictionKindEnumRuleCall_1_0; }
		
		//'relation'
		public Keyword getRelationKeyword_2() { return cRelationKeyword_2; }
		
		//relation=[Relation|Ref]
		public Assignment getRelationAssignment_3() { return cRelationAssignment_3; }
		
		//[Relation|Ref]
		public CrossReference getRelationRelationCrossReference_3_0() { return cRelationRelationCrossReference_3_0; }
		
		//Ref
		public RuleCall getRelationRelationRefParserRuleCall_3_0_1() { return cRelationRelationRefParserRuleCall_3_0_1; }
		
		//'to'
		public Keyword getToKeyword_4() { return cToKeyword_4; }
		
		//range=[Entity|Ref]
		public Assignment getRangeAssignment_5() { return cRangeAssignment_5; }
		
		//[Entity|Ref]
		public CrossReference getRangeEntityCrossReference_5_0() { return cRangeEntityCrossReference_5_0; }
		
		//Ref
		public RuleCall getRangeEntityRefParserRuleCall_5_0_1() { return cRangeEntityRefParserRuleCall_5_0_1; }
	}
	public class RelationCardinalityRestrictionAxiomElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.RelationCardinalityRestrictionAxiom");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cRestrictsKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cRelationKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cRelationAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final CrossReference cRelationRelationCrossReference_2_0 = (CrossReference)cRelationAssignment_2.eContents().get(0);
		private final RuleCall cRelationRelationRefParserRuleCall_2_0_1 = (RuleCall)cRelationRelationCrossReference_2_0.eContents().get(1);
		private final Keyword cToKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cKindAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cKindCardinalityRestrictionKindEnumRuleCall_4_0 = (RuleCall)cKindAssignment_4.eContents().get(0);
		private final Assignment cCardinalityAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final RuleCall cCardinalityUnsignedIntegerParserRuleCall_5_0 = (RuleCall)cCardinalityAssignment_5.eContents().get(0);
		private final Assignment cRangeAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final CrossReference cRangeEntityCrossReference_6_0 = (CrossReference)cRangeAssignment_6.eContents().get(0);
		private final RuleCall cRangeEntityRefParserRuleCall_6_0_1 = (RuleCall)cRangeEntityCrossReference_6_0.eContents().get(1);
		
		//RelationCardinalityRestrictionAxiom:
		//    'restricts' 'relation' relation=[Relation|Ref] 'to' kind=CardinalityRestrictionKind cardinality=UnsignedInteger (range=[Entity|Ref])?;
		@Override public ParserRule getRule() { return rule; }
		
		//'restricts' 'relation' relation=[Relation|Ref] 'to' kind=CardinalityRestrictionKind cardinality=UnsignedInteger (range=[Entity|Ref])?
		public Group getGroup() { return cGroup; }
		
		//'restricts'
		public Keyword getRestrictsKeyword_0() { return cRestrictsKeyword_0; }
		
		//'relation'
		public Keyword getRelationKeyword_1() { return cRelationKeyword_1; }
		
		//relation=[Relation|Ref]
		public Assignment getRelationAssignment_2() { return cRelationAssignment_2; }
		
		//[Relation|Ref]
		public CrossReference getRelationRelationCrossReference_2_0() { return cRelationRelationCrossReference_2_0; }
		
		//Ref
		public RuleCall getRelationRelationRefParserRuleCall_2_0_1() { return cRelationRelationRefParserRuleCall_2_0_1; }
		
		//'to'
		public Keyword getToKeyword_3() { return cToKeyword_3; }
		
		//kind=CardinalityRestrictionKind
		public Assignment getKindAssignment_4() { return cKindAssignment_4; }
		
		//CardinalityRestrictionKind
		public RuleCall getKindCardinalityRestrictionKindEnumRuleCall_4_0() { return cKindCardinalityRestrictionKindEnumRuleCall_4_0; }
		
		//cardinality=UnsignedInteger
		public Assignment getCardinalityAssignment_5() { return cCardinalityAssignment_5; }
		
		//UnsignedInteger
		public RuleCall getCardinalityUnsignedIntegerParserRuleCall_5_0() { return cCardinalityUnsignedIntegerParserRuleCall_5_0; }
		
		//(range=[Entity|Ref])?
		public Assignment getRangeAssignment_6() { return cRangeAssignment_6; }
		
		//[Entity|Ref]
		public CrossReference getRangeEntityCrossReference_6_0() { return cRangeEntityCrossReference_6_0; }
		
		//Ref
		public RuleCall getRangeEntityRefParserRuleCall_6_0_1() { return cRangeEntityRefParserRuleCall_6_0_1; }
	}
	public class RelationTargetRestrictionAxiomElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.RelationTargetRestrictionAxiom");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cRestrictsKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cRelationKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cRelationAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final CrossReference cRelationRelationCrossReference_2_0 = (CrossReference)cRelationAssignment_2.eContents().get(0);
		private final RuleCall cRelationRelationRefParserRuleCall_2_0_1 = (RuleCall)cRelationRelationCrossReference_2_0.eContents().get(1);
		private final Keyword cToKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cTargetAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final CrossReference cTargetNamedInstanceCrossReference_4_0 = (CrossReference)cTargetAssignment_4.eContents().get(0);
		private final RuleCall cTargetNamedInstanceRefParserRuleCall_4_0_1 = (RuleCall)cTargetNamedInstanceCrossReference_4_0.eContents().get(1);
		
		//RelationTargetRestrictionAxiom:
		//    'restricts' 'relation' relation=[Relation|Ref] 'to' target=[NamedInstance|Ref];
		@Override public ParserRule getRule() { return rule; }
		
		//'restricts' 'relation' relation=[Relation|Ref] 'to' target=[NamedInstance|Ref]
		public Group getGroup() { return cGroup; }
		
		//'restricts'
		public Keyword getRestrictsKeyword_0() { return cRestrictsKeyword_0; }
		
		//'relation'
		public Keyword getRelationKeyword_1() { return cRelationKeyword_1; }
		
		//relation=[Relation|Ref]
		public Assignment getRelationAssignment_2() { return cRelationAssignment_2; }
		
		//[Relation|Ref]
		public CrossReference getRelationRelationCrossReference_2_0() { return cRelationRelationCrossReference_2_0; }
		
		//Ref
		public RuleCall getRelationRelationRefParserRuleCall_2_0_1() { return cRelationRelationRefParserRuleCall_2_0_1; }
		
		//'to'
		public Keyword getToKeyword_3() { return cToKeyword_3; }
		
		//target=[NamedInstance|Ref]
		public Assignment getTargetAssignment_4() { return cTargetAssignment_4; }
		
		//[NamedInstance|Ref]
		public CrossReference getTargetNamedInstanceCrossReference_4_0() { return cTargetNamedInstanceCrossReference_4_0; }
		
		//Ref
		public RuleCall getTargetNamedInstanceRefParserRuleCall_4_0_1() { return cTargetNamedInstanceRefParserRuleCall_4_0_1; }
	}
	public class KeyAxiomElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.KeyAxiom");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cKeyKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cPropertiesAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cPropertiesFeatureCrossReference_1_0 = (CrossReference)cPropertiesAssignment_1.eContents().get(0);
		private final RuleCall cPropertiesFeatureRefParserRuleCall_1_0_1 = (RuleCall)cPropertiesFeatureCrossReference_1_0.eContents().get(1);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cCommaKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cPropertiesAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final CrossReference cPropertiesFeatureCrossReference_2_1_0 = (CrossReference)cPropertiesAssignment_2_1.eContents().get(0);
		private final RuleCall cPropertiesFeatureRefParserRuleCall_2_1_0_1 = (RuleCall)cPropertiesFeatureCrossReference_2_1_0.eContents().get(1);
		
		//KeyAxiom:
		//    'key' properties+=[Feature|Ref] (',' properties+=[Feature|Ref])*;
		@Override public ParserRule getRule() { return rule; }
		
		//'key' properties+=[Feature|Ref] (',' properties+=[Feature|Ref])*
		public Group getGroup() { return cGroup; }
		
		//'key'
		public Keyword getKeyKeyword_0() { return cKeyKeyword_0; }
		
		//properties+=[Feature|Ref]
		public Assignment getPropertiesAssignment_1() { return cPropertiesAssignment_1; }
		
		//[Feature|Ref]
		public CrossReference getPropertiesFeatureCrossReference_1_0() { return cPropertiesFeatureCrossReference_1_0; }
		
		//Ref
		public RuleCall getPropertiesFeatureRefParserRuleCall_1_0_1() { return cPropertiesFeatureRefParserRuleCall_1_0_1; }
		
		//(',' properties+=[Feature|Ref])*
		public Group getGroup_2() { return cGroup_2; }
		
		//','
		public Keyword getCommaKeyword_2_0() { return cCommaKeyword_2_0; }
		
		//properties+=[Feature|Ref]
		public Assignment getPropertiesAssignment_2_1() { return cPropertiesAssignment_2_1; }
		
		//[Feature|Ref]
		public CrossReference getPropertiesFeatureCrossReference_2_1_0() { return cPropertiesFeatureCrossReference_2_1_0; }
		
		//Ref
		public RuleCall getPropertiesFeatureRefParserRuleCall_2_1_0_1() { return cPropertiesFeatureRefParserRuleCall_2_1_0_1; }
	}
	public class ConceptTypeAssertionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.ConceptTypeAssertion");
		private final Assignment cTypeAssignment = (Assignment)rule.eContents().get(1);
		private final CrossReference cTypeConceptCrossReference_0 = (CrossReference)cTypeAssignment.eContents().get(0);
		private final RuleCall cTypeConceptRefParserRuleCall_0_1 = (RuleCall)cTypeConceptCrossReference_0.eContents().get(1);
		
		//ConceptTypeAssertion:
		//    type=[Concept|Ref];
		@Override public ParserRule getRule() { return rule; }
		
		//type=[Concept|Ref]
		public Assignment getTypeAssignment() { return cTypeAssignment; }
		
		//[Concept|Ref]
		public CrossReference getTypeConceptCrossReference_0() { return cTypeConceptCrossReference_0; }
		
		//Ref
		public RuleCall getTypeConceptRefParserRuleCall_0_1() { return cTypeConceptRefParserRuleCall_0_1; }
	}
	public class RelationTypeAssertionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.RelationTypeAssertion");
		private final Assignment cTypeAssignment = (Assignment)rule.eContents().get(1);
		private final CrossReference cTypeRelationEntityCrossReference_0 = (CrossReference)cTypeAssignment.eContents().get(0);
		private final RuleCall cTypeRelationEntityRefParserRuleCall_0_1 = (RuleCall)cTypeRelationEntityCrossReference_0.eContents().get(1);
		
		//RelationTypeAssertion:
		//    type=[RelationEntity|Ref];
		@Override public ParserRule getRule() { return rule; }
		
		//type=[RelationEntity|Ref]
		public Assignment getTypeAssignment() { return cTypeAssignment; }
		
		//[RelationEntity|Ref]
		public CrossReference getTypeRelationEntityCrossReference_0() { return cTypeRelationEntityCrossReference_0; }
		
		//Ref
		public RuleCall getTypeRelationEntityRefParserRuleCall_0_1() { return cTypeRelationEntityRefParserRuleCall_0_1; }
	}
	public class PropertyValueAssertionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.PropertyValueAssertion");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cScalarPropertyValueAssertionParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cStructuredPropertyValueAssertionParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//PropertyValueAssertion:
		//    ScalarPropertyValueAssertion |
		//    StructuredPropertyValueAssertion;
		@Override public ParserRule getRule() { return rule; }
		
		//ScalarPropertyValueAssertion |
		//StructuredPropertyValueAssertion
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//ScalarPropertyValueAssertion
		public RuleCall getScalarPropertyValueAssertionParserRuleCall_0() { return cScalarPropertyValueAssertionParserRuleCall_0; }
		
		//StructuredPropertyValueAssertion
		public RuleCall getStructuredPropertyValueAssertionParserRuleCall_1() { return cStructuredPropertyValueAssertionParserRuleCall_1; }
	}
	public class ScalarPropertyValueAssertionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.ScalarPropertyValueAssertion");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cPropertyAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cPropertyScalarPropertyCrossReference_0_0 = (CrossReference)cPropertyAssignment_0.eContents().get(0);
		private final RuleCall cPropertyScalarPropertyRefParserRuleCall_0_0_1 = (RuleCall)cPropertyScalarPropertyCrossReference_0_0.eContents().get(1);
		private final Assignment cValueAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cValueLiteralParserRuleCall_1_0 = (RuleCall)cValueAssignment_1.eContents().get(0);
		
		//ScalarPropertyValueAssertion:
		//    property=[ScalarProperty|Ref] value=Literal;
		@Override public ParserRule getRule() { return rule; }
		
		//property=[ScalarProperty|Ref] value=Literal
		public Group getGroup() { return cGroup; }
		
		//property=[ScalarProperty|Ref]
		public Assignment getPropertyAssignment_0() { return cPropertyAssignment_0; }
		
		//[ScalarProperty|Ref]
		public CrossReference getPropertyScalarPropertyCrossReference_0_0() { return cPropertyScalarPropertyCrossReference_0_0; }
		
		//Ref
		public RuleCall getPropertyScalarPropertyRefParserRuleCall_0_0_1() { return cPropertyScalarPropertyRefParserRuleCall_0_0_1; }
		
		//value=Literal
		public Assignment getValueAssignment_1() { return cValueAssignment_1; }
		
		//Literal
		public RuleCall getValueLiteralParserRuleCall_1_0() { return cValueLiteralParserRuleCall_1_0; }
	}
	public class StructuredPropertyValueAssertionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.StructuredPropertyValueAssertion");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cPropertyAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cPropertyStructuredPropertyCrossReference_0_0 = (CrossReference)cPropertyAssignment_0.eContents().get(0);
		private final RuleCall cPropertyStructuredPropertyRefParserRuleCall_0_0_1 = (RuleCall)cPropertyStructuredPropertyCrossReference_0_0.eContents().get(1);
		private final Assignment cValueAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cValueStructureInstanceParserRuleCall_1_0 = (RuleCall)cValueAssignment_1.eContents().get(0);
		
		//StructuredPropertyValueAssertion:
		//    property=[StructuredProperty|Ref] value=StructureInstance;
		@Override public ParserRule getRule() { return rule; }
		
		//property=[StructuredProperty|Ref] value=StructureInstance
		public Group getGroup() { return cGroup; }
		
		//property=[StructuredProperty|Ref]
		public Assignment getPropertyAssignment_0() { return cPropertyAssignment_0; }
		
		//[StructuredProperty|Ref]
		public CrossReference getPropertyStructuredPropertyCrossReference_0_0() { return cPropertyStructuredPropertyCrossReference_0_0; }
		
		//Ref
		public RuleCall getPropertyStructuredPropertyRefParserRuleCall_0_0_1() { return cPropertyStructuredPropertyRefParserRuleCall_0_0_1; }
		
		//value=StructureInstance
		public Assignment getValueAssignment_1() { return cValueAssignment_1; }
		
		//StructureInstance
		public RuleCall getValueStructureInstanceParserRuleCall_1_0() { return cValueStructureInstanceParserRuleCall_1_0; }
	}
	public class LinkAssertionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.LinkAssertion");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cRelationAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cRelationRelationCrossReference_0_0 = (CrossReference)cRelationAssignment_0.eContents().get(0);
		private final RuleCall cRelationRelationRefParserRuleCall_0_0_1 = (RuleCall)cRelationRelationCrossReference_0_0.eContents().get(1);
		private final Assignment cTargetAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cTargetNamedInstanceCrossReference_1_0 = (CrossReference)cTargetAssignment_1.eContents().get(0);
		private final RuleCall cTargetNamedInstanceRefParserRuleCall_1_0_1 = (RuleCall)cTargetNamedInstanceCrossReference_1_0.eContents().get(1);
		
		//LinkAssertion:
		//    relation=[Relation|Ref] target=[NamedInstance|Ref];
		@Override public ParserRule getRule() { return rule; }
		
		//relation=[Relation|Ref] target=[NamedInstance|Ref]
		public Group getGroup() { return cGroup; }
		
		//relation=[Relation|Ref]
		public Assignment getRelationAssignment_0() { return cRelationAssignment_0; }
		
		//[Relation|Ref]
		public CrossReference getRelationRelationCrossReference_0_0() { return cRelationRelationCrossReference_0_0; }
		
		//Ref
		public RuleCall getRelationRelationRefParserRuleCall_0_0_1() { return cRelationRelationRefParserRuleCall_0_0_1; }
		
		//target=[NamedInstance|Ref]
		public Assignment getTargetAssignment_1() { return cTargetAssignment_1; }
		
		//[NamedInstance|Ref]
		public CrossReference getTargetNamedInstanceCrossReference_1_0() { return cTargetNamedInstanceCrossReference_1_0; }
		
		//Ref
		public RuleCall getTargetNamedInstanceRefParserRuleCall_1_0_1() { return cTargetNamedInstanceRefParserRuleCall_1_0_1; }
	}
	public class PredicateElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Predicate");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cUnaryPredicateParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cBinaryPredicateParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//Predicate:
		//    UnaryPredicate |
		//    BinaryPredicate;
		@Override public ParserRule getRule() { return rule; }
		
		//UnaryPredicate |
		//BinaryPredicate
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//UnaryPredicate
		public RuleCall getUnaryPredicateParserRuleCall_0() { return cUnaryPredicateParserRuleCall_0; }
		
		//BinaryPredicate
		public RuleCall getBinaryPredicateParserRuleCall_1() { return cBinaryPredicateParserRuleCall_1; }
	}
	public class UnaryPredicateElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.UnaryPredicate");
		private final RuleCall cTypePredicateParserRuleCall = (RuleCall)rule.eContents().get(1);
		
		//UnaryPredicate:
		//    TypePredicate;
		@Override public ParserRule getRule() { return rule; }
		
		//TypePredicate
		public RuleCall getTypePredicateParserRuleCall() { return cTypePredicateParserRuleCall; }
	}
	public class TypePredicateElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.TypePredicate");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cTypeAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cTypeTypeCrossReference_0_0 = (CrossReference)cTypeAssignment_0.eContents().get(0);
		private final RuleCall cTypeTypeRefParserRuleCall_0_0_1 = (RuleCall)cTypeTypeCrossReference_0_0.eContents().get(1);
		private final Keyword cLeftParenthesisKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cVariableAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cVariableIDTerminalRuleCall_2_0 = (RuleCall)cVariableAssignment_2.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//TypePredicate:
		//    type=[Type|Ref] => '(' variable=ID ')';
		@Override public ParserRule getRule() { return rule; }
		
		//type=[Type|Ref] => '(' variable=ID ')'
		public Group getGroup() { return cGroup; }
		
		//type=[Type|Ref]
		public Assignment getTypeAssignment_0() { return cTypeAssignment_0; }
		
		//[Type|Ref]
		public CrossReference getTypeTypeCrossReference_0_0() { return cTypeTypeCrossReference_0_0; }
		
		//Ref
		public RuleCall getTypeTypeRefParserRuleCall_0_0_1() { return cTypeTypeRefParserRuleCall_0_0_1; }
		
		//=> '('
		public Keyword getLeftParenthesisKeyword_1() { return cLeftParenthesisKeyword_1; }
		
		//variable=ID
		public Assignment getVariableAssignment_2() { return cVariableAssignment_2; }
		
		//ID
		public RuleCall getVariableIDTerminalRuleCall_2_0() { return cVariableIDTerminalRuleCall_2_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_3() { return cRightParenthesisKeyword_3; }
	}
	public class BinaryPredicateElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.BinaryPredicate");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cRelationEntityPredicateParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cFeaturePredicateParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cSameAsPredicateParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cDifferentFromPredicateParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		
		//BinaryPredicate:
		//    RelationEntityPredicate |
		//    FeaturePredicate |
		//    SameAsPredicate |
		//    DifferentFromPredicate;
		@Override public ParserRule getRule() { return rule; }
		
		//RelationEntityPredicate |
		//FeaturePredicate |
		//SameAsPredicate |
		//DifferentFromPredicate
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//RelationEntityPredicate
		public RuleCall getRelationEntityPredicateParserRuleCall_0() { return cRelationEntityPredicateParserRuleCall_0; }
		
		//FeaturePredicate
		public RuleCall getFeaturePredicateParserRuleCall_1() { return cFeaturePredicateParserRuleCall_1; }
		
		//SameAsPredicate
		public RuleCall getSameAsPredicateParserRuleCall_2() { return cSameAsPredicateParserRuleCall_2; }
		
		//DifferentFromPredicate
		public RuleCall getDifferentFromPredicateParserRuleCall_3() { return cDifferentFromPredicateParserRuleCall_3; }
	}
	public class RelationEntityPredicateElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.RelationEntityPredicate");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cEntityAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cEntityRelationEntityCrossReference_0_0 = (CrossReference)cEntityAssignment_0.eContents().get(0);
		private final RuleCall cEntityRelationEntityRefParserRuleCall_0_0_1 = (RuleCall)cEntityRelationEntityCrossReference_0_0.eContents().get(1);
		private final Keyword cLeftParenthesisKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cVariable1Assignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cVariable1IDTerminalRuleCall_2_0 = (RuleCall)cVariable1Assignment_2.eContents().get(0);
		private final Keyword cCommaKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cEntityVariableAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cEntityVariableIDTerminalRuleCall_4_0 = (RuleCall)cEntityVariableAssignment_4.eContents().get(0);
		private final Keyword cCommaKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Alternatives cAlternatives_6 = (Alternatives)cGroup.eContents().get(6);
		private final Assignment cVariable2Assignment_6_0 = (Assignment)cAlternatives_6.eContents().get(0);
		private final RuleCall cVariable2IDTerminalRuleCall_6_0_0 = (RuleCall)cVariable2Assignment_6_0.eContents().get(0);
		private final Assignment cInstance2Assignment_6_1 = (Assignment)cAlternatives_6.eContents().get(1);
		private final CrossReference cInstance2NamedInstanceCrossReference_6_1_0 = (CrossReference)cInstance2Assignment_6_1.eContents().get(0);
		private final RuleCall cInstance2NamedInstanceCrossRefParserRuleCall_6_1_0_1 = (RuleCall)cInstance2NamedInstanceCrossReference_6_1_0.eContents().get(1);
		private final Keyword cRightParenthesisKeyword_7 = (Keyword)cGroup.eContents().get(7);
		
		//RelationEntityPredicate:
		//    entity=[RelationEntity|Ref] '(' variable1=ID ',' entityVariable=ID ',' (variable2=ID | instance2=[NamedInstance|CrossRef]) ')';
		@Override public ParserRule getRule() { return rule; }
		
		//entity=[RelationEntity|Ref] '(' variable1=ID ',' entityVariable=ID ',' (variable2=ID | instance2=[NamedInstance|CrossRef]) ')'
		public Group getGroup() { return cGroup; }
		
		//entity=[RelationEntity|Ref]
		public Assignment getEntityAssignment_0() { return cEntityAssignment_0; }
		
		//[RelationEntity|Ref]
		public CrossReference getEntityRelationEntityCrossReference_0_0() { return cEntityRelationEntityCrossReference_0_0; }
		
		//Ref
		public RuleCall getEntityRelationEntityRefParserRuleCall_0_0_1() { return cEntityRelationEntityRefParserRuleCall_0_0_1; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1() { return cLeftParenthesisKeyword_1; }
		
		//variable1=ID
		public Assignment getVariable1Assignment_2() { return cVariable1Assignment_2; }
		
		//ID
		public RuleCall getVariable1IDTerminalRuleCall_2_0() { return cVariable1IDTerminalRuleCall_2_0; }
		
		//','
		public Keyword getCommaKeyword_3() { return cCommaKeyword_3; }
		
		//entityVariable=ID
		public Assignment getEntityVariableAssignment_4() { return cEntityVariableAssignment_4; }
		
		//ID
		public RuleCall getEntityVariableIDTerminalRuleCall_4_0() { return cEntityVariableIDTerminalRuleCall_4_0; }
		
		//','
		public Keyword getCommaKeyword_5() { return cCommaKeyword_5; }
		
		//(variable2=ID | instance2=[NamedInstance|CrossRef])
		public Alternatives getAlternatives_6() { return cAlternatives_6; }
		
		//variable2=ID
		public Assignment getVariable2Assignment_6_0() { return cVariable2Assignment_6_0; }
		
		//ID
		public RuleCall getVariable2IDTerminalRuleCall_6_0_0() { return cVariable2IDTerminalRuleCall_6_0_0; }
		
		//instance2=[NamedInstance|CrossRef]
		public Assignment getInstance2Assignment_6_1() { return cInstance2Assignment_6_1; }
		
		//[NamedInstance|CrossRef]
		public CrossReference getInstance2NamedInstanceCrossReference_6_1_0() { return cInstance2NamedInstanceCrossReference_6_1_0; }
		
		//CrossRef
		public RuleCall getInstance2NamedInstanceCrossRefParserRuleCall_6_1_0_1() { return cInstance2NamedInstanceCrossRefParserRuleCall_6_1_0_1; }
		
		//')'
		public Keyword getRightParenthesisKeyword_7() { return cRightParenthesisKeyword_7; }
	}
	public class FeaturePredicateElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.FeaturePredicate");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cFeatureAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cFeatureFeatureCrossReference_0_0 = (CrossReference)cFeatureAssignment_0.eContents().get(0);
		private final RuleCall cFeatureFeatureRefParserRuleCall_0_0_1 = (RuleCall)cFeatureFeatureCrossReference_0_0.eContents().get(1);
		private final Keyword cLeftParenthesisKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cVariable1Assignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cVariable1IDTerminalRuleCall_2_0 = (RuleCall)cVariable1Assignment_2.eContents().get(0);
		private final Keyword cCommaKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Alternatives cAlternatives_4 = (Alternatives)cGroup.eContents().get(4);
		private final Assignment cVariable2Assignment_4_0 = (Assignment)cAlternatives_4.eContents().get(0);
		private final RuleCall cVariable2IDTerminalRuleCall_4_0_0 = (RuleCall)cVariable2Assignment_4_0.eContents().get(0);
		private final Assignment cLiteral2Assignment_4_1 = (Assignment)cAlternatives_4.eContents().get(1);
		private final RuleCall cLiteral2LiteralParserRuleCall_4_1_0 = (RuleCall)cLiteral2Assignment_4_1.eContents().get(0);
		private final Assignment cInstance2Assignment_4_2 = (Assignment)cAlternatives_4.eContents().get(2);
		private final CrossReference cInstance2NamedInstanceCrossReference_4_2_0 = (CrossReference)cInstance2Assignment_4_2.eContents().get(0);
		private final RuleCall cInstance2NamedInstanceCrossRefParserRuleCall_4_2_0_1 = (RuleCall)cInstance2NamedInstanceCrossReference_4_2_0.eContents().get(1);
		private final Keyword cRightParenthesisKeyword_5 = (Keyword)cGroup.eContents().get(5);
		
		//FeaturePredicate:
		//    feature=[Feature|Ref] '(' variable1=ID ',' (variable2=ID | literal2=Literal | instance2=[NamedInstance|CrossRef]) ')';
		@Override public ParserRule getRule() { return rule; }
		
		//feature=[Feature|Ref] '(' variable1=ID ',' (variable2=ID | literal2=Literal | instance2=[NamedInstance|CrossRef]) ')'
		public Group getGroup() { return cGroup; }
		
		//feature=[Feature|Ref]
		public Assignment getFeatureAssignment_0() { return cFeatureAssignment_0; }
		
		//[Feature|Ref]
		public CrossReference getFeatureFeatureCrossReference_0_0() { return cFeatureFeatureCrossReference_0_0; }
		
		//Ref
		public RuleCall getFeatureFeatureRefParserRuleCall_0_0_1() { return cFeatureFeatureRefParserRuleCall_0_0_1; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1() { return cLeftParenthesisKeyword_1; }
		
		//variable1=ID
		public Assignment getVariable1Assignment_2() { return cVariable1Assignment_2; }
		
		//ID
		public RuleCall getVariable1IDTerminalRuleCall_2_0() { return cVariable1IDTerminalRuleCall_2_0; }
		
		//','
		public Keyword getCommaKeyword_3() { return cCommaKeyword_3; }
		
		//(variable2=ID | literal2=Literal | instance2=[NamedInstance|CrossRef])
		public Alternatives getAlternatives_4() { return cAlternatives_4; }
		
		//variable2=ID
		public Assignment getVariable2Assignment_4_0() { return cVariable2Assignment_4_0; }
		
		//ID
		public RuleCall getVariable2IDTerminalRuleCall_4_0_0() { return cVariable2IDTerminalRuleCall_4_0_0; }
		
		//literal2=Literal
		public Assignment getLiteral2Assignment_4_1() { return cLiteral2Assignment_4_1; }
		
		//Literal
		public RuleCall getLiteral2LiteralParserRuleCall_4_1_0() { return cLiteral2LiteralParserRuleCall_4_1_0; }
		
		//instance2=[NamedInstance|CrossRef]
		public Assignment getInstance2Assignment_4_2() { return cInstance2Assignment_4_2; }
		
		//[NamedInstance|CrossRef]
		public CrossReference getInstance2NamedInstanceCrossReference_4_2_0() { return cInstance2NamedInstanceCrossReference_4_2_0; }
		
		//CrossRef
		public RuleCall getInstance2NamedInstanceCrossRefParserRuleCall_4_2_0_1() { return cInstance2NamedInstanceCrossRefParserRuleCall_4_2_0_1; }
		
		//')'
		public Keyword getRightParenthesisKeyword_5() { return cRightParenthesisKeyword_5; }
	}
	public class SameAsPredicateElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.SameAsPredicate");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cSameAsKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cVariable1Assignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cVariable1IDTerminalRuleCall_2_0 = (RuleCall)cVariable1Assignment_2.eContents().get(0);
		private final Keyword cCommaKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Alternatives cAlternatives_4 = (Alternatives)cGroup.eContents().get(4);
		private final Assignment cVariable2Assignment_4_0 = (Assignment)cAlternatives_4.eContents().get(0);
		private final RuleCall cVariable2IDTerminalRuleCall_4_0_0 = (RuleCall)cVariable2Assignment_4_0.eContents().get(0);
		private final Assignment cInstance2Assignment_4_1 = (Assignment)cAlternatives_4.eContents().get(1);
		private final CrossReference cInstance2NamedInstanceCrossReference_4_1_0 = (CrossReference)cInstance2Assignment_4_1.eContents().get(0);
		private final RuleCall cInstance2NamedInstanceCrossRefParserRuleCall_4_1_0_1 = (RuleCall)cInstance2NamedInstanceCrossReference_4_1_0.eContents().get(1);
		private final Keyword cRightParenthesisKeyword_5 = (Keyword)cGroup.eContents().get(5);
		
		//SameAsPredicate:
		//    'sameAs' '(' variable1=ID ',' (variable2=ID | instance2=[NamedInstance|CrossRef]) ')';
		@Override public ParserRule getRule() { return rule; }
		
		//'sameAs' '(' variable1=ID ',' (variable2=ID | instance2=[NamedInstance|CrossRef]) ')'
		public Group getGroup() { return cGroup; }
		
		//'sameAs'
		public Keyword getSameAsKeyword_0() { return cSameAsKeyword_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1() { return cLeftParenthesisKeyword_1; }
		
		//variable1=ID
		public Assignment getVariable1Assignment_2() { return cVariable1Assignment_2; }
		
		//ID
		public RuleCall getVariable1IDTerminalRuleCall_2_0() { return cVariable1IDTerminalRuleCall_2_0; }
		
		//','
		public Keyword getCommaKeyword_3() { return cCommaKeyword_3; }
		
		//(variable2=ID | instance2=[NamedInstance|CrossRef])
		public Alternatives getAlternatives_4() { return cAlternatives_4; }
		
		//variable2=ID
		public Assignment getVariable2Assignment_4_0() { return cVariable2Assignment_4_0; }
		
		//ID
		public RuleCall getVariable2IDTerminalRuleCall_4_0_0() { return cVariable2IDTerminalRuleCall_4_0_0; }
		
		//instance2=[NamedInstance|CrossRef]
		public Assignment getInstance2Assignment_4_1() { return cInstance2Assignment_4_1; }
		
		//[NamedInstance|CrossRef]
		public CrossReference getInstance2NamedInstanceCrossReference_4_1_0() { return cInstance2NamedInstanceCrossReference_4_1_0; }
		
		//CrossRef
		public RuleCall getInstance2NamedInstanceCrossRefParserRuleCall_4_1_0_1() { return cInstance2NamedInstanceCrossRefParserRuleCall_4_1_0_1; }
		
		//')'
		public Keyword getRightParenthesisKeyword_5() { return cRightParenthesisKeyword_5; }
	}
	public class DifferentFromPredicateElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.DifferentFromPredicate");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cDifferentFromKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cVariable1Assignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cVariable1IDTerminalRuleCall_2_0 = (RuleCall)cVariable1Assignment_2.eContents().get(0);
		private final Keyword cCommaKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Alternatives cAlternatives_4 = (Alternatives)cGroup.eContents().get(4);
		private final Assignment cVariable2Assignment_4_0 = (Assignment)cAlternatives_4.eContents().get(0);
		private final RuleCall cVariable2IDTerminalRuleCall_4_0_0 = (RuleCall)cVariable2Assignment_4_0.eContents().get(0);
		private final Assignment cInstance2Assignment_4_1 = (Assignment)cAlternatives_4.eContents().get(1);
		private final CrossReference cInstance2NamedInstanceCrossReference_4_1_0 = (CrossReference)cInstance2Assignment_4_1.eContents().get(0);
		private final RuleCall cInstance2NamedInstanceCrossRefParserRuleCall_4_1_0_1 = (RuleCall)cInstance2NamedInstanceCrossReference_4_1_0.eContents().get(1);
		private final Keyword cRightParenthesisKeyword_5 = (Keyword)cGroup.eContents().get(5);
		
		//DifferentFromPredicate:
		//    'differentFrom' '(' variable1=ID ',' (variable2=ID | instance2=[NamedInstance|CrossRef]) ')';
		@Override public ParserRule getRule() { return rule; }
		
		//'differentFrom' '(' variable1=ID ',' (variable2=ID | instance2=[NamedInstance|CrossRef]) ')'
		public Group getGroup() { return cGroup; }
		
		//'differentFrom'
		public Keyword getDifferentFromKeyword_0() { return cDifferentFromKeyword_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1() { return cLeftParenthesisKeyword_1; }
		
		//variable1=ID
		public Assignment getVariable1Assignment_2() { return cVariable1Assignment_2; }
		
		//ID
		public RuleCall getVariable1IDTerminalRuleCall_2_0() { return cVariable1IDTerminalRuleCall_2_0; }
		
		//','
		public Keyword getCommaKeyword_3() { return cCommaKeyword_3; }
		
		//(variable2=ID | instance2=[NamedInstance|CrossRef])
		public Alternatives getAlternatives_4() { return cAlternatives_4; }
		
		//variable2=ID
		public Assignment getVariable2Assignment_4_0() { return cVariable2Assignment_4_0; }
		
		//ID
		public RuleCall getVariable2IDTerminalRuleCall_4_0_0() { return cVariable2IDTerminalRuleCall_4_0_0; }
		
		//instance2=[NamedInstance|CrossRef]
		public Assignment getInstance2Assignment_4_1() { return cInstance2Assignment_4_1; }
		
		//[NamedInstance|CrossRef]
		public CrossReference getInstance2NamedInstanceCrossReference_4_1_0() { return cInstance2NamedInstanceCrossReference_4_1_0; }
		
		//CrossRef
		public RuleCall getInstance2NamedInstanceCrossRefParserRuleCall_4_1_0_1() { return cInstance2NamedInstanceCrossRefParserRuleCall_4_1_0_1; }
		
		//')'
		public Keyword getRightParenthesisKeyword_5() { return cRightParenthesisKeyword_5; }
	}
	public class LiteralElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Literal");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cIntegerLiteralParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cDecimalLiteralParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cDoubleLiteralParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cBooleanLiteralParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		private final RuleCall cQuotedLiteralParserRuleCall_4 = (RuleCall)cAlternatives.eContents().get(4);
		
		//Literal:
		//    IntegerLiteral |
		//    DecimalLiteral |
		//    DoubleLiteral |
		//    BooleanLiteral |
		//    QuotedLiteral;
		@Override public ParserRule getRule() { return rule; }
		
		//IntegerLiteral |
		//DecimalLiteral |
		//DoubleLiteral |
		//BooleanLiteral |
		//QuotedLiteral
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//IntegerLiteral
		public RuleCall getIntegerLiteralParserRuleCall_0() { return cIntegerLiteralParserRuleCall_0; }
		
		//DecimalLiteral
		public RuleCall getDecimalLiteralParserRuleCall_1() { return cDecimalLiteralParserRuleCall_1; }
		
		//DoubleLiteral
		public RuleCall getDoubleLiteralParserRuleCall_2() { return cDoubleLiteralParserRuleCall_2; }
		
		//BooleanLiteral
		public RuleCall getBooleanLiteralParserRuleCall_3() { return cBooleanLiteralParserRuleCall_3; }
		
		//QuotedLiteral
		public RuleCall getQuotedLiteralParserRuleCall_4() { return cQuotedLiteralParserRuleCall_4; }
	}
	public class IntegerLiteralElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.IntegerLiteral");
		private final Assignment cValueAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cValueIntegerParserRuleCall_0 = (RuleCall)cValueAssignment.eContents().get(0);
		
		//IntegerLiteral:
		//    value=Integer;
		@Override public ParserRule getRule() { return rule; }
		
		//value=Integer
		public Assignment getValueAssignment() { return cValueAssignment; }
		
		//Integer
		public RuleCall getValueIntegerParserRuleCall_0() { return cValueIntegerParserRuleCall_0; }
	}
	public class DecimalLiteralElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.DecimalLiteral");
		private final Assignment cValueAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cValueDecimalParserRuleCall_0 = (RuleCall)cValueAssignment.eContents().get(0);
		
		//DecimalLiteral:
		//    value=Decimal;
		@Override public ParserRule getRule() { return rule; }
		
		//value=Decimal
		public Assignment getValueAssignment() { return cValueAssignment; }
		
		//Decimal
		public RuleCall getValueDecimalParserRuleCall_0() { return cValueDecimalParserRuleCall_0; }
	}
	public class DoubleLiteralElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.DoubleLiteral");
		private final Assignment cValueAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cValueDoubleParserRuleCall_0 = (RuleCall)cValueAssignment.eContents().get(0);
		
		//DoubleLiteral:
		//    value=Double;
		@Override public ParserRule getRule() { return rule; }
		
		//value=Double
		public Assignment getValueAssignment() { return cValueAssignment; }
		
		//Double
		public RuleCall getValueDoubleParserRuleCall_0() { return cValueDoubleParserRuleCall_0; }
	}
	public class BooleanLiteralElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.BooleanLiteral");
		private final Assignment cValueAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cValueBooleanParserRuleCall_0 = (RuleCall)cValueAssignment.eContents().get(0);
		
		//BooleanLiteral:
		//    value=Boolean;
		@Override public ParserRule getRule() { return rule; }
		
		//value=Boolean
		public Assignment getValueAssignment() { return cValueAssignment; }
		
		//Boolean
		public RuleCall getValueBooleanParserRuleCall_0() { return cValueBooleanParserRuleCall_0; }
	}
	public class QuotedLiteralElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.QuotedLiteral");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cValueAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cValueSTRINGTerminalRuleCall_0_0 = (RuleCall)cValueAssignment_0.eContents().get(0);
		private final Alternatives cAlternatives_1 = (Alternatives)cGroup.eContents().get(1);
		private final Group cGroup_1_0 = (Group)cAlternatives_1.eContents().get(0);
		private final Keyword cCircumflexAccentCircumflexAccentKeyword_1_0_0 = (Keyword)cGroup_1_0.eContents().get(0);
		private final Assignment cTypeAssignment_1_0_1 = (Assignment)cGroup_1_0.eContents().get(1);
		private final CrossReference cTypeScalarCrossReference_1_0_1_0 = (CrossReference)cTypeAssignment_1_0_1.eContents().get(0);
		private final RuleCall cTypeScalarRefParserRuleCall_1_0_1_0_1 = (RuleCall)cTypeScalarCrossReference_1_0_1_0.eContents().get(1);
		private final Group cGroup_1_1 = (Group)cAlternatives_1.eContents().get(1);
		private final Keyword cDollarSignKeyword_1_1_0 = (Keyword)cGroup_1_1.eContents().get(0);
		private final Assignment cLangTagAssignment_1_1_1 = (Assignment)cGroup_1_1.eContents().get(1);
		private final RuleCall cLangTagIDTerminalRuleCall_1_1_1_0 = (RuleCall)cLangTagAssignment_1_1_1.eContents().get(0);
		
		//QuotedLiteral:
		//    value=STRING (('^^' type=[Scalar|Ref]) | ('$' langTag=ID))?;
		@Override public ParserRule getRule() { return rule; }
		
		//value=STRING (('^^' type=[Scalar|Ref]) | ('$' langTag=ID))?
		public Group getGroup() { return cGroup; }
		
		//value=STRING
		public Assignment getValueAssignment_0() { return cValueAssignment_0; }
		
		//STRING
		public RuleCall getValueSTRINGTerminalRuleCall_0_0() { return cValueSTRINGTerminalRuleCall_0_0; }
		
		//(('^^' type=[Scalar|Ref]) | ('$' langTag=ID))?
		public Alternatives getAlternatives_1() { return cAlternatives_1; }
		
		//('^^' type=[Scalar|Ref])
		public Group getGroup_1_0() { return cGroup_1_0; }
		
		//'^^'
		public Keyword getCircumflexAccentCircumflexAccentKeyword_1_0_0() { return cCircumflexAccentCircumflexAccentKeyword_1_0_0; }
		
		//type=[Scalar|Ref]
		public Assignment getTypeAssignment_1_0_1() { return cTypeAssignment_1_0_1; }
		
		//[Scalar|Ref]
		public CrossReference getTypeScalarCrossReference_1_0_1_0() { return cTypeScalarCrossReference_1_0_1_0; }
		
		//Ref
		public RuleCall getTypeScalarRefParserRuleCall_1_0_1_0_1() { return cTypeScalarRefParserRuleCall_1_0_1_0_1; }
		
		//('$' langTag=ID)
		public Group getGroup_1_1() { return cGroup_1_1; }
		
		//'$'
		public Keyword getDollarSignKeyword_1_1_0() { return cDollarSignKeyword_1_1_0; }
		
		//langTag=ID
		public Assignment getLangTagAssignment_1_1_1() { return cLangTagAssignment_1_1_1; }
		
		//ID
		public RuleCall getLangTagIDTerminalRuleCall_1_1_1_0() { return cLangTagIDTerminalRuleCall_1_1_1_0; }
	}
	public class RefElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Ref");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cIDTerminalRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cQNAMETerminalRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cIRITerminalRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		////--------------
		//Ref returns ecore::EString:                             ID | QNAME | IRI;
		@Override public ParserRule getRule() { return rule; }
		
		//ID | QNAME | IRI
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//ID
		public RuleCall getIDTerminalRuleCall_0() { return cIDTerminalRuleCall_0; }
		
		//QNAME
		public RuleCall getQNAMETerminalRuleCall_1() { return cQNAMETerminalRuleCall_1; }
		
		//IRI
		public RuleCall getIRITerminalRuleCall_2() { return cIRITerminalRuleCall_2; }
	}
	public class CrossRefElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.CrossRef");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cQNAMETerminalRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cIRITerminalRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//CrossRef returns ecore::EString: 						QNAME | IRI;
		@Override public ParserRule getRule() { return rule; }
		
		//QNAME | IRI
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//QNAME
		public RuleCall getQNAMETerminalRuleCall_0() { return cQNAMETerminalRuleCall_0; }
		
		//IRI
		public RuleCall getIRITerminalRuleCall_1() { return cIRITerminalRuleCall_1; }
	}
	public class BooleanElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Boolean");
		private final RuleCall cBOOLEAN_STRTerminalRuleCall = (RuleCall)rule.eContents().get(1);
		
		//Boolean returns ecore::EBoolean:						BOOLEAN_STR;
		@Override public ParserRule getRule() { return rule; }
		
		//BOOLEAN_STR
		public RuleCall getBOOLEAN_STRTerminalRuleCall() { return cBOOLEAN_STRTerminalRuleCall; }
	}
	public class UnsignedIntegerElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.UnsignedInteger");
		private final RuleCall cUNSIGNED_INTEGER_STRTerminalRuleCall = (RuleCall)rule.eContents().get(1);
		
		//UnsignedInteger returns UnsignedInt: 					UNSIGNED_INTEGER_STR;
		@Override public ParserRule getRule() { return rule; }
		
		//UNSIGNED_INTEGER_STR
		public RuleCall getUNSIGNED_INTEGER_STRTerminalRuleCall() { return cUNSIGNED_INTEGER_STRTerminalRuleCall; }
	}
	public class IntegerElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Integer");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cUNSIGNED_INTEGER_STRTerminalRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cINTEGER_STRTerminalRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//Integer returns ecore::EInt: 							UNSIGNED_INTEGER_STR | INTEGER_STR;
		@Override public ParserRule getRule() { return rule; }
		
		//UNSIGNED_INTEGER_STR | INTEGER_STR
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//UNSIGNED_INTEGER_STR
		public RuleCall getUNSIGNED_INTEGER_STRTerminalRuleCall_0() { return cUNSIGNED_INTEGER_STRTerminalRuleCall_0; }
		
		//INTEGER_STR
		public RuleCall getINTEGER_STRTerminalRuleCall_1() { return cINTEGER_STRTerminalRuleCall_1; }
	}
	public class DecimalElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Decimal");
		private final RuleCall cDECIMAL_STRTerminalRuleCall = (RuleCall)rule.eContents().get(1);
		
		//Decimal returns Decimal:								DECIMAL_STR;
		@Override public ParserRule getRule() { return rule; }
		
		//DECIMAL_STR
		public RuleCall getDECIMAL_STRTerminalRuleCall() { return cDECIMAL_STRTerminalRuleCall; }
	}
	public class DoubleElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.Double");
		private final RuleCall cDOUBLE_STRTerminalRuleCall = (RuleCall)rule.eContents().get(1);
		
		//Double returns ecore::EDouble:							DOUBLE_STR;
		@Override public ParserRule getRule() { return rule; }
		
		//DOUBLE_STR
		public RuleCall getDOUBLE_STRTerminalRuleCall() { return cDOUBLE_STRTerminalRuleCall; }
	}
	
	public class RangeRestrictionKindElements extends AbstractElementFinder.AbstractEnumRuleElementFinder {
		private final EnumRule rule = (EnumRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.RangeRestrictionKind");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final EnumLiteralDeclaration cAllEnumLiteralDeclaration_0 = (EnumLiteralDeclaration)cAlternatives.eContents().get(0);
		private final Keyword cAllAllKeyword_0_0 = (Keyword)cAllEnumLiteralDeclaration_0.eContents().get(0);
		private final EnumLiteralDeclaration cSomeEnumLiteralDeclaration_1 = (EnumLiteralDeclaration)cAlternatives.eContents().get(1);
		private final Keyword cSomeSomeKeyword_1_0 = (Keyword)cSomeEnumLiteralDeclaration_1.eContents().get(0);
		
		//enum RangeRestrictionKind:
		//    all |
		//    some;
		public EnumRule getRule() { return rule; }
		
		//all |
		//some
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//all
		public EnumLiteralDeclaration getAllEnumLiteralDeclaration_0() { return cAllEnumLiteralDeclaration_0; }
		
		public Keyword getAllAllKeyword_0_0() { return cAllAllKeyword_0_0; }
		
		//some
		public EnumLiteralDeclaration getSomeEnumLiteralDeclaration_1() { return cSomeEnumLiteralDeclaration_1; }
		
		public Keyword getSomeSomeKeyword_1_0() { return cSomeSomeKeyword_1_0; }
	}
	public class CardinalityRestrictionKindElements extends AbstractElementFinder.AbstractEnumRuleElementFinder {
		private final EnumRule rule = (EnumRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.CardinalityRestrictionKind");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final EnumLiteralDeclaration cExactlyEnumLiteralDeclaration_0 = (EnumLiteralDeclaration)cAlternatives.eContents().get(0);
		private final Keyword cExactlyExactlyKeyword_0_0 = (Keyword)cExactlyEnumLiteralDeclaration_0.eContents().get(0);
		private final EnumLiteralDeclaration cMinEnumLiteralDeclaration_1 = (EnumLiteralDeclaration)cAlternatives.eContents().get(1);
		private final Keyword cMinMinKeyword_1_0 = (Keyword)cMinEnumLiteralDeclaration_1.eContents().get(0);
		private final EnumLiteralDeclaration cMaxEnumLiteralDeclaration_2 = (EnumLiteralDeclaration)cAlternatives.eContents().get(2);
		private final Keyword cMaxMaxKeyword_2_0 = (Keyword)cMaxEnumLiteralDeclaration_2.eContents().get(0);
		
		//enum CardinalityRestrictionKind:
		//    exactly |
		//    min |
		//    max;
		public EnumRule getRule() { return rule; }
		
		//exactly |
		//min |
		//max
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//exactly
		public EnumLiteralDeclaration getExactlyEnumLiteralDeclaration_0() { return cExactlyEnumLiteralDeclaration_0; }
		
		public Keyword getExactlyExactlyKeyword_0_0() { return cExactlyExactlyKeyword_0_0; }
		
		//min
		public EnumLiteralDeclaration getMinEnumLiteralDeclaration_1() { return cMinEnumLiteralDeclaration_1; }
		
		public Keyword getMinMinKeyword_1_0() { return cMinMinKeyword_1_0; }
		
		//max
		public EnumLiteralDeclaration getMaxEnumLiteralDeclaration_2() { return cMaxEnumLiteralDeclaration_2; }
		
		public Keyword getMaxMaxKeyword_2_0() { return cMaxMaxKeyword_2_0; }
	}
	
	private final OntologyElements pOntology;
	private final AnnotationElements pAnnotation;
	private final VocabularyBoxElements pVocabularyBox;
	private final VocabularyElements pVocabulary;
	private final VocabularyBundleElements pVocabularyBundle;
	private final DescriptionBoxElements pDescriptionBox;
	private final DescriptionElements pDescription;
	private final DescriptionBundleElements pDescriptionBundle;
	private final SpecializableTermElements pSpecializableTerm;
	private final TypeElements pType;
	private final ClassifierElements pClassifier;
	private final EntityElements pEntity;
	private final AspectElements pAspect;
	private final ConceptElements pConcept;
	private final RelationEntityElements pRelationEntity;
	private final StructureElements pStructure;
	private final FeatureElements pFeature;
	private final PropertyElements pProperty;
	private final AnnotationPropertyElements pAnnotationProperty;
	private final SemanticPropertyElements pSemanticProperty;
	private final ScalarPropertyElements pScalarProperty;
	private final StructuredPropertyElements pStructuredProperty;
	private final ScalarElements pScalar;
	private final FacetedScalarElements pFacetedScalar;
	private final EnumeratedScalarElements pEnumeratedScalar;
	private final RelationElements pRelation;
	private final ForwardRelationElements pForwardRelation;
	private final ReverseRelationElements pReverseRelation;
	private final RuleElements pRule;
	private final StructureInstanceElements pStructureInstance;
	private final NamedInstanceElements pNamedInstance;
	private final ConceptInstanceElements pConceptInstance;
	private final RelationInstanceElements pRelationInstance;
	private final SpecializableTermReferenceElements pSpecializableTermReference;
	private final ClassifierReferenceElements pClassifierReference;
	private final EntityReferenceElements pEntityReference;
	private final AspectReferenceElements pAspectReference;
	private final ConceptReferenceElements pConceptReference;
	private final RelationEntityReferenceElements pRelationEntityReference;
	private final StructureReferenceElements pStructureReference;
	private final AnnotationPropertyReferenceElements pAnnotationPropertyReference;
	private final ScalarPropertyReferenceElements pScalarPropertyReference;
	private final StructuredPropertyReferenceElements pStructuredPropertyReference;
	private final FacetedScalarReferenceElements pFacetedScalarReference;
	private final EnumeratedScalarReferenceElements pEnumeratedScalarReference;
	private final RelationReferenceElements pRelationReference;
	private final RuleReferenceElements pRuleReference;
	private final NamedInstanceReferenceElements pNamedInstanceReference;
	private final ConceptInstanceReferenceElements pConceptInstanceReference;
	private final RelationInstanceReferenceElements pRelationInstanceReference;
	private final VocabularyStatementElements pVocabularyStatement;
	private final DescriptionStatementElements pDescriptionStatement;
	private final VocabularyImportElements pVocabularyImport;
	private final VocabularyExtensionElements pVocabularyExtension;
	private final VocabularyUsageElements pVocabularyUsage;
	private final VocabularyBundleImportElements pVocabularyBundleImport;
	private final VocabularyBundleInclusionElements pVocabularyBundleInclusion;
	private final VocabularyBundleExtensionElements pVocabularyBundleExtension;
	private final DescriptionImportElements pDescriptionImport;
	private final DescriptionUsageElements pDescriptionUsage;
	private final DescriptionExtensionElements pDescriptionExtension;
	private final DescriptionBundleImportElements pDescriptionBundleImport;
	private final DescriptionBundleInclusionElements pDescriptionBundleInclusion;
	private final DescriptionBundleExtensionElements pDescriptionBundleExtension;
	private final DescriptionBundleUsageElements pDescriptionBundleUsage;
	private final SpecializationAxiomElements pSpecializationAxiom;
	private final PropertyRestrictionAxiomElements pPropertyRestrictionAxiom;
	private final ScalarPropertyRestrictionAxiomElements pScalarPropertyRestrictionAxiom;
	private final ScalarPropertyRangeRestrictionAxiomElements pScalarPropertyRangeRestrictionAxiom;
	private final ScalarPropertyCardinalityRestrictionAxiomElements pScalarPropertyCardinalityRestrictionAxiom;
	private final ScalarPropertyValueRestrictionAxiomElements pScalarPropertyValueRestrictionAxiom;
	private final StructuredPropertyRestrictionAxiomElements pStructuredPropertyRestrictionAxiom;
	private final StructuredPropertyRangeRestrictionAxiomElements pStructuredPropertyRangeRestrictionAxiom;
	private final StructuredPropertyCardinalityRestrictionAxiomElements pStructuredPropertyCardinalityRestrictionAxiom;
	private final StructuredPropertyValueRestrictionAxiomElements pStructuredPropertyValueRestrictionAxiom;
	private final RelationRestrictionAxiomElements pRelationRestrictionAxiom;
	private final RelationRangeRestrictionAxiomElements pRelationRangeRestrictionAxiom;
	private final RelationCardinalityRestrictionAxiomElements pRelationCardinalityRestrictionAxiom;
	private final RelationTargetRestrictionAxiomElements pRelationTargetRestrictionAxiom;
	private final KeyAxiomElements pKeyAxiom;
	private final ConceptTypeAssertionElements pConceptTypeAssertion;
	private final RelationTypeAssertionElements pRelationTypeAssertion;
	private final PropertyValueAssertionElements pPropertyValueAssertion;
	private final ScalarPropertyValueAssertionElements pScalarPropertyValueAssertion;
	private final StructuredPropertyValueAssertionElements pStructuredPropertyValueAssertion;
	private final LinkAssertionElements pLinkAssertion;
	private final PredicateElements pPredicate;
	private final UnaryPredicateElements pUnaryPredicate;
	private final TypePredicateElements pTypePredicate;
	private final BinaryPredicateElements pBinaryPredicate;
	private final RelationEntityPredicateElements pRelationEntityPredicate;
	private final FeaturePredicateElements pFeaturePredicate;
	private final SameAsPredicateElements pSameAsPredicate;
	private final DifferentFromPredicateElements pDifferentFromPredicate;
	private final LiteralElements pLiteral;
	private final IntegerLiteralElements pIntegerLiteral;
	private final DecimalLiteralElements pDecimalLiteral;
	private final DoubleLiteralElements pDoubleLiteral;
	private final BooleanLiteralElements pBooleanLiteral;
	private final QuotedLiteralElements pQuotedLiteral;
	private final RangeRestrictionKindElements eRangeRestrictionKind;
	private final CardinalityRestrictionKindElements eCardinalityRestrictionKind;
	private final RefElements pRef;
	private final CrossRefElements pCrossRef;
	private final BooleanElements pBoolean;
	private final UnsignedIntegerElements pUnsignedInteger;
	private final IntegerElements pInteger;
	private final DecimalElements pDecimal;
	private final DoubleElements pDouble;
	private final TerminalRule tBOOLEAN_STR;
	private final TerminalRule tUNSIGNED_INTEGER_STR;
	private final TerminalRule tINTEGER_STR;
	private final TerminalRule tDECIMAL_STR;
	private final TerminalRule tDOUBLE_STR;
	private final TerminalRule tSTRING;
	private final TerminalRule tNAMESPACE;
	private final TerminalRule tIRI;
	private final TerminalRule tID;
	private final TerminalRule tQNAME;
	private final TerminalRule tML_COMMENT;
	private final TerminalRule tSL_COMMENT;
	private final TerminalRule tWS;
	private final TerminalRule tIDFRAG;
	private final TerminalRule tALPHA;
	private final TerminalRule tDIGIT;
	
	private final Grammar grammar;

	@Inject
	public OmlGrammarAccess(GrammarProvider grammarProvider) {
		this.grammar = internalFindGrammar(grammarProvider);
		this.pOntology = new OntologyElements();
		this.pAnnotation = new AnnotationElements();
		this.pVocabularyBox = new VocabularyBoxElements();
		this.pVocabulary = new VocabularyElements();
		this.pVocabularyBundle = new VocabularyBundleElements();
		this.pDescriptionBox = new DescriptionBoxElements();
		this.pDescription = new DescriptionElements();
		this.pDescriptionBundle = new DescriptionBundleElements();
		this.pSpecializableTerm = new SpecializableTermElements();
		this.pType = new TypeElements();
		this.pClassifier = new ClassifierElements();
		this.pEntity = new EntityElements();
		this.pAspect = new AspectElements();
		this.pConcept = new ConceptElements();
		this.pRelationEntity = new RelationEntityElements();
		this.pStructure = new StructureElements();
		this.pFeature = new FeatureElements();
		this.pProperty = new PropertyElements();
		this.pAnnotationProperty = new AnnotationPropertyElements();
		this.pSemanticProperty = new SemanticPropertyElements();
		this.pScalarProperty = new ScalarPropertyElements();
		this.pStructuredProperty = new StructuredPropertyElements();
		this.pScalar = new ScalarElements();
		this.pFacetedScalar = new FacetedScalarElements();
		this.pEnumeratedScalar = new EnumeratedScalarElements();
		this.pRelation = new RelationElements();
		this.pForwardRelation = new ForwardRelationElements();
		this.pReverseRelation = new ReverseRelationElements();
		this.pRule = new RuleElements();
		this.pStructureInstance = new StructureInstanceElements();
		this.pNamedInstance = new NamedInstanceElements();
		this.pConceptInstance = new ConceptInstanceElements();
		this.pRelationInstance = new RelationInstanceElements();
		this.pSpecializableTermReference = new SpecializableTermReferenceElements();
		this.pClassifierReference = new ClassifierReferenceElements();
		this.pEntityReference = new EntityReferenceElements();
		this.pAspectReference = new AspectReferenceElements();
		this.pConceptReference = new ConceptReferenceElements();
		this.pRelationEntityReference = new RelationEntityReferenceElements();
		this.pStructureReference = new StructureReferenceElements();
		this.pAnnotationPropertyReference = new AnnotationPropertyReferenceElements();
		this.pScalarPropertyReference = new ScalarPropertyReferenceElements();
		this.pStructuredPropertyReference = new StructuredPropertyReferenceElements();
		this.pFacetedScalarReference = new FacetedScalarReferenceElements();
		this.pEnumeratedScalarReference = new EnumeratedScalarReferenceElements();
		this.pRelationReference = new RelationReferenceElements();
		this.pRuleReference = new RuleReferenceElements();
		this.pNamedInstanceReference = new NamedInstanceReferenceElements();
		this.pConceptInstanceReference = new ConceptInstanceReferenceElements();
		this.pRelationInstanceReference = new RelationInstanceReferenceElements();
		this.pVocabularyStatement = new VocabularyStatementElements();
		this.pDescriptionStatement = new DescriptionStatementElements();
		this.pVocabularyImport = new VocabularyImportElements();
		this.pVocabularyExtension = new VocabularyExtensionElements();
		this.pVocabularyUsage = new VocabularyUsageElements();
		this.pVocabularyBundleImport = new VocabularyBundleImportElements();
		this.pVocabularyBundleInclusion = new VocabularyBundleInclusionElements();
		this.pVocabularyBundleExtension = new VocabularyBundleExtensionElements();
		this.pDescriptionImport = new DescriptionImportElements();
		this.pDescriptionUsage = new DescriptionUsageElements();
		this.pDescriptionExtension = new DescriptionExtensionElements();
		this.pDescriptionBundleImport = new DescriptionBundleImportElements();
		this.pDescriptionBundleInclusion = new DescriptionBundleInclusionElements();
		this.pDescriptionBundleExtension = new DescriptionBundleExtensionElements();
		this.pDescriptionBundleUsage = new DescriptionBundleUsageElements();
		this.pSpecializationAxiom = new SpecializationAxiomElements();
		this.pPropertyRestrictionAxiom = new PropertyRestrictionAxiomElements();
		this.pScalarPropertyRestrictionAxiom = new ScalarPropertyRestrictionAxiomElements();
		this.pScalarPropertyRangeRestrictionAxiom = new ScalarPropertyRangeRestrictionAxiomElements();
		this.pScalarPropertyCardinalityRestrictionAxiom = new ScalarPropertyCardinalityRestrictionAxiomElements();
		this.pScalarPropertyValueRestrictionAxiom = new ScalarPropertyValueRestrictionAxiomElements();
		this.pStructuredPropertyRestrictionAxiom = new StructuredPropertyRestrictionAxiomElements();
		this.pStructuredPropertyRangeRestrictionAxiom = new StructuredPropertyRangeRestrictionAxiomElements();
		this.pStructuredPropertyCardinalityRestrictionAxiom = new StructuredPropertyCardinalityRestrictionAxiomElements();
		this.pStructuredPropertyValueRestrictionAxiom = new StructuredPropertyValueRestrictionAxiomElements();
		this.pRelationRestrictionAxiom = new RelationRestrictionAxiomElements();
		this.pRelationRangeRestrictionAxiom = new RelationRangeRestrictionAxiomElements();
		this.pRelationCardinalityRestrictionAxiom = new RelationCardinalityRestrictionAxiomElements();
		this.pRelationTargetRestrictionAxiom = new RelationTargetRestrictionAxiomElements();
		this.pKeyAxiom = new KeyAxiomElements();
		this.pConceptTypeAssertion = new ConceptTypeAssertionElements();
		this.pRelationTypeAssertion = new RelationTypeAssertionElements();
		this.pPropertyValueAssertion = new PropertyValueAssertionElements();
		this.pScalarPropertyValueAssertion = new ScalarPropertyValueAssertionElements();
		this.pStructuredPropertyValueAssertion = new StructuredPropertyValueAssertionElements();
		this.pLinkAssertion = new LinkAssertionElements();
		this.pPredicate = new PredicateElements();
		this.pUnaryPredicate = new UnaryPredicateElements();
		this.pTypePredicate = new TypePredicateElements();
		this.pBinaryPredicate = new BinaryPredicateElements();
		this.pRelationEntityPredicate = new RelationEntityPredicateElements();
		this.pFeaturePredicate = new FeaturePredicateElements();
		this.pSameAsPredicate = new SameAsPredicateElements();
		this.pDifferentFromPredicate = new DifferentFromPredicateElements();
		this.pLiteral = new LiteralElements();
		this.pIntegerLiteral = new IntegerLiteralElements();
		this.pDecimalLiteral = new DecimalLiteralElements();
		this.pDoubleLiteral = new DoubleLiteralElements();
		this.pBooleanLiteral = new BooleanLiteralElements();
		this.pQuotedLiteral = new QuotedLiteralElements();
		this.eRangeRestrictionKind = new RangeRestrictionKindElements();
		this.eCardinalityRestrictionKind = new CardinalityRestrictionKindElements();
		this.pRef = new RefElements();
		this.pCrossRef = new CrossRefElements();
		this.pBoolean = new BooleanElements();
		this.pUnsignedInteger = new UnsignedIntegerElements();
		this.pInteger = new IntegerElements();
		this.pDecimal = new DecimalElements();
		this.pDouble = new DoubleElements();
		this.tBOOLEAN_STR = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.BOOLEAN_STR");
		this.tUNSIGNED_INTEGER_STR = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.UNSIGNED_INTEGER_STR");
		this.tINTEGER_STR = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.INTEGER_STR");
		this.tDECIMAL_STR = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.DECIMAL_STR");
		this.tDOUBLE_STR = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.DOUBLE_STR");
		this.tSTRING = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.STRING");
		this.tNAMESPACE = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.NAMESPACE");
		this.tIRI = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.IRI");
		this.tID = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.ID");
		this.tQNAME = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.QNAME");
		this.tML_COMMENT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.ML_COMMENT");
		this.tSL_COMMENT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.SL_COMMENT");
		this.tWS = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.WS");
		this.tIDFRAG = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.IDFRAG");
		this.tALPHA = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.ALPHA");
		this.tDIGIT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "io.opencaesar.oml.dsl.Oml.DIGIT");
	}
	
	protected Grammar internalFindGrammar(GrammarProvider grammarProvider) {
		Grammar grammar = grammarProvider.getGrammar(this);
		while (grammar != null) {
			if ("io.opencaesar.oml.dsl.Oml".equals(grammar.getName())) {
				return grammar;
			}
			List<Grammar> grammars = grammar.getUsedGrammars();
			if (!grammars.isEmpty()) {
				grammar = grammars.iterator().next();
			} else {
				return null;
			}
		}
		return grammar;
	}
	
	@Override
	public Grammar getGrammar() {
		return grammar;
	}
	

	
	//Ontology:
	//    VocabularyBox |
	//    DescriptionBox;
	public OntologyElements getOntologyAccess() {
		return pOntology;
	}
	
	public ParserRule getOntologyRule() {
		return getOntologyAccess().getRule();
	}
	
	//Annotation:
	//    '@' {Annotation} property=[AnnotationProperty|Ref] (value=Literal | referenceValue=[Member|Ref])?;
	public AnnotationElements getAnnotationAccess() {
		return pAnnotation;
	}
	
	public ParserRule getAnnotationRule() {
		return getAnnotationAccess().getRule();
	}
	
	//VocabularyBox:
	//    Vocabulary |
	//    VocabularyBundle;
	public VocabularyBoxElements getVocabularyBoxAccess() {
		return pVocabularyBox;
	}
	
	public ParserRule getVocabularyBoxRule() {
		return getVocabularyBoxAccess().getRule();
	}
	
	//Vocabulary:
	//    ownedAnnotations+=Annotation*
	//    'vocabulary' namespace=NAMESPACE 'as' prefix=ID  '{'
	//        ownedImports+=VocabularyImport*
	//        ownedStatements+=VocabularyStatement*
	//    '}';
	public VocabularyElements getVocabularyAccess() {
		return pVocabulary;
	}
	
	public ParserRule getVocabularyRule() {
		return getVocabularyAccess().getRule();
	}
	
	//VocabularyBundle:
	//    ownedAnnotations+=Annotation*
	//    'vocabulary' 'bundle' namespace=NAMESPACE 'as' prefix=ID '{'
	//        ownedImports+=VocabularyBundleImport*
	//    '}';
	public VocabularyBundleElements getVocabularyBundleAccess() {
		return pVocabularyBundle;
	}
	
	public ParserRule getVocabularyBundleRule() {
		return getVocabularyBundleAccess().getRule();
	}
	
	//DescriptionBox:
	//    Description |
	//    DescriptionBundle;
	public DescriptionBoxElements getDescriptionBoxAccess() {
		return pDescriptionBox;
	}
	
	public ParserRule getDescriptionBoxRule() {
		return getDescriptionBoxAccess().getRule();
	}
	
	//Description:
	//    ownedAnnotations+=Annotation*
	//    'description' namespace=NAMESPACE 'as' prefix=ID '{'
	//        ownedImports+=DescriptionImport*
	//        ownedStatements+=DescriptionStatement*
	//    '}';
	public DescriptionElements getDescriptionAccess() {
		return pDescription;
	}
	
	public ParserRule getDescriptionRule() {
		return getDescriptionAccess().getRule();
	}
	
	//DescriptionBundle:
	//    ownedAnnotations+=Annotation*
	//    'description' 'bundle' namespace=NAMESPACE 'as' prefix=ID '{'
	//        ownedImports+=DescriptionBundleImport*
	//    '}';
	public DescriptionBundleElements getDescriptionBundleAccess() {
		return pDescriptionBundle;
	}
	
	public ParserRule getDescriptionBundleRule() {
		return getDescriptionBundleAccess().getRule();
	}
	
	//SpecializableTerm:
	//    Type |
	//    AnnotationProperty |
	//    ScalarProperty |
	//    StructuredProperty;
	public SpecializableTermElements getSpecializableTermAccess() {
		return pSpecializableTerm;
	}
	
	public ParserRule getSpecializableTermRule() {
		return getSpecializableTermAccess().getRule();
	}
	
	//Type:
	//    Classifier |
	//    Scalar;
	public TypeElements getTypeAccess() {
		return pType;
	}
	
	public ParserRule getTypeRule() {
		return getTypeAccess().getRule();
	}
	
	//Classifier:
	//    Entity |
	//    Structure;
	public ClassifierElements getClassifierAccess() {
		return pClassifier;
	}
	
	public ParserRule getClassifierRule() {
		return getClassifierAccess().getRule();
	}
	
	//Entity:
	//    Aspect |
	//    Concept |
	//    RelationEntity;
	public EntityElements getEntityAccess() {
		return pEntity;
	}
	
	public ParserRule getEntityRule() {
		return getEntityAccess().getRule();
	}
	
	//Aspect:
	//    ownedAnnotations+=Annotation*
	//    'aspect' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
	//        (ownedKeys+=KeyAxiom |
	//         ownedPropertyRestrictions+=PropertyRestrictionAxiom |
	//         ownedRelationRestrictions+=RelationRestrictionAxiom)*
	//    ']')?;
	public AspectElements getAspectAccess() {
		return pAspect;
	}
	
	public ParserRule getAspectRule() {
		return getAspectAccess().getRule();
	}
	
	//Concept:
	//    ownedAnnotations+=Annotation*
	//    'concept' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
	//        (ownedKeys+=KeyAxiom |
	//         ownedPropertyRestrictions+=PropertyRestrictionAxiom |
	//         ownedRelationRestrictions+=RelationRestrictionAxiom)*
	//        ('enumerates' enumeratedInstances+=[ConceptInstance|Ref] (',' enumeratedInstances+=[ConceptInstance|Ref])*)?
	//    ']')?;
	public ConceptElements getConceptAccess() {
		return pConcept;
	}
	
	public ParserRule getConceptRule() {
		return getConceptAccess().getRule();
	}
	
	//RelationEntity:
	//    ownedAnnotations+=Annotation*
	//    'relation' 'entity' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? '['
	//        'from' source=[Entity|Ref]
	//        'to' target=[Entity|Ref]
	//        ((forwardRelation=ForwardRelation)? &
	//         (reverseRelation=ReverseRelation)?)
	//        ((functional?='functional')? &
	//         (inverseFunctional?='inverse' 'functional')? &
	//         (symmetric?='symmetric')? &
	//         (asymmetric?='asymmetric')? &
	//         (reflexive?='reflexive')? &
	//         (irreflexive?='irreflexive')? &
	//         (transitive?='transitive')?)
	//        (ownedKeys+=KeyAxiom |
	//         ownedPropertyRestrictions+=PropertyRestrictionAxiom |
	//         ownedRelationRestrictions+=RelationRestrictionAxiom)*
	//    ']';
	public RelationEntityElements getRelationEntityAccess() {
		return pRelationEntity;
	}
	
	public ParserRule getRelationEntityRule() {
		return getRelationEntityAccess().getRule();
	}
	
	//Structure:
	//    ownedAnnotations+=Annotation*
	//    'structure' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
	//        ownedPropertyRestrictions+=PropertyRestrictionAxiom*
	//    ']')?;
	public StructureElements getStructureAccess() {
		return pStructure;
	}
	
	public ParserRule getStructureRule() {
		return getStructureAccess().getRule();
	}
	
	//Feature:
	//    Property;
	public FeatureElements getFeatureAccess() {
		return pFeature;
	}
	
	public ParserRule getFeatureRule() {
		return getFeatureAccess().getRule();
	}
	
	//Property:
	//    AnnotationProperty |
	//    SemanticProperty;
	public PropertyElements getPropertyAccess() {
		return pProperty;
	}
	
	public ParserRule getPropertyRule() {
		return getPropertyAccess().getRule();
	}
	
	//AnnotationProperty:
	//    ownedAnnotations+=Annotation*
	//    'annotation' 'property' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?;
	public AnnotationPropertyElements getAnnotationPropertyAccess() {
		return pAnnotationProperty;
	}
	
	public ParserRule getAnnotationPropertyRule() {
		return getAnnotationPropertyAccess().getRule();
	}
	
	//SemanticProperty:
	//    ScalarProperty |
	//    StructuredProperty;
	public SemanticPropertyElements getSemanticPropertyAccess() {
		return pSemanticProperty;
	}
	
	public ParserRule getSemanticPropertyRule() {
		return getSemanticPropertyAccess().getRule();
	}
	
	//ScalarProperty:
	//    ownedAnnotations+=Annotation*
	//    'scalar' 'property' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
	//        'domain' domain=[Classifier|Ref]
	//        'range' range=[Scalar|Ref]
	//        (functional?='functional')?
	//    ']')?;
	public ScalarPropertyElements getScalarPropertyAccess() {
		return pScalarProperty;
	}
	
	public ParserRule getScalarPropertyRule() {
		return getScalarPropertyAccess().getRule();
	}
	
	//StructuredProperty:
	//    ownedAnnotations+=Annotation*
	//    'structured' 'property' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
	//        'domain' domain=[Classifier|Ref]
	//        'range' range=[Structure|Ref]
	//        (functional?='functional')?
	//    ']')?;
	public StructuredPropertyElements getStructuredPropertyAccess() {
		return pStructuredProperty;
	}
	
	public ParserRule getStructuredPropertyRule() {
		return getStructuredPropertyAccess().getRule();
	}
	
	//Scalar:
	//    FacetedScalar |
	//    EnumeratedScalar;
	public ScalarElements getScalarAccess() {
		return pScalar;
	}
	
	public ParserRule getScalarRule() {
		return getScalarAccess().getRule();
	}
	
	//FacetedScalar:
	//    ownedAnnotations+=Annotation*
	//    'scalar' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
	//         (('length' length=UnsignedInteger)? &
	//         ('minLength' minLength=UnsignedInteger)? &
	//         ('maxLength' maxLength=UnsignedInteger)? &
	//         ('pattern' pattern=STRING)? &
	//         ('language' language=ID)? &
	//         ('minInclusive' minInclusive=Literal)? &
	//         ('minExclusive' minExclusive=Literal)? &
	//         ('maxInclusive' maxInclusive=Literal)? &
	//         ('maxExclusive' maxExclusive=Literal)?)
	//    ']')?;
	public FacetedScalarElements getFacetedScalarAccess() {
		return pFacetedScalar;
	}
	
	public ParserRule getFacetedScalarRule() {
		return getFacetedScalarAccess().getRule();
	}
	
	//EnumeratedScalar:
	//    ownedAnnotations+=Annotation*
	//    'enumerated' 'scalar' name=ID (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
	//        (literals+=Literal (',' literals+=Literal)*)?
	//    ']')?;
	public EnumeratedScalarElements getEnumeratedScalarAccess() {
		return pEnumeratedScalar;
	}
	
	public ParserRule getEnumeratedScalarRule() {
		return getEnumeratedScalarAccess().getRule();
	}
	
	//Relation:
	//    ForwardRelation |
	//    ReverseRelation;
	public RelationElements getRelationAccess() {
		return pRelation;
	}
	
	public ParserRule getRelationRule() {
		return getRelationAccess().getRule();
	}
	
	//ForwardRelation:
	//    ownedAnnotations+=Annotation*
	//    'forward' name=ID;
	public ForwardRelationElements getForwardRelationAccess() {
		return pForwardRelation;
	}
	
	public ParserRule getForwardRelationRule() {
		return getForwardRelationAccess().getRule();
	}
	
	//ReverseRelation:
	//    ownedAnnotations+=Annotation*
	//    'reverse' name=ID;
	public ReverseRelationElements getReverseRelationAccess() {
		return pReverseRelation;
	}
	
	public ParserRule getReverseRelationRule() {
		return getReverseRelationAccess().getRule();
	}
	
	//Rule:
	//    ownedAnnotations+=Annotation*
	//    'rule' name=ID '['
	//        antecedent+=Predicate ('^' antecedent+=Predicate)* '->' consequent+=Predicate ('^' consequent+=Predicate)*
	//    ']';
	public RuleElements getRuleAccess() {
		return pRule;
	}
	
	public ParserRule getRuleRule() {
		return getRuleAccess().getRule();
	}
	
	//StructureInstance:
	//    type=[Structure|Ref] '['
	//        ownedPropertyValues+=PropertyValueAssertion*
	//    ']';
	public StructureInstanceElements getStructureInstanceAccess() {
		return pStructureInstance;
	}
	
	public ParserRule getStructureInstanceRule() {
		return getStructureInstanceAccess().getRule();
	}
	
	//NamedInstance:
	//    ConceptInstance |
	//    RelationInstance;
	public NamedInstanceElements getNamedInstanceAccess() {
		return pNamedInstance;
	}
	
	public ParserRule getNamedInstanceRule() {
		return getNamedInstanceAccess().getRule();
	}
	
	//ConceptInstance:
	//    ownedAnnotations+=Annotation*
	//    'ci' name=ID (':' ownedTypes+=ConceptTypeAssertion (',' ownedTypes+=ConceptTypeAssertion)*)? ('['
	//        (ownedPropertyValues+=PropertyValueAssertion |
	//         ownedLinks+=LinkAssertion)*
	//    ']')?;
	public ConceptInstanceElements getConceptInstanceAccess() {
		return pConceptInstance;
	}
	
	public ParserRule getConceptInstanceRule() {
		return getConceptInstanceAccess().getRule();
	}
	
	//RelationInstance:
	//    ownedAnnotations+=Annotation*
	//    'ri' name=ID (':' ownedTypes+=RelationTypeAssertion (',' ownedTypes+=RelationTypeAssertion)*)? '['
	//        'from' sources+=[NamedInstance|Ref] (',' sources+=[NamedInstance|Ref])*
	//        'to' targets+=[NamedInstance|Ref] (',' targets+=[NamedInstance|Ref])*
	//        (ownedPropertyValues+=PropertyValueAssertion |
	//         ownedLinks+=LinkAssertion)*
	//    ']';
	public RelationInstanceElements getRelationInstanceAccess() {
		return pRelationInstance;
	}
	
	public ParserRule getRelationInstanceRule() {
		return getRelationInstanceAccess().getRule();
	}
	
	//SpecializableTermReference:
	//    ClassifierReference |
	//    FacetedScalarReference |
	//    EnumeratedScalarReference |
	//    AnnotationPropertyReference |
	//    ScalarPropertyReference |
	//    StructuredPropertyReference;
	public SpecializableTermReferenceElements getSpecializableTermReferenceAccess() {
		return pSpecializableTermReference;
	}
	
	public ParserRule getSpecializableTermReferenceRule() {
		return getSpecializableTermReferenceAccess().getRule();
	}
	
	//ClassifierReference:
	//    EntityReference |
	//    StructureReference;
	public ClassifierReferenceElements getClassifierReferenceAccess() {
		return pClassifierReference;
	}
	
	public ParserRule getClassifierReferenceRule() {
		return getClassifierReferenceAccess().getRule();
	}
	
	//EntityReference:
	//    AspectReference |
	//    ConceptReference |
	//    RelationEntityReference;
	public EntityReferenceElements getEntityReferenceAccess() {
		return pEntityReference;
	}
	
	public ParserRule getEntityReferenceRule() {
		return getEntityReferenceAccess().getRule();
	}
	
	//AspectReference:
	//    ownedAnnotations+=Annotation*
	//    'ref' 'aspect' aspect=[Aspect|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
	//        (ownedKeys+=KeyAxiom |
	//         ownedPropertyRestrictions+=PropertyRestrictionAxiom |
	//         ownedRelationRestrictions+=RelationRestrictionAxiom)*
	//    ']')?;
	public AspectReferenceElements getAspectReferenceAccess() {
		return pAspectReference;
	}
	
	public ParserRule getAspectReferenceRule() {
		return getAspectReferenceAccess().getRule();
	}
	
	//ConceptReference:
	//    ownedAnnotations+=Annotation*
	//    'ref' 'concept' concept=[Concept|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
	//        (ownedKeys+=KeyAxiom |
	//         ownedPropertyRestrictions+=PropertyRestrictionAxiom |
	//         ownedRelationRestrictions+=RelationRestrictionAxiom)*
	//    ']')?;
	public ConceptReferenceElements getConceptReferenceAccess() {
		return pConceptReference;
	}
	
	public ParserRule getConceptReferenceRule() {
		return getConceptReferenceAccess().getRule();
	}
	
	//RelationEntityReference:
	//    ownedAnnotations+=Annotation*
	//    'ref' 'relation' 'entity' entity=[RelationEntity|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
	//        (ownedKeys+=KeyAxiom |
	//         ownedPropertyRestrictions+=PropertyRestrictionAxiom |
	//         ownedRelationRestrictions+=RelationRestrictionAxiom)*
	//    ']')?;
	public RelationEntityReferenceElements getRelationEntityReferenceAccess() {
		return pRelationEntityReference;
	}
	
	public ParserRule getRelationEntityReferenceRule() {
		return getRelationEntityReferenceAccess().getRule();
	}
	
	//StructureReference:
	//    ownedAnnotations+=Annotation*
	//    'ref' 'structure' structure=[Structure|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)? ('['
	//        ownedPropertyRestrictions+=PropertyRestrictionAxiom*
	//    ']')?;
	public StructureReferenceElements getStructureReferenceAccess() {
		return pStructureReference;
	}
	
	public ParserRule getStructureReferenceRule() {
		return getStructureReferenceAccess().getRule();
	}
	
	//AnnotationPropertyReference:
	//    ownedAnnotations+=Annotation*
	//    'ref' 'annotation' 'property' property=[AnnotationProperty|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?;
	public AnnotationPropertyReferenceElements getAnnotationPropertyReferenceAccess() {
		return pAnnotationPropertyReference;
	}
	
	public ParserRule getAnnotationPropertyReferenceRule() {
		return getAnnotationPropertyReferenceAccess().getRule();
	}
	
	//ScalarPropertyReference:
	//    ownedAnnotations+=Annotation*
	//    'ref' 'scalar' 'property' property=[ScalarProperty|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?;
	public ScalarPropertyReferenceElements getScalarPropertyReferenceAccess() {
		return pScalarPropertyReference;
	}
	
	public ParserRule getScalarPropertyReferenceRule() {
		return getScalarPropertyReferenceAccess().getRule();
	}
	
	//StructuredPropertyReference:
	//    ownedAnnotations+=Annotation*
	//    'ref' 'structured' 'property' property=[StructuredProperty|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?;
	public StructuredPropertyReferenceElements getStructuredPropertyReferenceAccess() {
		return pStructuredPropertyReference;
	}
	
	public ParserRule getStructuredPropertyReferenceRule() {
		return getStructuredPropertyReferenceAccess().getRule();
	}
	
	//FacetedScalarReference:
	//    ownedAnnotations+=Annotation*
	//    'ref' 'scalar' scalar=[FacetedScalar|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?;
	public FacetedScalarReferenceElements getFacetedScalarReferenceAccess() {
		return pFacetedScalarReference;
	}
	
	public ParserRule getFacetedScalarReferenceRule() {
		return getFacetedScalarReferenceAccess().getRule();
	}
	
	//EnumeratedScalarReference:
	//    ownedAnnotations+=Annotation*
	//    'ref' 'enumerated' 'scalar' scalar=[EnumeratedScalar|Ref] (':>' ownedSpecializations+=SpecializationAxiom (',' ownedSpecializations+=SpecializationAxiom)*)?;
	public EnumeratedScalarReferenceElements getEnumeratedScalarReferenceAccess() {
		return pEnumeratedScalarReference;
	}
	
	public ParserRule getEnumeratedScalarReferenceRule() {
		return getEnumeratedScalarReferenceAccess().getRule();
	}
	
	//RelationReference:
	//    ownedAnnotations+=Annotation*
	//    'ref' 'relation' relation=[Relation|Ref];
	public RelationReferenceElements getRelationReferenceAccess() {
		return pRelationReference;
	}
	
	public ParserRule getRelationReferenceRule() {
		return getRelationReferenceAccess().getRule();
	}
	
	//RuleReference:
	//    ownedAnnotations+=Annotation*
	//    'ref' 'rule' rule=[Rule|Ref];
	public RuleReferenceElements getRuleReferenceAccess() {
		return pRuleReference;
	}
	
	public ParserRule getRuleReferenceRule() {
		return getRuleReferenceAccess().getRule();
	}
	
	//NamedInstanceReference:
	//    ConceptInstanceReference |
	//    RelationInstanceReference;
	public NamedInstanceReferenceElements getNamedInstanceReferenceAccess() {
		return pNamedInstanceReference;
	}
	
	public ParserRule getNamedInstanceReferenceRule() {
		return getNamedInstanceReferenceAccess().getRule();
	}
	
	//ConceptInstanceReference:
	//    ownedAnnotations+=Annotation*
	//    'ref' 'ci' instance=[ConceptInstance|Ref] (':' ownedTypes+=ConceptTypeAssertion (',' ownedTypes+=ConceptTypeAssertion)*)? ('['
	//        ownedPropertyValues+=PropertyValueAssertion*
	//        ownedLinks+=LinkAssertion*
	//    ']')?;
	public ConceptInstanceReferenceElements getConceptInstanceReferenceAccess() {
		return pConceptInstanceReference;
	}
	
	public ParserRule getConceptInstanceReferenceRule() {
		return getConceptInstanceReferenceAccess().getRule();
	}
	
	//RelationInstanceReference:
	//    ownedAnnotations+=Annotation*
	//    'ref' 'ri' instance=[RelationInstance|Ref] (':' ownedTypes+=RelationTypeAssertion (',' ownedTypes+=RelationTypeAssertion)*)? ('['
	//        ownedPropertyValues+=PropertyValueAssertion*
	//        ownedLinks+=LinkAssertion*
	//    ']')?;
	public RelationInstanceReferenceElements getRelationInstanceReferenceAccess() {
		return pRelationInstanceReference;
	}
	
	public ParserRule getRelationInstanceReferenceRule() {
		return getRelationInstanceReferenceAccess().getRule();
	}
	
	//VocabularyStatement:
	//    Rule |
	//    RuleReference |
	//    SpecializableTerm |
	//    SpecializableTermReference |
	//    RelationReference;
	public VocabularyStatementElements getVocabularyStatementAccess() {
		return pVocabularyStatement;
	}
	
	public ParserRule getVocabularyStatementRule() {
		return getVocabularyStatementAccess().getRule();
	}
	
	//DescriptionStatement:
	//    NamedInstance |
	//    NamedInstanceReference;
	public DescriptionStatementElements getDescriptionStatementAccess() {
		return pDescriptionStatement;
	}
	
	public ParserRule getDescriptionStatementRule() {
		return getDescriptionStatementAccess().getRule();
	}
	
	//VocabularyImport:
	//    VocabularyExtension |
	//    VocabularyUsage;
	public VocabularyImportElements getVocabularyImportAccess() {
		return pVocabularyImport;
	}
	
	public ParserRule getVocabularyImportRule() {
		return getVocabularyImportAccess().getRule();
	}
	
	//VocabularyExtension:
	//    ownedAnnotations+=Annotation*
	//    'extends' namespace=NAMESPACE ('as' prefix=ID)?;
	public VocabularyExtensionElements getVocabularyExtensionAccess() {
		return pVocabularyExtension;
	}
	
	public ParserRule getVocabularyExtensionRule() {
		return getVocabularyExtensionAccess().getRule();
	}
	
	//VocabularyUsage:
	//    ownedAnnotations+=Annotation*
	//    'uses' namespace=NAMESPACE ('as' prefix=ID)?;
	public VocabularyUsageElements getVocabularyUsageAccess() {
		return pVocabularyUsage;
	}
	
	public ParserRule getVocabularyUsageRule() {
		return getVocabularyUsageAccess().getRule();
	}
	
	//VocabularyBundleImport:
	//    VocabularyBundleExtension |
	//    VocabularyBundleInclusion;
	public VocabularyBundleImportElements getVocabularyBundleImportAccess() {
		return pVocabularyBundleImport;
	}
	
	public ParserRule getVocabularyBundleImportRule() {
		return getVocabularyBundleImportAccess().getRule();
	}
	
	//VocabularyBundleInclusion:
	//    ownedAnnotations+=Annotation*
	//    'includes' namespace=NAMESPACE ('as' prefix=ID)?;
	public VocabularyBundleInclusionElements getVocabularyBundleInclusionAccess() {
		return pVocabularyBundleInclusion;
	}
	
	public ParserRule getVocabularyBundleInclusionRule() {
		return getVocabularyBundleInclusionAccess().getRule();
	}
	
	//VocabularyBundleExtension:
	//    ownedAnnotations+=Annotation*
	//    'extends' namespace=NAMESPACE ('as' prefix=ID)?;
	public VocabularyBundleExtensionElements getVocabularyBundleExtensionAccess() {
		return pVocabularyBundleExtension;
	}
	
	public ParserRule getVocabularyBundleExtensionRule() {
		return getVocabularyBundleExtensionAccess().getRule();
	}
	
	//DescriptionImport:
	//    DescriptionExtension |
	//    DescriptionUsage;
	public DescriptionImportElements getDescriptionImportAccess() {
		return pDescriptionImport;
	}
	
	public ParserRule getDescriptionImportRule() {
		return getDescriptionImportAccess().getRule();
	}
	
	//DescriptionUsage:
	//    ownedAnnotations+=Annotation*
	//    'uses' namespace=NAMESPACE ('as' prefix=ID)?;
	public DescriptionUsageElements getDescriptionUsageAccess() {
		return pDescriptionUsage;
	}
	
	public ParserRule getDescriptionUsageRule() {
		return getDescriptionUsageAccess().getRule();
	}
	
	//DescriptionExtension:
	//    ownedAnnotations+=Annotation*
	//    'extends' namespace=NAMESPACE ('as' prefix=ID)?;
	public DescriptionExtensionElements getDescriptionExtensionAccess() {
		return pDescriptionExtension;
	}
	
	public ParserRule getDescriptionExtensionRule() {
		return getDescriptionExtensionAccess().getRule();
	}
	
	//DescriptionBundleImport:
	//    DescriptionBundleExtension |
	//    DescriptionBundleInclusion |
	//    DescriptionBundleUsage;
	public DescriptionBundleImportElements getDescriptionBundleImportAccess() {
		return pDescriptionBundleImport;
	}
	
	public ParserRule getDescriptionBundleImportRule() {
		return getDescriptionBundleImportAccess().getRule();
	}
	
	//DescriptionBundleInclusion:
	//    ownedAnnotations+=Annotation*
	//    'includes' namespace=NAMESPACE ('as' prefix=ID)?;
	public DescriptionBundleInclusionElements getDescriptionBundleInclusionAccess() {
		return pDescriptionBundleInclusion;
	}
	
	public ParserRule getDescriptionBundleInclusionRule() {
		return getDescriptionBundleInclusionAccess().getRule();
	}
	
	//DescriptionBundleExtension:
	//    ownedAnnotations+=Annotation*
	//    'extends' namespace=NAMESPACE ('as' prefix=ID)?;
	public DescriptionBundleExtensionElements getDescriptionBundleExtensionAccess() {
		return pDescriptionBundleExtension;
	}
	
	public ParserRule getDescriptionBundleExtensionRule() {
		return getDescriptionBundleExtensionAccess().getRule();
	}
	
	//DescriptionBundleUsage:
	//    ownedAnnotations+=Annotation*
	//    'uses' namespace=NAMESPACE ('as' prefix=ID)?;
	public DescriptionBundleUsageElements getDescriptionBundleUsageAccess() {
		return pDescriptionBundleUsage;
	}
	
	public ParserRule getDescriptionBundleUsageRule() {
		return getDescriptionBundleUsageAccess().getRule();
	}
	
	//SpecializationAxiom:
	//    specializedTerm=[SpecializableTerm|Ref];
	public SpecializationAxiomElements getSpecializationAxiomAccess() {
		return pSpecializationAxiom;
	}
	
	public ParserRule getSpecializationAxiomRule() {
		return getSpecializationAxiomAccess().getRule();
	}
	
	//PropertyRestrictionAxiom:
	//    ScalarPropertyRestrictionAxiom |
	//    StructuredPropertyRestrictionAxiom;
	public PropertyRestrictionAxiomElements getPropertyRestrictionAxiomAccess() {
		return pPropertyRestrictionAxiom;
	}
	
	public ParserRule getPropertyRestrictionAxiomRule() {
		return getPropertyRestrictionAxiomAccess().getRule();
	}
	
	//ScalarPropertyRestrictionAxiom:
	//    ScalarPropertyRangeRestrictionAxiom |
	//    ScalarPropertyCardinalityRestrictionAxiom |
	//    ScalarPropertyValueRestrictionAxiom;
	public ScalarPropertyRestrictionAxiomElements getScalarPropertyRestrictionAxiomAccess() {
		return pScalarPropertyRestrictionAxiom;
	}
	
	public ParserRule getScalarPropertyRestrictionAxiomRule() {
		return getScalarPropertyRestrictionAxiomAccess().getRule();
	}
	
	//ScalarPropertyRangeRestrictionAxiom:
	//    'restricts' kind=RangeRestrictionKind 'scalar' 'property' property=[ScalarProperty|Ref] 'to' range=[Scalar|Ref];
	public ScalarPropertyRangeRestrictionAxiomElements getScalarPropertyRangeRestrictionAxiomAccess() {
		return pScalarPropertyRangeRestrictionAxiom;
	}
	
	public ParserRule getScalarPropertyRangeRestrictionAxiomRule() {
		return getScalarPropertyRangeRestrictionAxiomAccess().getRule();
	}
	
	//ScalarPropertyCardinalityRestrictionAxiom:
	//    'restricts' 'scalar' 'property' property=[ScalarProperty|Ref] 'to' kind=CardinalityRestrictionKind cardinality=UnsignedInteger (range=[Scalar|Ref])?;
	public ScalarPropertyCardinalityRestrictionAxiomElements getScalarPropertyCardinalityRestrictionAxiomAccess() {
		return pScalarPropertyCardinalityRestrictionAxiom;
	}
	
	public ParserRule getScalarPropertyCardinalityRestrictionAxiomRule() {
		return getScalarPropertyCardinalityRestrictionAxiomAccess().getRule();
	}
	
	//ScalarPropertyValueRestrictionAxiom:
	//    'restricts' 'scalar' 'property' property=[ScalarProperty|Ref] 'to' value=Literal;
	public ScalarPropertyValueRestrictionAxiomElements getScalarPropertyValueRestrictionAxiomAccess() {
		return pScalarPropertyValueRestrictionAxiom;
	}
	
	public ParserRule getScalarPropertyValueRestrictionAxiomRule() {
		return getScalarPropertyValueRestrictionAxiomAccess().getRule();
	}
	
	//StructuredPropertyRestrictionAxiom:
	//    StructuredPropertyRangeRestrictionAxiom |
	//    StructuredPropertyCardinalityRestrictionAxiom |
	//    StructuredPropertyValueRestrictionAxiom;
	public StructuredPropertyRestrictionAxiomElements getStructuredPropertyRestrictionAxiomAccess() {
		return pStructuredPropertyRestrictionAxiom;
	}
	
	public ParserRule getStructuredPropertyRestrictionAxiomRule() {
		return getStructuredPropertyRestrictionAxiomAccess().getRule();
	}
	
	//StructuredPropertyRangeRestrictionAxiom:
	//    'restricts' kind=RangeRestrictionKind 'structured' 'property' property=[StructuredProperty|Ref] 'to' range=[Structure|Ref];
	public StructuredPropertyRangeRestrictionAxiomElements getStructuredPropertyRangeRestrictionAxiomAccess() {
		return pStructuredPropertyRangeRestrictionAxiom;
	}
	
	public ParserRule getStructuredPropertyRangeRestrictionAxiomRule() {
		return getStructuredPropertyRangeRestrictionAxiomAccess().getRule();
	}
	
	//StructuredPropertyCardinalityRestrictionAxiom:
	//    'restricts' 'structured' 'property' property=[StructuredProperty|Ref] 'to' kind=CardinalityRestrictionKind cardinality=UnsignedInteger (range=[Structure|Ref])?;
	public StructuredPropertyCardinalityRestrictionAxiomElements getStructuredPropertyCardinalityRestrictionAxiomAccess() {
		return pStructuredPropertyCardinalityRestrictionAxiom;
	}
	
	public ParserRule getStructuredPropertyCardinalityRestrictionAxiomRule() {
		return getStructuredPropertyCardinalityRestrictionAxiomAccess().getRule();
	}
	
	//StructuredPropertyValueRestrictionAxiom:
	//    'restricts' 'structured' 'property' property=[StructuredProperty|Ref] 'to' value=StructureInstance;
	public StructuredPropertyValueRestrictionAxiomElements getStructuredPropertyValueRestrictionAxiomAccess() {
		return pStructuredPropertyValueRestrictionAxiom;
	}
	
	public ParserRule getStructuredPropertyValueRestrictionAxiomRule() {
		return getStructuredPropertyValueRestrictionAxiomAccess().getRule();
	}
	
	//RelationRestrictionAxiom:
	//    RelationRangeRestrictionAxiom |
	//    RelationCardinalityRestrictionAxiom |
	//    RelationTargetRestrictionAxiom;
	public RelationRestrictionAxiomElements getRelationRestrictionAxiomAccess() {
		return pRelationRestrictionAxiom;
	}
	
	public ParserRule getRelationRestrictionAxiomRule() {
		return getRelationRestrictionAxiomAccess().getRule();
	}
	
	//RelationRangeRestrictionAxiom:
	//    'restricts' kind=RangeRestrictionKind 'relation' relation=[Relation|Ref] 'to' range=[Entity|Ref];
	public RelationRangeRestrictionAxiomElements getRelationRangeRestrictionAxiomAccess() {
		return pRelationRangeRestrictionAxiom;
	}
	
	public ParserRule getRelationRangeRestrictionAxiomRule() {
		return getRelationRangeRestrictionAxiomAccess().getRule();
	}
	
	//RelationCardinalityRestrictionAxiom:
	//    'restricts' 'relation' relation=[Relation|Ref] 'to' kind=CardinalityRestrictionKind cardinality=UnsignedInteger (range=[Entity|Ref])?;
	public RelationCardinalityRestrictionAxiomElements getRelationCardinalityRestrictionAxiomAccess() {
		return pRelationCardinalityRestrictionAxiom;
	}
	
	public ParserRule getRelationCardinalityRestrictionAxiomRule() {
		return getRelationCardinalityRestrictionAxiomAccess().getRule();
	}
	
	//RelationTargetRestrictionAxiom:
	//    'restricts' 'relation' relation=[Relation|Ref] 'to' target=[NamedInstance|Ref];
	public RelationTargetRestrictionAxiomElements getRelationTargetRestrictionAxiomAccess() {
		return pRelationTargetRestrictionAxiom;
	}
	
	public ParserRule getRelationTargetRestrictionAxiomRule() {
		return getRelationTargetRestrictionAxiomAccess().getRule();
	}
	
	//KeyAxiom:
	//    'key' properties+=[Feature|Ref] (',' properties+=[Feature|Ref])*;
	public KeyAxiomElements getKeyAxiomAccess() {
		return pKeyAxiom;
	}
	
	public ParserRule getKeyAxiomRule() {
		return getKeyAxiomAccess().getRule();
	}
	
	//ConceptTypeAssertion:
	//    type=[Concept|Ref];
	public ConceptTypeAssertionElements getConceptTypeAssertionAccess() {
		return pConceptTypeAssertion;
	}
	
	public ParserRule getConceptTypeAssertionRule() {
		return getConceptTypeAssertionAccess().getRule();
	}
	
	//RelationTypeAssertion:
	//    type=[RelationEntity|Ref];
	public RelationTypeAssertionElements getRelationTypeAssertionAccess() {
		return pRelationTypeAssertion;
	}
	
	public ParserRule getRelationTypeAssertionRule() {
		return getRelationTypeAssertionAccess().getRule();
	}
	
	//PropertyValueAssertion:
	//    ScalarPropertyValueAssertion |
	//    StructuredPropertyValueAssertion;
	public PropertyValueAssertionElements getPropertyValueAssertionAccess() {
		return pPropertyValueAssertion;
	}
	
	public ParserRule getPropertyValueAssertionRule() {
		return getPropertyValueAssertionAccess().getRule();
	}
	
	//ScalarPropertyValueAssertion:
	//    property=[ScalarProperty|Ref] value=Literal;
	public ScalarPropertyValueAssertionElements getScalarPropertyValueAssertionAccess() {
		return pScalarPropertyValueAssertion;
	}
	
	public ParserRule getScalarPropertyValueAssertionRule() {
		return getScalarPropertyValueAssertionAccess().getRule();
	}
	
	//StructuredPropertyValueAssertion:
	//    property=[StructuredProperty|Ref] value=StructureInstance;
	public StructuredPropertyValueAssertionElements getStructuredPropertyValueAssertionAccess() {
		return pStructuredPropertyValueAssertion;
	}
	
	public ParserRule getStructuredPropertyValueAssertionRule() {
		return getStructuredPropertyValueAssertionAccess().getRule();
	}
	
	//LinkAssertion:
	//    relation=[Relation|Ref] target=[NamedInstance|Ref];
	public LinkAssertionElements getLinkAssertionAccess() {
		return pLinkAssertion;
	}
	
	public ParserRule getLinkAssertionRule() {
		return getLinkAssertionAccess().getRule();
	}
	
	//Predicate:
	//    UnaryPredicate |
	//    BinaryPredicate;
	public PredicateElements getPredicateAccess() {
		return pPredicate;
	}
	
	public ParserRule getPredicateRule() {
		return getPredicateAccess().getRule();
	}
	
	//UnaryPredicate:
	//    TypePredicate;
	public UnaryPredicateElements getUnaryPredicateAccess() {
		return pUnaryPredicate;
	}
	
	public ParserRule getUnaryPredicateRule() {
		return getUnaryPredicateAccess().getRule();
	}
	
	//TypePredicate:
	//    type=[Type|Ref] => '(' variable=ID ')';
	public TypePredicateElements getTypePredicateAccess() {
		return pTypePredicate;
	}
	
	public ParserRule getTypePredicateRule() {
		return getTypePredicateAccess().getRule();
	}
	
	//BinaryPredicate:
	//    RelationEntityPredicate |
	//    FeaturePredicate |
	//    SameAsPredicate |
	//    DifferentFromPredicate;
	public BinaryPredicateElements getBinaryPredicateAccess() {
		return pBinaryPredicate;
	}
	
	public ParserRule getBinaryPredicateRule() {
		return getBinaryPredicateAccess().getRule();
	}
	
	//RelationEntityPredicate:
	//    entity=[RelationEntity|Ref] '(' variable1=ID ',' entityVariable=ID ',' (variable2=ID | instance2=[NamedInstance|CrossRef]) ')';
	public RelationEntityPredicateElements getRelationEntityPredicateAccess() {
		return pRelationEntityPredicate;
	}
	
	public ParserRule getRelationEntityPredicateRule() {
		return getRelationEntityPredicateAccess().getRule();
	}
	
	//FeaturePredicate:
	//    feature=[Feature|Ref] '(' variable1=ID ',' (variable2=ID | literal2=Literal | instance2=[NamedInstance|CrossRef]) ')';
	public FeaturePredicateElements getFeaturePredicateAccess() {
		return pFeaturePredicate;
	}
	
	public ParserRule getFeaturePredicateRule() {
		return getFeaturePredicateAccess().getRule();
	}
	
	//SameAsPredicate:
	//    'sameAs' '(' variable1=ID ',' (variable2=ID | instance2=[NamedInstance|CrossRef]) ')';
	public SameAsPredicateElements getSameAsPredicateAccess() {
		return pSameAsPredicate;
	}
	
	public ParserRule getSameAsPredicateRule() {
		return getSameAsPredicateAccess().getRule();
	}
	
	//DifferentFromPredicate:
	//    'differentFrom' '(' variable1=ID ',' (variable2=ID | instance2=[NamedInstance|CrossRef]) ')';
	public DifferentFromPredicateElements getDifferentFromPredicateAccess() {
		return pDifferentFromPredicate;
	}
	
	public ParserRule getDifferentFromPredicateRule() {
		return getDifferentFromPredicateAccess().getRule();
	}
	
	//Literal:
	//    IntegerLiteral |
	//    DecimalLiteral |
	//    DoubleLiteral |
	//    BooleanLiteral |
	//    QuotedLiteral;
	public LiteralElements getLiteralAccess() {
		return pLiteral;
	}
	
	public ParserRule getLiteralRule() {
		return getLiteralAccess().getRule();
	}
	
	//IntegerLiteral:
	//    value=Integer;
	public IntegerLiteralElements getIntegerLiteralAccess() {
		return pIntegerLiteral;
	}
	
	public ParserRule getIntegerLiteralRule() {
		return getIntegerLiteralAccess().getRule();
	}
	
	//DecimalLiteral:
	//    value=Decimal;
	public DecimalLiteralElements getDecimalLiteralAccess() {
		return pDecimalLiteral;
	}
	
	public ParserRule getDecimalLiteralRule() {
		return getDecimalLiteralAccess().getRule();
	}
	
	//DoubleLiteral:
	//    value=Double;
	public DoubleLiteralElements getDoubleLiteralAccess() {
		return pDoubleLiteral;
	}
	
	public ParserRule getDoubleLiteralRule() {
		return getDoubleLiteralAccess().getRule();
	}
	
	//BooleanLiteral:
	//    value=Boolean;
	public BooleanLiteralElements getBooleanLiteralAccess() {
		return pBooleanLiteral;
	}
	
	public ParserRule getBooleanLiteralRule() {
		return getBooleanLiteralAccess().getRule();
	}
	
	//QuotedLiteral:
	//    value=STRING (('^^' type=[Scalar|Ref]) | ('$' langTag=ID))?;
	public QuotedLiteralElements getQuotedLiteralAccess() {
		return pQuotedLiteral;
	}
	
	public ParserRule getQuotedLiteralRule() {
		return getQuotedLiteralAccess().getRule();
	}
	
	//enum RangeRestrictionKind:
	//    all |
	//    some;
	public RangeRestrictionKindElements getRangeRestrictionKindAccess() {
		return eRangeRestrictionKind;
	}
	
	public EnumRule getRangeRestrictionKindRule() {
		return getRangeRestrictionKindAccess().getRule();
	}
	
	//enum CardinalityRestrictionKind:
	//    exactly |
	//    min |
	//    max;
	public CardinalityRestrictionKindElements getCardinalityRestrictionKindAccess() {
		return eCardinalityRestrictionKind;
	}
	
	public EnumRule getCardinalityRestrictionKindRule() {
		return getCardinalityRestrictionKindAccess().getRule();
	}
	
	////--------------
	//Ref returns ecore::EString:                             ID | QNAME | IRI;
	public RefElements getRefAccess() {
		return pRef;
	}
	
	public ParserRule getRefRule() {
		return getRefAccess().getRule();
	}
	
	//CrossRef returns ecore::EString: 						QNAME | IRI;
	public CrossRefElements getCrossRefAccess() {
		return pCrossRef;
	}
	
	public ParserRule getCrossRefRule() {
		return getCrossRefAccess().getRule();
	}
	
	//Boolean returns ecore::EBoolean:						BOOLEAN_STR;
	public BooleanElements getBooleanAccess() {
		return pBoolean;
	}
	
	public ParserRule getBooleanRule() {
		return getBooleanAccess().getRule();
	}
	
	//UnsignedInteger returns UnsignedInt: 					UNSIGNED_INTEGER_STR;
	public UnsignedIntegerElements getUnsignedIntegerAccess() {
		return pUnsignedInteger;
	}
	
	public ParserRule getUnsignedIntegerRule() {
		return getUnsignedIntegerAccess().getRule();
	}
	
	//Integer returns ecore::EInt: 							UNSIGNED_INTEGER_STR | INTEGER_STR;
	public IntegerElements getIntegerAccess() {
		return pInteger;
	}
	
	public ParserRule getIntegerRule() {
		return getIntegerAccess().getRule();
	}
	
	//Decimal returns Decimal:								DECIMAL_STR;
	public DecimalElements getDecimalAccess() {
		return pDecimal;
	}
	
	public ParserRule getDecimalRule() {
		return getDecimalAccess().getRule();
	}
	
	//Double returns ecore::EDouble:							DOUBLE_STR;
	public DoubleElements getDoubleAccess() {
		return pDouble;
	}
	
	public ParserRule getDoubleRule() {
		return getDoubleAccess().getRule();
	}
	
	////----------------------------
	//terminal BOOLEAN_STR:                                    'false'|'true';
	public TerminalRule getBOOLEAN_STRRule() {
		return tBOOLEAN_STR;
	}
	
	//terminal UNSIGNED_INTEGER_STR:							DIGIT+;
	public TerminalRule getUNSIGNED_INTEGER_STRRule() {
		return tUNSIGNED_INTEGER_STR;
	}
	
	//terminal INTEGER_STR:									('+'|'-')? DIGIT+;
	public TerminalRule getINTEGER_STRRule() {
		return tINTEGER_STR;
	}
	
	//terminal DECIMAL_STR:									('+'|'-')? (DIGIT+('.'DIGIT*)? | ('.'DIGIT+));
	public TerminalRule getDECIMAL_STRRule() {
		return tDECIMAL_STR;
	}
	
	//terminal DOUBLE_STR:									('+'|'-')? (DIGIT+('.'DIGIT*)? | ('.'DIGIT+)) (('e'|'E') ('+'|'-')? DIGIT+)?;
	public TerminalRule getDOUBLE_STRRule() {
		return tDOUBLE_STR;
	}
	
	//terminal STRING:										('"' (!('"'|'\\') | '\\'.)* '"') | ("'" (!("'"|'\\') | '\\'.)* "'") | ("'''" -> "'''") | '"""' -> '"""';
	public TerminalRule getSTRINGRule() {
		return tSTRING;
	}
	
	//terminal NAMESPACE:										'<' (!('>'|' '|'#'))* ('#'|'/') '>';
	public TerminalRule getNAMESPACERule() {
		return tNAMESPACE;
	}
	
	//terminal IRI:											'<' (!('>'|' '))* '>';
	public TerminalRule getIRIRule() {
		return tIRI;
	}
	
	//terminal ID:											IDFRAG;
	public TerminalRule getIDRule() {
		return tID;
	}
	
	//terminal QNAME:											IDFRAG ':' IDFRAG;
	public TerminalRule getQNAMERule() {
		return tQNAME;
	}
	
	//terminal ML_COMMENT: 									'/*' -> '*/';
	public TerminalRule getML_COMMENTRule() {
		return tML_COMMENT;
	}
	
	//terminal SL_COMMENT:									'//' !('\n'|'\r')* ('\r'? '\n')?;
	public TerminalRule getSL_COMMENTRule() {
		return tSL_COMMENT;
	}
	
	//terminal WS: 											(' '|'\t'|'\r'|'\n')+;
	public TerminalRule getWSRule() {
		return tWS;
	}
	
	////----------------------------
	//terminal fragment IDFRAG:                                '^'? (ALPHA|DIGIT|'_') (ALPHA|DIGIT|'_'|'-'|'.'|'$')*;
	public TerminalRule getIDFRAGRule() {
		return tIDFRAG;
	}
	
	//terminal fragment ALPHA:								'a'..'z'| 'A'..'Z';
	public TerminalRule getALPHARule() {
		return tALPHA;
	}
	
	//terminal fragment DIGIT: 								'0'..'9';
	public TerminalRule getDIGITRule() {
		return tDIGIT;
	}
}
