/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.merge;

import io.opencaesar.oml.merge.OmlMergeApp;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.work.Incremental;

public abstract class OmlMergeTask
extends DefaultTask {
    @InputFiles
    public abstract ListProperty<File> getInputZipPaths();

    @InputFiles
    public abstract ListProperty<File> getInputFolderPaths();

    @InputFiles
    public abstract ListProperty<File> getInputCatalogPaths();

    @OutputDirectory
    public abstract DirectoryProperty getOutputCatalogFolder();

    @Optional
    @Input
    public abstract Property<Boolean> getGenerateOutputCatalog();

    @Input
    @Optional
    public abstract Property<Boolean> getDebug();

    @Incremental
    @InputFiles
    protected ConfigurableFileCollection getInputFiles() {
        if (!((List)this.getInputZipPaths().get()).isEmpty()) {
            return this.getProject().files(new Object[]{this.getInputZipPaths().get()});
        }
        if (!((List)this.getInputFolderPaths().get()).isEmpty()) {
            return this.getProject().files(new Object[]{this.getInputFolderPaths()});
        }
        if (!((List)this.getInputCatalogPaths().get()).isEmpty()) {
            return this.getProject().files(new Object[]{this.getInputCatalogPaths()});
        }
        return this.getProject().files(new Object[]{Collections.EMPTY_LIST});
    }

    @TaskAction
    public void run() {
        ArrayList<String> args = new ArrayList<String>();
        if (!((List)this.getInputZipPaths().get()).isEmpty()) {
            for (File inputZipPath : (List)this.getInputZipPaths().get()) {
                args.add("-z");
                args.add(inputZipPath.getAbsolutePath());
            }
        }
        if (!((List)this.getInputFolderPaths().get()).isEmpty()) {
            for (File inputFolderPath : (List)this.getInputFolderPaths().get()) {
                args.add("-f");
                args.add(inputFolderPath.getAbsolutePath());
            }
        }
        if (!((List)this.getInputCatalogPaths().get()).isEmpty()) {
            for (File inputCatalogPath : (List)this.getInputCatalogPaths().get()) {
                args.add("-c");
                args.add(inputCatalogPath.getAbsolutePath());
            }
        }
        if (this.getOutputCatalogFolder().isPresent()) {
            args.add("-o");
            args.add(((Directory)this.getOutputCatalogFolder().get()).getAsFile().getAbsolutePath());
        }
        if (this.getGenerateOutputCatalog().isPresent() && ((Boolean)this.getGenerateOutputCatalog().get()).booleanValue()) {
            args.add("-g");
        }
        if (this.getDebug().isPresent() && ((Boolean)this.getDebug().get()).booleanValue()) {
            args.add("-d");
        }
        try {
            OmlMergeApp.main((String[])args.toArray(new String[0]));
        }
        catch (Exception e) {
            throw new TaskExecutionException((Task)this, (Throwable)e);
        }
    }
}

