/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.validate;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import io.opencaesar.oml.Ontology;
import io.opencaesar.oml.dsl.OmlStandaloneSetup;
import io.opencaesar.oml.util.OmlCatalog;
import io.opencaesar.oml.util.OmlRead;
import io.opencaesar.oml.util.OmlXMIResourceFactory;
import io.opencaesar.oml.validate.OmlValidator;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.xml.resolver.Catalog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.xtext.resource.XtextResourceSet;

public class OmlValidateApp {
    private static final List<String> omlExtensions = Arrays.asList("oml", "omlxmi");
    @Parameter(names={"--input-catalog-path", "-i"}, description="Path of OML input catalog (Required)", validateWith={InputCatalogPath.class}, required=true, order=1)
    private String inputCatalogPath;
    @Parameter(names={"--output-result-path", "-o"}, description="Path of output report file (Optional)", order=2)
    private String outputReportPath;
    @Parameter(names={"-debug", "--d"}, description="Shows debug logging statements", order=3)
    private boolean debug;
    @Parameter(names={"--help", "-h"}, description="Displays summary of options", help=true, order=4)
    private boolean help;
    @Parameter(names={"--version", "-v"}, description="Displays app version", help=true, order=5)
    private boolean version;
    private Logger LOGGER = LogManager.getLogger(OmlValidateApp.class);

    public static void main(String ... args) throws Exception {
        OmlValidateApp app = new OmlValidateApp();
        JCommander builder = JCommander.newBuilder().addObject((Object)app).build();
        builder.parse(args);
        if (app.version) {
            System.out.println(app.getAppVersion());
            return;
        }
        if (app.help) {
            builder.usage();
            return;
        }
        DOMConfigurator.configure((URL)ClassLoader.getSystemClassLoader().getResource("log4j.xml"));
        if (app.debug) {
            Appender appender = LogManager.getRootLogger().getAppender("stdout");
            ((AppenderSkeleton)appender).setThreshold((Priority)Level.DEBUG);
        }
        app.run();
    }

    public void run() throws Exception {
        this.LOGGER.info((Object)"=================================================================");
        this.LOGGER.info((Object)"                        S T A R T");
        this.LOGGER.info((Object)("                    OML Validate " + this.getAppVersion()));
        this.LOGGER.info((Object)"=================================================================");
        this.LOGGER.info((Object)("Input Catalog = " + this.inputCatalogPath));
        this.LOGGER.info((Object)("Output Report = " + this.outputReportPath));
        OmlStandaloneSetup.doSetup();
        OmlXMIResourceFactory.register();
        XtextResourceSet inputResourceSet = new XtextResourceSet();
        inputResourceSet.eAdapters().add((Object)new ECrossReferenceAdapter());
        OmlCatalog inputCatalog = OmlCatalog.create((URI)URI.createFileURI((String)this.inputCatalogPath));
        try {
            List ontologies = this.collectInputOmlFiles(inputCatalog).stream().map(f -> URI.createFileURI((String)f.getAbsolutePath())).map(u -> inputResourceSet.getResource(u, true)).map(r -> OmlRead.getOntology((Resource)r)).collect(Collectors.toList());
            for (Ontology ontology : ontologies) {
                OmlValidator.validate(ontology);
            }
        }
        catch (IllegalStateException e) {
            if (this.outputReportPath != null) {
                Files.write(Paths.get(this.outputReportPath, new String[0]), e.getMessage().getBytes(), new OpenOption[0]);
                throw new IllegalStateException("Problems validating OML catalog: check '" + this.outputReportPath + "' for details.");
            }
            throw e;
        }
        File reportFile = new File(this.outputReportPath);
        if (reportFile.exists()) {
            reportFile.delete();
        }
        this.LOGGER.info((Object)"=================================================================");
        this.LOGGER.info((Object)"                          E N D");
        this.LOGGER.info((Object)"=================================================================");
    }

    private List<File> collectInputOmlFiles(OmlCatalog catalog) throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        catalog.getEntries().stream().filter(e -> e.getEntryType() == Catalog.REWRITE_URI).forEach(e -> {
            String folderPath = e.getEntryArg(1);
            File path = new File(URI.createURI((String)folderPath).toFileString());
            files.addAll(this.collectInputOmlFiles(path));
        });
        for (String subCatalogPath : catalog.getNestedCatalogs()) {
            OmlCatalog subCatalog = OmlCatalog.create((URI)URI.createFileURI((String)subCatalogPath));
            files.addAll(this.collectInputOmlFiles(subCatalog));
        }
        return files;
    }

    private List<File> collectInputOmlFiles(File path) {
        List<File> files = path.isDirectory() ? Arrays.asList(path.listFiles()) : Collections.singletonList(path);
        ArrayList<File> omlFiles = new ArrayList<File>();
        for (File file : files) {
            if (file.isDirectory()) {
                omlFiles.addAll(this.collectInputOmlFiles(file));
                continue;
            }
            if (file.isFile()) {
                String ext = this.getFileExtension(file);
                if (!omlExtensions.contains(ext)) continue;
                omlFiles.add(file);
                continue;
            }
            for (String ext : omlExtensions) {
                File f = new File(path.toString() + "." + ext);
                if (!f.exists()) continue;
                omlFiles.add(f);
            }
        }
        return omlFiles;
    }

    private String getFileExtension(File file) {
        String fileName = file.getName();
        if (fileName.lastIndexOf(".") != -1) {
            return fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return "";
    }

    public String getAppVersion() {
        String version = this.getClass().getPackage().getImplementationVersion();
        return version != null ? version : "<SNAPSHOT>";
    }

    public static class InputCatalogPath
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            File file = new File(value);
            if (!file.getName().endsWith("catalog.xml")) {
                throw new ParameterException("Parameter " + name + " should be a valid OML catalog path");
            }
        }
    }
}

