/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.validate;

import io.opencaesar.oml.Member;
import io.opencaesar.oml.Ontology;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class OmlValidator {
    public static void validate(Ontology ontology) {
        Diagnostician diagnostician = new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                if (eObject != null) {
                    String name = eObject instanceof Member ? ((Member)eObject).getAbbreviatedIri() : (eObject instanceof Ontology ? ((Ontology)eObject).getIri() : EcoreUtil.getID((EObject)eObject));
                    return eObject.eClass().getName() + " " + name;
                }
                return "<null>";
            }
        };
        Diagnostic diagnostic = diagnostician.validate((EObject)ontology);
        if (diagnostic.getSeverity() == 4) {
            StringBuilder sb = new StringBuilder(diagnostic.getMessage());
            for (Diagnostic child : diagnostic.getChildren()) {
                if (child.getSeverity() != 4) continue;
                sb.append(System.lineSeparator());
                sb.append(child.getMessage());
            }
            throw new IllegalStateException(sb.toString());
        }
    }
}

