/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.validate;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import io.opencaesar.oml.dsl.OmlStandaloneSetup;
import io.opencaesar.oml.resource.OmlJsonResourceFactory;
import io.opencaesar.oml.resource.OmlXMIResourceFactory;
import io.opencaesar.oml.util.OmlCatalog;
import io.opencaesar.oml.validate.OmlValidator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.xml.DOMConfigurator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;

public class OmlValidateApp {
    @Parameter(names={"--input-catalog-path", "-i"}, description="Path of OML input catalog (Required)", validateWith={InputCatalogPath.class}, required=true, order=1)
    private String inputCatalogPath;
    @Parameter(names={"--output-result-path", "-o"}, description="Path of output report file (Optional)", order=2)
    private String outputReportPath;
    @Parameter(names={"-debug", "--d"}, description="Shows debug logging statements", order=3)
    private boolean debug;
    @Parameter(names={"--help", "-h"}, description="Displays summary of options", help=true, order=4)
    private boolean help;
    @Parameter(names={"--version", "-v"}, description="Displays app version", help=true, order=5)
    private boolean version;
    private Logger LOGGER = LogManager.getLogger(OmlValidateApp.class);

    public static void main(String ... args) throws Exception {
        OmlValidateApp app = new OmlValidateApp();
        JCommander builder = JCommander.newBuilder().addObject((Object)app).build();
        builder.parse(args);
        if (app.version) {
            System.out.println(app.getAppVersion());
            return;
        }
        if (app.help) {
            builder.usage();
            return;
        }
        DOMConfigurator.configure((URL)ClassLoader.getSystemClassLoader().getResource("log4j.xml"));
        if (app.debug) {
            Appender appender = LogManager.getRootLogger().getAppender("stdout");
            ((AppenderSkeleton)appender).setThreshold((Priority)Level.DEBUG);
        }
        app.run();
    }

    public void run() throws Exception {
        File reportFile;
        this.LOGGER.info((Object)"=================================================================");
        this.LOGGER.info((Object)"                        S T A R T");
        this.LOGGER.info((Object)("                    OML Validate " + this.getAppVersion()));
        this.LOGGER.info((Object)"=================================================================");
        this.LOGGER.info((Object)("Input Catalog = " + this.inputCatalogPath));
        this.LOGGER.info((Object)("Output Report = " + this.outputReportPath));
        OmlStandaloneSetup.doSetup();
        OmlXMIResourceFactory.register();
        OmlJsonResourceFactory.register();
        ResourceSetImpl inputResourceSet = new ResourceSetImpl();
        inputResourceSet.eAdapters().add((Object)new ECrossReferenceAdapter());
        OmlCatalog inputCatalog = OmlCatalog.create((URI)URI.createFileURI((String)this.inputCatalogPath));
        StringBuffer problems = new StringBuffer();
        for (File file : OmlValidateApp.collectOmlFiles(inputCatalog)) {
            URI uri = URI.createFileURI((String)file.getAbsolutePath());
            Resource r = inputResourceSet.getResource(uri, true);
            String results = OmlValidator.validate(r);
            if (results.length() <= 0) continue;
            if (problems.length() > 0) {
                problems.append("\n\n");
            }
            problems.append(results);
        }
        if (problems.length() > 0) {
            if (this.outputReportPath != null) {
                Files.write(Paths.get(this.outputReportPath, new String[0]), problems.toString().getBytes(), new OpenOption[0]);
                throw new IllegalStateException("Problems validating OML catalog: check '" + this.outputReportPath + "' for details.");
            }
            throw new IllegalStateException("Problems validating OML catalog:\n" + problems);
        }
        if (this.outputReportPath != null && (reportFile = new File(this.outputReportPath)).exists()) {
            reportFile.delete();
        }
        this.LOGGER.info((Object)"=================================================================");
        this.LOGGER.info((Object)"                          E N D");
        this.LOGGER.info((Object)"=================================================================");
    }

    public static List<File> collectOmlFiles(OmlCatalog catalog) throws IOException {
        return catalog.getResolvedUris().stream().map(i -> new File(i.toFileString())).collect(Collectors.toList());
    }

    private String getAppVersion() {
        String version = this.getClass().getPackage().getImplementationVersion();
        return version != null ? version : "<SNAPSHOT>";
    }

    public static class InputCatalogPath
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            File file = new File(value);
            if (!file.exists() || !file.getName().endsWith("catalog.xml")) {
                throw new ParameterException("Parameter " + name + " should be a valid OML catalog path");
            }
        }
    }
}

