/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.validate;

import io.opencaesar.oml.Member;
import io.opencaesar.oml.Ontology;
import io.opencaesar.oml.util.OmlRead;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;

public class OmlValidator {
    public static String validate(Ontology ontology) {
        Diagnostician diagnostician = new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                if (eObject == null) {
                    return "null";
                }
                String type = eObject.eClass().getName();
                String name = this.getName(eObject);
                return type + (String)(name.length() > 0 ? " " + name : "");
            }

            private String getName(EObject eObject) {
                if (eObject instanceof Member) {
                    return ((Member)eObject).getAbbreviatedIri();
                }
                if (eObject instanceof Ontology) {
                    return ((Ontology)eObject).getNamespace();
                }
                EReference eRef = eObject.eContainmentFeature();
                int index = -1;
                if (eRef.isMany()) {
                    index = ((List)eObject.eContainer().eGet((EStructuralFeature)eRef)).indexOf(eObject);
                }
                return this.getName(eObject.eContainer()) + "/" + eRef.getName() + (String)(index != -1 ? "[" + index + "]" : "");
            }
        };
        String problems = "";
        Diagnostic diagnostic = diagnostician.validate((EObject)ontology);
        if (diagnostic.getSeverity() == 4) {
            StringBuilder sb = new StringBuilder(diagnostic.getMessage());
            for (Diagnostic child : diagnostic.getChildren()) {
                if (child.getSeverity() != 4) continue;
                sb.append(System.lineSeparator());
                sb.append("\t" + child.getMessage());
            }
            problems = sb.toString();
        }
        return problems;
    }

    public static String validate(Resource resource) {
        StringBuilder sb = new StringBuilder();
        if (!resource.getErrors().isEmpty()) {
            sb.append("Diagnosis of resource " + resource.getURI());
            for (Resource.Diagnostic diagnostic : resource.getErrors()) {
                sb.append(System.lineSeparator());
                sb.append("\t[" + diagnostic.getLine() + ", " + diagnostic.getColumn() + "]: " + diagnostic.getMessage());
            }
        } else {
            String problems;
            Ontology ontology = OmlRead.getOntology((Resource)resource);
            if (ontology != null && (problems = OmlValidator.validate(ontology)).length() > 0) {
                sb.append(problems);
            }
        }
        return sb.toString();
    }
}

