/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.dsl.formatting2;

import com.google.inject.Inject;
import io.opencaesar.oml.Annotation;
import io.opencaesar.oml.AnnotationProperty;
import io.opencaesar.oml.Aspect;
import io.opencaesar.oml.BuiltIn;
import io.opencaesar.oml.BuiltInPredicate;
import io.opencaesar.oml.ClassifierEquivalenceAxiom;
import io.opencaesar.oml.Concept;
import io.opencaesar.oml.ConceptInstance;
import io.opencaesar.oml.Description;
import io.opencaesar.oml.DescriptionBundle;
import io.opencaesar.oml.DescriptionStatement;
import io.opencaesar.oml.DifferentFromPredicate;
import io.opencaesar.oml.Element;
import io.opencaesar.oml.ForwardRelation;
import io.opencaesar.oml.Import;
import io.opencaesar.oml.InstanceEnumerationAxiom;
import io.opencaesar.oml.KeyAxiom;
import io.opencaesar.oml.Literal;
import io.opencaesar.oml.LiteralEnumerationAxiom;
import io.opencaesar.oml.OmlPackage;
import io.opencaesar.oml.Predicate;
import io.opencaesar.oml.PropertyCardinalityRestrictionAxiom;
import io.opencaesar.oml.PropertyPredicate;
import io.opencaesar.oml.PropertyRangeRestrictionAxiom;
import io.opencaesar.oml.PropertyRestrictionAxiom;
import io.opencaesar.oml.PropertySelfRestrictionAxiom;
import io.opencaesar.oml.PropertyValueAssertion;
import io.opencaesar.oml.PropertyValueRestrictionAxiom;
import io.opencaesar.oml.QuotedLiteral;
import io.opencaesar.oml.Relation;
import io.opencaesar.oml.RelationEntity;
import io.opencaesar.oml.RelationEntityPredicate;
import io.opencaesar.oml.RelationInstance;
import io.opencaesar.oml.ReverseRelation;
import io.opencaesar.oml.Rule;
import io.opencaesar.oml.SameAsPredicate;
import io.opencaesar.oml.Scalar;
import io.opencaesar.oml.ScalarEquivalenceAxiom;
import io.opencaesar.oml.ScalarProperty;
import io.opencaesar.oml.Structure;
import io.opencaesar.oml.StructureInstance;
import io.opencaesar.oml.StructuredProperty;
import io.opencaesar.oml.TypePredicate;
import io.opencaesar.oml.UnreifiedRelation;
import io.opencaesar.oml.Vocabulary;
import io.opencaesar.oml.VocabularyBundle;
import io.opencaesar.oml.VocabularyStatement;
import io.opencaesar.oml.dsl.services.OmlGrammarAccess;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.formatting.IIndentationInformation;
import org.eclipse.xtext.formatting2.AbstractJavaFormatter;
import org.eclipse.xtext.formatting2.FormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.preferences.TypedPreferenceKey;
import org.eclipse.xtext.xbase.lib.Procedures;

public class OmlFormatter
extends AbstractJavaFormatter {
    @Inject
    protected OmlGrammarAccess oml;
    @Inject
    protected IIndentationInformation indent;
    private List<Method> formatMethods;

    protected void initialize(FormatterRequest request) {
        ITypedPreferenceValues preferences = request.getPreferences();
        if (preferences instanceof MapBasedPreferenceValues) {
            ((MapBasedPreferenceValues)preferences).put((TypedPreferenceKey)FormatterPreferenceKeys.indentation, (Object)this.indent.getIndentString());
        }
        super.initialize(request);
    }

    protected void _format(Annotation annotation, IFormattableDocument doc) {
        doc.append(this.keyword((EObject)annotation, this.oml.getAnnotationAccess().getCommercialAtKeyword_0()), this.noSpace());
        this.IfTrue(annotation.getValue() instanceof Literal, () -> doc.prepend((EObject)((Element)doc.format((Object)annotation.getValue())), this.oneSpace()));
    }

    protected void _format(Vocabulary vocabulary, IFormattableDocument doc) {
        doc.prepend((EObject)vocabulary, this.compose(this.setNewLines(0, 0, 0), this.noSpace()));
        vocabulary.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        doc.append(this.keyword((EObject)vocabulary, this.oml.getVocabularyAccess().getVocabularyKeyword_1()), this.oneSpace());
        doc.surround(this.keyword((EObject)vocabulary, this.oml.getVocabularyAccess().getAsKeyword_3()), this.oneSpace());
        this.formatBraces((EObject)vocabulary, doc);
        vocabulary.getOwnedImports().forEach(i -> doc.prepend((EObject)((Import)doc.format(i)), this.newLines(2)));
        vocabulary.getOwnedStatements().forEach(i -> doc.prepend((EObject)((VocabularyStatement)doc.format(i)), this.newLines(2)));
    }

    protected void _format(VocabularyBundle bundle, IFormattableDocument doc) {
        doc.prepend((EObject)bundle, this.compose(this.setNewLines(0, 0, 0), this.noSpace()));
        bundle.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        doc.append(this.keyword((EObject)bundle, this.oml.getVocabularyBundleAccess().getVocabularyKeyword_1()), this.oneSpace());
        doc.surround(this.keyword((EObject)bundle, this.oml.getVocabularyBundleAccess().getBundleKeyword_2()), this.oneSpace());
        doc.surround(this.keyword((EObject)bundle, this.oml.getVocabularyBundleAccess().getAsKeyword_4()), this.oneSpace());
        this.formatBraces((EObject)bundle, doc);
        bundle.getOwnedImports().forEach(i -> doc.prepend((EObject)((Import)doc.format(i)), this.newLines(2)));
    }

    protected void _format(Description description, IFormattableDocument doc) {
        doc.prepend((EObject)description, this.compose(this.setNewLines(0, 0, 0), this.noSpace()));
        description.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        doc.append(this.keyword((EObject)description, this.oml.getDescriptionAccess().getDescriptionKeyword_1()), this.oneSpace());
        doc.surround(this.keyword((EObject)description, this.oml.getDescriptionAccess().getAsKeyword_3()), this.oneSpace());
        this.formatBraces((EObject)description, doc);
        description.getOwnedImports().forEach(i -> doc.prepend((EObject)((Import)doc.format(i)), this.newLines(2)));
        description.getOwnedStatements().forEach(i -> doc.prepend((EObject)((DescriptionStatement)doc.format(i)), this.newLines(2)));
    }

    protected void _format(DescriptionBundle bundle, IFormattableDocument doc) {
        doc.prepend((EObject)bundle, this.compose(this.setNewLines(0, 0, 0), this.noSpace()));
        bundle.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        doc.append(this.keyword((EObject)bundle, this.oml.getDescriptionBundleAccess().getDescriptionKeyword_1()), this.oneSpace());
        doc.surround(this.keyword((EObject)bundle, this.oml.getDescriptionBundleAccess().getBundleKeyword_2()), this.oneSpace());
        doc.surround(this.keyword((EObject)bundle, this.oml.getDescriptionBundleAccess().getAsKeyword_4()), this.oneSpace());
        this.formatBraces((EObject)bundle, doc);
        bundle.getOwnedImports().forEach(i -> doc.prepend((EObject)((Import)doc.format(i)), this.newLines(2)));
    }

    protected void _format(Aspect aspect, IFormattableDocument doc) {
        aspect.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        if (aspect.getName() != null) {
            doc.append(this.keyword((EObject)aspect, this.oml.getAspectAccess().getAspectKeyword_1_0_0()), this.oneSpace());
        } else if (aspect.isRef()) {
            doc.append(this.keyword((EObject)aspect, this.oml.getAspectAccess().getRefKeyword_1_1_0()), this.oneSpace());
            doc.append(this.keyword((EObject)aspect, this.oml.getAspectAccess().getAspectKeyword_1_1_1()), this.oneSpace());
        }
        this.formatBrackets((EObject)aspect, doc, this.oml.getAspectAccess().getLeftSquareBracketKeyword_2_0(), this.oml.getAspectAccess().getRightSquareBracketKeyword_2_2());
        aspect.getOwnedKeys().forEach(i -> doc.prepend((EObject)((KeyAxiom)doc.format(i)), this.newLine()));
        doc.surround(this.keyword((EObject)aspect, this.oml.getClassifierSpecializationAccess().getLessThanSignKeyword_0()), this.oneSpace());
        this.formatCommas((EObject)aspect, doc);
        this.formatBrackets((EObject)aspect, doc, this.oml.getClassifierSpecializationAccess().getLeftSquareBracketKeyword_1_1_1(), this.oml.getClassifierSpecializationAccess().getRightSquareBracketKeyword_1_1_3());
        aspect.getOwnedPropertyRestrictions().forEach(i -> doc.prepend((EObject)((PropertyRestrictionAxiom)doc.format(i)), this.newLine()));
        doc.surround(this.keyword((EObject)aspect, this.oml.getClassifierEquivalenceAccess().getEqualsSignKeyword_0()), this.oneSpace());
        aspect.getOwnedEquivalences().forEach(i -> doc.prepend((EObject)((ClassifierEquivalenceAxiom)doc.format(i)), this.oneSpace()));
    }

    protected void _format(Concept concept, IFormattableDocument doc) {
        concept.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        if (concept.getName() != null) {
            doc.append(this.keyword((EObject)concept, this.oml.getConceptAccess().getConceptKeyword_1_0_0()), this.oneSpace());
        } else if (concept.isRef()) {
            doc.append(this.keyword((EObject)concept, this.oml.getConceptAccess().getRefKeyword_1_1_0()), this.oneSpace());
            doc.append(this.keyword((EObject)concept, this.oml.getConceptAccess().getConceptKeyword_1_1_1()), this.oneSpace());
        }
        this.formatBrackets((EObject)concept, doc, this.oml.getConceptAccess().getLeftSquareBracketKeyword_2_0(), this.oml.getConceptAccess().getRightSquareBracketKeyword_2_3());
        this.ifNotNull(concept.getOwnedEnumeration(), i -> doc.prepend((EObject)((InstanceEnumerationAxiom)doc.format(i)), this.newLine()));
        concept.getOwnedKeys().forEach(i -> doc.prepend((EObject)((KeyAxiom)doc.format(i)), this.newLine()));
        doc.surround(this.keyword((EObject)concept, this.oml.getClassifierSpecializationAccess().getLessThanSignKeyword_0()), this.oneSpace());
        this.formatCommas((EObject)concept, doc);
        this.formatBrackets((EObject)concept, doc, this.oml.getClassifierSpecializationAccess().getLeftSquareBracketKeyword_1_1_1(), this.oml.getClassifierSpecializationAccess().getRightSquareBracketKeyword_1_1_3());
        concept.getOwnedPropertyRestrictions().forEach(i -> doc.prepend((EObject)((PropertyRestrictionAxiom)doc.format(i)), this.newLine()));
        doc.surround(this.keyword((EObject)concept, this.oml.getClassifierEquivalenceAccess().getEqualsSignKeyword_0()), this.oneSpace());
        concept.getOwnedEquivalences().forEach(i -> doc.prepend((EObject)((ClassifierEquivalenceAxiom)doc.format(i)), this.oneSpace()));
    }

    protected void _format(RelationEntity entity, IFormattableDocument doc) {
        entity.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        if (entity.getName() != null) {
            doc.append(this.keyword((EObject)entity, this.oml.getRelationEntityAccess().getRelationKeyword_1_0_0()), this.oneSpace());
            doc.append(this.keyword((EObject)entity, this.oml.getRelationEntityAccess().getEntityKeyword_1_0_1()), this.oneSpace());
        } else if (entity.isRef()) {
            doc.append(this.keyword((EObject)entity, this.oml.getRelationEntityAccess().getRefKeyword_1_1_0()), this.oneSpace());
            doc.append(this.keyword((EObject)entity, this.oml.getRelationEntityAccess().getRelationKeyword_1_1_1()), this.oneSpace());
            doc.append(this.keyword((EObject)entity, this.oml.getRelationEntityAccess().getEntityKeyword_1_1_2()), this.oneSpace());
        }
        this.formatBrackets((EObject)entity, doc, this.oml.getRelationEntityAccess().getLeftSquareBracketKeyword_2_0(), this.oml.getRelationEntityAccess().getRightSquareBracketKeyword_2_7());
        doc.append(doc.prepend(this.keyword((EObject)entity, this.oml.getRelationEntityAccess().getFromKeyword_2_1_0()), this.newLine()), this.oneSpace());
        doc.append(doc.prepend(this.keyword((EObject)entity, this.oml.getRelationEntityAccess().getToKeyword_2_2_0()), this.newLine()), this.oneSpace());
        this.ifNotNull(entity.getForwardRelation(), i -> doc.prepend((EObject)((ForwardRelation)doc.format(i)), this.newLine()));
        this.ifNotNull(entity.getReverseRelation(), i -> doc.prepend((EObject)((ReverseRelation)doc.format(i)), this.newLine()));
        doc.prepend(this.keyword((EObject)entity, this.oml.getRelationEntityAccess().getFunctionalFunctionalKeyword_2_5_0_0()), this.newLine());
        doc.prepend(this.keyword((EObject)entity, this.oml.getRelationEntityAccess().getInverseFunctionalInverseKeyword_2_5_1_0_0()), this.newLine());
        doc.prepend(this.keyword((EObject)entity, this.oml.getRelationEntityAccess().getSymmetricSymmetricKeyword_2_5_2_0()), this.newLine());
        doc.prepend(this.keyword((EObject)entity, this.oml.getRelationEntityAccess().getAsymmetricAsymmetricKeyword_2_5_3_0()), this.newLine());
        doc.prepend(this.keyword((EObject)entity, this.oml.getRelationEntityAccess().getReflexiveReflexiveKeyword_2_5_4_0()), this.newLine());
        doc.prepend(this.keyword((EObject)entity, this.oml.getRelationEntityAccess().getIrreflexiveIrreflexiveKeyword_2_5_5_0()), this.newLine());
        doc.prepend(this.keyword((EObject)entity, this.oml.getRelationEntityAccess().getTransitiveTransitiveKeyword_2_5_6_0()), this.newLine());
        entity.getOwnedKeys().forEach(i -> doc.prepend((EObject)((KeyAxiom)doc.format(i)), this.newLine()));
        doc.surround(this.keyword((EObject)entity, this.oml.getClassifierSpecializationAccess().getLessThanSignKeyword_0()), this.oneSpace());
        this.formatCommas((EObject)entity, doc);
        this.formatBrackets((EObject)entity, doc, this.oml.getClassifierSpecializationAccess().getLeftSquareBracketKeyword_1_1_1(), this.oml.getClassifierSpecializationAccess().getRightSquareBracketKeyword_1_1_3());
        entity.getOwnedPropertyRestrictions().forEach(i -> doc.prepend((EObject)((PropertyRestrictionAxiom)doc.format(i)), this.newLine()));
        doc.surround(this.keyword((EObject)entity, this.oml.getClassifierEquivalenceAccess().getEqualsSignKeyword_0()), this.oneSpace());
        entity.getOwnedEquivalences().forEach(i -> doc.prepend((EObject)((ClassifierEquivalenceAxiom)doc.format(i)), this.oneSpace()));
    }

    protected void _format(Structure structure, IFormattableDocument doc) {
        structure.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        if (structure.getName() != null) {
            doc.append(this.keyword((EObject)structure, this.oml.getStructureAccess().getStructureKeyword_1_0_0()), this.oneSpace());
        } else if (structure.isRef()) {
            doc.append(this.keyword((EObject)structure, this.oml.getStructureAccess().getRefKeyword_1_1_0()), this.oneSpace());
            doc.append(this.keyword((EObject)structure, this.oml.getStructureAccess().getStructureKeyword_1_1_1()), this.oneSpace());
        }
        doc.surround(this.keyword((EObject)structure, this.oml.getClassifierSpecializationAccess().getLessThanSignKeyword_0()), this.oneSpace());
        this.formatCommas((EObject)structure, doc);
        this.formatBrackets((EObject)structure, doc);
        structure.getOwnedPropertyRestrictions().forEach(i -> doc.prepend((EObject)((PropertyRestrictionAxiom)doc.format(i)), this.newLine()));
        doc.surround(this.keyword((EObject)structure, this.oml.getClassifierEquivalenceAccess().getEqualsSignKeyword_0()), this.oneSpace());
        structure.getOwnedEquivalences().forEach(i -> doc.prepend((EObject)((ClassifierEquivalenceAxiom)doc.format(i)), this.oneSpace()));
    }

    protected void _format(ClassifierEquivalenceAxiom axiom, IFormattableDocument doc) {
        this.formatAmpersands((EObject)axiom, doc);
        this.formatBrackets((EObject)axiom, doc);
        axiom.getOwnedPropertyRestrictions().forEach(i -> doc.prepend((EObject)((PropertyRestrictionAxiom)doc.format(i)), this.newLine()));
    }

    protected void _format(AnnotationProperty property, IFormattableDocument doc) {
        property.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        if (property.getName() != null) {
            doc.append(this.keyword((EObject)property, this.oml.getAnnotationPropertyAccess().getAnnotationKeyword_1_0_0()), this.oneSpace());
            doc.append(this.keyword((EObject)property, this.oml.getAnnotationPropertyAccess().getPropertyKeyword_1_0_1()), this.oneSpace());
        } else if (property.isRef()) {
            doc.append(this.keyword((EObject)property, this.oml.getAnnotationPropertyAccess().getRefKeyword_1_1_0()), this.oneSpace());
            doc.append(this.keyword((EObject)property, this.oml.getAnnotationPropertyAccess().getAnnotationKeyword_1_1_1()), this.oneSpace());
            doc.append(this.keyword((EObject)property, this.oml.getAnnotationPropertyAccess().getPropertyKeyword_1_1_2()), this.oneSpace());
        }
        doc.surround(this.keyword((EObject)property, this.oml.getPropertySpecializationAccess().getLessThanSignKeyword_0()), this.oneSpace());
        doc.surround(this.keyword((EObject)property, this.oml.getPropertyEquivalenceAccess().getEqualsSignKeyword_0()), this.oneSpace());
        this.formatCommas((EObject)property, doc);
    }

    protected void _format(ScalarProperty property, IFormattableDocument doc) {
        property.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        if (property.getName() != null) {
            doc.append(this.keyword((EObject)property, this.oml.getScalarPropertyAccess().getScalarKeyword_1_0_0()), this.oneSpace());
            doc.append(this.keyword((EObject)property, this.oml.getScalarPropertyAccess().getPropertyKeyword_1_0_1()), this.oneSpace());
        } else if (property.isRef()) {
            doc.append(this.keyword((EObject)property, this.oml.getScalarPropertyAccess().getRefKeyword_1_1_0()), this.oneSpace());
            doc.append(this.keyword((EObject)property, this.oml.getScalarPropertyAccess().getScalarKeyword_1_1_1()), this.oneSpace());
            doc.append(this.keyword((EObject)property, this.oml.getScalarPropertyAccess().getPropertyKeyword_1_1_2()), this.oneSpace());
        }
        this.formatBrackets((EObject)property, doc);
        doc.prepend(this.keyword((EObject)property, this.oml.getScalarPropertyAccess().getDomainKeyword_2_1_0()), this.newLine());
        doc.prepend(this.keyword((EObject)property, this.oml.getScalarPropertyAccess().getRangeKeyword_2_2_0()), this.newLine());
        doc.prepend(this.keyword((EObject)property, this.oml.getScalarPropertyAccess().getFunctionalFunctionalKeyword_2_3_0()), this.newLine());
        doc.surround(this.keyword((EObject)property, this.oml.getPropertySpecializationAccess().getLessThanSignKeyword_0()), this.oneSpace());
        doc.surround(this.keyword((EObject)property, this.oml.getPropertyEquivalenceAccess().getEqualsSignKeyword_0()), this.oneSpace());
        this.formatCommas((EObject)property, doc);
    }

    protected void _format(StructuredProperty property, IFormattableDocument doc) {
        property.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        if (property.getName() != null) {
            doc.append(this.keyword((EObject)property, this.oml.getStructuredPropertyAccess().getStructuredKeyword_1_0_0()), this.oneSpace());
            doc.append(this.keyword((EObject)property, this.oml.getStructuredPropertyAccess().getPropertyKeyword_1_0_1()), this.oneSpace());
        } else if (property.isRef()) {
            doc.append(this.keyword((EObject)property, this.oml.getStructuredPropertyAccess().getRefKeyword_1_1_0()), this.oneSpace());
            doc.append(this.keyword((EObject)property, this.oml.getStructuredPropertyAccess().getStructuredKeyword_1_1_1()), this.oneSpace());
            doc.append(this.keyword((EObject)property, this.oml.getStructuredPropertyAccess().getPropertyKeyword_1_1_2()), this.oneSpace());
        }
        this.formatBrackets((EObject)property, doc);
        doc.prepend(this.keyword((EObject)property, this.oml.getStructuredPropertyAccess().getDomainKeyword_2_1_0()), this.newLine());
        doc.prepend(this.keyword((EObject)property, this.oml.getStructuredPropertyAccess().getRangeKeyword_2_2_0()), this.newLine());
        doc.prepend(this.keyword((EObject)property, this.oml.getStructuredPropertyAccess().getFunctionalFunctionalKeyword_2_3_0()), this.newLine());
        doc.surround(this.keyword((EObject)property, this.oml.getPropertySpecializationAccess().getLessThanSignKeyword_0()), this.oneSpace());
        doc.surround(this.keyword((EObject)property, this.oml.getPropertyEquivalenceAccess().getEqualsSignKeyword_0()), this.oneSpace());
        this.formatCommas((EObject)property, doc);
    }

    protected void _format(Scalar scalar, IFormattableDocument doc) {
        scalar.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        if (scalar.getName() != null) {
            doc.append(this.keyword((EObject)scalar, this.oml.getScalarAccess().getScalarKeyword_1_0_0()), this.oneSpace());
        } else if (scalar.isRef()) {
            doc.append(this.keyword((EObject)scalar, this.oml.getScalarAccess().getRefKeyword_1_1_0()), this.oneSpace());
            doc.append(this.keyword((EObject)scalar, this.oml.getScalarAccess().getScalarKeyword_1_1_1()), this.oneSpace());
        }
        this.formatBrackets((EObject)scalar, doc);
        this.ifNotNull(scalar.getOwnedEnumeration(), i -> doc.prepend((EObject)((LiteralEnumerationAxiom)doc.format(i)), this.newLine()));
        doc.surround(this.keyword((EObject)scalar, this.oml.getScalarSpecializationAccess().getLessThanSignKeyword_0()), this.oneSpace());
        this.formatCommas((EObject)scalar, doc);
    }

    protected void _format(ScalarEquivalenceAxiom axiom, IFormattableDocument doc) {
        this.formatBrackets((EObject)axiom, doc);
        doc.prepend(this.keyword((EObject)axiom, this.oml.getScalarEquivalenceAxiomAccess().getLengthKeyword_1_1_0_0()), this.newLine());
        doc.prepend(this.keyword((EObject)axiom, this.oml.getScalarEquivalenceAxiomAccess().getMinLengthKeyword_1_1_1_0()), this.newLine());
        doc.prepend(this.keyword((EObject)axiom, this.oml.getScalarEquivalenceAxiomAccess().getMaxLengthKeyword_1_1_2_0()), this.newLine());
        doc.prepend(this.keyword((EObject)axiom, this.oml.getScalarEquivalenceAxiomAccess().getPatternKeyword_1_1_3_0()), this.newLine());
        doc.prepend(this.keyword((EObject)axiom, this.oml.getScalarEquivalenceAxiomAccess().getLanguageKeyword_1_1_4_0()), this.newLine());
        doc.prepend(this.keyword((EObject)axiom, this.oml.getScalarEquivalenceAxiomAccess().getMinInclusiveKeyword_1_1_5_0()), this.newLine());
        this.ifNotNull(axiom.getMinInclusive(), i -> doc.prepend((EObject)((Literal)doc.format(i)), this.oneSpace()));
        doc.prepend(this.keyword((EObject)axiom, this.oml.getScalarEquivalenceAxiomAccess().getMaxInclusiveKeyword_1_1_7_0()), this.newLine());
        this.ifNotNull(axiom.getMaxInclusive(), i -> doc.prepend((EObject)((Literal)doc.format(i)), this.oneSpace()));
        doc.prepend(this.keyword((EObject)axiom, this.oml.getScalarEquivalenceAxiomAccess().getMinExclusiveKeyword_1_1_6_0()), this.newLine());
        this.ifNotNull(axiom.getMinExclusive(), i -> doc.prepend((EObject)((Literal)doc.format(i)), this.oneSpace()));
        doc.prepend(this.keyword((EObject)axiom, this.oml.getScalarEquivalenceAxiomAccess().getMaxExclusiveKeyword_1_1_8_0()), this.newLine());
        this.ifNotNull(axiom.getMaxExclusive(), i -> doc.prepend((EObject)((Literal)doc.format(i)), this.oneSpace()));
    }

    protected void _format(ForwardRelation relation, IFormattableDocument doc) {
        relation.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        doc.append(this.keyword((EObject)relation, this.oml.getForwardRelationAccess().getForwardKeyword_1()), this.oneSpace());
    }

    protected void _format(ReverseRelation relation, IFormattableDocument doc) {
        relation.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        doc.append(this.keyword((EObject)relation, this.oml.getReverseRelationAccess().getReverseKeyword_1()), this.oneSpace());
    }

    protected void _format(UnreifiedRelation relation, IFormattableDocument doc) {
        relation.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        if (relation.getName() != null) {
            doc.append(this.keyword((EObject)relation, this.oml.getUnreifiedRelationAccess().getRelationKeyword_1_0_0()), this.oneSpace());
        } else if (relation.isRef()) {
            doc.append(this.keyword((EObject)relation, this.oml.getUnreifiedRelationAccess().getRefKeyword_1_1_0()), this.oneSpace());
            doc.append(this.keyword((EObject)relation, this.oml.getUnreifiedRelationAccess().getRelationKeyword_1_1_1()), this.oneSpace());
        }
        this.formatBrackets((EObject)relation, doc);
        doc.append(doc.prepend(this.keyword((EObject)relation, this.oml.getUnreifiedRelationAccess().getFromKeyword_2_1_0()), this.newLine()), this.oneSpace());
        doc.append(doc.prepend(this.keyword((EObject)relation, this.oml.getUnreifiedRelationAccess().getToKeyword_2_2_0()), this.newLine()), this.oneSpace());
        this.ifNotNull(relation.getReverseRelation(), i -> doc.prepend((EObject)((ReverseRelation)doc.format(i)), this.newLine()));
        doc.prepend(this.keyword((EObject)relation, this.oml.getUnreifiedRelationAccess().getFunctionalFunctionalKeyword_2_4_0_0()), this.newLine());
        doc.prepend(this.keyword((EObject)relation, this.oml.getUnreifiedRelationAccess().getInverseFunctionalInverseKeyword_2_4_1_0_0()), this.newLine());
        doc.prepend(this.keyword((EObject)relation, this.oml.getUnreifiedRelationAccess().getSymmetricSymmetricKeyword_2_4_2_0()), this.newLine());
        doc.prepend(this.keyword((EObject)relation, this.oml.getUnreifiedRelationAccess().getAsymmetricAsymmetricKeyword_2_4_3_0()), this.newLine());
        doc.prepend(this.keyword((EObject)relation, this.oml.getUnreifiedRelationAccess().getReflexiveReflexiveKeyword_2_4_4_0()), this.newLine());
        doc.prepend(this.keyword((EObject)relation, this.oml.getUnreifiedRelationAccess().getIrreflexiveIrreflexiveKeyword_2_4_5_0()), this.newLine());
        doc.prepend(this.keyword((EObject)relation, this.oml.getUnreifiedRelationAccess().getTransitiveTransitiveKeyword_2_4_6_0()), this.newLine());
        doc.surround(this.keyword((EObject)relation, this.oml.getPropertySpecializationAccess().getLessThanSignKeyword_0()), this.oneSpace());
        doc.surround(this.keyword((EObject)relation, this.oml.getPropertyEquivalenceAccess().getEqualsSignKeyword_0()), this.oneSpace());
        this.formatCommas((EObject)relation, doc);
    }

    protected void _format(Rule rule, IFormattableDocument doc) {
        rule.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        if (rule.getName() != null) {
            doc.append(this.keyword((EObject)rule, this.oml.getRuleAccess().getRuleKeyword_1_0_0()), this.oneSpace());
        } else if (rule.isRef()) {
            doc.append(this.keyword((EObject)rule, this.oml.getRuleAccess().getRefKeyword_1_1_0()), this.oneSpace());
            doc.append(this.keyword((EObject)rule, this.oml.getRuleAccess().getRuleKeyword_1_1_1()), this.oneSpace());
        }
        this.formatBrackets((EObject)rule, doc);
        this.ifNotEmpty((List)rule.getAntecedent(), (Procedures.Procedure1)i -> doc.prepend((EObject)((Predicate)doc.format((Object)((Predicate)i.get(0)))), this.newLine()));
        this.keywords((EObject)rule, "&").forEach(i -> doc.surround(i, this.oneSpace()));
        rule.getAntecedent().forEach(i -> doc.format(i));
        doc.surround(this.keyword((EObject)rule, this.oml.getRuleAccess().getHyphenMinusGreaterThanSignKeyword_2_1_2()), this.oneSpace());
        rule.getConsequent().forEach(i -> doc.format(i));
    }

    protected void _format(BuiltIn builtIn, IFormattableDocument doc) {
        builtIn.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        if (builtIn.getName() != null) {
            doc.append(this.keyword((EObject)builtIn, this.oml.getBuiltInAccess().getBuiltinKeyword_1_0_0()), this.oneSpace());
        } else if (builtIn.isRef()) {
            doc.append(this.keyword((EObject)builtIn, this.oml.getBuiltInAccess().getRefKeyword_1_1_0()), this.oneSpace());
            doc.append(this.keyword((EObject)builtIn, this.oml.getBuiltInAccess().getBuiltinKeyword_1_1_1()), this.oneSpace());
        }
    }

    protected void _format(ConceptInstance instance, IFormattableDocument doc) {
        instance.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        if (instance.getName() != null) {
            doc.append(this.keyword((EObject)instance, this.oml.getConceptInstanceAccess().getInstanceKeyword_1_0_0()), this.oneSpace());
        } else if (instance.isRef()) {
            doc.append(this.keyword((EObject)instance, this.oml.getConceptInstanceAccess().getRefKeyword_1_1_0()), this.oneSpace());
            doc.append(this.keyword((EObject)instance, this.oml.getConceptInstanceAccess().getInstanceKeyword_1_1_1()), this.oneSpace());
        }
        doc.surround(this.keyword((EObject)instance, this.oml.getConceptInstanceAccess().getColonKeyword_2_0()), this.oneSpace());
        this.formatCommas((EObject)instance, doc);
        this.formatBrackets((EObject)instance, doc);
        instance.getOwnedPropertyValues().forEach(i -> doc.prepend((EObject)((PropertyValueAssertion)doc.format(i)), this.newLine()));
    }

    protected void _format(RelationInstance instance, IFormattableDocument doc) {
        instance.getOwnedAnnotations().forEach(i -> doc.append((EObject)((Annotation)doc.format(i)), this.newLine()));
        if (instance.getName() != null) {
            doc.append(this.keyword((EObject)instance, this.oml.getRelationInstanceAccess().getRelationKeyword_1_0_0()), this.oneSpace());
            doc.append(this.keyword((EObject)instance, this.oml.getRelationInstanceAccess().getInstanceKeyword_1_0_1()), this.oneSpace());
        } else if (instance.isRef()) {
            doc.append(this.keyword((EObject)instance, this.oml.getRelationInstanceAccess().getRefKeyword_1_1_0()), this.oneSpace());
            doc.append(this.keyword((EObject)instance, this.oml.getRelationInstanceAccess().getRelationKeyword_1_1_1()), this.oneSpace());
            doc.append(this.keyword((EObject)instance, this.oml.getRelationInstanceAccess().getInstanceKeyword_1_1_2()), this.oneSpace());
        }
        doc.surround(this.keyword((EObject)instance, this.oml.getRelationInstanceAccess().getColonKeyword_2_0()), this.oneSpace());
        this.formatCommas((EObject)instance, doc);
        this.formatBrackets((EObject)instance, doc);
        doc.append(doc.prepend(this.keyword((EObject)instance, this.oml.getRelationInstanceAccess().getFromKeyword_3_1_0()), this.newLine()), this.oneSpace());
        doc.append(doc.prepend(this.keyword((EObject)instance, this.oml.getRelationInstanceAccess().getToKeyword_3_2_0()), this.newLine()), this.oneSpace());
        instance.getOwnedPropertyValues().forEach(i -> doc.prepend((EObject)((PropertyValueAssertion)doc.format(i)), this.newLine()));
    }

    protected void _format(StructureInstance instance, IFormattableDocument doc) {
        this.formatBrackets((EObject)instance, doc);
        instance.getOwnedPropertyValues().forEach(i -> doc.prepend((EObject)((PropertyValueAssertion)doc.format(i)), this.newLine()));
    }

    protected void _format(Import import_, IFormattableDocument doc) {
        doc.surround(this.feature((EObject)import_, (EStructuralFeature)OmlPackage.Literals.IMPORT__KIND), this.oneSpace());
        doc.surround(this.keyword((EObject)import_, this.oml.getExtensionAccess().getAsKeyword_2_0()), this.oneSpace());
    }

    protected void _format(PropertyRangeRestrictionAxiom axiom, IFormattableDocument doc) {
        if (axiom.getProperty() instanceof ScalarProperty) {
            doc.append(this.keyword((EObject)axiom, this.oml.getScalarPropertyRangeRestrictionAxiomAccess().getRestrictsKeyword_0()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getScalarPropertyRangeRestrictionAxiomAccess().getScalarKeyword_2()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getScalarPropertyRangeRestrictionAxiomAccess().getPropertyKeyword_3()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getScalarPropertyRangeRestrictionAxiomAccess().getToKeyword_5()), this.oneSpace());
        } else if (axiom.getProperty() instanceof StructuredProperty) {
            doc.append(this.keyword((EObject)axiom, this.oml.getStructuredPropertyRangeRestrictionAxiomAccess().getRestrictsKeyword_0()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getStructuredPropertyRangeRestrictionAxiomAccess().getStructuredKeyword_2()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getStructuredPropertyRangeRestrictionAxiomAccess().getPropertyKeyword_3()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getStructuredPropertyRangeRestrictionAxiomAccess().getToKeyword_5()), this.oneSpace());
        } else if (axiom.getProperty() instanceof Relation) {
            doc.append(this.keyword((EObject)axiom, this.oml.getRelationRangeRestrictionAxiomAccess().getRestrictsKeyword_0()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getRelationRangeRestrictionAxiomAccess().getRelationKeyword_2()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getRelationRangeRestrictionAxiomAccess().getToKeyword_4()), this.oneSpace());
        }
    }

    protected void _format(PropertyCardinalityRestrictionAxiom axiom, IFormattableDocument doc) {
        if (axiom.getProperty() instanceof ScalarProperty) {
            doc.append(this.keyword((EObject)axiom, this.oml.getScalarPropertyCardinalityRestrictionAxiomAccess().getRestrictsKeyword_0()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getScalarPropertyCardinalityRestrictionAxiomAccess().getScalarKeyword_1()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getScalarPropertyCardinalityRestrictionAxiomAccess().getPropertyKeyword_2()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getScalarPropertyCardinalityRestrictionAxiomAccess().getToKeyword_4()), this.oneSpace());
        } else if (axiom.getProperty() instanceof StructuredProperty) {
            doc.append(this.keyword((EObject)axiom, this.oml.getStructuredPropertyCardinalityRestrictionAxiomAccess().getRestrictsKeyword_0()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getStructuredPropertyCardinalityRestrictionAxiomAccess().getStructuredKeyword_1()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getStructuredPropertyCardinalityRestrictionAxiomAccess().getPropertyKeyword_2()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getStructuredPropertyCardinalityRestrictionAxiomAccess().getToKeyword_4()), this.oneSpace());
        } else if (axiom.getProperty() instanceof Relation) {
            doc.append(this.keyword((EObject)axiom, this.oml.getRelationCardinalityRestrictionAxiomAccess().getRestrictsKeyword_0()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getRelationCardinalityRestrictionAxiomAccess().getRelationKeyword_1()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getRelationCardinalityRestrictionAxiomAccess().getToKeyword_3()), this.oneSpace());
        }
        doc.surround(this.feature((EObject)axiom, (EStructuralFeature)OmlPackage.Literals.PROPERTY_CARDINALITY_RESTRICTION_AXIOM__KIND), this.oneSpace());
        this.ifNotNull(axiom.getRange(), i -> doc.prepend(this.feature((EObject)i, (EStructuralFeature)OmlPackage.Literals.PROPERTY_CARDINALITY_RESTRICTION_AXIOM__RANGE), this.oneSpace()));
    }

    protected void _format(PropertyValueRestrictionAxiom axiom, IFormattableDocument doc) {
        if (axiom.getProperty() instanceof ScalarProperty) {
            doc.append(this.keyword((EObject)axiom, this.oml.getScalarPropertyValueRestrictionAxiomAccess().getRestrictsKeyword_0()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getScalarPropertyValueRestrictionAxiomAccess().getScalarKeyword_1()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getScalarPropertyValueRestrictionAxiomAccess().getPropertyKeyword_2()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getScalarPropertyValueRestrictionAxiomAccess().getToKeyword_4()), this.oneSpace());
        } else if (axiom.getProperty() instanceof StructuredProperty) {
            doc.append(this.keyword((EObject)axiom, this.oml.getStructuredPropertyValueRestrictionAxiomAccess().getRestrictsKeyword_0()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getStructuredPropertyValueRestrictionAxiomAccess().getStructuredKeyword_1()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getStructuredPropertyValueRestrictionAxiomAccess().getPropertyKeyword_2()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getStructuredPropertyValueRestrictionAxiomAccess().getToKeyword_4()), this.oneSpace());
        } else if (axiom.getProperty() instanceof Relation) {
            doc.append(this.keyword((EObject)axiom, this.oml.getRelationValueRestrictionAxiomAccess().getRestrictsKeyword_0()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getRelationValueRestrictionAxiomAccess().getRelationKeyword_1()), this.oneSpace());
            doc.surround(this.keyword((EObject)axiom, this.oml.getRelationValueRestrictionAxiomAccess().getToKeyword_3()), this.oneSpace());
        }
    }

    protected void _format(PropertySelfRestrictionAxiom axiom, IFormattableDocument doc) {
        doc.append(this.keyword((EObject)axiom, this.oml.getPropertySelfRestrictionAxiomAccess().getRestrictsKeyword_0()), this.oneSpace());
        doc.surround(this.keyword((EObject)axiom, this.oml.getPropertySelfRestrictionAxiomAccess().getRelationKeyword_1()), this.oneSpace());
        doc.surround(this.keyword((EObject)axiom, this.oml.getPropertySelfRestrictionAxiomAccess().getToKeyword_3()), this.oneSpace());
        doc.prepend(this.keyword((EObject)axiom, this.oml.getPropertySelfRestrictionAxiomAccess().getSelfKeyword_4()), this.oneSpace());
    }

    protected void _format(KeyAxiom axiom, IFormattableDocument doc) {
        doc.append(this.keyword((EObject)axiom, this.oml.getKeyAxiomAccess().getKeyKeyword_0()), this.oneSpace());
        this.formatCommas((EObject)axiom, doc);
    }

    protected void _format(InstanceEnumerationAxiom axiom, IFormattableDocument doc) {
        doc.append(this.keyword((EObject)axiom, this.oml.getInstanceEnumerationAxiomAccess().getOneOfKeyword_0()), this.oneSpace());
        this.formatCommas((EObject)axiom, doc);
    }

    protected void _format(LiteralEnumerationAxiom axiom, IFormattableDocument doc) {
        doc.append(this.keyword((EObject)axiom, this.oml.getLiteralEnumerationAxiomAccess().getOneOfKeyword_0()), this.oneSpace());
        this.formatCommas((EObject)axiom, doc);
    }

    protected void _format(PropertyValueAssertion assertion, IFormattableDocument doc) {
        doc.append(this.feature((EObject)assertion, (EStructuralFeature)OmlPackage.Literals.PROPERTY_VALUE_ASSERTION__PROPERTY), this.oneSpace());
    }

    protected void _format(TypePredicate predicate, IFormattableDocument doc) {
        doc.surround(this.keyword((EObject)predicate, this.oml.getTypePredicateAccess().getLeftParenthesisKeyword_1()), this.noSpace());
        doc.prepend(this.keyword((EObject)predicate, this.oml.getTypePredicateAccess().getRightParenthesisKeyword_3()), this.noSpace());
    }

    protected void _format(RelationEntityPredicate predicate, IFormattableDocument doc) {
        doc.surround(this.keyword((EObject)predicate, this.oml.getRelationEntityPredicateAccess().getLeftParenthesisKeyword_1()), this.noSpace());
        this.formatCommas((EObject)predicate, doc);
        doc.prepend(this.keyword((EObject)predicate, this.oml.getRelationEntityPredicateAccess().getRightParenthesisKeyword_7()), this.noSpace());
    }

    protected void _format(PropertyPredicate predicate, IFormattableDocument doc) {
        doc.surround(this.keyword((EObject)predicate, this.oml.getPropertyPredicateAccess().getLeftParenthesisKeyword_1()), this.noSpace());
        this.formatCommas((EObject)predicate, doc);
        doc.prepend(this.keyword((EObject)predicate, this.oml.getPropertyPredicateAccess().getRightParenthesisKeyword_5()), this.noSpace());
    }

    protected void _format(SameAsPredicate predicate, IFormattableDocument doc) {
        doc.surround(this.keyword((EObject)predicate, this.oml.getSameAsPredicateAccess().getLeftParenthesisKeyword_1()), this.noSpace());
        this.formatCommas((EObject)predicate, doc);
        doc.prepend(this.keyword((EObject)predicate, this.oml.getSameAsPredicateAccess().getRightParenthesisKeyword_5()), this.noSpace());
    }

    protected void _format(DifferentFromPredicate predicate, IFormattableDocument doc) {
        doc.surround(this.keyword((EObject)predicate, this.oml.getDifferentFromPredicateAccess().getLeftParenthesisKeyword_1()), this.noSpace());
        this.formatCommas((EObject)predicate, doc);
        doc.prepend(this.keyword((EObject)predicate, this.oml.getDifferentFromPredicateAccess().getRightParenthesisKeyword_5()), this.noSpace());
    }

    protected void _format(BuiltInPredicate predicate, IFormattableDocument doc) {
        doc.surround(this.keyword((EObject)predicate, this.oml.getBuiltInPredicateAccess().getLeftParenthesisKeyword_1()), this.noSpace());
        this.formatCommas((EObject)predicate, doc);
        doc.prepend(this.keyword((EObject)predicate, this.oml.getBuiltInPredicateAccess().getRightParenthesisKeyword_6()), this.noSpace());
    }

    protected void _format(QuotedLiteral literal, IFormattableDocument doc) {
        doc.surround(this.keyword((EObject)literal, this.oml.getQuotedLiteralAccess().getCircumflexAccentCircumflexAccentKeyword_1_0_0()), this.noSpace());
        doc.surround(this.keyword((EObject)literal, this.oml.getQuotedLiteralAccess().getDollarSignKeyword_1_1_0()), this.noSpace());
    }

    public void format(Object object, IFormattableDocument doc) {
        if (this.formatMethods == null) {
            this.formatMethods = new ArrayList<Method>();
            for (Method method : ((Object)((Object)this)).getClass().getDeclaredMethods()) {
                try {
                    if (!method.getName().equals("_format")) continue;
                    this.formatMethods.add(method);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (object instanceof Element) {
            for (Method method : this.formatMethods) {
                try {
                    Class<?> paramType = method.getParameterTypes()[0];
                    if (!paramType.isAssignableFrom(object.getClass())) continue;
                    method.invoke((Object)this, object, doc);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        super.format(object, doc);
    }

    protected void formatBrackets(EObject e, IFormattableDocument doc) {
        ISemanticRegion open = this.keyword(e, "[");
        doc.prepend(open, this.oneSpace());
        ISemanticRegion close = this.keyword(e, "]");
        doc.prepend(close, this.newLine());
        doc.interior(open, close, this.indent());
    }

    protected void formatBrackets(EObject e, IFormattableDocument doc, Keyword openKeyword, Keyword closeKeyword) {
        ISemanticRegion open = this.keyword(e, openKeyword);
        doc.prepend(open, this.oneSpace());
        ISemanticRegion close = this.keyword(e, closeKeyword);
        doc.prepend(close, this.newLine());
        doc.interior(open, close, this.indent());
    }

    protected void formatBraces(EObject e, IFormattableDocument doc) {
        ISemanticRegion open = this.keyword(e, "{");
        doc.prepend(open, this.oneSpace());
        ISemanticRegion close = this.keyword(e, "}");
        doc.prepend(close, this.newLine());
        doc.interior(open, close, this.indent());
    }

    protected void formatCommas(EObject e, IFormattableDocument doc) {
        this.keywords(e, ",").forEach(i -> doc.append(doc.prepend(i, this.noSpace()), this.oneSpace()));
    }

    protected void formatAmpersands(EObject e, IFormattableDocument doc) {
        this.keywords(e, "&").forEach(i -> doc.append(doc.prepend(i, this.noSpace()), this.oneSpace()));
    }

    protected ISemanticRegion feature(EObject obj, EStructuralFeature feature) {
        return this.textRegionExtensions.regionFor(obj).feature(feature);
    }

    protected ISemanticRegion rule(EObject obj, RuleCall rule) {
        return this.textRegionExtensions.regionFor(obj).ruleCall(rule);
    }

    protected ISemanticRegion keyword(EObject obj, Keyword keyword) {
        return this.textRegionExtensions.regionFor(obj).keyword(keyword);
    }

    protected ISemanticRegion keyword(EObject obj, String keyword) {
        return this.textRegionExtensions.regionFor(obj).keyword(keyword);
    }

    protected List<ISemanticRegion> keywords(EObject obj, String keyword) {
        return this.textRegionExtensions.regionFor(obj).keywords(new String[]{keyword});
    }

    @SafeVarargs
    private Procedures.Procedure1<IHiddenRegionFormatter> compose(Procedures.Procedure1<IHiddenRegionFormatter> ... lambdas) {
        return i -> {
            for (Procedures.Procedure1 lambda : lambdas) {
                lambda.apply(i);
            }
        };
    }

    protected Procedures.Procedure1<IHiddenRegionFormatter> newLine() {
        return i -> i.newLine();
    }

    protected Procedures.Procedure1<IHiddenRegionFormatter> newLines(int n) {
        return i -> i.setNewLines(n);
    }

    protected Procedures.Procedure1<IHiddenRegionFormatter> setNewLines(int n1, int n2, int n3) {
        return i -> i.setNewLines(n1, n2, n3);
    }

    protected Procedures.Procedure1<IHiddenRegionFormatter> oneSpace() {
        return i -> i.oneSpace();
    }

    protected Procedures.Procedure1<IHiddenRegionFormatter> indent() {
        return i -> i.indent();
    }

    protected Procedures.Procedure1<IHiddenRegionFormatter> noSpace() {
        return i -> i.noSpace();
    }

    protected <T> void IfTrue(boolean b, Runnable runnable) {
        if (b) {
            runnable.run();
        }
    }

    protected <T> void ifNotNull(T obj, Procedures.Procedure1<T> proc) {
        if (obj != null) {
            proc.apply(obj);
        }
    }

    protected <T> void ifNotEmpty(List<T> list, Procedures.Procedure1<List<T>> proc) {
        if (!list.isEmpty()) {
            proc.apply(list);
        }
    }
}

