/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.dsl.scoping;

import com.google.inject.Inject;
import io.opencaesar.oml.Import;
import io.opencaesar.oml.Ontology;
import io.opencaesar.oml.dsl.naming.OmlNamespaceImportNormalizer;
import io.opencaesar.oml.util.OmlRead;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportedNamespaceAwareLocalScopeProvider;

public class OmlImportedNamespaceAwareLocalScopeProvider
extends ImportedNamespaceAwareLocalScopeProvider {
    @Inject
    private IQualifiedNameConverter qnc;

    public String getImportedNamespace(EObject object) {
        if (object instanceof Import) {
            return ((Import)object).getPrefix();
        }
        return null;
    }

    public List<ImportNormalizer> internalGetImportedNamespaceResolvers(EObject context, boolean ignoreCase) {
        if (context instanceof Ontology) {
            Ontology ontology = (Ontology)context;
            ArrayList<ImportNormalizer> importedNamespaceResolvers = new ArrayList<ImportNormalizer>();
            if (ontology.getNamespace() != null) {
                importedNamespaceResolvers.add(new OmlNamespaceImportNormalizer(this.qnc.toQualifiedName(ontology.getNamespace()), ontology.getPrefix(), ignoreCase));
            }
            OmlRead.getImportNamespaceToPrefixMap((Ontology)ontology).forEach((namespace, prefix) -> {
                if (prefix != null && namespace != null) {
                    importedNamespaceResolvers.add(new OmlNamespaceImportNormalizer(this.qnc.toQualifiedName(namespace), (String)prefix, ignoreCase));
                }
            });
            return importedNamespaceResolvers;
        }
        return Collections.emptyList();
    }
}

