/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.dsl.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.util.internal.Log;

@Log
public class JsonFileBasedPreferenceValues
extends MapBasedPreferenceValues {
    private final Path path;
    private FileTime lastModification = null;
    private static final Logger LOG = Logger.getLogger(JsonFileBasedPreferenceValues.class);

    public JsonFileBasedPreferenceValues(Path path, IPreferenceValues delegate) {
        super(delegate, new HashMap());
        this.path = path;
    }

    public boolean checkIsUpToDate() {
        boolean result;
        block6: {
            result = true;
            IPreferenceValues d = this.getDelegate();
            if (d instanceof JsonFileBasedPreferenceValues) {
                result &= ((JsonFileBasedPreferenceValues)d).checkIsUpToDate();
            }
            try {
                FileTime localLastMod = Files.getLastModifiedTime(this.path, new LinkOption[0]);
                if (localLastMod != this.lastModification) {
                    this.lastModification = localLastMod;
                    this.read();
                    return false;
                }
            }
            catch (Exception e) {
                if (!(e instanceof NoSuchFileException)) {
                    LOG.error((Object)("Error reading settings '" + this.path + "' : " + e.getMessage()));
                } else {
                    this.lastModification = null;
                }
                if (this.getValues().isEmpty()) break block6;
                this.clear();
                return false;
            }
        }
        return result;
    }

    public void read() {
        try {
            this.clear();
            byte[] bytes = Files.readAllBytes(this.path);
            JsonReader reader = new JsonReader((Reader)new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes))));
            reader.setLenient(true);
            JsonElement object = Streams.parse((JsonReader)reader);
            if (object instanceof JsonObject) {
                this.internalFillMap(null, (JsonObject)object);
            } else {
                LOG.error((Object)"The oml.settings file, did not contain a top level object.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void internalFillMap(String prefix, JsonObject object) {
        for (Map.Entry entry : object.entrySet()) {
            JsonElement v = (JsonElement)entry.getValue();
            if (v instanceof JsonObject) {
                this.internalFillMap((String)entry.getKey(), (JsonObject)entry.getValue());
                continue;
            }
            if (!(v instanceof JsonPrimitive)) continue;
            Object key = null;
            key = prefix != null ? prefix + "." + (String)entry.getKey() : (String)entry.getKey();
            this.put((String)key, v.getAsString().toString());
        }
    }
}

