/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.dsl.settings;

import com.google.common.base.StandardSystemProperty;
import com.google.inject.Inject;
import io.opencaesar.oml.dsl.settings.JsonFileBasedPreferenceValues;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.IPreferenceValuesProvider;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.preferences.PreferenceValuesByLanguage;
import org.eclipse.xtext.util.IDisposable;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfigProvider;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
@Log
public class PreferenceValuesProvider
implements IPreferenceValuesProvider {
    @Inject(optional=true)
    private IProjectConfigProvider configProvider;
    @Inject
    private LanguageInfo language;
    private List<Procedures.Procedure2<? super IPreferenceValues, ? super Resource>> onChangeListeners = new ArrayList<Procedures.Procedure2<? super IPreferenceValues, ? super Resource>>();
    private static final Logger LOG = Logger.getLogger(PreferenceValuesProvider.class);
    public static final Map<String, String> constantSettings = new HashMap<String, String>();

    public IPreferenceValues getPreferenceValues(Resource context) {
        IPreferenceValues values;
        if (context == null) {
            return new MapBasedPreferenceValues(Collections.emptyMap());
        }
        PreferenceValuesByLanguage valuesByLanguage = PreferenceValuesByLanguage.findInEmfObject((Notifier)context.getResourceSet());
        if (valuesByLanguage == null) {
            valuesByLanguage = new PreferenceValuesByLanguage();
            valuesByLanguage.attachToEmfObject((Notifier)context.getResourceSet());
        }
        if ((values = valuesByLanguage.get(this.language.getLanguageName())) != null) {
            IProjectConfig c;
            URI uri = null;
            if (this.configProvider != null && (c = this.configProvider.getProjectConfig(context.getResourceSet())) != null) {
                uri = c.getPath();
            }
            PreferenceValuesProvider.createPreferenceValues(uri);
        }
        valuesByLanguage.put(this.language.getLanguageName(), values);
        if (values instanceof JsonFileBasedPreferenceValues && !((JsonFileBasedPreferenceValues)values).checkIsUpToDate()) {
            for (Procedures.Procedure2<? super IPreferenceValues, ? super Resource> listener : this.onChangeListeners) {
                listener.apply((Object)values, (Object)context);
            }
        }
        return values;
    }

    public static IPreferenceValues createPreferenceValues(URI projectURI) {
        try {
            MapBasedPreferenceValues result = new MapBasedPreferenceValues(constantSettings);
            Path userHome = Paths.get(StandardSystemProperty.USER_HOME.value(), new String[0]);
            Path userSettings = userHome.resolve(".oml").resolve("oml.settings");
            result = new JsonFileBasedPreferenceValues(userSettings, (IPreferenceValues)result);
            if (projectURI == null) {
                return result;
            }
            int segmentsToRemove = projectURI.lastSegment().isEmpty() ? 1 : 0;
            java.net.URI workspaceDirectory = new java.net.URI(projectURI.trimSegments(segmentsToRemove + 1).toString());
            Path workspaceSettings = Paths.get(workspaceDirectory).resolve("oml.settings");
            result = new JsonFileBasedPreferenceValues(workspaceSettings, (IPreferenceValues)result);
            java.net.URI projectDirectory = new java.net.URI(projectURI.trimSegments(segmentsToRemove).toString());
            Path projectSettings = Paths.get(projectDirectory).resolve("oml.settings");
            result = new JsonFileBasedPreferenceValues(projectSettings, (IPreferenceValues)result);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IDisposable registerChangeListener(Procedures.Procedure2<? super IPreferenceValues, ? super Resource> callback) {
        this.onChangeListeners.add(callback);
        return () -> this.onChangeListeners.remove(callback);
    }
}

