/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.deser;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emfcloud.jackson.databind.deser.CollectionDeserializer;
import org.eclipse.emfcloud.jackson.databind.deser.EDataTypeDeserializer;
import org.eclipse.emfcloud.jackson.databind.deser.EMapDeserializer;
import org.eclipse.emfcloud.jackson.databind.deser.EObjectDeserializer;
import org.eclipse.emfcloud.jackson.databind.deser.ReferenceEntry;
import org.eclipse.emfcloud.jackson.databind.deser.ResourceDeserializer;
import org.eclipse.emfcloud.jackson.databind.property.EObjectPropertyMap;
import org.eclipse.emfcloud.jackson.databind.type.EcoreType;
import org.eclipse.emfcloud.jackson.module.EMFModule;

public class EMFDeserializers
extends Deserializers.Base {
    private final ResourceDeserializer resourceDeserializer;
    private final JsonDeserializer<EList<Map.Entry<?, ?>>> mapDeserializer;
    private final JsonDeserializer<Object> dataTypeDeserializer;
    private final JsonDeserializer<ReferenceEntry> referenceDeserializer;
    private final EObjectPropertyMap.Builder builder;

    public EMFDeserializers(EMFModule module) {
        this.builder = new EObjectPropertyMap.Builder(module.getIdentityInfo(), module.getTypeInfo(), module.getReferenceInfo(), module.getFeatures());
        this.resourceDeserializer = new ResourceDeserializer(module.getUriHandler());
        this.referenceDeserializer = module.getReferenceDeserializer();
        this.mapDeserializer = new EMapDeserializer();
        this.dataTypeDeserializer = new EDataTypeDeserializer();
    }

    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        if (type.isTypeOrSubTypeOf(EMap.class)) {
            return this.mapDeserializer;
        }
        return super.findMapLikeDeserializer(type, config, beanDesc, keyDeserializer, elementTypeDeserializer, elementDeserializer);
    }

    public JsonDeserializer<?> findEnumDeserializer(Class<?> type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        if (Enumerator.class.isAssignableFrom(type)) {
            return this.dataTypeDeserializer;
        }
        return super.findEnumDeserializer(type, config, beanDesc);
    }

    public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        if (type.getContentType().isTypeOrSubTypeOf(EObject.class)) {
            return new CollectionDeserializer(type, new EObjectDeserializer(this.builder, type.getContentType().getRawClass()), this.referenceDeserializer);
        }
        return super.findCollectionDeserializer(type, config, beanDesc, elementTypeDeserializer, elementDeserializer);
    }

    public JsonDeserializer<?> findReferenceDeserializer(ReferenceType refType, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer contentTypeDeserializer, JsonDeserializer<?> contentDeserializer) throws JsonMappingException {
        if (this.referenceDeserializer != null) {
            return this.referenceDeserializer;
        }
        return super.findReferenceDeserializer(refType, config, beanDesc, contentTypeDeserializer, contentDeserializer);
    }

    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        if (type.isTypeOrSubTypeOf(Resource.class)) {
            return this.resourceDeserializer;
        }
        if (type.isReferenceType()) {
            return this.referenceDeserializer;
        }
        if (type.isTypeOrSubTypeOf(EcoreType.DataType.class)) {
            return this.dataTypeDeserializer;
        }
        if (type.isTypeOrSubTypeOf(EObject.class)) {
            return new EObjectDeserializer(this.builder, type.getRawClass());
        }
        return super.findBeanDeserializer(type, config, beanDesc);
    }
}

