/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ImportKind implements Enumerator
{
    EXTENSION(0, "extension", "extension"),
    USAGE(1, "usage", "usage"),
    INCLUSION(2, "inclusion", "inclusion");

    public static final int EXTENSION_VALUE = 0;
    public static final int USAGE_VALUE = 1;
    public static final int INCLUSION_VALUE = 2;
    private static final ImportKind[] VALUES_ARRAY;
    public static final List<ImportKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ImportKind get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ImportKind result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ImportKind getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ImportKind result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ImportKind get(int value) {
        switch (value) {
            case 0: {
                return EXTENSION;
            }
            case 1: {
                return USAGE;
            }
            case 2: {
                return INCLUSION;
            }
        }
        return null;
    }

    private ImportKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ImportKind[]{EXTENSION, USAGE, INCLUSION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

